/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wkplc.httptunnel.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.wsspi.http.channel.HttpRequestMessage;
import com.ibm.wsspi.http.channel.HttpResponseMessage;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.StringTokenizer;
import javax.servlet.http.Cookie;

public class HttpRequestProperties {
    private static final TraceComponent tc = Tr.register(HttpRequestProperties.class, "HTTPTunnelChannel", "com.ibm.wkplc.httptunnel.resources.tunnelMessages");
    public static final String PROP_ID = "id";
    public static final String PROP_POLL = "pol";
    public static final String PROP_CLOSE_SESSION = "clo";
    public static final String PROP_PAUSE_SESSION = "pau";
    public static final String PROP_SERVER_SEQUENCE = "ssq";
    public static final String PROP_CLIENT_SEQUENCE = "csq";
    public static final String PROP_CLIENT_RETRY_INTERVAL = "rti";
    private static final String COOKIE_PREFIX = "tcsid.";
    public static final String COOKIE_PROP_DELIM = "|";
    public static final String COOKIE_PROP_ASSIGN = "~";
    public static final String HTTP_PROP_DELIM = "&";
    public static final String HTTP_PROP_ASSIGN = "=";
    private Hashtable sessionProperties = new Hashtable();
    private int sessionId = 0;
    private boolean sessionPaused = false;

    public void setSessionId(int n) {
        this.sessionId = n;
    }

    public int getSessionId() {
        return this.sessionId;
    }

    public int getServerSequence() {
        return this.getRequestIntProperty(PROP_SERVER_SEQUENCE, 0);
    }

    public int getClientSequence() {
        return this.getRequestIntProperty(PROP_CLIENT_SEQUENCE, 0);
    }

    public boolean isSessionClosed() {
        return this.sessionProperties.containsKey(PROP_CLOSE_SESSION);
    }

    public void setSessionClosed(boolean bl) {
        if (bl) {
            this.sessionProperties.put(PROP_CLOSE_SESSION, "");
        } else {
            this.sessionProperties.remove(PROP_CLOSE_SESSION);
        }
    }

    public boolean isSessionPaused() {
        String string = this.getRequestProperty(PROP_PAUSE_SESSION);
        if (string != null) {
            this.sessionPaused = Boolean.valueOf(string);
            this.sessionProperties.remove(PROP_PAUSE_SESSION);
        }
        return this.sessionPaused;
    }

    public void setRequestProperty(String string, String string2) {
        this.sessionProperties.put(string, string2);
    }

    public String getRequestProperty(String string) {
        return (String)this.sessionProperties.get(string);
    }

    private int getRequestIntProperty(String string, int n) {
        block3: {
            String string2 = this.getRequestProperty(string);
            if (null != string2) {
                try {
                    return Integer.parseInt(string2);
                }
                catch (NumberFormatException numberFormatException) {
                    if (!tc.isDebugEnabled()) break block3;
                    Tr.debug(tc, "Invalid number property: " + string + "/" + string2);
                }
            }
        }
        return n;
    }

    public Cookie createSessionCookie() {
        Cookie cookie;
        block6: {
            cookie = null;
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "createSessionCookie");
            }
            try {
                Enumeration enumeration = this.sessionProperties.keys();
                StringBuffer stringBuffer = new StringBuffer();
                while (enumeration.hasMoreElements()) {
                    String string = (String)enumeration.nextElement();
                    stringBuffer.append(string + COOKIE_PROP_ASSIGN + this.getRequestProperty(string));
                    if (!enumeration.hasMoreElements()) continue;
                    stringBuffer.append(COOKIE_PROP_DELIM);
                }
                cookie = new Cookie(COOKIE_PREFIX + this.getSessionId(), stringBuffer.toString());
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "createSessionCookie: " + cookie.getName() + HTTP_PROP_ASSIGN + cookie.getValue());
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if (!tc.isDebugEnabled()) break block6;
                Tr.debug(tc, "createSessionCookie: " + illegalArgumentException);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createSessionCookie");
        }
        return cookie;
    }

    public void parseSessionProperties(HttpRequestMessage httpRequestMessage) {
        if (httpRequestMessage == null) {
            return;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "parseSessionProperties: query: " + httpRequestMessage.getQueryString());
        }
        this.parseProperties(httpRequestMessage.getQueryString(), HTTP_PROP_DELIM, HTTP_PROP_ASSIGN);
        this.sessionId = this.getRequestIntProperty(PROP_ID, 0);
    }

    public void parseSessionProperties(HttpResponseMessage httpResponseMessage) {
        if (httpResponseMessage == null) {
            return;
        }
        this.sessionProperties.clear();
        Iterator iterator = httpResponseMessage.getAllCookies().iterator();
        while (iterator.hasNext()) {
            int n;
            String string;
            int n2;
            Cookie cookie = (Cookie)iterator.next();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "parseSessionProperties: cookie: " + cookie.getName() + HTTP_PROP_ASSIGN + cookie.getValue());
            }
            if ((n2 = (string = cookie.getName()).indexOf(COOKIE_PREFIX)) == -1) continue;
            for (n = n2 + COOKIE_PREFIX.length(); n < string.length() && string.charAt(n) >= '0' && string.charAt(n) <= '9'; ++n) {
            }
            try {
                int n3 = Integer.parseInt(string.substring(n2 + COOKIE_PREFIX.length(), n));
                if (this.sessionId == 0) {
                    this.sessionId = n3;
                }
                if (this.sessionId == n3) {
                    this.parseProperties(cookie.getValue(), COOKIE_PROP_DELIM, COOKIE_PROP_ASSIGN);
                    break;
                }
                if (!tc.isDebugEnabled()) break;
                Tr.debug(tc, "Error: different session ID recieved, " + this.sessionId + " input: " + n3);
            }
            catch (NumberFormatException numberFormatException) {
                if (!tc.isDebugEnabled()) break;
                Tr.debug(tc, "parseSessionProperties: " + numberFormatException);
            }
            break;
        }
    }

    private void parseProperties(String string, String string2, String string3) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "parseProperties: for: s = " + string + " delim = " + string2 + " assign = " + string3);
        }
        if (string == null) {
            return;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
        if (stringTokenizer == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "parseProperties: null stringtokenizer");
            }
            return;
        }
        while (stringTokenizer.hasMoreElements()) {
            try {
                String string4;
                StringTokenizer stringTokenizer2 = new StringTokenizer((String)stringTokenizer.nextElement(), string3);
                if (stringTokenizer2 == null || !stringTokenizer2.hasMoreElements()) continue;
                String string5 = (String)stringTokenizer2.nextElement();
                String string6 = string4 = stringTokenizer2.hasMoreElements() ? (String)stringTokenizer2.nextElement() : "";
                if (string5 == null || string5.length() <= 0) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "parseProperties: " + string5 + HTTP_PROP_ASSIGN + string4);
                }
                this.setRequestProperty(string5, string4);
            }
            catch (Exception exception) {
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "parseProperties: " + exception);
            }
        }
    }
}

