/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wkplc.httptunnel.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.wkplc.httptunnel.impl.HttpSessionConnection;
import com.ibm.wkplc.httptunnel.impl.HttpSessionConnectionListener;
import com.ibm.wkplc.util.BufferUtil;
import com.ibm.wkplc.util.WSCircularBuffer;
import com.ibm.ws.buffermgmt.impl.WsByteBufferPoolManagerImpl;
import com.ibm.wsspi.buffermgmt.WsByteBuffer;
import com.ibm.wsspi.buffermgmt.WsByteBufferUtils;
import com.ibm.wsspi.channel.ConnectionLink;
import com.ibm.wsspi.channel.framework.VirtualConnection;
import com.ibm.wsspi.runtime.ThreadPool;
import com.ibm.wsspi.tcp.channel.SSLConnectionContext;
import com.ibm.wsspi.tcp.channel.TCPConnectionContext;
import com.ibm.wsspi.tcp.channel.TCPReadCompletedCallback;
import com.ibm.wsspi.tcp.channel.TCPReadRequestContext;
import com.ibm.wsspi.tcp.channel.TCPWriteCompletedCallback;
import com.ibm.wsspi.tcp.channel.TCPWriteRequestContext;
import java.io.IOException;
import java.net.InetAddress;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;

public class HttpTunnelSession
implements HttpSessionConnectionListener,
TCPConnectionContext {
    protected static final TraceComponent tc;
    public static final String CLOSED_EXCEPTION = "Connection is closed";
    private static final int WRITE_METHOD_INT = 0;
    private static final int WRITE_ASYNCH_METHOD_INT = 1;
    private static final int READ_METHOD_INT = 0;
    private static final int READ_ASYNCH_METHOD_INT = 1;
    private static final int QUEUE_SIZE = 32768;
    private static final int BUFFER_SIZE = 1024;
    private ConnectionLink connectionLink = null;
    private List inboundDataQ = new ArrayList();
    private int inboundDataQSize = 0;
    private WSCircularBuffer outboundDataQ = new WSCircularBuffer(32768);
    private WsByteBuffer writeBuffer = null;
    private WsByteBuffer readContextBuffer = null;
    private WsByteBuffer writeContextBuffer = null;
    private HttpTunnelReadServiceContext readSC = null;
    private HttpTunnelWriteServiceContext writeSC = null;
    protected HttpSessionConnection sessionConnection = null;
    protected ThreadPool threadPool = null;
    protected boolean sessionStarted = false;
    private Timer sessionTimer = null;
    protected int defaultReadTimeout = -1;
    protected int defaultWriteTimeout = -1;
    static final /* synthetic */ boolean $assertionsDisabled;

    public HttpTunnelSession(ThreadPool threadPool, Timer timer, int n, int n2) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, this.dbg("HttpTunnelSession"));
        }
        this.threadPool = threadPool;
        this.sessionTimer = timer;
        this.defaultReadTimeout = n;
        this.defaultWriteTimeout = n2;
        this.readSC = new HttpTunnelReadServiceContext(this.sessionTimer);
        this.readContextBuffer = WsByteBufferPoolManagerImpl.getRef().allocate(1024);
        this.readSC.setBuffer(this.readContextBuffer);
        this.writeSC = new HttpTunnelWriteServiceContext(this.sessionTimer);
        this.writeContextBuffer = WsByteBufferPoolManagerImpl.getRef().allocate(1024);
        this.writeSC.setBuffer(this.writeContextBuffer);
        this.writeBuffer = WsByteBufferPoolManagerImpl.getRef().allocate(16384);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, this.dbg("HttpTunnelSession"));
        }
    }

    public void startup(HttpSessionConnection httpSessionConnection, ConnectionLink connectionLink) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, this.dbg("startup"));
        }
        if (!this.isSessionStarted()) {
            this.sessionStarted = true;
            this.sessionConnection = httpSessionConnection;
            this.connectionLink = connectionLink;
            this.sessionConnection.setHttpConnectionListener(this);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, this.dbg("startup"));
        }
    }

    protected boolean isSessionStarted() {
        return this.sessionStarted;
    }

    public void shutdown(Exception exception) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, this.dbg("shutdown: " + exception));
        }
        if (this.isSessionStarted()) {
            this.sessionStarted = false;
            this.reader().shutdown();
            this.writer().shutdown();
            if (this.writeContextBuffer != null) {
                this.writeContextBuffer.release();
                this.writeContextBuffer = null;
            }
            if (this.readContextBuffer != null) {
                this.readContextBuffer.release();
                this.readContextBuffer = null;
            }
            if (this.writeBuffer != null) {
                this.writeBuffer.release();
                this.writeBuffer = null;
            }
            if (this.sessionConnection != null) {
                this.sessionConnection.close(exception);
                this.sessionConnection = null;
            }
            while (!this.inboundDataQ.isEmpty()) {
                BufferUtil.release((WsByteBuffer[])this.inboundDataQ.remove(0));
            }
            this.outboundDataQ.release();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, this.dbg("shutdown"));
        }
    }

    private String hashId() {
        int n = 0;
        if (this.getConnectionLink() != null && this.getVirtualConnection() != null) {
            n = this.getVirtualConnection().hashCode();
        }
        return " (hc=" + this.hashCode() + "; vc=" + n + ")";
    }

    protected String dbg(String string) {
        return string + this.hashId();
    }

    public ConnectionLink getConnectionLink() {
        return this.connectionLink;
    }

    protected VirtualConnection getVirtualConnection() {
        return this.connectionLink.getVirtualConnection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int readInboundData(WsByteBuffer[] wsByteBufferArray) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, this.dbg("readInboundData: dst=" + BufferUtil.remaining(wsByteBufferArray)));
        }
        int n = 0;
        List list = this.inboundDataQ;
        synchronized (list) {
            WsByteBuffer[] wsByteBufferArray2 = null;
            while (!this.inboundDataQ.isEmpty() && BufferUtil.hasRemaining(wsByteBufferArray)) {
                if (null == wsByteBufferArray2) {
                    wsByteBufferArray2 = (WsByteBuffer[])this.inboundDataQ.get(0);
                }
                n += BufferUtil.put(wsByteBufferArray2, wsByteBufferArray);
                if (BufferUtil.hasRemaining(wsByteBufferArray2)) continue;
                BufferUtil.release(wsByteBufferArray2);
                this.inboundDataQ.remove(0);
                wsByteBufferArray2 = null;
            }
            this.inboundDataQSize -= n;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, this.dbg("readInboundData: " + n + " bytes read"));
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized int queueOutboundData(WsByteBuffer[] wsByteBufferArray) {
        int n = 0;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, this.dbg("queueOutboundData: src=" + WsByteBufferUtils.lengthOf((WsByteBuffer[])wsByteBufferArray) + "; dst=" + this.outboundDataQ.remaining()));
        }
        WSCircularBuffer wSCircularBuffer = this.outboundDataQ;
        synchronized (wSCircularBuffer) {
            if (wsByteBufferArray != null) {
                int n2 = this.outboundDataQ.used();
                for (int i = 0; i < wsByteBufferArray.length; ++i) {
                    WsByteBuffer wsByteBuffer = wsByteBufferArray[i];
                    if (wsByteBuffer == null || wsByteBuffer.remaining() <= 0) continue;
                    if (wsByteBuffer.remaining() > this.outboundDataQ.remaining()) {
                        int n3 = wsByteBuffer.limit();
                        wsByteBuffer.limit(wsByteBuffer.position() + this.outboundDataQ.remaining());
                        if (wsByteBuffer.remaining() != 0) {
                            this.outboundDataQ.write(wsByteBuffer);
                        }
                        wsByteBuffer.limit(n3);
                        break;
                    }
                    this.outboundDataQ.write(wsByteBuffer);
                }
                n = this.outboundDataQ.used() - n2;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, this.dbg("queueOutboundData: " + n + " copied"));
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WsByteBuffer getWriteData(HttpSessionConnection httpSessionConnection) {
        WsByteBuffer wsByteBuffer = null;
        if (!$assertionsDisabled && this.writeBuffer == null) {
            throw new AssertionError((Object)"getWriteData: transfer buffer is null");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, this.dbg("getWriteData: " + this.outboundDataQ.used() + " bytes in queue"));
        }
        WSCircularBuffer wSCircularBuffer = this.outboundDataQ;
        synchronized (wSCircularBuffer) {
            this.writeBuffer.clear();
            if (this.outboundDataQ.read(this.writeBuffer) != 0) {
                this.writeBuffer.flip();
                wsByteBuffer = this.writeBuffer;
            }
        }
        this.writer().dataIsSent();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, this.dbg("getWriteData: returning " + wsByteBuffer));
        }
        return wsByteBuffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isWriteDataPending() {
        boolean bl = false;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, this.dbg("isWriteDataPending"));
        }
        WSCircularBuffer wSCircularBuffer = this.outboundDataQ;
        synchronized (wSCircularBuffer) {
            bl = this.outboundDataQ.used() > 0;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, this.dbg("isWriteDataPending: " + bl));
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isOutboundDataQFull() {
        boolean bl = false;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, this.dbg("isOutboundDataQFull"));
        }
        WSCircularBuffer wSCircularBuffer = this.outboundDataQ;
        synchronized (wSCircularBuffer) {
            bl = this.outboundDataQ.used() == this.outboundDataQ.capacity();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, this.dbg("isOutboundDataQFull: " + bl));
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setReadData(WsByteBuffer[] wsByteBufferArray, HttpSessionConnection httpSessionConnection) throws IOException {
        int n = BufferUtil.remaining(wsByteBufferArray);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, this.dbg("setReadData: " + n + " bytes"));
        }
        List list = this.inboundDataQ;
        synchronized (list) {
            this.inboundDataQSize += n;
            this.inboundDataQ.add(wsByteBufferArray);
        }
        this.reader().dataIsReceived();
    }

    public void sessionConnectionClosed(Exception exception) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, this.dbg("sessionConnectionClosed: " + exception));
        }
        this.sessionStarted = false;
        this.reader().shutdown();
        this.writer().shutdown();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, this.dbg("sessionConnectionClosed"));
        }
    }

    public TCPReadRequestContext getReadInterface() {
        return this.readSC;
    }

    private HttpTunnelReadServiceContext reader() {
        return this.readSC;
    }

    public TCPWriteRequestContext getWriteInterface() {
        return this.writeSC;
    }

    private HttpTunnelWriteServiceContext writer() {
        return this.writeSC;
    }

    public InetAddress getRemoteAddress() {
        InetAddress inetAddress = null;
        if (this.sessionConnection != null) {
            inetAddress = this.sessionConnection.getRemoteAddress();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, this.dbg("getRemoteAddress: address=" + (inetAddress != null ? inetAddress.toString() : "null")));
        }
        return inetAddress;
    }

    public int getRemotePort() {
        int n = 0;
        if (this.sessionConnection != null) {
            n = this.sessionConnection.getRemotePort();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, this.dbg("getRemotePort: port=" + n));
        }
        return n;
    }

    public InetAddress getLocalAddress() {
        InetAddress inetAddress = null;
        if (this.sessionConnection != null) {
            inetAddress = this.sessionConnection.getLocalAddress();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, this.dbg("getLocalAddress: address=" + (inetAddress != null ? inetAddress.toString() : "null")));
        }
        return inetAddress;
    }

    public int getLocalPort() {
        int n = 0;
        if (this.sessionConnection != null) {
            n = this.sessionConnection.getLocalPort();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, this.dbg("getLocalPort: port=" + n));
        }
        return n;
    }

    public SSLConnectionContext getSSLContext() {
        return null;
    }

    protected boolean dispatchTask(Runnable runnable) {
        return 0 == this.threadPool.execute(runnable);
    }

    protected boolean dispatchWaitableTask(Runnable runnable) {
        int n = 0;
        try {
            n = this.threadPool.execute(runnable, 1);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, this.dbg("dispatchWaitableTask: WAIT_WHEN_AT_CAPACITY not supported"));
            }
            n = this.threadPool.execute(runnable);
        }
        if (0 != n) {
            Tr.event(tc, this.dbg("dispatchWaitableTask: Could not dispatch command: " + n));
        }
        return false;
    }

    static {
        $assertionsDisabled = !HttpTunnelSession.class.desiredAssertionStatus();
        tc = Tr.register(HttpTunnelSession.class, "HTTPTunnelChannel", "com.ibm.wkplc.httptunnel.resources.tunnelMessages");
    }

    abstract class TimeoutTask {
        private Timer timer = null;
        protected TimerTask task = null;
        private long t0 = System.currentTimeMillis();

        TimeoutTask(Timer timer) {
            this.timer = timer;
        }

        public abstract void run();

        public synchronized void start(long l) {
            block2: {
                try {
                    this.stop();
                    this.task = new TimerTask(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void run() {
                            TimeoutTask timeoutTask = TimeoutTask.this;
                            synchronized (timeoutTask) {
                                block5: {
                                    TimeoutTask.this.task = null;
                                    try {
                                        TimeoutTask.this.run();
                                    }
                                    catch (Exception exception) {
                                        if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block5;
                                        Tr.debug(tc, HttpTunnelSession.this.dbg("TimeoutTask.run: EXCEPTION: " + exception));
                                    }
                                }
                            }
                        }
                    };
                    this.t0 = System.currentTimeMillis();
                    this.timer.schedule(this.task, l);
                }
                catch (Exception exception) {
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block2;
                    Tr.debug(tc, HttpTunnelSession.this.dbg("TimeoutTask.run: EXCEPTION: " + exception));
                }
            }
        }

        public synchronized void stop() {
            if (this.task != null) {
                this.task.cancel();
                this.task = null;
            }
        }

        public synchronized void expire() {
            if (this.task != null && this.task.cancel()) {
                this.task = null;
                this.start(1L);
            }
        }

        public String toString() {
            return System.currentTimeMillis() - this.t0 + "ms";
        }
    }

    public class HttpTunnelWriteServiceContext
    implements TCPWriteRequestContext,
    Runnable {
        protected TCPWriteCompletedCallback writeCB = null;
        private WsByteBuffer[] buffers = null;
        private boolean shutdown = false;
        protected boolean sendCallback = false;
        private WriteTimer writeTimer = null;
        protected boolean writeTimerExpired = false;
        protected HttpTunnelWriteServiceContext writeContext = this;
        protected long pendingWriteCount = 0L;
        protected Object writeMonitor = new Object();
        private IOException writeError = null;

        public HttpTunnelWriteServiceContext(Timer timer) {
            this.writeTimer = new WriteTimer(timer);
        }

        public String toString() {
            return "HttpTunnelWriteServiceContext";
        }

        public TCPConnectionContext getInterface() {
            return HttpTunnelSession.this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public long write(long l, int n) throws IOException {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.entry(tc, HttpTunnelSession.this.dbg(this + ": (sync)"));
            }
            WsByteBuffer[] wsByteBufferArray = this.getBuffers();
            int n2 = 0;
            int n3 = n;
            this.writeError = null;
            this.writeCB = null;
            if (!HttpTunnelSession.this.isSessionStarted()) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, HttpTunnelSession.this.dbg(this + ": write context is shutdown already"));
                }
                throw new IOException("write context is shutdown");
            }
            if (n3 == -2) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, HttpTunnelSession.this.dbg(this + ": write cancelled; force write timeout"));
                }
                this.writeTimer.expire();
            } else {
                this.sendCallback = false;
                this.checkForErrors(l, 0);
                if (n3 == 0) {
                    n3 = HttpTunnelSession.this.defaultWriteTimeout;
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, HttpTunnelSession.this.dbg(this + ": sync: " + l + " bytes"));
                }
                Object object = this.writeMonitor;
                synchronized (object) {
                    this.pendingWriteCount = -1L == l ? (long)WsByteBufferUtils.lengthOf((WsByteBuffer[])wsByteBufferArray) : l;
                    this.pendingWriteCount -= (long)(n2 += HttpTunnelSession.this.queueOutboundData(this.getBuffers()));
                }
                this.writeTimerExpired = false;
                if (this.pendingWriteCount > 0L && n3 != -1) {
                    this.writeTimer.start(n3);
                }
                HttpTunnelSession.this.sessionConnection.writePending();
                while (true) {
                    int n4 = 0;
                    Object object2 = this.writeMonitor;
                    synchronized (object2) {
                        block29: {
                            if (this.pendingWriteCount <= 0L) {
                                break;
                            }
                            try {
                                if (HttpTunnelSession.this.isOutboundDataQFull()) {
                                    this.writeMonitor.wait();
                                }
                                if (this.shutdown) {
                                    throw new IOException(HttpTunnelSession.CLOSED_EXCEPTION);
                                }
                                if (this.writeTimerExpired) {
                                    break;
                                }
                                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                    Tr.debug(tc, HttpTunnelSession.this.dbg(this + ": pendingWriteCount before queuing outbound data = " + this.pendingWriteCount));
                                }
                                if ((n4 = HttpTunnelSession.this.queueOutboundData(this.getBuffers())) != 0) {
                                    n2 += n4;
                                    this.pendingWriteCount -= (long)n4;
                                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                        Tr.debug(tc, HttpTunnelSession.this.dbg(this + ": pendingWriteCount after queuing outbound data = " + this.pendingWriteCount));
                                    }
                                }
                            }
                            catch (InterruptedException interruptedException) {
                                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block29;
                                Tr.debug(tc, HttpTunnelSession.this.dbg(this + ": EXCEPTION: " + interruptedException));
                            }
                        }
                    }
                    if (n4 == 0) continue;
                    HttpTunnelSession.this.sessionConnection.writePending();
                }
                if (n3 != -1) {
                    if (this.writeTimerExpired) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                            Tr.exit(tc, HttpTunnelSession.this.dbg(this + ": operation timed out"));
                        }
                        throw new SocketTimeoutException("operation timed out");
                    }
                    this.writeTimer.stop();
                }
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, HttpTunnelSession.this.dbg(this + ": " + n2));
            }
            return n2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public VirtualConnection write(long l, TCPWriteCompletedCallback tCPWriteCompletedCallback, boolean bl, int n) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.entry(tc, HttpTunnelSession.this.dbg(this + ": (async)"));
            }
            int n2 = 0;
            int n3 = n;
            VirtualConnection virtualConnection = null;
            WsByteBuffer[] wsByteBufferArray = this.getBuffers();
            this.writeError = null;
            if (!HttpTunnelSession.this.isSessionStarted()) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, this + ": write context is shutdown already");
                }
                this.writeError = new IOException("write context is shutdown");
                if (bl) {
                    this.writeCB = tCPWriteCompletedCallback;
                    if (!HttpTunnelSession.this.dispatchTask(this)) {
                        this.run();
                    }
                } else {
                    tCPWriteCompletedCallback.error(HttpTunnelSession.this.getVirtualConnection(), (TCPWriteRequestContext)this, this.writeError);
                }
                return null;
            }
            if (n3 == -2) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, HttpTunnelSession.this.dbg(this + ": write cancelled; force write timeout"));
                }
                this.writeTimer.expire();
            } else {
                this.checkForErrors(l, 1);
                if (n3 == 0) {
                    n3 = HttpTunnelSession.this.defaultWriteTimeout;
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, HttpTunnelSession.this.dbg(this + ": async: " + l + " bytes"));
                }
                Object object = this.writeMonitor;
                synchronized (object) {
                    this.pendingWriteCount = -1L == l ? (long)WsByteBufferUtils.lengthOf((WsByteBuffer[])wsByteBufferArray) : l;
                    n2 = HttpTunnelSession.this.queueOutboundData(this.getBuffers());
                    this.pendingWriteCount -= (long)n2;
                    if (this.pendingWriteCount > 0L) {
                        this.sendCallback = true;
                        this.writeCB = tCPWriteCompletedCallback;
                        if (n3 != -1) {
                            this.writeTimerExpired = false;
                            this.writeTimer.start(n3);
                        }
                    } else {
                        this.sendCallback = false;
                        if (bl) {
                            this.writeCB = tCPWriteCompletedCallback;
                            if (!HttpTunnelSession.this.dispatchTask(this)) {
                                this.run();
                            }
                        } else {
                            virtualConnection = HttpTunnelSession.this.getVirtualConnection();
                        }
                    }
                }
                if (n2 != 0) {
                    HttpTunnelSession.this.sessionConnection.writePending();
                }
                if (HttpTunnelSession.this.getVirtualConnection().isInputStateTrackingOperational()) {
                    object = HttpTunnelSession.this.getVirtualConnection().getLockObject();
                    synchronized (object) {
                        HttpTunnelSession.this.getVirtualConnection().setWriteStatetoCloseAllowedNoSync();
                        if (HttpTunnelSession.this.getVirtualConnection().getCloseWaiting()) {
                            HttpTunnelSession.this.getVirtualConnection().getLockObject().notify();
                        }
                    }
                }
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, HttpTunnelSession.this.dbg(this + ": (async): " + virtualConnection));
            }
            return virtualConnection;
        }

        private void checkForErrors(long l, int n) {
            String string = null;
            if (this.getBuffers() == null || this.getBuffers().length == 0) {
                string = "No buffer(s) provided for writing data from";
            } else if (l < -1L || l == 0L && n == 1) {
                string = "Number of bytes requested to write: " + l + " is not valid";
            } else {
                WsByteBuffer[] wsByteBufferArray = this.getBuffers();
                long l2 = 0L;
                for (int i = 0; i < this.getBuffers().length && wsByteBufferArray[i] != null; ++i) {
                    l2 += (long)(wsByteBufferArray[i].limit() - wsByteBufferArray[i].position());
                }
                if (l > l2) {
                    string = "Number of bytes requested: " + l + " exceeds space remaining in the buffers provided: " + l2;
                }
            }
            if (string != null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, HttpTunnelSession.this.dbg(string));
                }
                throw new IllegalArgumentException(string);
            }
        }

        public void run() {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.entry(tc, HttpTunnelSession.this.dbg(this + ".run"));
            }
            TCPWriteCompletedCallback tCPWriteCompletedCallback = this.writeCB;
            this.writeCB = null;
            if (null != tCPWriteCompletedCallback) {
                if (this.writeError != null) {
                    tCPWriteCompletedCallback.error(HttpTunnelSession.this.getVirtualConnection(), (TCPWriteRequestContext)this, this.writeError);
                } else {
                    tCPWriteCompletedCallback.complete(HttpTunnelSession.this.getVirtualConnection(), (TCPWriteRequestContext)this);
                }
            } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, HttpTunnelSession.this.dbg(this + ".run: null write callback"));
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, HttpTunnelSession.this.dbg(this + ".run"));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void clearBuffers() {
            if (this.buffers == null) return;
            WsByteBuffer[] wsByteBufferArray = this.buffers;
            synchronized (this.buffers) {
                for (int i = 0; i < this.buffers.length; ++i) {
                    if (this.buffers[i] == null) continue;
                    this.buffers[i].clear();
                }
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
        }

        public WsByteBuffer[] getBuffers() {
            return this.buffers;
        }

        public void setBuffers(WsByteBuffer[] wsByteBufferArray) {
            this.buffers = wsByteBufferArray;
        }

        public WsByteBuffer getBuffer() {
            WsByteBuffer wsByteBuffer = null;
            if (this.buffers != null && this.buffers.length > 0) {
                wsByteBuffer = this.buffers[0];
            }
            return wsByteBuffer;
        }

        public void setBuffer(WsByteBuffer wsByteBuffer) {
            if (wsByteBuffer != null) {
                if (this.buffers == null) {
                    this.buffers = new WsByteBuffer[]{wsByteBuffer};
                } else {
                    this.buffers[0] = wsByteBuffer;
                }
            } else {
                this.buffers = null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void shutdown() {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.entry(tc, HttpTunnelSession.this.dbg(this + ".shutdown"));
            }
            boolean bl = false;
            Object object = this.writeMonitor;
            synchronized (object) {
                this.shutdown = true;
                this.writeMonitor.notifyAll();
                if (this.pendingWriteCount > 0L) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, HttpTunnelSession.this.dbg(this + ".shutdown: ERROR: pendingWriteCount=" + this.pendingWriteCount));
                    }
                    this.pendingWriteCount = 0L;
                    bl = true;
                }
            }
            if (bl && this.writeCB != null && (!HttpTunnelSession.this.getVirtualConnection().isInputStateTrackingOperational() || HttpTunnelSession.this.getVirtualConnection().requestPermissionToFinishWrite())) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, HttpTunnelSession.this.dbg(this + ": sending write error callback"));
                }
                this.writeError = new IOException("Connection has been shutdown.");
                if (!HttpTunnelSession.this.dispatchTask(this)) {
                    this.run();
                }
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, HttpTunnelSession.this.dbg(this + ".shutdown"));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void dataIsSent() {
            VirtualConnection virtualConnection;
            boolean bl = false;
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.entry(tc, HttpTunnelSession.this.dbg(this + ".dataIsSent"));
            }
            if (!(virtualConnection = HttpTunnelSession.this.getVirtualConnection()).isInputStateTrackingOperational() || virtualConnection.requestPermissionToFinishWrite()) {
                Object object = this.writeMonitor;
                synchronized (object) {
                    if (this.pendingWriteCount > 0L) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug(tc, HttpTunnelSession.this.dbg(this + ".dataIsSent: Before queuing outbound data: pendingWriteCount = " + this.pendingWriteCount));
                        }
                        if (this.sendCallback) {
                            this.pendingWriteCount -= (long)HttpTunnelSession.this.queueOutboundData(this.getBuffers());
                            if (this.pendingWriteCount <= 0L) {
                                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                    Tr.debug(tc, HttpTunnelSession.this.dbg(this + ".dataIsSent: send write completed"));
                                }
                                bl = true;
                                this.sendCallback = false;
                                this.writeTimer.stop();
                            } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                Tr.debug(tc, HttpTunnelSession.this.dbg(this + ".dataIsSent: pendingWriteCount = " + this.pendingWriteCount));
                            }
                        } else {
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                Tr.debug(tc, HttpTunnelSession.this.dbg(this + ".dataIsSent: notifyAll"));
                            }
                            this.writeMonitor.notifyAll();
                        }
                    }
                }
                if (bl) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, HttpTunnelSession.this.dbg(this + ": sending write completed callback"));
                    }
                    if (!HttpTunnelSession.this.dispatchWaitableTask(this)) {
                        this.run();
                    }
                } else if (virtualConnection.isInputStateTrackingOperational()) {
                    virtualConnection.setWriteStatetoCloseAllowedNoSync();
                    if (virtualConnection.getCloseWaiting()) {
                        virtualConnection.getLockObject();
                    }
                }
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, HttpTunnelSession.this.dbg(this + ".dataIsSent"));
            }
        }

        class WriteTimer
        extends TimeoutTask {
            WriteTimer(Timer timer) {
                super(timer);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.entry(tc, HttpTunnelSession.this.dbg("WriteTimer.run: timer expired"));
                }
                SocketTimeoutException socketTimeoutException = null;
                Object object = HttpTunnelWriteServiceContext.this.writeMonitor;
                synchronized (object) {
                    if (HttpTunnelWriteServiceContext.this.pendingWriteCount > 0L) {
                        HttpTunnelWriteServiceContext.this.pendingWriteCount = 0L;
                        if (HttpTunnelWriteServiceContext.this.sendCallback) {
                            HttpTunnelWriteServiceContext.this.sendCallback = false;
                            socketTimeoutException = new SocketTimeoutException("operation timed out");
                        } else {
                            HttpTunnelWriteServiceContext.this.writeTimerExpired = true;
                            HttpTunnelWriteServiceContext.this.writeMonitor.notifyAll();
                        }
                    }
                }
                if (socketTimeoutException != null) {
                    HttpTunnelWriteServiceContext.this.writeCB.error(HttpTunnelSession.this.getVirtualConnection(), (TCPWriteRequestContext)HttpTunnelWriteServiceContext.this.writeContext, (IOException)socketTimeoutException);
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, HttpTunnelSession.this.dbg("WriteTimer.run"));
                }
            }
        }
    }

    class HttpTunnelReadServiceContext
    implements TCPReadRequestContext,
    Runnable {
        protected TCPReadCompletedCallback readCB = null;
        private WsByteBuffer[] buffers = null;
        private int jitSize = 0;
        private boolean jitAction = false;
        protected long pendingReadCount = 0L;
        private boolean shutdown = false;
        protected boolean sendCallback = false;
        private ReadTimer readTimer = null;
        protected boolean readTimerExpired = false;
        protected HttpTunnelReadServiceContext readContext = this;
        protected Object readMonitor = new Object();
        protected WsByteBuffer jitBuffer = null;
        private IOException readError = null;

        public HttpTunnelReadServiceContext(Timer timer) {
            this.readTimer = new ReadTimer(timer);
        }

        public String toString() {
            return "HttpTunnelReadServiceContext";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public long read(long l, int n) throws IOException {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.entry(tc, HttpTunnelSession.this.dbg(this + ": (sync)"));
            }
            int n2 = 0;
            int n3 = n;
            this.readError = null;
            this.readCB = null;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, HttpTunnelSession.this.dbg(this + ": blocking: " + l + " byte(s)"));
            }
            if (!HttpTunnelSession.this.isSessionStarted()) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, HttpTunnelSession.this.dbg(this + ": read context is shutdown"));
                }
                throw new IOException("read context is shutdown");
            }
            if (n3 == -2) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, HttpTunnelSession.this.dbg(this + ": read cancelled; force read timeout"));
                }
                this.readTimer.expire();
            } else {
                this.sendCallback = false;
                this.checkForErrors(l, 0);
                if (n3 == 0) {
                    n3 = HttpTunnelSession.this.defaultReadTimeout;
                }
                if (this.getJITAllocateSize() != 0) {
                    this.setJITAllocateAction(true);
                    this.jitBuffer = WsByteBufferPoolManagerImpl.getRef().allocate(this.getJITAllocateSize());
                    this.setBuffer(this.jitBuffer);
                } else {
                    this.setJITAllocateAction(false);
                }
                Object object = this.readMonitor;
                synchronized (object) {
                    this.pendingReadCount = l;
                    n2 = HttpTunnelSession.this.readInboundData(this.getBuffers());
                    this.pendingReadCount -= (long)n2;
                    this.readTimerExpired = false;
                    if (this.pendingReadCount > 0L && n3 != -1) {
                        this.readTimer.start(n3);
                    }
                    while (this.pendingReadCount > 0L && !this.readTimerExpired) {
                        try {
                            this.readMonitor.wait();
                            if (this.shutdown) {
                                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                                    Tr.exit(tc, HttpTunnelSession.this.dbg(this + ": shutdown after wait"));
                                }
                                throw new IOException(HttpTunnelSession.CLOSED_EXCEPTION);
                            }
                            int n4 = HttpTunnelSession.this.readInboundData(this.getBuffers());
                            if (n4 == 0) continue;
                            n2 += n4;
                            this.pendingReadCount -= (long)n4;
                        }
                        catch (InterruptedException interruptedException) {
                            if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                            Tr.debug(tc, HttpTunnelSession.this.dbg(this + ".read: EXCEPTION: " + interruptedException));
                        }
                    }
                }
                if (n3 != -1) {
                    if (this.readTimerExpired) {
                        this.setJITAllocateAction(false);
                        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                            Tr.exit(tc, HttpTunnelSession.this.dbg(this + ": operation timed out"));
                        }
                        throw new SocketTimeoutException("operation timed out");
                    }
                    this.readTimer.stop();
                }
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, HttpTunnelSession.this.dbg(this + ".read"));
            }
            return n2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public VirtualConnection read(long l, TCPReadCompletedCallback tCPReadCompletedCallback, boolean bl, int n) {
            Object object;
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.entry(tc, HttpTunnelSession.this.dbg(this + ": (async)"));
            }
            VirtualConnection virtualConnection = null;
            int n2 = n;
            this.readError = null;
            if (!HttpTunnelSession.this.isSessionStarted()) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, HttpTunnelSession.this.dbg(this + ": read context is shutdown"));
                }
                this.readError = new IOException("read context is shutdown");
                if (bl) {
                    this.readCB = tCPReadCompletedCallback;
                    if (!HttpTunnelSession.this.dispatchTask(this)) {
                        this.run();
                    }
                } else {
                    tCPReadCompletedCallback.error(HttpTunnelSession.this.getVirtualConnection(), (TCPReadRequestContext)this, this.readError);
                }
                return null;
            }
            if (n2 == -2) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, HttpTunnelSession.this.dbg(this + ": read cancelled; force read timeout"));
                }
                this.readTimer.expire();
            } else {
                this.checkForErrors(l, 1);
                this.sendCallback = false;
                if (n2 == 0) {
                    n2 = HttpTunnelSession.this.defaultReadTimeout;
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, HttpTunnelSession.this.dbg(this + ": async: " + l + " byte(s)"));
                }
                if (this.getJITAllocateSize() != 0) {
                    this.setJITAllocateAction(true);
                    this.jitBuffer = WsByteBufferPoolManagerImpl.getRef().allocate(this.getJITAllocateSize());
                    this.setBuffer(this.jitBuffer);
                } else {
                    this.setJITAllocateAction(false);
                }
                object = this.readMonitor;
                synchronized (object) {
                    this.pendingReadCount = l - (long)HttpTunnelSession.this.readInboundData(this.getBuffers());
                    if (this.pendingReadCount > 0L) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug(tc, HttpTunnelSession.this.dbg(this + ": async callback after " + this.pendingReadCount + " bytes rec'd"));
                        }
                        this.sendCallback = true;
                        this.readCB = tCPReadCompletedCallback;
                        if (n2 != -1) {
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                Tr.debug(tc, HttpTunnelSession.this.dbg(this + ": start read timer. Timeout = " + n2));
                            }
                            this.readTimerExpired = false;
                            this.readTimer.start(n2);
                        }
                    } else {
                        this.pendingReadCount = 0L;
                        if (bl) {
                            this.readCB = tCPReadCompletedCallback;
                            if (!HttpTunnelSession.this.dispatchTask(this)) {
                                this.run();
                            }
                        } else {
                            virtualConnection = HttpTunnelSession.this.getVirtualConnection();
                        }
                    }
                }
            }
            if (HttpTunnelSession.this.getVirtualConnection().isInputStateTrackingOperational()) {
                object = HttpTunnelSession.this.getVirtualConnection().getLockObject();
                synchronized (object) {
                    HttpTunnelSession.this.getVirtualConnection().setReadStatetoCloseAllowedNoSync();
                    if (HttpTunnelSession.this.getVirtualConnection().getCloseWaiting()) {
                        HttpTunnelSession.this.getVirtualConnection().getLockObject().notify();
                    }
                }
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, HttpTunnelSession.this.dbg(this + ": (async), vc=" + virtualConnection));
            }
            return virtualConnection;
        }

        public void run() {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.entry(tc, HttpTunnelSession.this.dbg(this + ".run"));
            }
            TCPReadCompletedCallback tCPReadCompletedCallback = this.readCB;
            this.readCB = null;
            if (null != tCPReadCompletedCallback) {
                if (this.readError != null) {
                    tCPReadCompletedCallback.error(HttpTunnelSession.this.getVirtualConnection(), (TCPReadRequestContext)this, this.readError);
                } else {
                    tCPReadCompletedCallback.complete(HttpTunnelSession.this.getVirtualConnection(), (TCPReadRequestContext)this);
                }
            } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, HttpTunnelSession.this.dbg(this + ".run: null read callback"));
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, HttpTunnelSession.this.dbg(this + ".run"));
            }
        }

        private void checkForErrors(long l, int n) {
            String string = null;
            if (l < 0L && n == 0 || l < 1L && n == 1) {
                string = "Number of bytes to requested to read: " + l + " is less than minimum allowed (0 for sync, 1 for asynch)";
            } else if (this.getJITAllocateSize() > 0 && this.getBuffers() == null) {
                if (l > (long)this.getJITAllocateSize()) {
                    string = "Number of bytes requested: " + l + " exceeds JIT allocated buffer size: " + this.getJITAllocateSize();
                }
            } else if (this.getBuffers() == null || this.getBuffers().length == 0) {
                string = "No buffer(s) provided for reading data into";
            } else {
                WsByteBuffer[] wsByteBufferArray = this.getBuffers();
                long l2 = 0L;
                for (int i = 0; i < wsByteBufferArray.length && wsByteBufferArray[i] != null; ++i) {
                    l2 += (long)(wsByteBufferArray[i].limit() - wsByteBufferArray[i].position());
                }
                if (l > l2) {
                    string = "Number of bytes requested: " + l + " exceeds space remaining in the buffers provided: " + l2;
                }
            }
            if (string != null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, HttpTunnelSession.this.dbg(string));
                }
                throw new IllegalArgumentException(string);
            }
        }

        public TCPConnectionContext getInterface() {
            return HttpTunnelSession.this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void clearBuffers() {
            if (this.buffers == null) return;
            WsByteBuffer[] wsByteBufferArray = this.buffers;
            synchronized (this.buffers) {
                for (int i = 0; i < this.buffers.length; ++i) {
                    if (this.buffers[i] == null) continue;
                    this.buffers[i].clear();
                }
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
        }

        public WsByteBuffer getBuffer(int n) {
            WsByteBuffer wsByteBuffer = null;
            if (this.buffers != null && this.buffers.length > n) {
                wsByteBuffer = this.buffers[n];
            }
            return wsByteBuffer;
        }

        public WsByteBuffer[] getBuffers() {
            return this.buffers;
        }

        public void setBuffers(WsByteBuffer[] wsByteBufferArray) {
            this.buffers = wsByteBufferArray;
        }

        public WsByteBuffer getBuffer() {
            return this.getBuffer(0);
        }

        public void setBuffer(WsByteBuffer wsByteBuffer) {
            if (wsByteBuffer != null) {
                if (this.buffers == null) {
                    this.buffers = new WsByteBuffer[]{wsByteBuffer};
                } else {
                    this.buffers[0] = wsByteBuffer;
                }
            } else {
                this.buffers = null;
            }
        }

        public void setJITAllocateSize(int n) {
            this.jitSize = n;
        }

        public boolean getJITAllocateAction() {
            return this.jitAction;
        }

        private int getJITAllocateSize() {
            return this.jitSize;
        }

        protected void setJITAllocateAction(boolean bl) {
            this.jitAction = bl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void dataIsReceived() {
            VirtualConnection virtualConnection;
            boolean bl = false;
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.entry(tc, HttpTunnelSession.this.dbg(this + ".dataIsReceived: pending=" + this.pendingReadCount));
            }
            if (!(virtualConnection = HttpTunnelSession.this.getVirtualConnection()).isInputStateTrackingOperational() || virtualConnection.requestPermissionToFinishRead()) {
                Object object = this.readMonitor;
                synchronized (object) {
                    if (this.pendingReadCount > 0L) {
                        if (this.sendCallback) {
                            this.pendingReadCount -= (long)HttpTunnelSession.this.readInboundData(this.getBuffers());
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                Tr.debug(tc, HttpTunnelSession.this.dbg(this + ".dataIsReceived: pending=" + this.pendingReadCount));
                            }
                            if (this.pendingReadCount <= 0L) {
                                bl = true;
                            }
                        } else {
                            this.readMonitor.notifyAll();
                        }
                    }
                }
                if (bl) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, HttpTunnelSession.this.dbg(this + ".dataIsReceived: call complete()"));
                    }
                    this.readTimer.stop();
                    this.readCB.complete(HttpTunnelSession.this.getVirtualConnection(), (TCPReadRequestContext)this);
                } else if (virtualConnection.isInputStateTrackingOperational()) {
                    virtualConnection.setReadStatetoCloseAllowedNoSync();
                    if (virtualConnection.getCloseWaiting()) {
                        virtualConnection.getLockObject();
                    }
                }
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, HttpTunnelSession.this.dbg(this + ".dataIsReceived"));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void shutdown() {
            boolean bl = false;
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.entry(tc, HttpTunnelSession.this.dbg(this + ".shutdown"));
            }
            Object object = this.readMonitor;
            synchronized (object) {
                this.shutdown = true;
                if (this.jitBuffer != null) {
                    this.setJITAllocateAction(false);
                    WsByteBuffer wsByteBuffer = this.getBuffer();
                    if (wsByteBuffer != null) {
                        wsByteBuffer.release();
                    }
                    this.setBuffer(null);
                }
                this.readMonitor.notifyAll();
                if (this.pendingReadCount > 0L) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, HttpTunnelSession.this.dbg(this + ".shutdown: ERROR: pendingReadCount=" + this.pendingReadCount));
                    }
                    this.pendingReadCount = 0L;
                    bl = true;
                }
            }
            if (bl && this.readCB != null) {
                this.readTimer.stop();
                if (!HttpTunnelSession.this.getVirtualConnection().isInputStateTrackingOperational() || HttpTunnelSession.this.getVirtualConnection().requestPermissionToFinishRead()) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, HttpTunnelSession.this.dbg(this + ": sending read error callback"));
                    }
                    this.readError = new IOException("Connection has been shutdown.");
                    if (!HttpTunnelSession.this.dispatchTask(this)) {
                        this.run();
                    }
                }
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, HttpTunnelSession.this.dbg(this + ".shutdown"));
            }
        }

        class ReadTimer
        extends TimeoutTask {
            ReadTimer(Timer timer) {
                super(timer);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.entry(tc, HttpTunnelSession.this.dbg("ReadTimer.run: timer expired"));
                }
                SocketTimeoutException socketTimeoutException = null;
                Object object = HttpTunnelReadServiceContext.this.readMonitor;
                synchronized (object) {
                    if (HttpTunnelReadServiceContext.this.pendingReadCount > 0L) {
                        HttpTunnelReadServiceContext.this.pendingReadCount = 0L;
                        if (HttpTunnelReadServiceContext.this.jitBuffer != null) {
                            HttpTunnelReadServiceContext.this.setJITAllocateAction(false);
                            HttpTunnelReadServiceContext.this.getBuffer().release();
                            HttpTunnelReadServiceContext.this.setBuffer(null);
                        }
                        if (HttpTunnelReadServiceContext.this.sendCallback) {
                            HttpTunnelReadServiceContext.this.sendCallback = false;
                            socketTimeoutException = new SocketTimeoutException("operation timed out");
                        } else {
                            HttpTunnelReadServiceContext.this.readTimerExpired = true;
                            HttpTunnelReadServiceContext.this.readMonitor.notifyAll();
                        }
                    }
                }
                if (socketTimeoutException != null) {
                    HttpTunnelReadServiceContext.this.readCB.error(HttpTunnelSession.this.getVirtualConnection(), (TCPReadRequestContext)HttpTunnelReadServiceContext.this.readContext, socketTimeoutException);
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, HttpTunnelSession.this.dbg("ReadTimer.run"));
                }
            }
        }
    }
}

