/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wkplc.httptunnel.inbound.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.wkplc.httptunnel.HttpTunnelException;
import com.ibm.wkplc.httptunnel.impl.HttpRequestProperties;
import com.ibm.wkplc.httptunnel.impl.HttpSessionConnection;
import com.ibm.wkplc.httptunnel.impl.HttpSessionConnectionListener;
import com.ibm.wkplc.httptunnel.inbound.impl.HttpInboundSessionConnectionListener;
import com.ibm.wkplc.httptunnel.inbound.impl.HttpRequestDefaultHandler;
import com.ibm.wkplc.httptunnel.inbound.impl.HttpRequestHandler;
import com.ibm.wkplc.httptunnel.inbound.impl.HttpRequestJavaScriptHandler;
import com.ibm.wkplc.util.BufferUtil;
import com.ibm.ws.buffermgmt.impl.WsByteBufferPoolManagerImpl;
import com.ibm.wsspi.buffermgmt.WsByteBuffer;
import com.ibm.wsspi.buffermgmt.WsByteBufferUtils;
import com.ibm.wsspi.channel.ConnectionLink;
import com.ibm.wsspi.channel.InterChannelCallback;
import com.ibm.wsspi.channel.base.InboundApplicationLink;
import com.ibm.wsspi.channel.framework.VirtualConnection;
import com.ibm.wsspi.genericbnf.HeaderKeys;
import com.ibm.wsspi.genericbnf.exception.MessageSentException;
import com.ibm.wsspi.http.channel.HttpBaseMessage;
import com.ibm.wsspi.http.channel.HttpConstants;
import com.ibm.wsspi.http.channel.HttpRequestMessage;
import com.ibm.wsspi.http.channel.HttpResponseMessage;
import com.ibm.wsspi.http.channel.HttpServiceContext;
import com.ibm.wsspi.http.channel.inbound.HttpInboundServiceContext;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Timer;
import java.util.TimerTask;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.Cookie;

public class HttpInboundSessionConnection
implements HttpSessionConnection {
    protected static final TraceComponent tc = Tr.register(HttpInboundSessionConnection.class, "HTTPTunnelChannel", "com.ibm.wkplc.httptunnel.resources.tunnelMessages");
    private static final int EVENT_ID_NEW_GET = 1;
    private static final int EVENT_ID_WRITE_DATA_AVAILABLE = 2;
    private static final int EVENT_ID_WRITE_SESSION_CLOSED = 3;
    private static final int EVENT_ID_GET_REQUEST_TIMEOUT = 4;
    private static final int EVENT_ID_SESSION_TIMEOUT = 5;
    private static final int EVENT_ID_PAUSE = 6;
    private static final int EVENT_ID_NEW_POST = 1;
    private static final int EVENT_ID_POST_REQUEST_COMPLETED = 2;
    private static final int EVENT_ID_READ_SESSION_CLOSED = 3;
    private static final byte[] NO_CACHE_BYTES = "no-cache".getBytes();
    private static final byte[] NO_CACHE_PRAGMA_BYTES = "no-cache".getBytes();
    private static final int RETRY_INTERVAL = 500;
    protected ConnectionState WRITE_STATE_CLOSED = new WriteStateClosed();
    protected ConnectionState WRITE_STATE_IDLE = new WriteStateIdle();
    protected ConnectionState WRITE_STATE_DATA_PENDING = new WriteStateDataPending();
    protected ConnectionState WRITE_STATE_GET_PENDING = new WriteStateGetPending();
    protected ConnectionState READ_STATE_CLOSED = new ReadStateClosed();
    protected ConnectionState READ_STATE_IDLE = new ReadStateIdle();
    private static final String HTTP_SERVICE_CONTEXT_KEY = "HSC_KEY";
    private static final String HTTP_SESSION_PROPERTIES_KEY = "HSP_KEY";
    protected static final String HTTP_CONNECTION_LINK_KEY = "HCL_KEY";
    private static final int HTTP_OK = 200;
    private static final String DEFAULT_HANDLER = "*";
    private static final String JAVASCRIPT_HANDLER = "js";
    private static final String HANDLER_PARAM = "type";
    protected int serverSequence = 0;
    protected int clientSequence = 0;
    private int sessionId = 0;
    protected HttpRequestCallback httpRequestCallback = new HttpRequestCallback();
    protected HttpResponseCallback httpResponseCallback = new HttpResponseCallback();
    protected HttpSessionConnectionListener sessionListener = null;
    protected WsByteBuffer lastWriteBuffer = null;
    protected WsByteBuffer lastReadBuffer = null;
    private final WsByteBuffer[] lastWriteBufferArray = new WsByteBuffer[1];
    private final WsByteBuffer[] lastReadBufferArray = new WsByteBuffer[1];
    private final StringBuffer templateWriteBuffer = new StringBuffer();
    private final StringBuffer templateReadBuffer = new StringBuffer();
    private HttpInboundSessionConnectionListener inboundConnectionListener = null;
    private ConnectionState writeState = this.WRITE_STATE_IDLE;
    private ConnectionState readState = this.READ_STATE_IDLE;
    private boolean connectionClosed = false;
    private Object writeThreadMonitor = new Object();
    private Object readThreadMonitor = new Object();
    private TimeoutTask sessionTimeoutTimer = null;
    private TimeoutTask getRequestTimeoutTimer = null;
    private ConnectionLink connLink = null;
    private Cookie affinityCookie = null;
    private InetAddress remoteAddress = null;
    private int remotePort = 0;
    private InetAddress localAddress = null;
    private int localPort = 0;
    protected Exception shutdownReason = null;
    private final HashMap requestHandlers = new HashMap();
    private final Pattern tagPattern = Pattern.compile("@([^@]*)@");

    public HttpInboundSessionConnection(HttpInboundSessionConnectionListener httpInboundSessionConnectionListener, Timer timer, int n, int n2, Cookie cookie, int n3) {
        this.inboundConnectionListener = httpInboundSessionConnectionListener;
        this.affinityCookie = cookie;
        this.sessionId = n3;
        this.sessionTimeoutTimer = new SessionTimeoutTimer(timer, n);
        this.getRequestTimeoutTimer = new GetRequestTimeoutTimer(timer, n2);
        this.requestHandlers.put(DEFAULT_HANDLER, new HttpRequestDefaultHandler());
        this.requestHandlers.put(JAVASCRIPT_HANDLER, new HttpRequestJavaScriptHandler());
    }

    protected String dbg(String string) {
        int n = 0;
        if (this.getSessListener() != null) {
            n = this.getSessListener().hashCode();
        }
        return string + " (hc=" + this.hashCode() + "; sc=" + n + ")";
    }

    public InetAddress getRemoteAddress() {
        return this.remoteAddress;
    }

    public int getRemotePort() {
        return this.remotePort;
    }

    public InetAddress getLocalAddress() {
        return this.localAddress;
    }

    public int getLocalPort() {
        return this.localPort;
    }

    public int getSessionConnectionId() {
        return this.sessionId;
    }

    public void setHttpConnectionListener(HttpSessionConnectionListener httpSessionConnectionListener) {
        this.sessionListener = httpSessionConnectionListener;
    }

    protected HttpSessionConnectionListener getSessListener() {
        return this.sessionListener;
    }

    public void writePending() {
        this.handleWriteEvent(2, null);
    }

    public void close(Exception exception) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, this.dbg("close: " + exception));
        }
        if (!this.connectionClosed) {
            this.connectionClosed = true;
            this.shutdownReason = exception;
            this.getSessionTimer().stop();
            this.getRequestTimer().stop();
            this.handleWriteEvent(3, null);
            this.handleReadEvent(3, null);
            this.getSessListener().sessionConnectionClosed(null);
            this.inboundConnectionListener.sessionConnectionClosed(this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, this.dbg("close"));
        }
    }

    public void setConnLink(ConnectionLink connectionLink) {
        this.connLink = connectionLink;
    }

    public ConnectionLink getConnLink() {
        return this.connLink;
    }

    protected int getSSQ() {
        return this.serverSequence;
    }

    protected int getCSQ() {
        return this.clientSequence;
    }

    protected TimeoutTask getSessionTimer() {
        return this.sessionTimeoutTimer;
    }

    protected TimeoutTask getRequestTimer() {
        return this.getRequestTimeoutTimer;
    }

    protected WsByteBuffer getLastWriteBuffer() {
        return this.lastWriteBuffer;
    }

    protected WsByteBuffer getLastReadBuffer() {
        return this.lastReadBuffer;
    }

    public void requestReceived(InboundApplicationLink inboundApplicationLink, HttpRequestProperties httpRequestProperties) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, this.dbg("requestReceived"));
        }
        VirtualConnection virtualConnection = inboundApplicationLink.getVirtualConnection();
        HttpInboundServiceContext httpInboundServiceContext = (HttpInboundServiceContext)inboundApplicationLink.getDeviceLink().getChannelAccessor();
        if (this.remoteAddress == null) {
            this.remoteAddress = httpInboundServiceContext.getRemoteAddr();
            this.remotePort = httpInboundServiceContext.getRemotePort();
            this.localAddress = httpInboundServiceContext.getLocalAddr();
            this.localPort = httpInboundServiceContext.getLocalPort();
        }
        virtualConnection.getStateMap().put(HTTP_SERVICE_CONTEXT_KEY, httpInboundServiceContext);
        virtualConnection.getStateMap().put(HTTP_SESSION_PROPERTIES_KEY, httpRequestProperties);
        virtualConnection.getStateMap().put(HTTP_CONNECTION_LINK_KEY, inboundApplicationLink);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, this.dbg("requestReceived: QueryString = " + httpInboundServiceContext.getRequest().getQueryString()));
            Tr.debug(tc, this.dumpMessage(httpInboundServiceContext.getRequest()));
        }
        if (!httpRequestProperties.isSessionClosed()) {
            if (httpInboundServiceContext.getRequest().getMethodValue().equals(HttpConstants.METHOD_GET)) {
                if (httpRequestProperties.isSessionPaused()) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, this.dbg("requestReceived: Session is paused: handling GET"));
                    }
                    this.sendResponse(httpInboundServiceContext, httpRequestProperties, null, 200, virtualConnection, false, false);
                    this.handleWriteEvent(6, null);
                } else {
                    this.handleWriteEvent(1, virtualConnection);
                }
            } else {
                this.handleReadEvent(1, virtualConnection);
                if (httpRequestProperties.isSessionPaused()) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, this.dbg("requestReceived: Session is paused: handling POST"));
                    }
                    this.handleWriteEvent(6, virtualConnection);
                }
            }
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, this.dbg("requestReceived: session closed...request ignored"));
            }
            this.close(new HttpTunnelException("Session closed"));
            this.sendResponse(httpInboundServiceContext, httpRequestProperties, null, 200, virtualConnection, false, false);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, this.dbg("requestReceived"));
        }
    }

    public void sendResponse(HttpServiceContext httpServiceContext, HttpRequestProperties httpRequestProperties, WsByteBuffer wsByteBuffer, int n, VirtualConnection virtualConnection, boolean bl, boolean bl2) {
        block26: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, this.dbg("sendResponse"));
            }
            HttpRequestHandler httpRequestHandler = this.getRequestHandler(httpServiceContext, httpRequestProperties);
            httpRequestProperties.setSessionId(this.getSessionConnectionId());
            HttpResponseMessage httpResponseMessage = httpServiceContext.getResponse();
            if (this.shutdownReason != null) {
                httpRequestProperties.setSessionClosed(true);
                httpResponseMessage.setConnection(HttpConstants.CONN_CLOSE);
            }
            httpResponseMessage.setCookie(httpRequestProperties.createSessionCookie(), HttpConstants.HDR_SET_COOKIE);
            if (this.affinityCookie != null) {
                httpResponseMessage.setCookie(this.affinityCookie, HttpConstants.HDR_SET_COOKIE);
            }
            if (HttpConstants.HTTP_VERSION_10.equals(httpResponseMessage.getVersionValue())) {
                httpResponseMessage.setHeader((HeaderKeys)HttpConstants.HDR_PRAGMA, NO_CACHE_PRAGMA_BYTES);
            } else {
                httpResponseMessage.setHeader((HeaderKeys)HttpConstants.HDR_CACHE_CONTROL, NO_CACHE_BYTES);
            }
            httpResponseMessage.setHeader((HeaderKeys)HttpConstants.HDR_CONTENT_TYPE, httpRequestHandler.getContentType());
            httpResponseMessage.setStatusCode(n);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "sendResponse:" + this.dbg("") + "\n" + this.dumpMessage(httpResponseMessage));
            }
            try {
                WsByteBuffer[] wsByteBufferArray = null;
                String string = null;
                if (bl2) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, this.dbg("sendResponse: resend response!"));
                    }
                    if (wsByteBuffer != null && wsByteBuffer.position() > 0) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, this.dbg("sendResponse: flip response buffer"));
                        }
                        wsByteBuffer.flip();
                    }
                    if (httpServiceContext.getRequest().getMethodValue().equals(HttpConstants.METHOD_GET)) {
                        this.lastWriteBufferArray[0] = wsByteBuffer;
                        this.lastWriteBuffer = this.lastWriteBufferArray[0];
                        wsByteBufferArray = this.lastWriteBufferArray;
                    } else {
                        this.lastReadBufferArray[0] = wsByteBuffer;
                        this.lastReadBuffer = this.lastReadBufferArray[0];
                        wsByteBufferArray = this.lastReadBufferArray;
                    }
                } else if (httpServiceContext.getRequest().getMethodValue().equals(HttpConstants.METHOD_GET)) {
                    string = httpRequestHandler.getWriteTemplate();
                    this.lastWriteBufferArray[0] = string != null ? this.createResponse(httpRequestProperties, wsByteBuffer, string, this.templateWriteBuffer, this.lastWriteBufferArray[0]) : wsByteBuffer;
                    this.lastWriteBuffer = this.lastWriteBufferArray[0];
                    wsByteBufferArray = this.lastWriteBufferArray;
                } else {
                    string = httpRequestHandler.getReadTemplate();
                    this.lastReadBufferArray[0] = string != null ? this.createResponse(httpRequestProperties, wsByteBuffer, string, this.templateReadBuffer, this.lastReadBufferArray[0]) : wsByteBuffer;
                    this.lastReadBuffer = this.lastReadBufferArray[0];
                    wsByteBufferArray = this.lastReadBufferArray;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, this.dbg("sendResponse: " + (wsByteBufferArray[0] != null ? wsByteBufferArray[0].limit() : 0) + " bytes"));
                }
                VirtualConnection virtualConnection2 = null;
                if (!bl) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, this.dbg("sendResponse: sending response asynchronously"));
                    }
                    virtualConnection2 = ((HttpInboundServiceContext)httpServiceContext).finishResponseMessage(wsByteBufferArray, this.httpResponseCallback, false);
                } else {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, this.dbg("sendResponse: sending response synchronously"));
                    }
                    ((HttpInboundServiceContext)httpServiceContext).finishResponseMessage(wsByteBufferArray);
                }
                if (virtualConnection2 != null || bl) {
                    this.closeConnection(virtualConnection, null);
                }
            }
            catch (MessageSentException messageSentException) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, this.dbg("sendResponse: EXCEPTION: " + messageSentException));
                }
            }
            catch (IOException iOException) {
                if (!tc.isDebugEnabled()) break block26;
                Tr.debug(tc, this.dbg("sendResponse: EXCEPTION: " + iOException));
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, this.dbg("sendResponse"));
        }
    }

    protected HttpRequestHandler getRequestHandler(HttpServiceContext httpServiceContext, HttpRequestProperties httpRequestProperties) {
        String string = httpRequestProperties.getRequestProperty(HANDLER_PARAM);
        HttpRequestHandler httpRequestHandler = null;
        if (string != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, this.dbg("getRequestHandler: type=" + string));
            }
            httpRequestHandler = (HttpRequestHandler)this.requestHandlers.get(string.toLowerCase());
        }
        if (httpRequestHandler == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, this.dbg("getRequestHandler: use default handler"));
            }
            httpRequestHandler = (HttpRequestHandler)this.requestHandlers.get(DEFAULT_HANDLER);
        }
        return httpRequestHandler;
    }

    private WsByteBuffer createResponse(HttpRequestProperties httpRequestProperties, WsByteBuffer wsByteBuffer, String string, StringBuffer stringBuffer, WsByteBuffer wsByteBuffer2) {
        WsByteBuffer wsByteBuffer3 = wsByteBuffer2;
        Matcher matcher = this.tagPattern.matcher(string);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "createResponse: " + this.dbg("") + "\n" + string);
        }
        stringBuffer.setLength(0);
        while (matcher.find()) {
            String string2;
            block12: {
                String string3 = matcher.group(1);
                string2 = null;
                if (string3.equalsIgnoreCase("data")) {
                    try {
                        if (wsByteBuffer != null) {
                            string2 = URLEncoder.encode(WsByteBufferUtils.asString((WsByteBuffer)wsByteBuffer), "UTF-8");
                        }
                        break block12;
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, this.dbg("createTags: EXCEPTION: " + unsupportedEncodingException));
                        }
                        break block12;
                    }
                }
                string2 = string3.equalsIgnoreCase("id") ? "" + httpRequestProperties.getSessionId() : httpRequestProperties.getRequestProperty(string3.toLowerCase());
            }
            if (string2 == null && tc.isDebugEnabled()) {
                Tr.debug(tc, this.dbg("createResponse: tag not found: " + matcher.group()));
            }
            matcher.appendReplacement(stringBuffer, string2 != null ? string2 : "");
        }
        matcher.appendTail(stringBuffer);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "createResponse: " + this.dbg("") + "\n" + stringBuffer);
        }
        if (wsByteBuffer3 == null || wsByteBuffer3.capacity() < stringBuffer.length()) {
            if (wsByteBuffer3 != null) {
                wsByteBuffer3.release();
            }
            wsByteBuffer3 = WsByteBufferPoolManagerImpl.getRef().allocate(stringBuffer.length());
        }
        if (wsByteBuffer3 != null) {
            wsByteBuffer3.clear();
            wsByteBuffer3.put(stringBuffer.toString().getBytes());
            wsByteBuffer3.flip();
        }
        return wsByteBuffer3;
    }

    protected void closeConnection(VirtualConnection virtualConnection, Exception exception) {
        InboundApplicationLink inboundApplicationLink;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, this.dbg("closeConnection: " + exception));
        }
        if ((inboundApplicationLink = (InboundApplicationLink)virtualConnection.getStateMap().get(HTTP_CONNECTION_LINK_KEY)) != null) {
            inboundApplicationLink.close(virtualConnection, exception);
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, this.dbg("closeConnection: invalid connlink"));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, this.dbg("closeConnection"));
        }
    }

    protected void changeReadState(ConnectionState connectionState) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, this.dbg("changeReadState from: " + this.readState.toString() + " to: " + connectionState.toString()));
        }
        this.readState = connectionState;
    }

    protected void changeWriteState(ConnectionState connectionState) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, this.dbg("changeWriteState from: " + this.writeState.toString() + " to: " + connectionState.toString()));
        }
        this.writeState = connectionState;
        this.writeState.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleWriteEvent(int n, VirtualConnection virtualConnection) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, this.dbg("handleWriteEvent"));
        }
        Object object = this.writeThreadMonitor;
        synchronized (object) {
            if (virtualConnection != null) {
                this.writeState.setContextVC(virtualConnection);
            }
            this.writeState.handleEvent(n);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, this.dbg("handleWriteEvent"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleReadEvent(int n, VirtualConnection virtualConnection) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, this.dbg("handleReadEvent"));
        }
        Object object = this.readThreadMonitor;
        synchronized (object) {
            if (virtualConnection != null) {
                this.readState.setContextVC(virtualConnection);
            }
            this.readState.handleEvent(n);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, this.dbg("handleReadEvent"));
        }
    }

    String dumpMessage(HttpBaseMessage httpBaseMessage) {
        Object object;
        StringBuffer stringBuffer = new StringBuffer();
        if (httpBaseMessage instanceof HttpRequestMessage) {
            object = (HttpRequestMessage)httpBaseMessage;
            stringBuffer.append("\t").append(object.getMethod());
            stringBuffer.append(" ");
            stringBuffer.append(object.getRequestURI());
            stringBuffer.append("?");
            stringBuffer.append(object.getQueryString());
            stringBuffer.append(" ");
            stringBuffer.append(object.getVersion());
        } else {
            object = (HttpResponseMessage)httpBaseMessage;
            stringBuffer.append("\tHTTP ").append(object.getStatusCode().getIntCode());
        }
        object = httpBaseMessage.getAllHeaders().iterator();
        while (object.hasNext()) {
            String string = (String)object.next();
            stringBuffer.append("\n\t").append(string).append("=").append(httpBaseMessage.getHeaderAsString(string));
        }
        return stringBuffer.toString();
    }

    class GetRequestTimeoutTimer
    extends TimeoutTask {
        GetRequestTimeoutTimer(Timer timer, long l) {
            super(timer, l);
        }

        public void run() {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, HttpInboundSessionConnection.this.dbg("GetRequestTimeoutTimer.run: timer expired: " + HttpInboundSessionConnection.this.getSessionConnectionId()));
            }
            HttpInboundSessionConnection.this.handleWriteEvent(4, null);
        }
    }

    class SessionTimeoutTimer
    extends TimeoutTask {
        SessionTimeoutTimer(Timer timer, long l) {
            super(timer, l);
        }

        public void run() {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, HttpInboundSessionConnection.this.dbg("SessionTimeoutTimer.run: timer expired: " + HttpInboundSessionConnection.this.getSessionConnectionId()));
            }
            HttpInboundSessionConnection.this.handleWriteEvent(5, null);
        }
    }

    abstract class TimeoutTask {
        private Timer timer = null;
        private TimerTask task = null;
        private long ms = -1L;
        private long t0 = System.currentTimeMillis();

        TimeoutTask(Timer timer, long l) {
            this.timer = timer;
            this.ms = l;
        }

        public abstract void run();

        public synchronized void start() {
            block2: {
                try {
                    this.stop();
                    this.task = new TimerTask(){

                        public void run() {
                            block2: {
                                try {
                                    TimeoutTask.this.run();
                                }
                                catch (Exception exception) {
                                    if (!tc.isDebugEnabled()) break block2;
                                    Tr.debug(tc, HttpInboundSessionConnection.this.dbg("TimeoutTask.run: EXCEPTION: " + exception));
                                }
                            }
                        }
                    };
                    this.t0 = System.currentTimeMillis();
                    this.timer.schedule(this.task, this.ms);
                }
                catch (Exception exception) {
                    if (!tc.isDebugEnabled()) break block2;
                    Tr.debug(tc, HttpInboundSessionConnection.this.dbg("TimeoutTask.run: EXCEPTION: " + exception));
                }
            }
        }

        public synchronized void stop() {
            if (this.task != null) {
                this.task.cancel();
                this.task = null;
            }
        }

        public String toString() {
            return System.currentTimeMillis() - this.t0 + "ms";
        }
    }

    class ReadStateIdle
    extends ConnectionState {
        ReadStateIdle() {
        }

        public String toString() {
            return "ReadStateIdle";
        }

        public void handleEvent(int n) {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, HttpInboundSessionConnection.this.dbg("ReadStateIdle:handleEvent: " + n));
            }
            switch (n) {
                case 1: 
                case 2: {
                    HttpRequestProperties httpRequestProperties = (HttpRequestProperties)this.contextVC.getStateMap().get(HttpInboundSessionConnection.HTTP_SESSION_PROPERTIES_KEY);
                    HttpInboundServiceContext httpInboundServiceContext = (HttpInboundServiceContext)this.contextVC.getStateMap().get(HttpInboundSessionConnection.HTTP_SERVICE_CONTEXT_KEY);
                    WsByteBuffer[] wsByteBufferArray = null;
                    try {
                        if (httpInboundServiceContext.getRequestBodyBuffers(HttpInboundSessionConnection.this.httpRequestCallback, false) == null) break;
                        int n2 = httpRequestProperties.getClientSequence();
                        if (n2 == HttpInboundSessionConnection.this.getCSQ() + 1) {
                            HttpRequestHandler httpRequestHandler = HttpInboundSessionConnection.this.getRequestHandler(httpInboundServiceContext, httpRequestProperties);
                            try {
                                wsByteBufferArray = httpRequestHandler.getBodyData(httpInboundServiceContext);
                                if (wsByteBufferArray != null) {
                                    HttpInboundSessionConnection.this.getSessListener().setReadData(wsByteBufferArray, HttpInboundSessionConnection.this);
                                }
                                ++HttpInboundSessionConnection.this.clientSequence;
                            }
                            catch (IOException iOException) {
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, HttpInboundSessionConnection.this.dbg("ReadStateIdle: EVENT_ID_NEW_GET: Input buffers are full. Flow control the request."));
                                }
                                httpRequestProperties.setRequestProperty("rti", "500");
                            }
                            BufferUtil.release(wsByteBufferArray);
                            HttpInboundSessionConnection.this.sendResponse(httpInboundServiceContext, httpRequestProperties, null, 200, this.contextVC, false, false);
                            break;
                        }
                        if (n2 == HttpInboundSessionConnection.this.getCSQ()) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, HttpInboundSessionConnection.this.dbg("ReadStateIdle: EVENT_ID_NEW_POST: CSQ matches; resend last response"));
                            }
                            HttpInboundSessionConnection.this.sendResponse(httpInboundServiceContext, httpRequestProperties, HttpInboundSessionConnection.this.getLastReadBuffer(), 200, this.contextVC, false, true);
                            break;
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, HttpInboundSessionConnection.this.dbg("ReadStateIdle: EVENT_ID_NEW_POST: invalid CSQ"));
                        }
                        HttpInboundSessionConnection.this.close(new HttpTunnelException("Invalid CSQ"));
                        HttpInboundSessionConnection.this.sendResponse(httpInboundServiceContext, httpRequestProperties, null, 200, this.contextVC, false, false);
                    }
                    catch (Exception exception) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, HttpInboundSessionConnection.this.dbg("ReadStateIdle: EVENT_ID_NEW_POST: EXCEPTION: " + exception));
                        }
                        HttpInboundSessionConnection.this.closeConnection(this.contextVC, exception);
                    }
                    break;
                }
                case 3: {
                    HttpInboundSessionConnection.this.changeReadState(HttpInboundSessionConnection.this.READ_STATE_CLOSED);
                    break;
                }
                default: {
                    super.handleEvent(n);
                }
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, HttpInboundSessionConnection.this.dbg("ReadStateIdle:handleEvent"));
            }
        }
    }

    class ReadStateClosed
    extends ConnectionState {
        ReadStateClosed() {
        }

        public String toString() {
            return "ReadStateClosed";
        }

        public void handleEvent(int n) {
        }
    }

    class WriteStateGetPending
    extends ConnectionState {
        static final /* synthetic */ boolean $assertionsDisabled;

        WriteStateGetPending() {
        }

        public String toString() {
            return "WriteStateGetPending";
        }

        public void init() {
            HttpInboundSessionConnection.this.getRequestTimer().start();
        }

        public void handleEvent(int n) {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, HttpInboundSessionConnection.this.dbg("WriteStateGetPending:handleEvent: " + n));
            }
            HttpRequestProperties httpRequestProperties = (HttpRequestProperties)this.contextVC.getStateMap().get(HttpInboundSessionConnection.HTTP_SESSION_PROPERTIES_KEY);
            HttpInboundServiceContext httpInboundServiceContext = (HttpInboundServiceContext)this.contextVC.getStateMap().get(HttpInboundSessionConnection.HTTP_SERVICE_CONTEXT_KEY);
            switch (n) {
                case 2: {
                    if (!$assertionsDisabled && null != HttpInboundSessionConnection.this.getLastWriteBuffer()) {
                        throw new AssertionError();
                    }
                    HttpInboundSessionConnection.this.lastWriteBuffer = HttpInboundSessionConnection.this.getSessListener().getWriteData(HttpInboundSessionConnection.this);
                    if (null == HttpInboundSessionConnection.this.getLastWriteBuffer()) {
                        if (!tc.isDebugEnabled()) break;
                        Tr.debug(tc, HttpInboundSessionConnection.this.dbg(this + ": WRITE_DATA_AVAILABLE: no data ready"));
                        break;
                    }
                    HttpInboundSessionConnection.this.getRequestTimer().stop();
                    ++HttpInboundSessionConnection.this.serverSequence;
                    httpRequestProperties.setRequestProperty("ssq", "" + HttpInboundSessionConnection.this.getSSQ());
                    HttpInboundSessionConnection.this.sendResponse(httpInboundServiceContext, httpRequestProperties, HttpInboundSessionConnection.this.getLastWriteBuffer(), 200, this.contextVC, false, false);
                    if (HttpInboundSessionConnection.this.getSessListener().isWriteDataPending()) {
                        HttpInboundSessionConnection.this.getSessionTimer().start();
                        HttpInboundSessionConnection.this.changeWriteState(HttpInboundSessionConnection.this.WRITE_STATE_DATA_PENDING);
                        break;
                    }
                    HttpInboundSessionConnection.this.changeWriteState(HttpInboundSessionConnection.this.WRITE_STATE_IDLE);
                    break;
                }
                case 3: {
                    HttpInboundSessionConnection.this.getRequestTimer().stop();
                    HttpInboundSessionConnection.this.sendResponse(httpInboundServiceContext, httpRequestProperties, HttpInboundSessionConnection.this.getLastWriteBuffer(), 200, this.contextVC, true, true);
                    HttpInboundSessionConnection.this.changeWriteState(HttpInboundSessionConnection.this.WRITE_STATE_CLOSED);
                    break;
                }
                case 4: {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, HttpInboundSessionConnection.this.dbg("WriteStateGetPending: EVENT_ID_GET_REQUEST_TIMEOUT: request expired"));
                    }
                    HttpInboundSessionConnection.this.sendResponse(httpInboundServiceContext, httpRequestProperties, null, 200, this.contextVC, false, false);
                    HttpInboundSessionConnection.this.changeWriteState(HttpInboundSessionConnection.this.WRITE_STATE_IDLE);
                    break;
                }
                case 6: {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, HttpInboundSessionConnection.this.dbg("WriteStateGetPending: EVENT_ID_PAUSE: pause requested"));
                    }
                    HttpInboundSessionConnection.this.getRequestTimer().stop();
                    HttpInboundSessionConnection.this.sendResponse(httpInboundServiceContext, httpRequestProperties, null, 200, this.contextVC, false, false);
                    HttpInboundSessionConnection.this.changeWriteState(HttpInboundSessionConnection.this.WRITE_STATE_IDLE);
                    break;
                }
                case 1: {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, HttpInboundSessionConnection.this.dbg("WriteStateGetPending: EVENT_ID_NEW_GET: new GET received. Must release the previous get."));
                    }
                    HttpRequestProperties httpRequestProperties2 = (HttpRequestProperties)this.prevContextVC.getStateMap().get(HttpInboundSessionConnection.HTTP_SESSION_PROPERTIES_KEY);
                    HttpInboundServiceContext httpInboundServiceContext2 = (HttpInboundServiceContext)this.prevContextVC.getStateMap().get(HttpInboundSessionConnection.HTTP_SERVICE_CONTEXT_KEY);
                    HttpInboundSessionConnection.this.sendResponse(httpInboundServiceContext2, httpRequestProperties2, null, 200, this.prevContextVC, false, false);
                    HttpInboundSessionConnection.this.getRequestTimer().stop();
                    HttpInboundSessionConnection.this.changeWriteState(HttpInboundSessionConnection.this.WRITE_STATE_IDLE);
                    HttpInboundSessionConnection.this.handleWriteEvent(1, this.contextVC);
                    break;
                }
                default: {
                    super.handleEvent(n);
                }
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, HttpInboundSessionConnection.this.dbg("WriteStateGetPending:handleEvent"));
            }
        }

        static {
            $assertionsDisabled = !(class$com$ibm$wkplc$httptunnel$inbound$impl$HttpInboundSessionConnection == null ? (class$com$ibm$wkplc$httptunnel$inbound$impl$HttpInboundSessionConnection = HttpInboundSessionConnection.class$("com.ibm.wkplc.httptunnel.inbound.impl.HttpInboundSessionConnection")) : class$com$ibm$wkplc$httptunnel$inbound$impl$HttpInboundSessionConnection).desiredAssertionStatus();
        }
    }

    class WriteStateDataPending
    extends ConnectionState {
        WriteStateDataPending() {
        }

        public String toString() {
            return "WriteStateDataPending";
        }

        public void handleEvent(int n) {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, HttpInboundSessionConnection.this.dbg("WriteStateDataPending:handleEvent: " + n));
            }
            switch (n) {
                case 1: {
                    HttpRequestProperties httpRequestProperties = (HttpRequestProperties)this.contextVC.getStateMap().get(HttpInboundSessionConnection.HTTP_SESSION_PROPERTIES_KEY);
                    HttpInboundServiceContext httpInboundServiceContext = (HttpInboundServiceContext)this.contextVC.getStateMap().get(HttpInboundSessionConnection.HTTP_SERVICE_CONTEXT_KEY);
                    HttpInboundSessionConnection.this.getSessionTimer().stop();
                    int n2 = httpRequestProperties.getServerSequence();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, HttpInboundSessionConnection.this.dbg(this + ": EVENT_ID_NEW_GET: reqssq=" + n2 + " serverssq=" + HttpInboundSessionConnection.this.getSSQ()));
                    }
                    if (n2 == HttpInboundSessionConnection.this.getSSQ()) {
                        HttpInboundSessionConnection.this.lastWriteBuffer = HttpInboundSessionConnection.this.getSessListener().getWriteData(HttpInboundSessionConnection.this);
                        if (null == HttpInboundSessionConnection.this.getLastWriteBuffer()) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, HttpInboundSessionConnection.this.dbg(this + ": EVENT_ID_NEW_GET: no data ready"));
                            }
                            HttpInboundSessionConnection.this.WRITE_STATE_GET_PENDING.setContextVC(this.contextVC);
                            HttpInboundSessionConnection.this.changeWriteState(HttpInboundSessionConnection.this.WRITE_STATE_GET_PENDING);
                            break;
                        }
                        ++HttpInboundSessionConnection.this.serverSequence;
                        httpRequestProperties.setRequestProperty("ssq", "" + HttpInboundSessionConnection.this.getSSQ());
                        HttpInboundSessionConnection.this.sendResponse(httpInboundServiceContext, httpRequestProperties, HttpInboundSessionConnection.this.getLastWriteBuffer(), 200, this.contextVC, false, false);
                        if (HttpInboundSessionConnection.this.getSessListener().isWriteDataPending()) {
                            HttpInboundSessionConnection.this.getSessionTimer().start();
                            break;
                        }
                        HttpInboundSessionConnection.this.changeWriteState(HttpInboundSessionConnection.this.WRITE_STATE_IDLE);
                        break;
                    }
                    if (n2 == HttpInboundSessionConnection.this.getSSQ() - 1 && HttpInboundSessionConnection.this.getLastWriteBuffer() != null) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, HttpInboundSessionConnection.this.dbg(this + ": EVENT_ID_NEW_GET: resending SSQ " + HttpInboundSessionConnection.this.getSSQ()));
                        }
                        httpRequestProperties.setRequestProperty("ssq", "" + HttpInboundSessionConnection.this.getSSQ());
                        HttpInboundSessionConnection.this.sendResponse(httpInboundServiceContext, httpRequestProperties, HttpInboundSessionConnection.this.getLastWriteBuffer(), 200, this.contextVC, false, true);
                        HttpInboundSessionConnection.this.getSessionTimer().start();
                        break;
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, HttpInboundSessionConnection.this.dbg(this + ": EVENT_ID_NEW_GET: invalid SSQ or last response is NULL"));
                    }
                    HttpInboundSessionConnection.this.close(new HttpTunnelException("Invalid SSQ or last response is NULL"));
                    HttpInboundSessionConnection.this.sendResponse(httpInboundServiceContext, httpRequestProperties, null, 200, this.contextVC, false, false);
                    break;
                }
                case 2: {
                    break;
                }
                case 6: {
                    break;
                }
                case 3: {
                    HttpInboundSessionConnection.this.changeWriteState(HttpInboundSessionConnection.this.WRITE_STATE_CLOSED);
                    break;
                }
                case 5: {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, HttpInboundSessionConnection.this.dbg("WriteStateDataPending: EVENT_ID_SESSION_TIMEOUT: session expired"));
                    }
                    HttpInboundSessionConnection.this.close(new HttpTunnelException("Session expired"));
                    break;
                }
                default: {
                    super.handleEvent(n);
                }
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, HttpInboundSessionConnection.this.dbg("WriteStateDataPending:handleEvent"));
            }
        }
    }

    class WriteStateIdle
    extends ConnectionState {
        WriteStateIdle() {
        }

        public String toString() {
            return "WriteStateIdle";
        }

        public void init() {
            HttpInboundSessionConnection.this.getSessionTimer().start();
        }

        public void handleEvent(int n) {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, HttpInboundSessionConnection.this.dbg("WriteStateIdle:handleEvent: " + n));
            }
            switch (n) {
                case 1: {
                    HttpRequestProperties httpRequestProperties = (HttpRequestProperties)this.contextVC.getStateMap().get(HttpInboundSessionConnection.HTTP_SESSION_PROPERTIES_KEY);
                    HttpInboundServiceContext httpInboundServiceContext = (HttpInboundServiceContext)this.contextVC.getStateMap().get(HttpInboundSessionConnection.HTTP_SERVICE_CONTEXT_KEY);
                    HttpInboundSessionConnection.this.getSessionTimer().stop();
                    int n2 = httpRequestProperties.getServerSequence();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, this + ": reqssq=" + n2 + " serverssq=" + HttpInboundSessionConnection.this.getSSQ());
                    }
                    if (httpRequestProperties.getSessionId() == 0) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, HttpInboundSessionConnection.this.dbg("WriteStateIdle: EVENT_ID_NEW_GET: initial request - session ID being requested"));
                        }
                        HttpInboundSessionConnection.this.sendResponse(httpInboundServiceContext, httpRequestProperties, null, 200, this.contextVC, false, false);
                        break;
                    }
                    if (n2 == HttpInboundSessionConnection.this.getSSQ()) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, HttpInboundSessionConnection.this.dbg("WriteStateIdle: EVENT_ID_NEW_GET: SSQ matches; clear last response"));
                        }
                        HttpInboundSessionConnection.this.lastWriteBuffer = null;
                        httpRequestProperties.setRequestProperty("ssq", "" + HttpInboundSessionConnection.this.getSSQ());
                        HttpInboundSessionConnection.this.WRITE_STATE_GET_PENDING.setContextVC(this.contextVC);
                        HttpInboundSessionConnection.this.changeWriteState(HttpInboundSessionConnection.this.WRITE_STATE_GET_PENDING);
                        break;
                    }
                    if (n2 == HttpInboundSessionConnection.this.getSSQ() - 1 && HttpInboundSessionConnection.this.getLastWriteBuffer() != null) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, HttpInboundSessionConnection.this.dbg("WriteStateIdle: EVENT_ID_NEW_GET: SSQ off by one; resend last response"));
                        }
                        httpRequestProperties.setRequestProperty("ssq", "" + HttpInboundSessionConnection.this.getSSQ());
                        HttpInboundSessionConnection.this.sendResponse(httpInboundServiceContext, httpRequestProperties, HttpInboundSessionConnection.this.getLastWriteBuffer(), 200, this.contextVC, false, true);
                        HttpInboundSessionConnection.this.getSessionTimer().start();
                        break;
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, HttpInboundSessionConnection.this.dbg("WriteStateIdle: EVENT_ID_NEW_GET: invalid SSQ or last response is NULL"));
                    }
                    HttpInboundSessionConnection.this.close(new HttpTunnelException("Invalid SSQ or last response is NULL"));
                    HttpInboundSessionConnection.this.sendResponse(httpInboundServiceContext, httpRequestProperties, null, 200, this.contextVC, false, false);
                    break;
                }
                case 2: {
                    HttpInboundSessionConnection.this.changeWriteState(HttpInboundSessionConnection.this.WRITE_STATE_DATA_PENDING);
                    break;
                }
                case 3: {
                    HttpInboundSessionConnection.this.changeWriteState(HttpInboundSessionConnection.this.WRITE_STATE_CLOSED);
                    break;
                }
                case 5: {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, HttpInboundSessionConnection.this.dbg("WriteStateIdle: EVENT_ID_SESSION_TIMEOUT: session expired"));
                    }
                    HttpInboundSessionConnection.this.close(new HttpTunnelException("Session expired"));
                    break;
                }
                case 6: {
                    break;
                }
                default: {
                    super.handleEvent(n);
                }
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, HttpInboundSessionConnection.this.dbg("WriteStateIdle:handleEvent"));
            }
        }
    }

    class WriteStateClosed
    extends ConnectionState {
        WriteStateClosed() {
        }

        public String toString() {
            return "WriteStateClosed";
        }

        public void handleEvent(int n) {
        }
    }

    class ConnectionState {
        protected VirtualConnection contextVC = null;
        protected VirtualConnection prevContextVC = null;
        static final /* synthetic */ boolean $assertionsDisabled;

        ConnectionState() {
        }

        public void setContextVC(VirtualConnection virtualConnection) {
            this.prevContextVC = this.contextVC;
            this.contextVC = virtualConnection;
        }

        public void handleEvent(int n) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, HttpInboundSessionConnection.this.dbg("Invalid state received: eventID = " + n + " for class: " + this.getClass().getName()));
            }
            if (!$assertionsDisabled) {
                throw new AssertionError((Object)"Invalid state received");
            }
        }

        public void init() {
        }

        static {
            $assertionsDisabled = !(class$com$ibm$wkplc$httptunnel$inbound$impl$HttpInboundSessionConnection == null ? (class$com$ibm$wkplc$httptunnel$inbound$impl$HttpInboundSessionConnection = HttpInboundSessionConnection.class$("com.ibm.wkplc.httptunnel.inbound.impl.HttpInboundSessionConnection")) : class$com$ibm$wkplc$httptunnel$inbound$impl$HttpInboundSessionConnection).desiredAssertionStatus();
        }
    }

    class HttpRequestCallback
    implements InterChannelCallback {
        static final /* synthetic */ boolean $assertionsDisabled;

        HttpRequestCallback() {
        }

        public void complete(VirtualConnection virtualConnection) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, HttpInboundSessionConnection.this.dbg("HttpRequestCallback.complete: " + virtualConnection));
            }
            HttpInboundServiceContext httpInboundServiceContext = (HttpInboundServiceContext)virtualConnection.getStateMap().get(HttpInboundSessionConnection.HTTP_SERVICE_CONTEXT_KEY);
            if (!$assertionsDisabled && !httpInboundServiceContext.getRequest().getMethodValue().equals(HttpConstants.METHOD_POST)) {
                throw new AssertionError((Object)"Complete received for a GET");
            }
            HttpInboundSessionConnection.this.handleReadEvent(2, virtualConnection);
        }

        public void error(VirtualConnection virtualConnection, Throwable throwable) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, HttpInboundSessionConnection.this.dbg("HttpRequestCallback.error: " + throwable));
            }
            HttpInboundSessionConnection.this.closeConnection(virtualConnection, new HttpTunnelException(throwable.getLocalizedMessage()));
        }

        static {
            $assertionsDisabled = !(class$com$ibm$wkplc$httptunnel$inbound$impl$HttpInboundSessionConnection == null ? (class$com$ibm$wkplc$httptunnel$inbound$impl$HttpInboundSessionConnection = HttpInboundSessionConnection.class$("com.ibm.wkplc.httptunnel.inbound.impl.HttpInboundSessionConnection")) : class$com$ibm$wkplc$httptunnel$inbound$impl$HttpInboundSessionConnection).desiredAssertionStatus();
        }
    }

    class HttpResponseCallback
    implements InterChannelCallback {
        HttpResponseCallback() {
        }

        public void complete(VirtualConnection virtualConnection) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, HttpInboundSessionConnection.this.dbg("HttpResponseCallback.complete: " + virtualConnection));
            }
            HttpInboundSessionConnection.this.closeConnection(virtualConnection, HttpInboundSessionConnection.this.shutdownReason);
        }

        public void error(VirtualConnection virtualConnection, Throwable throwable) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, HttpInboundSessionConnection.this.dbg("HttpResponseCallback.error: " + throwable));
            }
            HttpInboundSessionConnection.this.closeConnection(virtualConnection, new HttpTunnelException(throwable.getLocalizedMessage()));
        }
    }
}

