/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wkplc.httptunnel.inbound.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.wkplc.httptunnel.inbound.impl.HttpRequestHandler;
import com.ibm.wsspi.buffermgmt.WsByteBuffer;
import com.ibm.wsspi.buffermgmt.WsByteBufferUtils;
import com.ibm.wsspi.http.channel.exception.IllegalHttpBodyException;
import com.ibm.wsspi.http.channel.inbound.HttpInboundServiceContext;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class HttpRequestJavaScriptHandler
implements HttpRequestHandler {
    private static final TraceComponent tc = Tr.register(HttpRequestJavaScriptHandler.class, "HTTPTunnelChannel", "com.ibm.wkplc.httptunnel.resources.tunnelMessages");
    private static final String CONTENT_TYPE = "text/html";
    private static final String FORM_DATA_FIELD = "tunnelData";
    private static final String WRITE_TEMPLATE = "<script language=\"JavaScript\">\nif ('@domain@'.length > 0) document.domain = '@domain@';\nparent.getResponse(@id@,@ssq@,('@clo@'.length > 0),'@data@');\n</script>";
    private static final String READ_TEMPLATE = "<script language=\"JavaScript\">\nif ('@domain@'.length > 0) document.domain = '@domain@';\nparent.postResponse(@id@,@csq@,('@clo@'.length > 0),parseInt('@rti@'));\n</script>";
    private final Pattern fieldPattern = Pattern.compile("([^=]+)=([^&]*)&*");

    public String getContentType() {
        return CONTENT_TYPE;
    }

    public String getReadTemplate() {
        return READ_TEMPLATE;
    }

    public String getWriteTemplate() {
        return WRITE_TEMPLATE;
    }

    public WsByteBuffer[] getBodyData(HttpInboundServiceContext httpInboundServiceContext) {
        WsByteBuffer[] wsByteBufferArray;
        block12: {
            wsByteBufferArray = null;
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getBodyData");
            }
            try {
                wsByteBufferArray = httpInboundServiceContext.getRequestBodyBuffers();
                String string = WsByteBufferUtils.asString((WsByteBuffer[])wsByteBufferArray);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "getBodyData: body (" + string.length() + " bytes)\n" + string);
                }
                WsByteBufferUtils.clearBufferArray((WsByteBuffer[])wsByteBufferArray);
                Matcher matcher = this.fieldPattern.matcher(string);
                while (matcher.find()) {
                    if (!matcher.group(1).equalsIgnoreCase(FORM_DATA_FIELD)) continue;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "getBodyData: field 'tunnelData'\n" + matcher.group(2));
                    }
                    WsByteBufferUtils.putStringValue((WsByteBuffer[])wsByteBufferArray, (String)URLDecoder.decode(matcher.group(2), "UTF-8"), (boolean)true);
                    break;
                }
                if (tc.isDebugEnabled()) {
                    string = WsByteBufferUtils.asString((WsByteBuffer[])wsByteBufferArray);
                    Tr.debug(tc, "getBodyData: data (" + string.length() + " bytes)\n" + string);
                }
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "getBodyData: EXCEPTION: " + unsupportedEncodingException);
                }
            }
            catch (IllegalHttpBodyException illegalHttpBodyException) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "getBodyData: EXCEPTION: " + illegalHttpBodyException);
                }
            }
            catch (IOException iOException) {
                if (!tc.isDebugEnabled()) break block12;
                Tr.debug(tc, "getBodyData: EXCEPTION: " + iOException);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getBodyData");
        }
        return wsByteBufferArray;
    }
}

