/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wkplc.httptunnel.inbound.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.wkplc.httptunnel.HttpTunnelException;
import com.ibm.wkplc.httptunnel.impl.HttpRequestProperties;
import com.ibm.wkplc.httptunnel.inbound.impl.HttpInboundSessionConnection;
import com.ibm.wkplc.httptunnel.inbound.impl.HttpTunnelSessionManager;
import com.ibm.wkplc.httptunnel.inbound.impl.HttpTunnelTopConnLink;
import com.ibm.wsspi.channel.ConnectionLink;
import com.ibm.wsspi.channel.InterChannelCallback;
import com.ibm.wsspi.channel.base.InboundApplicationLink;
import com.ibm.wsspi.channel.framework.ChannelFramework;
import com.ibm.wsspi.channel.framework.DiscriminationProcess;
import com.ibm.wsspi.channel.framework.VirtualConnection;
import com.ibm.wsspi.http.channel.HttpConstants;
import com.ibm.wsspi.http.channel.HttpResponseMessage;
import com.ibm.wsspi.http.channel.inbound.HttpInboundServiceContext;
import com.ibm.wsspi.runtime.ThreadPool;
import java.util.Timer;
import javax.servlet.http.Cookie;

public class HttpTunnelBottomConnLink
extends InboundApplicationLink
implements InterChannelCallback {
    private static final TraceComponent tc = Tr.register(HttpTunnelBottomConnLink.class, "HTTPTunnelChannel", "com.ibm.wkplc.httptunnel.resources.tunnelMessages");
    private static final int SESSION_ID_COUNTER_INIT = 1;
    private static int sessionIdCounter = 1;
    private ChannelFramework channelFramework = null;
    private HttpTunnelSessionManager sessionManager = null;
    private HttpInboundServiceContext isc = null;
    private DiscriminationProcess discrimProcess = null;
    private Timer timer = null;
    private int sessionTimeout = 0;
    private int requestTimeout = 0;
    private ThreadPool threadPool = null;
    private Cookie affinityCookie = null;
    private int defaultReadTimeout;
    private int defaultWriteTimeout;

    public HttpTunnelBottomConnLink(ChannelFramework channelFramework, HttpTunnelSessionManager httpTunnelSessionManager, DiscriminationProcess discriminationProcess, Timer timer, ThreadPool threadPool, int n, int n2, Cookie cookie, int n3, int n4) {
        this.channelFramework = channelFramework;
        this.sessionManager = httpTunnelSessionManager;
        this.discrimProcess = discriminationProcess;
        this.timer = timer;
        this.threadPool = threadPool;
        this.sessionTimeout = n;
        this.requestTimeout = n2;
        this.affinityCookie = cookie;
        this.defaultReadTimeout = n3;
        this.defaultWriteTimeout = n4;
    }

    private HttpInboundServiceContext getHttpSC() {
        if (null == this.isc) {
            this.isc = (HttpInboundServiceContext)this.getDeviceLink().getChannelAccessor();
        }
        return this.isc;
    }

    public void ready(VirtualConnection virtualConnection) {
        block8: {
            try {
                HttpInboundSessionConnection httpInboundSessionConnection;
                VirtualConnection virtualConnection2 = null;
                HttpTunnelTopConnLink httpTunnelTopConnLink = null;
                HttpRequestProperties httpRequestProperties = new HttpRequestProperties();
                httpRequestProperties.parseSessionProperties(this.getHttpSC().getRequest());
                int n = httpRequestProperties.getSessionId();
                if (n != 0) {
                    httpInboundSessionConnection = this.sessionManager.findSessionConnection(n);
                    if (httpInboundSessionConnection == null) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "ready: invalid connection ID " + n + "; close request");
                        }
                        httpRequestProperties.setSessionId(n);
                        httpRequestProperties.setSessionClosed(true);
                        HttpResponseMessage httpResponseMessage = this.getHttpSC().getResponse();
                        httpResponseMessage.setCookie(httpRequestProperties.createSessionCookie(), HttpConstants.HDR_SET_COOKIE);
                        httpResponseMessage.setStatusCode(HttpConstants.STATUS_OK);
                        if (this.getHttpSC().finishResponseMessage(null, this, false) != null) {
                            this.complete(virtualConnection);
                        }
                        return;
                    }
                    this.updateCookieInVirtualConnection(httpInboundSessionConnection);
                } else {
                    int n2 = HttpTunnelBottomConnLink.getNextSessionId();
                    httpInboundSessionConnection = new HttpInboundSessionConnection(this.sessionManager, this.timer, this.sessionTimeout, this.requestTimeout, this.affinityCookie, n2);
                    this.sessionManager.addSessionConnection(httpInboundSessionConnection);
                    virtualConnection2 = this.channelFramework.getInboundVCFactory().createConnection();
                    httpTunnelTopConnLink = new HttpTunnelTopConnLink(httpInboundSessionConnection, this.discrimProcess, this.threadPool, this.timer, this.defaultReadTimeout, this.defaultWriteTimeout);
                    httpTunnelTopConnLink.init(virtualConnection2);
                    httpInboundSessionConnection.setConnLink((ConnectionLink)httpTunnelTopConnLink);
                    this.updateCookieInVirtualConnection(httpInboundSessionConnection);
                }
                httpInboundSessionConnection.requestReceived(this, httpRequestProperties);
                if (httpTunnelTopConnLink != null) {
                    httpTunnelTopConnLink.ready(virtualConnection2);
                }
            }
            catch (Exception exception) {
                if (!tc.isDebugEnabled()) break block8;
                Tr.debug(tc, "ready: EXCEPTION: " + exception);
            }
        }
    }

    private void updateCookieInVirtualConnection(HttpInboundSessionConnection httpInboundSessionConnection) {
        String string = this.getHttpSC().getRequest().getHeaderAsString(HttpConstants.HDR_COOKIE);
        if (string != null) {
            ConnectionLink connectionLink;
            StringBuffer stringBuffer;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "updateCookieInVirtualConnection: cookie=" + string);
            }
            if ((stringBuffer = (StringBuffer)(connectionLink = httpInboundSessionConnection.getConnLink()).getVirtualConnection().getStateMap().get("Cookie")) == null) {
                stringBuffer = new StringBuffer();
                connectionLink.getVirtualConnection().getStateMap().put("Cookie", stringBuffer);
            }
            stringBuffer.replace(0, stringBuffer.length(), string);
        }
    }

    public void error(VirtualConnection virtualConnection, Throwable throwable) {
        this.complete(virtualConnection);
    }

    public void complete(VirtualConnection virtualConnection) {
        this.close(virtualConnection, new HttpTunnelException("Session does not exist!"));
    }

    protected static synchronized int getNextSessionId() {
        if (++sessionIdCounter == Integer.MAX_VALUE) {
            sessionIdCounter = 1;
        }
        return sessionIdCounter;
    }
}

