/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wkplc.httptunnel.inbound.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.wkplc.httptunnel.impl.HttpTunnelUtils;
import com.ibm.wkplc.httptunnel.inbound.impl.HttpTunnelBottomConnLink;
import com.ibm.wkplc.httptunnel.inbound.impl.HttpTunnelSessionManager;
import com.ibm.wsspi.buffermgmt.WsByteBuffer;
import com.ibm.wsspi.channel.Channel;
import com.ibm.wsspi.channel.ConnectionLink;
import com.ibm.wsspi.channel.Discriminator;
import com.ibm.wsspi.channel.base.InboundProtocolChannel;
import com.ibm.wsspi.channel.framework.ChannelData;
import com.ibm.wsspi.channel.framework.VirtualConnection;
import com.ibm.wsspi.channel.framework.exception.ChannelException;
import com.ibm.wsspi.http.channel.HttpRequestMessage;
import com.ibm.wsspi.http.channel.inbound.HttpInboundServiceContext;
import com.ibm.wsspi.runtime.ThreadPool;
import com.ibm.wsspi.runtime.ThreadPoolRepositoryManager;
import com.ibm.wsspi.tcp.channel.TCPConnectionContext;
import java.util.Timer;
import java.util.regex.Pattern;
import javax.servlet.http.Cookie;

public class HttpTunnelProtocolChannel
extends InboundProtocolChannel
implements Discriminator {
    private static final TraceComponent tc = Tr.register(HttpTunnelProtocolChannel.class, "HTTPTunnelChannel", "com.ibm.wkplc.httptunnel.resources.tunnelMessages");
    private HttpTunnelSessionManager sessionManager = null;
    private String uriPattern = null;
    private Pattern discrimPattern = null;
    private Timer timer = null;
    private ThreadPool threadPool = null;
    private Cookie affinityCookie = null;
    private int defaultReadTimeout = 0;
    private int defaultWriteTimeout = 0;
    private int defaultSessionTimeout = 0;
    private int defaultRequestTimeout = 0;

    public HttpTunnelProtocolChannel(ChannelData channelData) {
        super(channelData);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "HttpTunnelProtocolChannel");
        }
        this.update(channelData);
        this.sessionManager = new HttpTunnelSessionManager();
        String string = (String)channelData.getPropertyBag().get("threadPool");
        ThreadPool threadPool = this.threadPool = null != string ? ThreadPoolRepositoryManager.getThreadPoolRepository().getThreadPool(string) : channelData.getChannelFramework().getDefaultThreadPool();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "HttpTunnelProtocolChannel");
        }
    }

    public int discriminate(VirtualConnection virtualConnection, Object object) {
        HttpRequestMessage httpRequestMessage = (HttpRequestMessage)object;
        int n = 0;
        String string = httpRequestMessage.getRequestURI();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "discriminate: " + this.uriPattern + "; " + string);
        }
        if (null != this.uriPattern && (string.startsWith(this.uriPattern) || this.discrimPattern.matcher(string).matches())) {
            n = 1;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "discriminate returning " + (0 == n ? "NO" : "YES"));
        }
        return n;
    }

    public Class getDiscriminatoryDataType() {
        return HttpRequestMessage.class;
    }

    public Channel getChannel() {
        return this;
    }

    public int getWeight() {
        return this.getConfig().getDiscriminatorWeight();
    }

    public Discriminator getDiscriminator() {
        return this;
    }

    public Class getDiscriminatoryType() {
        return WsByteBuffer.class;
    }

    public ConnectionLink getConnectionLink(VirtualConnection virtualConnection) {
        HttpTunnelBottomConnLink httpTunnelBottomConnLink = (HttpTunnelBottomConnLink)((Object)virtualConnection.getStateMap().get("HCL_KEY"));
        if (null == httpTunnelBottomConnLink) {
            httpTunnelBottomConnLink = new HttpTunnelBottomConnLink(this.getConfig().getChannelFramework(), this.sessionManager, this.getDiscriminationProcess(), this.timer, this.threadPool, this.defaultSessionTimeout, this.defaultRequestTimeout, this.affinityCookie, this.defaultReadTimeout, this.defaultWriteTimeout);
            virtualConnection.getStateMap().put("HCL_KEY", httpTunnelBottomConnLink);
        }
        httpTunnelBottomConnLink.init(virtualConnection);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "getConnectionLink: " + (Object)((Object)httpTunnelBottomConnLink));
        }
        return httpTunnelBottomConnLink;
    }

    public void start() throws ChannelException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "start");
        }
        this.timer = new Timer();
        Tr.audit(tc, "CHANNEL_STARTED", new Object[]{this.config.getExternalName()});
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "start");
        }
    }

    public void stop(long l) throws ChannelException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "stop: " + l);
        }
        if (0L == l && this.timer != null) {
            this.timer.cancel();
            this.timer = null;
            Tr.audit(tc, "CHANNEL_STOPPED", new Object[]{this.config.getExternalName()});
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "stop");
        }
    }

    public void init() throws ChannelException {
    }

    public void destroy() throws ChannelException {
    }

    public Class getApplicationInterface() {
        return TCPConnectionContext.class;
    }

    public Class getDeviceInterface() {
        return HttpInboundServiceContext.class;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(ChannelData channelData) {
        HttpTunnelProtocolChannel httpTunnelProtocolChannel = this;
        synchronized (httpTunnelProtocolChannel) {
            super.setConfig(channelData);
            this.uriPattern = this.getStringProperty("uriPattern", "/IBM_HTTP_TUNNEL/");
            this.discrimPattern = Pattern.compile(this.uriPattern);
            this.createAffinityCookie();
            this.defaultReadTimeout = this.getIntProperty("inactivityTimeout", 60000);
            this.defaultWriteTimeout = this.getIntProperty("inactivityTimeout", 60000);
            this.defaultSessionTimeout = this.getIntProperty("sessionTimeout", 45000);
            this.defaultRequestTimeout = this.getIntProperty("requestTimeout", 30000);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Config: uriPattern=" + this.uriPattern);
                Tr.debug(tc, "Config: writeTimeout=" + this.defaultWriteTimeout);
                Tr.debug(tc, "Config: readTimeout=" + this.defaultReadTimeout);
                Tr.debug(tc, "Config: sessionTimeout=" + this.defaultSessionTimeout);
                Tr.debug(tc, "Config: requestTimeout=" + this.defaultRequestTimeout);
            }
        }
    }

    private void createAffinityCookie() {
        String string;
        String string2;
        block6: {
            string2 = null;
            string = this.getStringProperty("affinityName", "htcaff");
            try {
                string2 = HttpTunnelUtils.getServerAffinity(this.getStringProperty("cellName", ""), this.getStringProperty("nodeName", ""), this.getStringProperty("serverName", ""));
            }
            catch (Exception exception) {
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block6;
                Tr.debug(tc, "createAffinityCookie: exception " + exception);
            }
        }
        this.affinityCookie = null;
        if (string != null && string2 != null && string.length() > 0 && string2.length() > 0) {
            this.affinityCookie = new Cookie(string, ":" + string2);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "createAffinityCookie: " + this.affinityCookie.getName() + "=" + this.affinityCookie.getValue());
            }
        } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Failed to create cookie; name=[" + string + "] value=[" + string2 + "]");
        }
    }

    private String getStringProperty(String string, String string2) {
        String string3 = (String)this.getConfig().getPropertyBag().get(string);
        if (null == string3 || 0 >= string3.trim().length()) {
            return string2;
        }
        return string3;
    }

    private int getIntProperty(String string, int n) {
        block3: {
            String string2 = (String)this.getConfig().getPropertyBag().get(string);
            if (null != string2) {
                try {
                    return Integer.parseInt(string2);
                }
                catch (NumberFormatException numberFormatException) {
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block3;
                    Tr.debug(tc, "getIntProperty: property " + string + " contains a non-int value [" + string2 + "]");
                }
            }
        }
        return n;
    }

    public void cleanUpState(VirtualConnection virtualConnection) {
    }
}

