/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wkplc.httptunnel.inbound.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.wkplc.httptunnel.impl.HttpSessionConnection;
import com.ibm.wkplc.httptunnel.impl.HttpTunnelSession;
import com.ibm.wsspi.buffermgmt.WsByteBuffer;
import com.ibm.wsspi.channel.ConnectionLink;
import com.ibm.wsspi.channel.base.InboundConnectorLink;
import com.ibm.wsspi.channel.framework.DiscriminationProcess;
import com.ibm.wsspi.channel.framework.VirtualConnection;
import com.ibm.wsspi.channel.framework.exception.DiscriminationProcessException;
import com.ibm.wsspi.runtime.ThreadPool;
import com.ibm.wsspi.tcp.channel.TCPReadCompletedCallback;
import com.ibm.wsspi.tcp.channel.TCPReadRequestContext;
import java.io.IOException;
import java.util.Timer;

public class HttpTunnelTopConnLink
extends InboundConnectorLink
implements TCPReadCompletedCallback {
    private static final TraceComponent tc = Tr.register(HttpTunnelTopConnLink.class, "HTTPTunnelChannel", "com.ibm.wkplc.httptunnel.resources.tunnelMessages");
    private HttpTunnelSession session = null;
    private DiscriminationProcess discrimProcess = null;
    private ThreadPool threadPool = null;

    public HttpTunnelTopConnLink(HttpSessionConnection httpSessionConnection, DiscriminationProcess discriminationProcess, ThreadPool threadPool, Timer timer, int n, int n2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "HttpTunnelTopConnLink");
        }
        this.discrimProcess = discriminationProcess;
        this.threadPool = threadPool;
        this.session = new HttpTunnelSession(this.threadPool, timer, n, n2);
        this.session.startup(httpSessionConnection, (ConnectionLink)this);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "HttpTunnelTopConnLink");
        }
    }

    public void ready(VirtualConnection virtualConnection) {
        this.doDiscriminate(virtualConnection, this.session.getReadInterface());
    }

    public Object getChannelAccessor() {
        return this.session;
    }

    private void doDiscriminate(VirtualConnection virtualConnection, TCPReadRequestContext tCPReadRequestContext) {
        block12: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "doDiscriminate: " + virtualConnection);
            }
            WsByteBuffer[] wsByteBufferArray = null;
            int[][] nArray = null;
            try {
                block13: {
                    VirtualConnection virtualConnection2;
                    do {
                        int n;
                        if ((wsByteBufferArray = tCPReadRequestContext.getBuffers()) != null && wsByteBufferArray.length > 0) {
                            nArray = new int[wsByteBufferArray.length][2];
                            for (n = 0; n < wsByteBufferArray.length; ++n) {
                                if (wsByteBufferArray[n] == null) continue;
                                nArray[n][0] = wsByteBufferArray[n].position();
                                nArray[n][1] = wsByteBufferArray[n].limit();
                            }
                        }
                        int n2 = this.discrimProcess.discriminate(virtualConnection, (Object)wsByteBufferArray, (ConnectionLink)this);
                        if (nArray != null) {
                            for (n = 0; n < wsByteBufferArray.length; ++n) {
                                if (wsByteBufferArray[n] == null) continue;
                                wsByteBufferArray[n].position(nArray[n][0]);
                                wsByteBufferArray[n].limit(nArray[n][1]);
                            }
                            nArray = null;
                        }
                        if (n2 == 1) {
                            this.getApplicationCallback().ready(virtualConnection);
                            break block12;
                        }
                        if (n2 != 2) break block13;
                    } while (null != (virtualConnection2 = tCPReadRequestContext.read(1L, (TCPReadCompletedCallback)this, false, 0)));
                    break block12;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "doDiscriminate: fail");
                }
                this.getDeviceLink().close(virtualConnection, null);
            }
            catch (DiscriminationProcessException discriminationProcessException) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "doDiscriminate: " + (Object)((Object)discriminationProcessException));
                }
                this.getDeviceLink().close(virtualConnection, null);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "doDiscriminate");
        }
    }

    public void complete(VirtualConnection virtualConnection, TCPReadRequestContext tCPReadRequestContext) {
        block2: {
            try {
                this.doDiscriminate(virtualConnection, tCPReadRequestContext);
            }
            catch (Exception exception) {
                if (!tc.isDebugEnabled()) break block2;
                Tr.debug(tc, "complete: " + exception);
            }
        }
    }

    public void error(VirtualConnection virtualConnection, TCPReadRequestContext tCPReadRequestContext, IOException iOException) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "error: " + virtualConnection + " " + iOException);
        }
        this.getDeviceLink().close(virtualConnection, null);
    }

    public void destroy(Exception exception) {
        this.session.shutdown(exception);
        super.destroy(exception);
    }
}

