/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wkplc.httptunnel.outbound.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.wkplc.httptunnel.HttpTunnelException;
import com.ibm.wkplc.httptunnel.impl.HttpRequestProperties;
import com.ibm.wkplc.httptunnel.impl.HttpSessionConnection;
import com.ibm.wkplc.httptunnel.impl.HttpSessionConnectionListener;
import com.ibm.wkplc.util.BufferUtil;
import com.ibm.wsspi.buffermgmt.WsByteBuffer;
import com.ibm.wsspi.channel.ConnectionLink;
import com.ibm.wsspi.channel.ConnectionReadyCallback;
import com.ibm.wsspi.channel.InterChannelCallback;
import com.ibm.wsspi.channel.framework.OutboundVirtualConnection;
import com.ibm.wsspi.channel.framework.VirtualConnection;
import com.ibm.wsspi.channel.framework.VirtualConnectionFactory;
import com.ibm.wsspi.http.channel.HttpBaseMessage;
import com.ibm.wsspi.http.channel.HttpConstants;
import com.ibm.wsspi.http.channel.HttpRequestMessage;
import com.ibm.wsspi.http.channel.HttpResponseMessage;
import com.ibm.wsspi.http.channel.outbound.HttpAddress;
import com.ibm.wsspi.http.channel.outbound.HttpOutboundServiceContext;
import com.ibm.wsspi.http.channel.values.StatusCodes;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Iterator;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import javax.servlet.http.Cookie;

public class HttpOutboundSessionConnection
implements HttpSessionConnection {
    protected static final TraceComponent tc = Tr.register(HttpOutboundSessionConnection.class, "HTTPTunnelChannel", "com.ibm.wkplc.httptunnel.resources.tunnelMessages");
    protected static final int EVENT_ID_DATA_PENDING = 0;
    protected static final int EVENT_ID_CONNECT = 1;
    protected static final int EVENT_ID_CONNECTION_READY = 2;
    protected static final int EVENT_ID_CONNECTION_ERROR = 3;
    protected static final int EVENT_ID_ASYNC_COMPLETE = 4;
    protected static final int EVENT_ID_SESSION_CLOSED = 5;
    protected static final int EVENT_ID_RETRY_TIMEOUT = 6;
    protected static final String[] EVENTS = new String[]{"EVENT_ID_DATA_PENDING", "EVENT_ID_CONNECT", "EVENT_ID_CONNECTION_READY", "EVENT_ID_CONNECTION_ERROR", "EVENT_ID_ASYNC_COMPLETE", "EVENT_ID_SESSION_CLOSED", "EVENT_ID_RETRY_TIMEOUT"};
    private static final int MAX_CONNECTION_FAILURES = 2;
    private final BaseState STATE_WRITE_DISCONNECTED = new StateWriteDisconnected(this);
    private final BaseState STATE_WRITE_IDLE = new StateWriteIdle(this);
    private final BaseState STATE_WRITE_ACTIVE = new StateWriteActive(this);
    private final BaseState STATE_READ_IDLE = new StateReadIdle(this);
    private final BaseState STATE_READ_ACTIVE = new StateReadActive(this);
    private final BaseState STATE_CLOSED = new StateClosed(this);
    private URL hostUrl = null;
    private byte[] hostUrlByteArray = null;
    private HttpSessionConnectionListener sessionListener = null;
    private StateContext writer = null;
    private StateContext reader = null;
    private int sessionId = 0;
    protected int clientSequence = 1;
    private ConnectionLink appLink = null;
    private HttpAddress remoteHttpAddress = null;
    private InetAddress remoteAddress = null;
    private InetAddress localAddress = null;
    private int localPort = 0;
    private boolean sessionShutdown = false;
    private TimeoutTask retryTimer = null;
    private ConnectionLink connLink = null;
    private VirtualConnectionFactory vcf = null;
    private Exception shutdownReason = null;

    public HttpOutboundSessionConnection(ConnectionLink connectionLink, Timer timer, VirtualConnectionFactory virtualConnectionFactory, URL uRL) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, this.dbg("HttpOutboundSessionConnection"));
        }
        this.retryTimer = new RetryTimer(timer);
        this.appLink = connectionLink;
        this.hostUrl = uRL;
        this.vcf = virtualConnectionFactory;
        this.writer = new StateContext("writer");
        this.writer.changeState(this.stateWriteDisconnected());
        this.reader = new StateContext("reader");
        this.reader.changeState(this.stateReadIdle());
        this.remoteHttpAddress = new TargetHttpAddress(uRL);
        try {
            this.hostUrlByteArray = uRL.toExternalForm().getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, this.dbg("HttpOutboundSessionConnection: EXCEPTION: " + unsupportedEncodingException));
            }
            throw new IllegalArgumentException("UTF-8 Encoding not supported on this platform");
        }
        try {
            this.remoteAddress = InetAddress.getByName(uRL.getHost());
        }
        catch (UnknownHostException unknownHostException) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, this.dbg("HttpOutboundSessionConnection: unable to resolve " + uRL.getHost()));
            }
            throw new IllegalArgumentException("Unknown host exception [" + uRL.getHost() + "]");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, this.dbg("HttpOutboundSessionConnection"));
        }
    }

    protected String dbg(String string) {
        int n = 0;
        if (null != this.sessionListener) {
            n = this.sessionListener.hashCode();
        }
        return string + " (hc=" + this.hashCode() + "; sc=" + n + ")";
    }

    public void setHttpConnectionListener(HttpSessionConnectionListener httpSessionConnectionListener) {
        this.sessionListener = httpSessionConnectionListener;
    }

    protected HttpSessionConnectionListener getSessionListener() {
        return this.sessionListener;
    }

    public InetAddress getRemoteAddress() {
        return this.remoteAddress;
    }

    public int getRemotePort() {
        return this.hostUrl.getPort();
    }

    public InetAddress getLocalAddress() {
        return this.localAddress;
    }

    protected void setLocalAddress(InetAddress inetAddress) {
        this.localAddress = inetAddress;
    }

    public int getLocalPort() {
        return this.localPort;
    }

    protected void setLocalPort(int n) {
        this.localPort = n;
    }

    protected HttpAddress getHttpAddress() {
        return this.remoteHttpAddress;
    }

    protected byte[] getTargetURL() {
        return this.hostUrlByteArray;
    }

    protected int getSessionID() {
        return this.sessionId;
    }

    protected void setSessionID(int n) {
        this.sessionId = n;
    }

    protected int getClientSQ() {
        return this.clientSequence;
    }

    protected TimeoutTask getRetryTimer() {
        return this.retryTimer;
    }

    public void writePending() {
        this.writer.processEvent(0);
    }

    protected StateContext reader() {
        return this.reader;
    }

    protected StateContext writer() {
        return this.writer;
    }

    protected BaseState stateClosed() {
        return this.STATE_CLOSED;
    }

    protected BaseState stateReadActive() {
        return this.STATE_READ_ACTIVE;
    }

    protected BaseState stateReadIdle() {
        return this.STATE_READ_IDLE;
    }

    protected BaseState stateWriteActive() {
        return this.STATE_WRITE_ACTIVE;
    }

    protected BaseState stateWriteDisconnected() {
        return this.STATE_WRITE_DISCONNECTED;
    }

    protected BaseState stateWriteIdle() {
        return this.STATE_WRITE_IDLE;
    }

    protected boolean isSessionShutdown() {
        return this.sessionShutdown;
    }

    public void open() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, this.dbg("open"));
        }
        if (this.reader().isState(this.stateReadIdle())) {
            this.reader().changeState(this.stateReadActive());
            this.reader().processEvent(1);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, this.dbg("open"));
        }
    }

    public void close(Exception exception) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, this.dbg("close: " + exception));
        }
        if (!this.isSessionShutdown()) {
            this.sessionShutdown = true;
            this.shutdownReason = exception;
            this.writer().processEvent(5, null, exception);
            this.reader().processEvent(5, null, exception);
            this.sessionListener.sessionConnectionClosed(exception);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, this.dbg("close"));
        }
    }

    protected void shutdown(Exception exception) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, this.dbg("shutdown: " + exception));
        }
        if (!this.isSessionShutdown()) {
            this.sessionShutdown = true;
            this.writer().processEvent(5);
            this.reader().processEvent(5);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, this.dbg("shutdown"));
        }
    }

    public void setConnLink(ConnectionLink connectionLink) {
        this.connLink = connectionLink;
    }

    public ConnectionLink getConnLink() {
        return this.connLink;
    }

    protected ConnectionLink getAppLink() {
        return this.appLink;
    }

    protected VirtualConnectionFactory getVCFactory() {
        return this.vcf;
    }

    protected void setCookies(HttpRequestMessage httpRequestMessage, List list) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, this.dbg("setCookies"));
        }
        if (list != null) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                Cookie cookie = (Cookie)iterator.next();
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, this.dbg(this + ".setCookie: " + cookie.getName() + "=" + cookie.getValue()));
                }
                httpRequestMessage.setCookie(cookie, HttpConstants.HDR_COOKIE);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, this.dbg("setCookies"));
        }
    }

    protected String dumpMessage(HttpBaseMessage httpBaseMessage) {
        Object object;
        StringBuffer stringBuffer = new StringBuffer();
        if (httpBaseMessage instanceof HttpRequestMessage) {
            object = (HttpRequestMessage)httpBaseMessage;
            stringBuffer.append("\t");
            stringBuffer.append(object.getMethod());
            stringBuffer.append(" ");
            stringBuffer.append(object.getRequestURI());
            stringBuffer.append("?");
            stringBuffer.append(object.getQueryString());
            stringBuffer.append(" ");
            stringBuffer.append(object.getVersion());
        } else {
            object = (HttpResponseMessage)httpBaseMessage;
            stringBuffer.append("\tHTTP ");
            stringBuffer.append(object.getStatusCode().getIntCode());
        }
        object = httpBaseMessage.getAllHeaders().iterator();
        while (object.hasNext()) {
            String string = (String)object.next();
            stringBuffer.append("\n\t").append(string).append("=").append(httpBaseMessage.getHeaderAsString(string));
        }
        return stringBuffer.toString();
    }

    abstract class TimeoutTask {
        private Timer timer = null;
        private TimerTask task = null;
        private long t0 = System.currentTimeMillis();

        TimeoutTask(Timer timer) {
            this.timer = timer;
        }

        public abstract void run();

        public synchronized void start(long l) {
            block2: {
                try {
                    this.stop();
                    this.task = new TimerTask(){

                        public void run() {
                            block2: {
                                try {
                                    TimeoutTask.this.run();
                                }
                                catch (Exception exception) {
                                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block2;
                                    Tr.debug(tc, HttpOutboundSessionConnection.this.dbg("TimeoutTask.run: EXCEPTION: " + exception));
                                }
                            }
                        }
                    };
                    this.t0 = System.currentTimeMillis();
                    this.timer.schedule(this.task, l);
                }
                catch (Exception exception) {
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block2;
                    Tr.debug(tc, HttpOutboundSessionConnection.this.dbg("TimeoutTask.run: EXCEPTION: " + exception));
                }
            }
        }

        public synchronized void stop() {
            if (this.task != null) {
                this.task.cancel();
                this.task = null;
            }
        }

        public String toString() {
            return System.currentTimeMillis() - this.t0 + "ms";
        }
    }

    class RetryTimer
    extends TimeoutTask {
        RetryTimer(Timer timer) {
            super(timer);
        }

        public void run() {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, HttpOutboundSessionConnection.this.dbg("RetryTimer.run: timer expired"));
            }
            HttpOutboundSessionConnection.this.writer().processEvent(6);
        }
    }

    class StateClosed
    extends BaseState {
        protected StateClosed(HttpOutboundSessionConnection httpOutboundSessionConnection2) {
            this.setSession(httpOutboundSessionConnection2);
        }

        public String toString() {
            return "StateClosed";
        }

        public void handleEvent(int n, OutboundVirtualConnection outboundVirtualConnection, Object object) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, HttpOutboundSessionConnection.this.dbg(this + ".handleEvent: " + EVENTS[n]));
            }
            switch (n) {
                case 4: {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, HttpOutboundSessionConnection.this.dbg(this + ".handleEvent: Received a completed event on a connection in the closed state."));
                    }
                    outboundVirtualConnection.setReadStateToDone();
                    outboundVirtualConnection.setWriteStateToDone();
                    this.close(outboundVirtualConnection, object);
                    break;
                }
            }
        }
    }

    class StateReadActive
    extends BaseState {
        private int failed;
        private StringBuffer args;
        private HttpRequestProperties sessionInfo;
        private boolean connecting;

        protected StateReadActive(HttpOutboundSessionConnection httpOutboundSessionConnection2) {
            this.failed = 0;
            this.args = new StringBuffer();
            this.sessionInfo = new HttpRequestProperties();
            this.connecting = false;
            this.setSession(httpOutboundSessionConnection2);
        }

        public String toString() {
            return "StateReadActive";
        }

        private void handleConnectionError(OutboundVirtualConnection outboundVirtualConnection, Object object) {
            outboundVirtualConnection.setReadStateToDone();
            outboundVirtualConnection.setWriteStateToDone();
            if (HttpOutboundSessionConnection.this.isSessionShutdown()) {
                this.connecting = false;
                HttpOutboundSessionConnection.this.reader().changeState(HttpOutboundSessionConnection.this.stateClosed());
                return;
            }
            Exception exception = (Exception)object;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, HttpOutboundSessionConnection.this.dbg(this + ".handleEvent: failed to connect to " + HttpOutboundSessionConnection.this.getHttpAddress().getRemoteAddress() + "; exc=" + exception));
            }
            if (++this.failed < 2) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, HttpOutboundSessionConnection.this.dbg(this + ".handleEvent: connection attempt " + this.failed + " of " + 2));
                }
                this.handleEvent(1, outboundVirtualConnection, object);
            } else {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, HttpOutboundSessionConnection.this.dbg(this + ".handleEvent: max connection attempts exceeded. Aborting session..."));
                    Tr.debug(tc, HttpOutboundSessionConnection.this.dbg(this + ".handleEvent: sessionID=" + HttpOutboundSessionConnection.this.getSessionID()));
                }
                this.connecting = false;
                HttpOutboundSessionConnection.this.reader().changeState(HttpOutboundSessionConnection.this.stateClosed());
                HttpOutboundSessionConnection.this.getSessionListener().sessionConnectionClosed(exception);
                HttpOutboundSessionConnection.this.shutdown(exception);
                if (0 == HttpOutboundSessionConnection.this.getSessionID()) {
                    HttpOutboundSessionConnection.this.getAppLink().destroy(exception);
                }
            }
        }

        private void handleConnectionReady(OutboundVirtualConnection outboundVirtualConnection, Object object) throws Exception {
            this.connecting = false;
            if (HttpOutboundSessionConnection.this.isSessionShutdown()) {
                this.close(outboundVirtualConnection, object);
                HttpOutboundSessionConnection.this.reader().changeState(HttpOutboundSessionConnection.this.stateClosed());
                return;
            }
            HttpOutboundServiceContext httpOutboundServiceContext = (HttpOutboundServiceContext)outboundVirtualConnection.getChannelAccessor();
            if (null == HttpOutboundSessionConnection.this.getLocalAddress()) {
                HttpOutboundSessionConnection.this.setLocalAddress(httpOutboundServiceContext.getLocalAddr());
                HttpOutboundSessionConnection.this.setLocalPort(httpOutboundServiceContext.getLocalPort());
            }
            httpOutboundServiceContext.clear();
            httpOutboundServiceContext.disallowRewrites();
            HttpRequestMessage httpRequestMessage = httpOutboundServiceContext.getRequest();
            this.args.setLength(0);
            this.args.append("id");
            this.args.append("=");
            this.args.append(HttpOutboundSessionConnection.this.getSessionID());
            this.args.append("&");
            this.args.append("ssq");
            this.args.append("=");
            this.args.append(this.sessionInfo.getServerSequence());
            httpRequestMessage.setMethod(HttpConstants.METHOD_GET);
            httpRequestMessage.setVersion(HttpConstants.HTTP_VERSION_11);
            httpRequestMessage.setRequestURL(HttpOutboundSessionConnection.this.getTargetURL());
            httpRequestMessage.setQueryString(this.args.toString());
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, this + ".handleEvent:" + HttpOutboundSessionConnection.this.dbg(httpRequestMessage.getRequestURLAsString() + "?" + httpRequestMessage.getQueryString()) + "\n" + HttpOutboundSessionConnection.this.dumpMessage(httpRequestMessage));
            }
            httpOutboundServiceContext.setReadTimeout(90000);
            if (outboundVirtualConnection.requestPermissionToWrite() && outboundVirtualConnection.requestPermissionToRead()) {
                if (httpOutboundServiceContext.finishRequestMessage(null, HttpOutboundSessionConnection.this.reader(), false) != null) {
                    this.handleEvent(4, outboundVirtualConnection, object);
                }
            } else {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, HttpOutboundSessionConnection.this.dbg(this + ".handleEvent: denied permission to send request"));
                }
                this.close(outboundVirtualConnection, object);
                this.handleEvent(3, outboundVirtualConnection, object);
            }
        }

        private void handleAsyncComplete(OutboundVirtualConnection outboundVirtualConnection, Object object) {
            block19: {
                WsByteBuffer[] wsByteBufferArray;
                this.connecting = false;
                outboundVirtualConnection.setReadStateToDone();
                outboundVirtualConnection.setWriteStateToDone();
                if (HttpOutboundSessionConnection.this.isSessionShutdown()) {
                    this.close(outboundVirtualConnection, object);
                    HttpOutboundSessionConnection.this.reader().changeState(HttpOutboundSessionConnection.this.stateClosed());
                    return;
                }
                HttpOutboundServiceContext httpOutboundServiceContext = (HttpOutboundServiceContext)outboundVirtualConnection.getChannelAccessor();
                StatusCodes statusCodes = httpOutboundServiceContext.getResponse().getStatusCode();
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, this + ".handleEvent:" + HttpOutboundSessionConnection.this.dbg("") + "\n" + HttpOutboundSessionConnection.this.dumpMessage(httpOutboundServiceContext.getResponse()));
                }
                if (!statusCodes.equals(HttpConstants.STATUS_OK)) {
                    this.handleEvent(3, outboundVirtualConnection, new HttpTunnelException("unexpected HTTP status: " + statusCodes));
                    return;
                }
                this.failed = 0;
                if (0 == HttpOutboundSessionConnection.this.getSessionID()) {
                    wsByteBufferArray = new HttpRequestProperties();
                    wsByteBufferArray.parseSessionProperties(httpOutboundServiceContext.getResponse());
                    HttpOutboundSessionConnection.this.setSessionID(wsByteBufferArray.getSessionId());
                    HttpOutboundSessionConnection.this.getAppLink().ready(HttpOutboundSessionConnection.this.getAppLink().getVirtualConnection());
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, HttpOutboundSessionConnection.this.dbg(this + ".handleEvent: new session ID received: " + HttpOutboundSessionConnection.this.getSessionID()));
                    }
                }
                try {
                    block20: {
                        wsByteBufferArray = null;
                        if (!outboundVirtualConnection.requestPermissionToRead()) {
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                Tr.debug(tc, HttpOutboundSessionConnection.this.dbg(this + ".handleEvent: denied permission to read"));
                            }
                            break block19;
                        }
                        if (httpOutboundServiceContext.getResponseBodyBuffers(HttpOutboundSessionConnection.this.reader(), false) == null) break block19;
                        wsByteBufferArray = httpOutboundServiceContext.getResponseBodyBuffers();
                        outboundVirtualConnection.setReadStateToDone();
                        if (wsByteBufferArray != null) {
                            try {
                                HttpOutboundSessionConnection.this.getSessionListener().setReadData(wsByteBufferArray, HttpOutboundSessionConnection.this);
                                this.sessionInfo.parseSessionProperties(httpOutboundServiceContext.getResponse());
                            }
                            catch (IOException iOException) {
                                BufferUtil.release(wsByteBufferArray);
                                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block20;
                                Tr.debug(tc, HttpOutboundSessionConnection.this.dbg(this + ".handleEvent: exception - " + iOException));
                            }
                        }
                    }
                    if (this.sessionInfo.isSessionClosed()) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug(tc, HttpOutboundSessionConnection.this.dbg(this + ".handleEvent: session closed by host"));
                        }
                        this.getSession().close(new IOException("HTTP tunnel session closed by remote host"));
                    } else if (!httpOutboundServiceContext.isPersistent()) {
                        this.handleEvent(1, outboundVirtualConnection, object);
                    } else {
                        this.handleEvent(2, outboundVirtualConnection, object);
                    }
                }
                catch (Exception exception) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, HttpOutboundSessionConnection.this.dbg(this + ".handleEvent: exception - " + exception));
                    }
                    if (!httpOutboundServiceContext.isPersistent()) {
                        this.handleEvent(1, outboundVirtualConnection, object);
                    }
                    this.handleEvent(2, outboundVirtualConnection, object);
                }
            }
        }

        public void handleEvent(int n, OutboundVirtualConnection outboundVirtualConnection, Object object) {
            try {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, HttpOutboundSessionConnection.this.dbg(this + ".handleEvent: " + EVENTS[n]));
                }
                switch (n) {
                    case 5: {
                        if (!this.connecting) {
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                Tr.debug(tc, HttpOutboundSessionConnection.this.dbg(this + ".handleEvent: closing connection"));
                            }
                            this.close(outboundVirtualConnection, object);
                            HttpOutboundSessionConnection.this.reader().changeState(HttpOutboundSessionConnection.this.stateClosed());
                            break;
                        }
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug(tc, HttpOutboundSessionConnection.this.dbg(this + ".handleEvent: connecting - can't close connection now"));
                        }
                        break;
                    }
                    case 1: {
                        if (HttpOutboundSessionConnection.this.isSessionShutdown()) {
                            this.close(outboundVirtualConnection, object);
                            HttpOutboundSessionConnection.this.reader().changeState(HttpOutboundSessionConnection.this.stateClosed());
                            break;
                        }
                        if (null != outboundVirtualConnection && !this.connecting) {
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                Tr.debug(tc, HttpOutboundSessionConnection.this.dbg(this + ".handleEvent: Closing existing socket before reconnect: " + outboundVirtualConnection + " exception: " + object));
                            }
                            this.close(outboundVirtualConnection, object);
                        }
                        OutboundVirtualConnection outboundVirtualConnection2 = (OutboundVirtualConnection)HttpOutboundSessionConnection.this.getVCFactory().createConnection();
                        HttpOutboundSessionConnection.this.reader().setOutboundVC(outboundVirtualConnection2);
                        this.connecting = true;
                        outboundVirtualConnection2.connectAsynch((Object)HttpOutboundSessionConnection.this.getHttpAddress(), (ConnectionReadyCallback)HttpOutboundSessionConnection.this.reader());
                        break;
                    }
                    case 2: {
                        this.handleConnectionReady(outboundVirtualConnection, object);
                        break;
                    }
                    case 4: {
                        this.handleAsyncComplete(outboundVirtualConnection, object);
                        break;
                    }
                    case 3: {
                        this.handleConnectionError(outboundVirtualConnection, object);
                        break;
                    }
                    default: {
                        super.handleEvent(n, outboundVirtualConnection, object);
                        break;
                    }
                }
            }
            catch (Exception exception) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, HttpOutboundSessionConnection.this.dbg(this + ".handleEvent: EXCEPTION: " + exception));
                }
                this.handleEvent(3, outboundVirtualConnection, exception);
            }
        }
    }

    class StateReadIdle
    extends BaseState {
        protected StateReadIdle(HttpOutboundSessionConnection httpOutboundSessionConnection2) {
            this.setSession(httpOutboundSessionConnection2);
        }

        public String toString() {
            return "StateReadIdle";
        }

        public void handleEvent(int n, OutboundVirtualConnection outboundVirtualConnection, Object object) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, HttpOutboundSessionConnection.this.dbg(this + ".handleEvent: " + EVENTS[n]));
            }
            switch (n) {
                case 5: {
                    this.close(outboundVirtualConnection, object);
                    HttpOutboundSessionConnection.this.reader().changeState(HttpOutboundSessionConnection.this.stateClosed());
                    break;
                }
                default: {
                    super.handleEvent(n, outboundVirtualConnection, object);
                }
            }
        }
    }

    class StateWriteActive
    extends BaseState {
        private int failed;
        private StringBuffer args;
        private List cookies;
        private HttpRequestProperties sessionInfo;
        private WsByteBuffer[] buffer;
        private boolean connecting;
        static final /* synthetic */ boolean $assertionsDisabled;

        protected StateWriteActive(HttpOutboundSessionConnection httpOutboundSessionConnection2) {
            this.failed = 0;
            this.args = new StringBuffer();
            this.cookies = null;
            this.sessionInfo = new HttpRequestProperties();
            this.buffer = new WsByteBuffer[]{null};
            this.connecting = false;
            this.setSession(httpOutboundSessionConnection2);
        }

        public String toString() {
            return "StateWriteActive";
        }

        private void handleConnectionReady(OutboundVirtualConnection outboundVirtualConnection, Object object) throws Exception {
            this.connecting = false;
            if (HttpOutboundSessionConnection.this.isSessionShutdown()) {
                this.close(outboundVirtualConnection, object);
                HttpOutboundSessionConnection.this.writer().changeState(HttpOutboundSessionConnection.this.stateClosed());
                return;
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, HttpOutboundSessionConnection.this.dbg(this + ".handleEvent: ID: " + HttpOutboundSessionConnection.this.getSessionID()));
            }
            HttpOutboundServiceContext httpOutboundServiceContext = (HttpOutboundServiceContext)outboundVirtualConnection.getChannelAccessor();
            if (null == HttpOutboundSessionConnection.this.getLocalAddress()) {
                HttpOutboundSessionConnection.this.setLocalAddress(httpOutboundServiceContext.getLocalAddr());
                HttpOutboundSessionConnection.this.setLocalPort(httpOutboundServiceContext.getLocalPort());
            }
            httpOutboundServiceContext.clear();
            httpOutboundServiceContext.disallowRewrites();
            HttpRequestMessage httpRequestMessage = httpOutboundServiceContext.getRequest();
            HttpOutboundSessionConnection.this.setCookies(httpRequestMessage, this.cookies);
            this.args.setLength(0);
            this.args.append("csq");
            this.args.append("=");
            this.args.append(HttpOutboundSessionConnection.this.getClientSQ());
            if (0 != HttpOutboundSessionConnection.this.getSessionID()) {
                this.args.append("&");
                this.args.append("id");
                this.args.append("=");
                this.args.append(HttpOutboundSessionConnection.this.getSessionID());
            }
            httpRequestMessage.setMethod(HttpConstants.METHOD_POST);
            httpRequestMessage.setVersion(HttpConstants.HTTP_VERSION_11);
            httpRequestMessage.setRequestURL(HttpOutboundSessionConnection.this.getTargetURL());
            httpRequestMessage.setQueryString(this.args.toString());
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, this + ".handleEvent:" + HttpOutboundSessionConnection.this.dbg(httpRequestMessage.getRequestURLAsString() + "?" + httpRequestMessage.getQueryString()) + "\n" + HttpOutboundSessionConnection.this.dumpMessage(httpRequestMessage));
            }
            if (null == this.buffer[0]) {
                this.buffer[0] = HttpOutboundSessionConnection.this.getSessionListener().getWriteData(HttpOutboundSessionConnection.this);
            } else if (!this.buffer[0].hasRemaining()) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, HttpOutboundSessionConnection.this.dbg(this + ".handleEvent: resending buffer: position = " + this.buffer[0].position() + " limit = " + this.buffer[0].limit() + " id = " + HttpOutboundSessionConnection.this.getSessionID()));
                }
                this.buffer[0].flip();
            } else if (!$assertionsDisabled) {
                throw new AssertionError((Object)"Buffer position does not equal limit.");
            }
            if (null == this.buffer[0]) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, HttpOutboundSessionConnection.this.dbg(this + ".handleEvent: no data in POST"));
                }
                HttpOutboundSessionConnection.this.writer().changeState(HttpOutboundSessionConnection.this.stateWriteIdle());
            } else {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, HttpOutboundSessionConnection.this.dbg(this + ".handleEvent: " + this.buffer[0].remaining() + " bytes in POST"));
                }
                if (!$assertionsDisabled && this.buffer[0].position() != 0) {
                    throw new AssertionError((Object)"Buffer position does not equal 0.");
                }
                if (outboundVirtualConnection.requestPermissionToWrite() && outboundVirtualConnection.requestPermissionToRead()) {
                    if (httpOutboundServiceContext.finishRequestMessage(this.buffer, HttpOutboundSessionConnection.this.writer(), false) != null) {
                        this.handleEvent(4, outboundVirtualConnection, object);
                    }
                } else {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, HttpOutboundSessionConnection.this.dbg(this + ".handleEvent: denied permission to send request"));
                    }
                    this.close(outboundVirtualConnection, object);
                    this.handleEvent(3, outboundVirtualConnection, object);
                }
            }
        }

        private void handleConnectionError(OutboundVirtualConnection outboundVirtualConnection, Object object) {
            outboundVirtualConnection.setReadStateToDone();
            outboundVirtualConnection.setWriteStateToDone();
            if (HttpOutboundSessionConnection.this.isSessionShutdown()) {
                this.connecting = false;
                HttpOutboundSessionConnection.this.writer().changeState(HttpOutboundSessionConnection.this.stateClosed());
                return;
            }
            Exception exception = (Exception)object;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, HttpOutboundSessionConnection.this.dbg(this + ".handleEvent: failed to connect to " + HttpOutboundSessionConnection.this.getHttpAddress().getRemoteAddress() + "; exc=" + exception));
            }
            if (++this.failed < 2) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, HttpOutboundSessionConnection.this.dbg(this + ".handleEvent: Connection failed, retrying connection..."));
                }
                this.handleEvent(1, outboundVirtualConnection, object);
            } else {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, HttpOutboundSessionConnection.this.dbg(this + ".handleEvent: max connection attempts exceeded. Aborting session..."));
                    Tr.debug(tc, HttpOutboundSessionConnection.this.dbg(this + ".handleEvent: sessionID=" + HttpOutboundSessionConnection.this.getSessionID()));
                }
                this.connecting = false;
                HttpOutboundSessionConnection.this.writer().changeState(HttpOutboundSessionConnection.this.stateClosed());
                HttpOutboundSessionConnection.this.getSessionListener().sessionConnectionClosed(exception);
                HttpOutboundSessionConnection.this.shutdown(exception);
                if (0 == HttpOutboundSessionConnection.this.getSessionID()) {
                    HttpOutboundSessionConnection.this.getAppLink().destroy(exception);
                }
            }
        }

        private void handleAsyncComplete(OutboundVirtualConnection outboundVirtualConnection, Object object) {
            this.connecting = false;
            outboundVirtualConnection.setReadStateToDone();
            outboundVirtualConnection.setWriteStateToDone();
            if (HttpOutboundSessionConnection.this.isSessionShutdown()) {
                this.close(outboundVirtualConnection, object);
                HttpOutboundSessionConnection.this.writer().changeState(HttpOutboundSessionConnection.this.stateClosed());
                return;
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, HttpOutboundSessionConnection.this.dbg(this + ".handleEvent: ID: " + HttpOutboundSessionConnection.this.getSessionID() + ", csq: " + HttpOutboundSessionConnection.this.getClientSQ()));
            }
            HttpOutboundServiceContext httpOutboundServiceContext = (HttpOutboundServiceContext)outboundVirtualConnection.getChannelAccessor();
            StatusCodes statusCodes = httpOutboundServiceContext.getResponse().getStatusCode();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, this + ".handleEvent:" + HttpOutboundSessionConnection.this.dbg("") + "\n" + HttpOutboundSessionConnection.this.dumpMessage(httpOutboundServiceContext.getResponse()));
            }
            if (!statusCodes.equals(HttpConstants.STATUS_OK)) {
                this.handleEvent(3, outboundVirtualConnection, new HttpTunnelException("unexpected HTTP status: " + statusCodes));
            } else {
                if (this.failed != 0 && TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, HttpOutboundSessionConnection.this.dbg(this + ".handleEvent: transaction succeeded after a failure"));
                }
                this.failed = 0;
                this.cookies = httpOutboundServiceContext.getResponse().getAllCookies();
                this.sessionInfo.parseSessionProperties(httpOutboundServiceContext.getResponse());
                String string = this.sessionInfo.getRequestProperty("rti");
                if (string != null) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, HttpOutboundSessionConnection.this.dbg(this + ".handleEvent: flow control detected for id " + HttpOutboundSessionConnection.this.getSessionID() + ", csq " + HttpOutboundSessionConnection.this.getClientSQ() + "; retry in " + string));
                    }
                    HttpOutboundSessionConnection.this.getRetryTimer().start(Integer.parseInt(string));
                } else {
                    this.buffer[0] = null;
                    ++HttpOutboundSessionConnection.this.clientSequence;
                    if (this.sessionInfo.isSessionClosed()) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug(tc, HttpOutboundSessionConnection.this.dbg(this + ".handleEvent: session closed by host"));
                        }
                        this.getSession().close(new IOException("HTTP tunnel session closed by remote host"));
                    } else if (HttpOutboundSessionConnection.this.getSessionListener().isWriteDataPending()) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug(tc, HttpOutboundSessionConnection.this.dbg(this + ".handleEvent: write response received: isPersistent = " + httpOutboundServiceContext.isPersistent()));
                        }
                        if (!httpOutboundServiceContext.isPersistent()) {
                            this.handleEvent(1, outboundVirtualConnection, object);
                        } else {
                            this.handleEvent(2, outboundVirtualConnection, object);
                        }
                    } else {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug(tc, HttpOutboundSessionConnection.this.dbg(this + ".handleEvent: No more data pending for ID: " + HttpOutboundSessionConnection.this.getSessionID()));
                        }
                        HttpOutboundSessionConnection.this.writer().changeState(HttpOutboundSessionConnection.this.stateWriteIdle());
                    }
                }
            }
        }

        public void handleEvent(int n, OutboundVirtualConnection outboundVirtualConnection, Object object) {
            try {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, HttpOutboundSessionConnection.this.dbg(this + ".handleEvent: " + EVENTS[n]));
                }
                switch (n) {
                    case 0: {
                        break;
                    }
                    case 5: {
                        if (!this.connecting) {
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                Tr.debug(tc, HttpOutboundSessionConnection.this.dbg(this + ".handleEvent: closing connection"));
                            }
                            this.close(outboundVirtualConnection, object);
                            HttpOutboundSessionConnection.this.writer().changeState(HttpOutboundSessionConnection.this.stateClosed());
                            break;
                        }
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug(tc, HttpOutboundSessionConnection.this.dbg(this + ".handleEvent: connecting - can't close connection now"));
                        }
                        break;
                    }
                    case 1: {
                        if (HttpOutboundSessionConnection.this.isSessionShutdown()) {
                            this.close(outboundVirtualConnection, object);
                            HttpOutboundSessionConnection.this.writer().changeState(HttpOutboundSessionConnection.this.stateClosed());
                            break;
                        }
                        if (null != outboundVirtualConnection && !this.connecting) {
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                Tr.debug(tc, HttpOutboundSessionConnection.this.dbg(this + ".handleEvent: Closing existing socket before reconnect: " + outboundVirtualConnection + " exception: " + object));
                            }
                            this.close(outboundVirtualConnection, object);
                        }
                        if (this.failed != 0 && TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug(tc, HttpOutboundSessionConnection.this.dbg(this + ".handleEvent: reconnecting after a failure"));
                        }
                        OutboundVirtualConnection outboundVirtualConnection2 = (OutboundVirtualConnection)HttpOutboundSessionConnection.this.getVCFactory().createConnection();
                        HttpOutboundSessionConnection.this.writer().setOutboundVC(outboundVirtualConnection2);
                        this.connecting = true;
                        outboundVirtualConnection2.connectAsynch((Object)HttpOutboundSessionConnection.this.getHttpAddress(), (ConnectionReadyCallback)HttpOutboundSessionConnection.this.writer());
                        break;
                    }
                    case 2: {
                        this.handleConnectionReady(outboundVirtualConnection, object);
                        break;
                    }
                    case 4: {
                        this.handleAsyncComplete(outboundVirtualConnection, object);
                        break;
                    }
                    case 6: {
                        this.connecting = false;
                        if (HttpOutboundSessionConnection.this.isSessionShutdown()) {
                            this.close(outboundVirtualConnection, object);
                            HttpOutboundSessionConnection.this.writer().changeState(HttpOutboundSessionConnection.this.stateClosed());
                            break;
                        }
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug(tc, HttpOutboundSessionConnection.this.dbg(this + ".handleEvent: retry timeout occured for ID: " + HttpOutboundSessionConnection.this.getSessionID() + ", csq " + HttpOutboundSessionConnection.this.getClientSQ()));
                        }
                        if (outboundVirtualConnection != null) {
                            HttpOutboundServiceContext httpOutboundServiceContext = (HttpOutboundServiceContext)outboundVirtualConnection.getChannelAccessor();
                            if (!httpOutboundServiceContext.isPersistent()) {
                                this.handleEvent(1, outboundVirtualConnection, object);
                                break;
                            }
                            this.handleEvent(2, outboundVirtualConnection, object);
                            break;
                        }
                        this.handleEvent(1, outboundVirtualConnection, object);
                        break;
                    }
                    case 3: {
                        this.handleConnectionError(outboundVirtualConnection, object);
                        break;
                    }
                    default: {
                        super.handleEvent(n, outboundVirtualConnection, object);
                    }
                }
            }
            catch (Exception exception) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, HttpOutboundSessionConnection.this.dbg(this + ".handleEvent: EXCEPTION: " + exception));
                }
                this.handleEvent(3, outboundVirtualConnection, exception);
            }
        }

        static {
            $assertionsDisabled = !(class$com$ibm$wkplc$httptunnel$outbound$impl$HttpOutboundSessionConnection == null ? (class$com$ibm$wkplc$httptunnel$outbound$impl$HttpOutboundSessionConnection = HttpOutboundSessionConnection.class$("com.ibm.wkplc.httptunnel.outbound.impl.HttpOutboundSessionConnection")) : class$com$ibm$wkplc$httptunnel$outbound$impl$HttpOutboundSessionConnection).desiredAssertionStatus();
        }
    }

    class StateWriteIdle
    extends BaseState {
        protected StateWriteIdle(HttpOutboundSessionConnection httpOutboundSessionConnection2) {
            this.setSession(httpOutboundSessionConnection2);
        }

        public String toString() {
            return "StateWriteIdle";
        }

        public void handleEvent(int n, OutboundVirtualConnection outboundVirtualConnection, Object object) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, HttpOutboundSessionConnection.this.dbg(this + ".handleEvent: " + EVENTS[n]));
            }
            switch (n) {
                case 0: {
                    if (!HttpOutboundSessionConnection.this.getSessionListener().isWriteDataPending()) break;
                    if (outboundVirtualConnection != null) {
                        HttpOutboundServiceContext httpOutboundServiceContext = (HttpOutboundServiceContext)outboundVirtualConnection.getChannelAccessor();
                        if (!httpOutboundServiceContext.isPersistent()) {
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                Tr.debug(tc, HttpOutboundSessionConnection.this.dbg(this + ".handleEvent: Persistence is false - create a connection"));
                            }
                            HttpOutboundSessionConnection.this.writer().changeState(HttpOutboundSessionConnection.this.stateWriteActive()).handleEvent(1, outboundVirtualConnection, object);
                            break;
                        }
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug(tc, HttpOutboundSessionConnection.this.dbg(this + ".handleEvent: Persistence is true - reuse connection"));
                        }
                        HttpOutboundSessionConnection.this.writer().changeState(HttpOutboundSessionConnection.this.stateWriteActive()).handleEvent(2, outboundVirtualConnection, object);
                        break;
                    }
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, HttpOutboundSessionConnection.this.dbg(this + ".handleEvent: VC is null - create a connection"));
                    }
                    HttpOutboundSessionConnection.this.writer().changeState(HttpOutboundSessionConnection.this.stateWriteActive()).handleEvent(1, outboundVirtualConnection, object);
                    break;
                }
                case 5: {
                    this.close(outboundVirtualConnection, object);
                    HttpOutboundSessionConnection.this.writer().changeState(HttpOutboundSessionConnection.this.stateClosed());
                    break;
                }
                default: {
                    super.handleEvent(n, outboundVirtualConnection, object);
                }
            }
        }
    }

    class StateWriteDisconnected
    extends BaseState {
        protected StateWriteDisconnected(HttpOutboundSessionConnection httpOutboundSessionConnection2) {
            this.setSession(httpOutboundSessionConnection2);
        }

        public String toString() {
            return "StateWriteDisconnected";
        }

        public void handleEvent(int n, OutboundVirtualConnection outboundVirtualConnection, Object object) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, HttpOutboundSessionConnection.this.dbg(this + ".handleEvent: " + EVENTS[n]));
            }
            switch (n) {
                case 0: {
                    HttpOutboundSessionConnection.this.writer().changeState(HttpOutboundSessionConnection.this.stateWriteActive()).handleEvent(1, outboundVirtualConnection, object);
                    break;
                }
                case 5: {
                    this.close(outboundVirtualConnection, object);
                    HttpOutboundSessionConnection.this.writer().changeState(HttpOutboundSessionConnection.this.stateClosed());
                    break;
                }
                default: {
                    super.handleEvent(n, outboundVirtualConnection, object);
                }
            }
        }
    }

    abstract class BaseState {
        private HttpOutboundSessionConnection session = null;

        BaseState() {
        }

        protected HttpOutboundSessionConnection getSession() {
            return this.session;
        }

        protected void setSession(HttpOutboundSessionConnection httpOutboundSessionConnection) {
            this.session = httpOutboundSessionConnection;
        }

        public void handleEvent(int n, OutboundVirtualConnection outboundVirtualConnection, Object object) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, HttpOutboundSessionConnection.this.dbg(this + ".handleEvent: event not handled - " + EVENTS[n] + " " + outboundVirtualConnection + " " + object));
            }
        }

        public void close(OutboundVirtualConnection outboundVirtualConnection, Object object) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, HttpOutboundSessionConnection.this.dbg(this + ".close: requestPermissionToClose " + outboundVirtualConnection));
            }
            if (outboundVirtualConnection == null) {
                return;
            }
            if (outboundVirtualConnection.requestPermissionToClose(0L)) {
                if (object instanceof Exception) {
                    outboundVirtualConnection.close((Exception)object);
                } else {
                    outboundVirtualConnection.close(null);
                }
            } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, HttpOutboundSessionConnection.this.dbg(this + ".close: requestPermissionToClose was denied. Will close later."));
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, HttpOutboundSessionConnection.this.dbg(this + ".close: finished"));
            }
        }
    }

    class StateContext
    implements ConnectionReadyCallback,
    InterChannelCallback {
        private final Object monitor = new Object();
        private BaseState currentState = null;
        private String name = null;
        private OutboundVirtualConnection ovc = null;

        StateContext(String string) {
            this.name = string;
        }

        protected void setOutboundVC(OutboundVirtualConnection outboundVirtualConnection) {
            this.ovc = outboundVirtualConnection;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void processEvent(int n, OutboundVirtualConnection outboundVirtualConnection, Throwable throwable) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.entry(tc, HttpOutboundSessionConnection.this.dbg("processEvent: " + this.name));
            }
            Object object = this.monitor;
            synchronized (object) {
                block7: {
                    try {
                        this.currentState.handleEvent(n, outboundVirtualConnection != null ? outboundVirtualConnection : this.ovc, throwable);
                    }
                    catch (Exception exception) {
                        if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block7;
                        Tr.debug(tc, HttpOutboundSessionConnection.this.dbg("processEvent: " + this.name + ": unhandled exception; state=" + this.currentState + ",event=" + EVENTS[n] + "; " + exception));
                    }
                }
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, HttpOutboundSessionConnection.this.dbg("processEvent: " + this.name));
            }
        }

        protected void processEvent(int n) {
            this.processEvent(n, this.ovc, null);
        }

        protected BaseState changeState(BaseState baseState) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, HttpOutboundSessionConnection.this.dbg("changeState: " + this.name + ": " + this.currentState + " => " + baseState));
            }
            this.currentState = baseState;
            return this.currentState;
        }

        protected boolean isState(BaseState baseState) {
            return this.currentState.equals(baseState);
        }

        public void ready(VirtualConnection virtualConnection) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.entry(tc, HttpOutboundSessionConnection.this.dbg("ready"));
            }
            this.processEvent(2, (OutboundVirtualConnection)virtualConnection, null);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, HttpOutboundSessionConnection.this.dbg("ready"));
            }
        }

        public void destroy(Exception exception) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.entry(tc, HttpOutboundSessionConnection.this.dbg("StateContext.destroy: " + exception));
            }
            if (!HttpOutboundSessionConnection.this.isSessionShutdown()) {
                this.processEvent(3, this.ovc, exception);
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, HttpOutboundSessionConnection.this.dbg("StateContext.destroy"));
            }
        }

        public void complete(VirtualConnection virtualConnection) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.entry(tc, HttpOutboundSessionConnection.this.dbg("complete"));
            }
            this.processEvent(4, (OutboundVirtualConnection)virtualConnection, null);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, HttpOutboundSessionConnection.this.dbg("complete"));
            }
        }

        public void error(VirtualConnection virtualConnection, Throwable throwable) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.entry(tc, HttpOutboundSessionConnection.this.dbg("error: " + throwable));
            }
            this.processEvent(3, (OutboundVirtualConnection)virtualConnection, throwable);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, HttpOutboundSessionConnection.this.dbg("error"));
            }
        }

        public OutboundVirtualConnection getVC() {
            return this.ovc;
        }
    }

    private class TargetHttpAddress
    implements HttpAddress {
        private String host;
        private InetSocketAddress address;

        protected TargetHttpAddress(URL uRL) {
            this.host = uRL.getHost();
            this.address = new InetSocketAddress(this.host, uRL.getPort());
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, HttpOutboundSessionConnection.this.dbg("Target address is " + this.address));
            }
        }

        public String getHostname() {
            return this.host;
        }

        public InetSocketAddress getLocalAddress() {
            return null;
        }

        public InetSocketAddress getRemoteAddress() {
            return this.address;
        }

        public int getConnectTimeout() {
            return -1;
        }

        public boolean isForwardProxy() {
            return false;
        }
    }
}

