/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wkplc.httptunnel.outbound.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.nws.ffdc.FFDCFilter;
import com.ibm.wkplc.httptunnel.outbound.impl.HttpTunnelOutboundProtocolConnLink;
import com.ibm.wsspi.channel.ConnectionLink;
import com.ibm.wsspi.channel.base.OutboundProtocolChannel;
import com.ibm.wsspi.channel.framework.ChannelData;
import com.ibm.wsspi.channel.framework.VirtualConnection;
import com.ibm.wsspi.channel.framework.VirtualConnectionFactory;
import com.ibm.wsspi.channel.framework.exception.ChannelException;
import com.ibm.wsspi.http.channel.outbound.HttpAddress;
import com.ibm.wsspi.http.channel.outbound.HttpOutboundServiceContext;
import com.ibm.wsspi.runtime.ThreadPool;
import com.ibm.wsspi.runtime.ThreadPoolRepositoryManager;
import com.ibm.wsspi.tcp.channel.TCPConnectRequestContext;
import com.ibm.wsspi.tcp.channel.TCPConnectionContext;
import java.util.Timer;

public class HttpTunnelOutboundProtocolChannel
extends OutboundProtocolChannel {
    private static final TraceComponent tc = Tr.register(HttpTunnelOutboundProtocolChannel.class, "HTTPTunnelChannel", "com.ibm.wkplc.httptunnel.resources.tunnelMessages");
    private static final Class[] APP_ADDRESS_INTERFACES = new Class[]{TCPConnectRequestContext.class};
    private String defaultProtocol = null;
    private String uriPattern = null;
    private int defaultReadTimeout = 0;
    private int defaultWriteTimeout = 0;
    private ThreadPool threadPool = null;
    private VirtualConnectionFactory vcf = null;
    private Timer timer = null;

    public HttpTunnelOutboundProtocolChannel(ChannelData channelData) {
        super(channelData);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "HttpTunnelOutboundProtocolChannel");
        }
        this.update(channelData);
        String string = (String)channelData.getPropertyBag().get("threadPool");
        ThreadPool threadPool = this.threadPool = null != string ? ThreadPoolRepositoryManager.getThreadPoolRepository().getThreadPool(string) : channelData.getChannelFramework().getDefaultThreadPool();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "HttpTunnelOutboundProtocolChannel");
        }
    }

    public Class[] getApplicationAddress() {
        return APP_ADDRESS_INTERFACES;
    }

    public Class getDeviceAddress() {
        return HttpAddress.class;
    }

    public void destroy() throws ChannelException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "destroy");
        }
        if (null != this.vcf) {
            try {
                this.vcf.destroy();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.vcf = null;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "destroy");
        }
    }

    public Class getApplicationInterface() {
        return TCPConnectionContext.class;
    }

    public ConnectionLink getConnectionLink(VirtualConnection virtualConnection) {
        HttpTunnelOutboundProtocolConnLink httpTunnelOutboundProtocolConnLink;
        block4: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.entry(tc, "getConnectionLink");
            }
            httpTunnelOutboundProtocolConnLink = null;
            try {
                httpTunnelOutboundProtocolConnLink = new HttpTunnelOutboundProtocolConnLink(this.defaultProtocol, this.uriPattern, this.threadPool, this.getVirtualConnectionFactory(), this.timer, this.defaultReadTimeout, this.defaultWriteTimeout);
                httpTunnelOutboundProtocolConnLink.init(virtualConnection);
            }
            catch (Exception exception) {
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block4;
                Tr.debug(tc, "getConnectionLink: EXCEPTION: " + exception);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getConnectionLink: " + httpTunnelOutboundProtocolConnLink);
        }
        return httpTunnelOutboundProtocolConnLink;
    }

    public Class getDeviceInterface() {
        return HttpOutboundServiceContext.class;
    }

    public void init() throws ChannelException {
    }

    public void start() throws ChannelException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "start");
        }
        this.timer = new Timer();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "start");
        }
    }

    public void stop(long l) throws ChannelException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "stop: " + l);
        }
        if (0L == l && this.timer != null) {
            this.timer.cancel();
            this.timer = null;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "stop");
        }
    }

    public void update(ChannelData channelData) {
        super.setConfig(channelData);
        this.defaultProtocol = this.getStringProperty("protocol", "http");
        this.uriPattern = this.getStringProperty("filepath", null);
        if (null == this.uriPattern) {
            this.uriPattern = this.getStringProperty("uriPattern", "/IBM_HTTP_TUNNEL/");
        } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Config: Using old filepath property");
        }
        this.defaultReadTimeout = this.getIntProperty("inactivityTimeout", 60000);
        this.defaultWriteTimeout = this.getIntProperty("inactivityTimeout", 60000);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Config: protocol=" + this.defaultProtocol);
            Tr.debug(tc, "Config: uriPattern=" + this.uriPattern);
            Tr.debug(tc, "Config: readTimeout=" + this.defaultReadTimeout);
            Tr.debug(tc, "Config: writeTimeout=" + this.defaultWriteTimeout);
        }
    }

    private String getStringProperty(String string, String string2) {
        String string3 = (String)this.getConfig().getPropertyBag().get(string);
        if (null == string3 || 0 >= string3.trim().length()) {
            return string2;
        }
        return string3;
    }

    private int getIntProperty(String string, int n) {
        block3: {
            String string2 = (String)this.getConfig().getPropertyBag().get(string);
            if (null != string2) {
                try {
                    return Integer.parseInt(string2);
                }
                catch (NumberFormatException numberFormatException) {
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block3;
                    Tr.debug(tc, "getIntProperty: property " + string + " contains a non-int value [" + string2 + "]");
                }
            }
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private VirtualConnectionFactory getVirtualConnectionFactory() {
        if (null == this.vcf) {
            HttpTunnelOutboundProtocolChannel httpTunnelOutboundProtocolChannel = this;
            synchronized (httpTunnelOutboundProtocolChannel) {
                block8: {
                    if (null == this.vcf) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug(tc, "Creating the VC factory.");
                        }
                        try {
                            this.vcf = this.getConfig().getChannelFramework().getOutboundVCFactory(this.getConfig().getName());
                        }
                        catch (Exception exception) {
                            FFDCFilter.processException((Throwable)exception, (String)(((Object)((Object)this)).getClass().getName() + ".getVirtualConnectionFactory"), (String)"306");
                            if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block8;
                            Tr.debug(tc, "getVirtualConnectionFactory: EXCEPTION: " + exception);
                        }
                    }
                }
            }
        }
        return this.vcf;
    }
}

