/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wkplc.httptunnel.outbound.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.wkplc.httptunnel.HttpTunnelException;
import com.ibm.wkplc.httptunnel.impl.HttpTunnelSession;
import com.ibm.wkplc.httptunnel.outbound.impl.HttpOutboundSessionConnection;
import com.ibm.wsspi.channel.ConnectionLink;
import com.ibm.wsspi.channel.OutboundProtocol;
import com.ibm.wsspi.channel.base.OutboundProtocolLink;
import com.ibm.wsspi.channel.framework.VirtualConnection;
import com.ibm.wsspi.channel.framework.VirtualConnectionFactory;
import com.ibm.wsspi.runtime.ThreadPool;
import com.ibm.wsspi.tcp.channel.TCPConnectRequestContext;
import java.io.Serializable;
import java.net.InetSocketAddress;
import java.net.URL;
import java.util.Timer;

public class HttpTunnelOutboundProtocolConnLink
extends OutboundProtocolLink
implements OutboundProtocol {
    private static final TraceComponent tc = Tr.register(HttpTunnelOutboundProtocolConnLink.class, "HTTPTunnelChannel", "com.ibm.wkplc.httptunnel.resources.tunnelMessages");
    private HttpTunnelSession tunnelSession = null;
    private HttpOutboundSessionConnection sessionConnection = null;
    private String httpProtocol = null;
    private String httpPath = null;
    private VirtualConnectionFactory vcf = null;
    private Timer timer = null;
    private Object connectMonitor = new Object();
    private boolean isConnected = false;
    private boolean connectAsync = false;
    private Exception connectException = null;

    protected HttpTunnelOutboundProtocolConnLink(String string, String string2, ThreadPool threadPool, VirtualConnectionFactory virtualConnectionFactory, Timer timer, int n, int n2) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "HttpTunnelOutboundProtocolConnLink");
        }
        this.httpProtocol = string;
        this.httpPath = string2;
        this.vcf = virtualConnectionFactory;
        this.timer = timer;
        this.tunnelSession = new HttpTunnelSession(threadPool, this.timer, n, n2);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "HttpTunnelOutboundProtocolConnLink");
        }
    }

    protected void postConnectProcessing(VirtualConnection virtualConnection) {
    }

    public Object getChannelAccessor() {
        return this.tunnelSession;
    }

    public String getProtocol() {
        return "HTTP";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy(Exception exception) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "HttpTunnelOutboundProtocolConnLink.destroy: " + exception);
        }
        if (!this.connectAsync && !this.isConnected) {
            this.connectException = exception;
            Object object = this.connectMonitor;
            synchronized (object) {
                this.connectMonitor.notifyAll();
            }
        } else {
            super.destroy(exception);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "HttpTunnelOutboundProtocolConnLink.destroy");
        }
    }

    public void connectAsynch(Object object) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "connectAsynch");
        }
        try {
            Serializable serializable;
            if (this.sessionConnection != null) {
                serializable = new HttpTunnelException("ConnectAsync on existing link");
                this.sessionConnection.close((Exception)serializable);
                this.tunnelSession.shutdown((Exception)serializable);
            }
            this.isConnected = false;
            this.connectAsync = true;
            serializable = ((TCPConnectRequestContext)object).getRemoteAddress();
            URL uRL = new URL(this.httpProtocol, ((InetSocketAddress)serializable).getHostName(), ((InetSocketAddress)serializable).getPort(), this.httpPath);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "connectAsynch: url: " + uRL.toExternalForm());
            }
            this.sessionConnection = new HttpOutboundSessionConnection((ConnectionLink)this, this.timer, this.vcf, uRL);
            this.tunnelSession.startup(this.sessionConnection, (ConnectionLink)this);
            this.sessionConnection.open();
        }
        catch (Exception exception) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "connectAsynch: EXCEPTION: " + exception);
            }
            this.destroy(exception);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "connectAsynch");
        }
    }

    public void close(VirtualConnection virtualConnection, Exception exception) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "close: " + virtualConnection + " exc: " + exception);
        }
        this.sessionConnection.close(exception);
        this.destroy(null);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "close");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connect(Object object) throws Exception {
        Serializable serializable;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "connect");
        }
        if (this.sessionConnection != null) {
            serializable = new HttpTunnelException("Connect on existing link");
            this.sessionConnection.close((Exception)serializable);
            this.tunnelSession.shutdown((Exception)serializable);
        }
        this.isConnected = false;
        this.connectAsync = false;
        serializable = ((TCPConnectRequestContext)object).getRemoteAddress();
        URL uRL = new URL(this.httpProtocol, ((InetSocketAddress)serializable).getHostName(), ((InetSocketAddress)serializable).getPort(), this.httpPath);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "connect: url: " + uRL.toExternalForm());
        }
        this.sessionConnection = new HttpOutboundSessionConnection((ConnectionLink)this, this.timer, this.vcf, uRL);
        this.tunnelSession.startup(this.sessionConnection, (ConnectionLink)this);
        this.sessionConnection.open();
        Object object2 = this.connectMonitor;
        synchronized (object2) {
            while (!this.isConnected) {
                this.connectMonitor.wait();
            }
        }
        if (this.connectException != null) {
            throw this.connectException;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "connect");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ready(VirtualConnection virtualConnection) {
        this.isConnected = true;
        if (this.connectAsync) {
            this.getApplicationCallback().ready(this.getVirtualConnection());
        } else {
            Object object = this.connectMonitor;
            synchronized (object) {
                this.connectMonitor.notifyAll();
            }
        }
    }
}

