/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wkplc.util;

import com.ibm.ws.buffermgmt.impl.WsByteBufferPoolManagerImpl;
import com.ibm.wsspi.buffermgmt.WsByteBuffer;

public class WSCircularBuffer {
    private int end = 0;
    private int start = 0;
    private int size;
    private int remaining;
    private WsByteBuffer circularBuffer;

    public WSCircularBuffer(int n) {
        this.size = n;
        this.remaining = n;
        this.circularBuffer = WsByteBufferPoolManagerImpl.getRef().allocate(n);
    }

    public void write(WsByteBuffer wsByteBuffer) {
        this.write(wsByteBuffer, wsByteBuffer.remaining());
    }

    public synchronized void write(WsByteBuffer wsByteBuffer, int n) {
        int n2 = wsByteBuffer.limit();
        if (n > this.remaining) {
            throw new IllegalArgumentException("Not enough space available");
        }
        int n3 = this.size - this.start;
        if (n3 < n) {
            wsByteBuffer.limit(wsByteBuffer.position() + n3);
            this.circularBuffer.limit(this.size);
            this.circularBuffer.position(this.start);
            this.circularBuffer.put(wsByteBuffer);
            wsByteBuffer.limit(n2);
            this.circularBuffer.position(0);
            this.circularBuffer.put(wsByteBuffer);
            this.start = n - n3;
        } else {
            this.circularBuffer.limit(this.size);
            this.circularBuffer.position(this.start);
            this.circularBuffer.put(wsByteBuffer);
            this.start += n;
        }
        this.remaining -= n;
        wsByteBuffer.limit(n2);
    }

    public synchronized int read(WsByteBuffer wsByteBuffer) {
        int n;
        int n2 = wsByteBuffer.remaining();
        if (n2 > this.used()) {
            n2 = this.used();
        }
        if ((n = this.size - this.end) < n2) {
            this.circularBuffer.limit(this.size);
            this.circularBuffer.position(this.end);
            wsByteBuffer.put(this.circularBuffer);
            this.circularBuffer.position(0);
            this.circularBuffer.limit(n2 - n);
            wsByteBuffer.put(this.circularBuffer);
            this.end = n2 - n;
        } else {
            this.circularBuffer.position(0);
            this.circularBuffer.limit(this.end + n2);
            this.circularBuffer.position(this.end);
            wsByteBuffer.put(this.circularBuffer);
            this.end += n2;
        }
        this.remaining += n2;
        return n2;
    }

    public synchronized int remaining() {
        return this.remaining;
    }

    public synchronized boolean isEmpty() {
        return this.remaining == this.size;
    }

    public int used() {
        return this.size - this.remaining;
    }

    public int capacity() {
        return this.size;
    }

    public synchronized void release() {
        if (null != this.circularBuffer) {
            this.start = 0;
            this.end = 0;
            this.size = 0;
            this.remaining = 0;
            this.circularBuffer.release();
            this.circularBuffer = null;
        }
    }
}

