/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ActivitySession;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ActivitySession.ActivitySessionServiceManager;
import com.ibm.ws.activity.WebSphereUserActivity;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.javax.activity.ActivityManager;
import com.ibm.ws.javax.activity.SystemException;
import javax.naming.Context;
import javax.naming.NamingException;

public class ActivityManagerAccess {
    private static TraceComponent tc = Tr.register(ActivityManagerAccess.class, "ActivitySession", "com.ibm.ws.ActivitySession.resources.ActivitySessionMessages");
    private static Object _access = null;
    private static boolean _isActivity;
    private static boolean _isServerProcess;
    private static Context _context;

    private ActivityManagerAccess() {
    }

    public static void registerActivitySessionService(Context context, boolean bl) throws SystemException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "registerActivitySessionService", new Object[]{"Context=" + context + ", ServerProcess=" + bl});
        }
        _context = context;
        _isServerProcess = bl;
        try {
            if (_isServerProcess) {
                ActivityManager activityManager = ActivityManagerAccess.getActivityManager();
                activityManager.registerService(new ActivitySessionServiceManager());
            } else {
                ActivityManagerAccess.getUserActivity().registerService(new ActivitySessionServiceManager());
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException(exception, "com.ibm.ws.ActivitySession.ActivityManagerAccess.registerActivitySessionService", "87");
            SystemException systemException = new SystemException("Unexpected error occurred whilst initialising ActivitySession service.", exception);
            if (tc.isEventEnabled()) {
                Tr.event(tc, "registerActivitySessionService", "Unexpected error occurred whilst initialising ActivitySession service.");
            }
            Tr.error(tc, "ERR_INIT_UNEXPECTED");
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "registerActivitySessionService");
            }
            throw systemException;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "registerActivitySessionService");
        }
    }

    public static ActivityManager getActivityManager() throws SystemException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getActivityManager");
        }
        if (_isActivity) {
            SystemException systemException = new SystemException("Cannot access ActivityManager in current environment.");
            if (tc.isEventEnabled()) {
                Tr.event(tc, "getActivityManager", "Logic error - trying to access ActivityManager in client env");
            }
            Tr.error(tc, "ERR_CANNOT_ACCESS_AM");
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getActivityManager");
            }
            throw systemException;
        }
        if (_access == null) {
            try {
                _access = (ActivityManager)_context.lookup("services:websphere/ActivityManager");
                _isActivity = false;
            }
            catch (NamingException namingException) {
                FFDCFilter.processException(namingException, "com.ibm.ws.ActivitySession.ActivityManagerAccess.getActivityManager", "132");
                SystemException systemException = new SystemException("Unable to retrieve ActivityManager from Namespace.", namingException);
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "getActivityManager", "Naming exception from ActivityManager lookup");
                }
                Tr.error(tc, "ERR_NO_ACTIVITY_MANAGER");
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getActivityManager");
                }
                throw systemException;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getActivityManager", "return=" + _access);
        }
        return (ActivityManager)_access;
    }

    public static WebSphereUserActivity getUserActivity() throws SystemException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getUserActivity");
        }
        if (_access == null) {
            try {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "performing lookup of services:websphere/UserActivity");
                }
                _access = _context.lookup("services:websphere/UserActivity");
                _isActivity = true;
            }
            catch (NamingException namingException) {
                FFDCFilter.processException(namingException, "com.ibm.ws.ActivitySession.ActivityManagerAccess.getUserActivity", "169");
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "getUserActivity", "Unable to retrieve UserActivity from Namespace.");
                }
                SystemException systemException = new SystemException("Unable to retrieve UserActivity from Namespace.", namingException);
                Tr.error(tc, "ERR_NO_USER_ACTIVITY");
                Tr.exit(tc, "getUserActivity");
                throw systemException;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getUserActivity", "return=" + _access);
        }
        return (WebSphereUserActivity)_access;
    }

    public static boolean isServerProcess() {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "isServerProcess", "return=" + _isServerProcess);
        }
        return _isServerProcess;
    }
}

