/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ActivitySession;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ActivitySession.ActivityManagerAccess;
import com.ibm.ws.ActivitySession.ActivitySession;
import com.ibm.ws.ActivitySession.ActivitySessionImpl;
import com.ibm.ws.Transaction.TransactionManagerFactory;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.javax.activity.ActivityManager;
import com.ibm.ws.javax.activity.ActivityToken;
import com.ibm.ws.javax.activity.InvalidActivityException;
import com.ibm.ws.javax.activity.SystemException;
import com.ibm.ws.javax.activity.UserActivity;

public class ActivitySessionAccess {
    private static TraceComponent tc = Tr.register(ActivitySessionAccess.class, "ActivitySession", "com.ibm.ws.ActivitySession.resources.ActivitySessionMessages");
    private static ActivityManager _manager;
    private static UserActivity _activity;
    private static int _timeout;
    private static boolean _enable;
    protected static final int DEFAULT_TIMEOUT_DEFAULT = 300;
    private static int _defaultTimeout;

    public static void beginSession() throws com.ibm.websphere.ActivitySession.SystemException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "beginSession");
        }
        try {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Beginning ActivitySession with timeout = " + _timeout);
            }
            ActivitySessionAccess.getActivity().begin(_timeout);
        }
        catch (Exception exception) {
            FFDCFilter.processException(exception, "com.ibm.ws.ActivitySession.ActivitySessionAccess.beginSession", "81");
            if (tc.isEventEnabled()) {
                Tr.event(tc, "beginSession", "Unexpected error occurred whilst beginning a new ActivitySession.");
            }
            com.ibm.websphere.ActivitySession.SystemException systemException = new com.ibm.websphere.ActivitySession.SystemException("Unexpected error occurred whilst beginning a new ActivitySession.", exception);
            Object[] objectArray = new Object[]{exception};
            Tr.error(tc, "ERR_BEGIN_AS", objectArray);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "beginSession", systemException);
            }
            throw systemException;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "beginSession");
        }
    }

    protected static ActivitySession suspendSession() throws com.ibm.websphere.ActivitySession.SystemException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "suspendSession");
        }
        ActivitySessionImpl activitySessionImpl = null;
        try {
            activitySessionImpl = (ActivitySessionImpl)ActivityManagerAccess.getUserActivity().getPG("ActivitySession");
            if (activitySessionImpl != null) {
                ActivityToken activityToken = ActivitySessionAccess.getManager().suspend();
                activitySessionImpl.setToken(activityToken);
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException(exception, "com.ibm.ws.ActivitySession.ActivitySessionAccess.suspendSession", "126");
            if (tc.isEventEnabled()) {
                Tr.event(tc, "suspendSession", "Unexpected error occured whilst suspending ActivitySession.");
            }
            com.ibm.websphere.ActivitySession.SystemException systemException = new com.ibm.websphere.ActivitySession.SystemException("Unexpected error occured whilst suspending ActivitySession.", exception);
            Object[] objectArray = new Object[]{exception};
            Tr.error(tc, "ERR_SUSPEND_AS", objectArray);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "suspendSession", systemException);
            }
            throw systemException;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "suspendSession", activitySessionImpl);
        }
        return activitySessionImpl;
    }

    protected static void resumeSession(ActivitySession activitySession) throws com.ibm.websphere.ActivitySession.SystemException, InvalidActivityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "resumeSession", activitySession);
        }
        if (activitySession == null) {
            com.ibm.websphere.ActivitySession.SystemException systemException = new com.ibm.websphere.ActivitySession.SystemException("Cannot resume ActivitySession. Provided ActivitySession is null!");
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "resumeSession", systemException);
            }
            throw systemException;
        }
        ActivitySessionImpl activitySessionImpl = (ActivitySessionImpl)activitySession;
        try {
            ActivityToken activityToken = activitySessionImpl.getToken();
            ActivitySessionAccess.getManager().resume(activityToken);
        }
        catch (InvalidActivityException invalidActivityException) {
            Object[] objectArray = new Object[]{invalidActivityException};
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "resumeSession", (Object)invalidActivityException);
            }
            throw invalidActivityException;
        }
        catch (Exception exception) {
            FFDCFilter.processException(exception, "com.ibm.ws.ActivitySession.ActivitySessionAccess.resumeSession", "176");
            if (tc.isEventEnabled()) {
                Tr.event(tc, "resumeSession", "Unexpected error occured whilst resuming ActivitySession.");
            }
            com.ibm.websphere.ActivitySession.SystemException systemException = new com.ibm.websphere.ActivitySession.SystemException("Unexpected error occured whilst resuming ActivitySession.", exception);
            Object[] objectArray = new Object[]{exception};
            Tr.error(tc, "ERR_RESUME_AS", objectArray);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "resumeSession", systemException);
            }
            throw systemException;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "resumeSession");
        }
    }

    protected static ActivitySessionImpl getSession() throws com.ibm.websphere.ActivitySession.SystemException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getSession");
        }
        ActivitySessionImpl activitySessionImpl = null;
        try {
            activitySessionImpl = (ActivitySessionImpl)ActivityManagerAccess.getUserActivity().getPG("ActivitySession");
        }
        catch (Exception exception) {
            FFDCFilter.processException(exception, "com.ibm.ws.ActivitySession.ActivitySessionAccess.getSession", "221");
            if (tc.isEventEnabled()) {
                Tr.event(tc, "Unexpected exception caught getting ActivitySession property group", exception);
            }
            Tr.error(tc, "ERR_GET_PG_FAILED");
            com.ibm.websphere.ActivitySession.SystemException systemException = new com.ibm.websphere.ActivitySession.SystemException(exception);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getSession", systemException);
            }
            throw systemException;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getSession", activitySessionImpl);
        }
        return activitySessionImpl;
    }

    protected static boolean sessionExists() {
        boolean bl;
        block13: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "sessionExists");
            }
            bl = false;
            try {
                int n = ActivitySessionAccess.getActivity().getStatus();
                if (tc.isDebugEnabled()) {
                    String string = "";
                    switch (n) {
                        case 0: {
                            string = "StatusActive";
                            break;
                        }
                        case 2: {
                            string = "StatusCompleted";
                            break;
                        }
                        case 1: {
                            string = "StatusCompleting";
                            break;
                        }
                        case 5: {
                            string = "StatusError";
                            break;
                        }
                        case 3: {
                            string = "StatusNoActivity";
                            break;
                        }
                        case 4: {
                            string = "StatusUnknown";
                        }
                    }
                    Tr.debug(tc, "sessionExists", "Activity status=" + string);
                }
                bl = n == 0 || n == 1;
            }
            catch (Exception exception) {
                FFDCFilter.processException(exception, "com.ibm.ws.ActivitySession.ActivitySessionAccess.sessionExists", "285");
                Tr.error(tc, "ERR_ACTIVITY_EXISTS");
                if (!tc.isEventEnabled()) break block13;
                Tr.event(tc, "sessionExists", "Unexpected error occurred whilst accessing status of underlying Activity.");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "sessionExists", new Boolean(bl));
        }
        return bl;
    }

    protected static boolean globalTranExists() {
        boolean bl;
        block5: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "globalTranExists");
            }
            bl = false;
            try {
                int n = TransactionManagerFactory.getTransactionManager().getStatus();
                if (n != 6) {
                    bl = true;
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException(exception, "com.ibm.ws.ActivitySession.ActivitySessionAccess.globalTranExists", "335");
                if (!tc.isEventEnabled()) break block5;
                Tr.event(tc, "globalTranExists", "Exception caught retrieving Global Tran status!:" + exception);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "globalTranExists", new Boolean(bl));
        }
        return bl;
    }

    protected static ActivityManager getManager() throws SystemException {
        if (_manager == null) {
            _manager = ActivityManagerAccess.getActivityManager();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "ActivityManager reference initialized", _manager);
            }
        }
        return _manager;
    }

    protected static UserActivity getActivity() throws SystemException {
        if (_activity == null) {
            _activity = ActivityManagerAccess.getUserActivity();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "UserActivity reference initialized", _activity);
            }
        }
        return _activity;
    }

    protected static void setDefaultTimeout(int n) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setDefaultTimeout", new Integer(n));
        }
        _timeout = n == 0 ? _defaultTimeout : n;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setDefaultTimeout");
        }
    }

    protected static void setDefaultTimeoutDefault(int n) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setDefaultTimeoutDefault", new Integer(n));
        }
        _defaultTimeout = n == 0 ? 300 : n;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setDefaultTimeoutDefault");
        }
    }

    protected static int getDefaultTimeout() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getDefaultTimeout");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getDefaultTimeout", new Integer(_timeout));
        }
        return _timeout;
    }

    static {
        _defaultTimeout = 300;
    }
}

