/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ActivitySession;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.ActivitySession.NotProcessedException;
import com.ibm.ws.ActivitySession.ActivitySessionResource;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.javax.activity.ActionErrorException;
import com.ibm.ws.javax.activity.ActivityInformation;
import com.ibm.ws.javax.activity.Outcome;
import com.ibm.ws.javax.activity.Signal;
import com.ibm.ws.javax.activity.coordination.Action;
import java.io.Serializable;
import javax.transaction.Synchronization;

public final class ActivitySessionAction
implements Action {
    private static TraceComponent tc = Tr.register(ActivitySessionAction.class, "ActivitySession", "com.ibm.ws.ActivitySession.resources.ActivitySessionMessages");
    private boolean _isResource;
    private ActivitySessionResource _resource;
    private Synchronization _sync;

    public ActivitySessionAction(ActivitySessionResource activitySessionResource) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "ActivitySessionAction", activitySessionResource);
        }
        this._resource = activitySessionResource;
        this._isResource = true;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "ActivitySessionAction", this);
        }
    }

    public ActivitySessionAction(Synchronization synchronization) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "ActivitySessionAction", synchronization);
        }
        this._sync = synchronization;
        this._isResource = false;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "ActivitySessionAction", this);
        }
    }

    public Outcome processSignal(Signal signal) throws ActionErrorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "processSignal", "" + signal);
        }
        Outcome outcome = null;
        if (signal != null) {
            String string = signal.getName();
            if (this._isResource) {
                boolean bl;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Resource processing signal name: " + string);
                }
                int n = 3;
                Integer n2 = (Integer)signal.getExtendedValue();
                if (n2 != null) {
                    n = n2;
                }
                boolean bl2 = bl = n == 1 || n == 2;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "isCompleting: " + bl);
                }
                if (string.equals("com.ibm.ws.ActivitySession.CheckpointSignal")) {
                    try {
                        this._resource.checkpointResource(bl);
                        outcome = new Outcome("com.ibm.ws.ActivitySession.CheckpointOutcome", (Serializable)((Object)""));
                    }
                    catch (NotProcessedException notProcessedException) {
                        FFDCFilter.processException((Throwable)notProcessedException, "com.ibm.ws.ActivitySession.ActivitySessionAction.processSignal", "114", this);
                        Object[] objectArray = new Object[]{notProcessedException};
                        Tr.error(tc, "ERR_RES_NOT_PROCESS_SIGNAL", objectArray);
                        if (tc.isEventEnabled()) {
                            Tr.event(tc, "processSignal", "Resource unable to process signal.");
                        }
                        String[] stringArray = notProcessedException.getMessages();
                        outcome = new Outcome("com.ibm.ws.ActivitySession.FailureOutcome", (Serializable)stringArray);
                    }
                    catch (Throwable throwable) {
                        FFDCFilter.processException(throwable, "com.ibm.ws.ActivitySession.ActivitySessionAction.processSignal", "122", this);
                        ActionErrorException actionErrorException = new ActionErrorException("Unexpected error occured whilst processing Signal.");
                        Object[] objectArray = new Object[]{throwable};
                        Tr.error(tc, "ERR_PROCESS_SIGNAL", objectArray);
                        if (tc.isEventEnabled()) {
                            Tr.event(tc, "processSignal", "Unexpected error occured whilst processing Signal.");
                        }
                        if (tc.isEntryEnabled()) {
                            Tr.exit(tc, "processSignal");
                        }
                        throw actionErrorException;
                    }
                } else if (string.equals("com.ibm.ws.ActivitySession.ResetSignal")) {
                    try {
                        this._resource.resetResource(bl);
                        outcome = new Outcome("com.ibm.ws.ActivitySession.ResetOutcome", (Serializable)((Object)""));
                    }
                    catch (NotProcessedException notProcessedException) {
                        FFDCFilter.processException((Throwable)notProcessedException, "com.ibm.ws.ActivitySession.ActivitySessionAction.processSignal", "142", this);
                        Object[] objectArray = new Object[]{notProcessedException};
                        Tr.error(tc, "ERR_RES_NOT_PROCESS_SIGNAL", objectArray);
                        if (tc.isEventEnabled()) {
                            Tr.event(tc, "processSignal", "Resource unable to process signal.");
                        }
                        String[] stringArray = notProcessedException.getMessages();
                        outcome = new Outcome("com.ibm.ws.ActivitySession.FailureOutcome", (Serializable)stringArray);
                    }
                    catch (Throwable throwable) {
                        FFDCFilter.processException(throwable, "com.ibm.ws.ActivitySession.ActivitySessionAction.processSignal", "151", this);
                        ActionErrorException actionErrorException = new ActionErrorException("Unexpected error occured whilst processing Signal.");
                        Object[] objectArray = new Object[]{throwable};
                        Tr.error(tc, "ERR_PROCESS_SIGNAL", objectArray);
                        if (tc.isEventEnabled()) {
                            Tr.event(tc, "processSignal", "Unexpected error occured whilst processing Signal.");
                        }
                        if (tc.isEntryEnabled()) {
                            Tr.exit(tc, "processSignal");
                        }
                        throw actionErrorException;
                    }
                }
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Synchronization processing signal name: " + string);
                }
                if (string.equals("preCompletion")) {
                    try {
                        this._sync.beforeCompletion();
                        outcome = new Outcome("preCompletionSuccess", (Serializable)((Object)""));
                    }
                    catch (Throwable throwable) {
                        FFDCFilter.processException(throwable, "com.ibm.ws.ActivitySession.ActivitySessionAction.processSignal", "173", this);
                        ActionErrorException actionErrorException = new ActionErrorException("Unexpected error occured whilst processing Signal.");
                        Object[] objectArray = new Object[]{throwable};
                        Tr.error(tc, "ERR_PROCESS_SIGNAL", objectArray);
                        if (tc.isEventEnabled()) {
                            Tr.event(tc, "processSignal", "Unexpected error occured whilst processing Signal.");
                        }
                        if (tc.isEntryEnabled()) {
                            Tr.exit(tc, "processSignal");
                        }
                        throw actionErrorException;
                    }
                }
                if (string.equals("postCompletion")) {
                    try {
                        ActivityInformation activityInformation = (ActivityInformation)signal.getExtendedValue();
                        switch (activityInformation.getCompletionStatus()) {
                            case 0: {
                                this._sync.afterCompletion(3);
                                break;
                            }
                            case 1: 
                            case 2: {
                                this._sync.afterCompletion(4);
                            }
                        }
                        outcome = new Outcome("postCompletionSuccess", (Serializable)((Object)""));
                    }
                    catch (Throwable throwable) {
                        FFDCFilter.processException(throwable, "com.ibm.ws.ActivitySession.ActivitySessionAction.processSignal", "211", this);
                        ActionErrorException actionErrorException = new ActionErrorException("Unexpected error occured whilst processing Signal.");
                        Object[] objectArray = new Object[]{throwable};
                        Tr.error(tc, "ERR_PROCESS_SIGNAL", objectArray);
                        if (tc.isEventEnabled()) {
                            Tr.event(tc, "processSignal", "Unexpected error occured whilst processing Signal.");
                        }
                        if (tc.isEntryEnabled()) {
                            Tr.exit(tc, "processSignal");
                        }
                        throw actionErrorException;
                    }
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "processSignal", "return=" + outcome);
        }
        return outcome;
    }

    public void destroy() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "destroy");
        }
        this._resource = null;
        this._sync = null;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "destroy");
        }
    }
}

