/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ActivitySession;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.ActivitySession.SystemException;
import com.ibm.websphere.ActivitySession.TransactionPendingException;
import com.ibm.ws.ActivitySession.ActivityManagerAccess;
import com.ibm.ws.ActivitySession.ActivitySession;
import com.ibm.ws.ActivitySession.ActivitySessionAccess;
import com.ibm.ws.ActivitySession.ActivitySessionImpl;
import com.ibm.ws.ActivitySession.ActivitySessionService;
import com.ibm.ws.ActivitySession.UserActivitySessionImpl;
import com.ibm.ws.ActivitySession.WebSphereActivitySessionManager;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.javax.activity.InvalidActivityException;
import com.ibm.ws.uow.UOWScope;
import java.io.Serializable;
import javax.servlet.http.HttpServletRequest;

public class ActivitySessionManagerImpl
extends UserActivitySessionImpl
implements WebSphereActivitySessionManager,
Serializable {
    private static TraceComponent tc = Tr.register(ActivitySessionManagerImpl.class, "ActivitySession", "com.ibm.ws.ActivitySession.resources.ActivitySessionMessages");
    private static final long serialVersionUID = 6165701376149874880L;

    public ActivitySessionManagerImpl() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "ActivitySessionManagerImpl");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "ActivitySessionManagerImpl", this);
        }
    }

    public ActivitySession suspend() throws SystemException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "suspend");
        }
        ActivitySession activitySession = null;
        try {
            activitySession = ActivitySessionAccess.suspendSession();
        }
        catch (SystemException systemException) {
            if (tc.isEventEnabled()) {
                Tr.event(tc, "suspend", "Unexpected Exception occurred during suspend.");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "suspend", systemException);
            }
            throw systemException;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "suspend", activitySession);
        }
        return activitySession;
    }

    public void resume(ActivitySession activitySession) throws TransactionPendingException, SystemException, InvalidActivityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "resume", activitySession);
        }
        if (!((ActivitySessionImpl)activitySession).isResumeAllowed()) {
            TransactionPendingException transactionPendingException = new TransactionPendingException("Cannot resume an ActivitySession whilst a Global Transaction is active.");
            Tr.error(tc, "ERR_GLOBAL_TRAN_RESUME");
            if (tc.isEventEnabled()) {
                Tr.event(tc, "resume", "Cannot resume an ActivitySession whilst a Global Transaction is active.");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "resume", transactionPendingException);
            }
            throw transactionPendingException;
        }
        try {
            ActivitySessionAccess.resumeSession(activitySession);
        }
        catch (SystemException systemException) {
            if (tc.isEventEnabled()) {
                Tr.event(tc, "Unexpected Exception occurred during resume.");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "resume");
            }
            throw systemException;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "resume");
        }
    }

    public boolean getResetOnly() throws SystemException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getResetOnly");
        }
        boolean bl = false;
        try {
            bl = ActivityManagerAccess.getUserActivity().getCompletionStatus() == 2;
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.ActivitySession.ActivitySessionManagerImpl.getResetOnly", "304", this);
            SystemException systemException = new SystemException(exception);
            Tr.error(tc, "ERR_GET_RESET_ONLY");
            if (tc.isEventEnabled()) {
                Tr.event(tc, "getResetOnly", "Unexpected error occurred whilst retrieving the ResetOnly flag on current ActivitySession.");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getResetOnly", systemException);
            }
            throw systemException;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getResetOnly", new Boolean(bl));
        }
        return bl;
    }

    public ActivitySession getActivitySession() throws SystemException {
        return ActivitySessionAccess.getSession();
    }

    public void setHttpRequest(HttpServletRequest httpServletRequest) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setHttpRequest", httpServletRequest);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "threadHttpRequest object is: " + threadHttpRequest);
        }
        threadHttpRequest.set(httpServletRequest);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setHttpRequest");
        }
    }

    protected void notifyCallbacks(int n, UOWScope uOWScope) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "notifyCallbacks", new Object[]{new Integer(n), uOWScope, this});
        }
        if (n == 1 || n == 2) {
            try {
                ActivitySessionService.notifyCallbacks(n, uOWScope);
            }
            catch (IllegalStateException illegalStateException) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "notifyCallbacks", illegalStateException);
                }
                throw illegalStateException;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "notifyCallbacks");
        }
    }
}

