/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ActivitySession;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.javax.activity.ActivityCoordinator;
import com.ibm.ws.javax.activity.CoordinationInformation;
import com.ibm.ws.javax.activity.Outcome;
import com.ibm.ws.javax.activity.Signal;
import com.ibm.ws.javax.activity.SignalSetActiveException;
import com.ibm.ws.javax.activity.SignalSetInactiveException;
import com.ibm.ws.javax.activity.coordination.SubordinateSignalSet;
import java.io.Serializable;
import java.util.HashSet;
import org.omg.CORBA.COMM_FAILURE;
import org.omg.CORBA.NO_RESPONSE;
import org.omg.CORBA.OBJECT_NOT_EXIST;

public final class ActivitySessionSignalSet
implements SubordinateSignalSet {
    private static TraceComponent tc = Tr.register(ActivitySessionSignalSet.class, "ActivitySession", "com.ibm.ws.ActivitySession.resources.ActivitySessionMessages");
    public static final String SIGNALSET_NAME = "com.ibm.ws.ActivitySession.ActivitySessionSignalSet";
    public static final String CHECKPOINT_SIGNAL = "com.ibm.ws.ActivitySession.CheckpointSignal";
    public static final String RESET_SIGNAL = "com.ibm.ws.ActivitySession.ResetSignal";
    public static final String CHECKPOINT_OUTCOME = "com.ibm.ws.ActivitySession.CheckpointOutcome";
    public static final String RESET_OUTCOME = "com.ibm.ws.ActivitySession.ResetOutcome";
    public static final String FAILURE_OUTCOME = "com.ibm.ws.ActivitySession.FailureOutcome";
    public static final String ACTION_ERROR = "ACTIONERROR";
    private int _completionStatus = 0;
    private int _status = 3;
    private int _actionCount = 0;
    private int _signalCount = 0;
    private boolean _hasBeenUsed = false;
    private boolean _checkpointed = false;
    private boolean _isBroadcast = false;
    private boolean _actionError = false;
    private boolean _checkpointOutcomeReceived = false;
    private boolean _resetOutcomeReceived = false;
    private HashSet _messages = new HashSet();

    public String getSignalSetName() {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getSignalSetName", "return=com.ibm.ws.ActivitySession.ActivitySessionSignalSet");
        }
        return SIGNALSET_NAME;
    }

    public Signal getSignal() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getSignal", "Status=" + this._status + ", CompletionStatus=" + this._completionStatus);
        }
        Signal signal = null;
        switch (this._status) {
            case 1: {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "StatusCompleting - set status completed and isBroadcast to false");
                }
                this._status = 2;
                this._isBroadcast = false;
            }
            case 0: {
                if (this._isBroadcast) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "set isBroadcast to false");
                    }
                    this._isBroadcast = false;
                    break;
                }
                switch (this._completionStatus) {
                    case 1: 
                    case 2: {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "create RESET signal; set checkpointed false and isBroadcast true");
                        }
                        signal = new Signal(RESET_SIGNAL, SIGNALSET_NAME, new Integer(this._status));
                        this._checkpointed = false;
                        this._isBroadcast = true;
                        this._resetOutcomeReceived = false;
                        this._checkpointOutcomeReceived = false;
                        break;
                    }
                    case 0: {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "create CHECKPOINT signal; set checkpointed true and isBroadcast true");
                        }
                        signal = new Signal(CHECKPOINT_SIGNAL, SIGNALSET_NAME, new Integer(this._status));
                        this._checkpointed = true;
                        this._isBroadcast = true;
                        this._resetOutcomeReceived = false;
                        this._checkpointOutcomeReceived = false;
                    }
                }
                break;
            }
        }
        this._hasBeenUsed = true;
        this._actionCount = 0;
        ++this._signalCount;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getSignal", "return=" + signal);
        }
        return signal;
    }

    public void setSignal(Signal signal) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setSignal", "Signal=" + signal);
        }
        this._resetOutcomeReceived = false;
        this._checkpointOutcomeReceived = false;
        if (signal.getName().equals(CHECKPOINT_SIGNAL)) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "set completion status success & checkpointed true");
            }
            this._completionStatus = 0;
            this._checkpointed = true;
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "set completion status fail & checkpointed false");
            }
            this._completionStatus = 1;
            this._checkpointed = false;
        }
        this._status = 0;
        this._isBroadcast = true;
        this._hasBeenUsed = true;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setSignal");
        }
    }

    public CoordinationInformation setResponse(Outcome outcome) throws SignalSetInactiveException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setResponse", "Response=" + outcome);
        }
        ++this._actionCount;
        String string = "Signal " + this._signalCount + ", Action " + this._actionCount + ": ";
        String string2 = outcome.getName();
        if (FAILURE_OUTCOME.equals(string2)) {
            String[] stringArray;
            block28: {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Outcome is FAILURE");
                }
                stringArray = null;
                try {
                    stringArray = (String[])outcome.getExtendedValue();
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, "com.ibm.ws.ActivitySession.ActivitySessionSignalSet.setResponse", "248", this);
                    Tr.error(tc, "ERR_RESPONSE_OUTCOME");
                    if (!tc.isEventEnabled()) break block28;
                    Tr.event(tc, "setResponse", "Unexpected error occurred whilst retrieving extended outcome from response.");
                }
            }
            if (stringArray != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "number of messages to process: " + stringArray.length);
                }
                for (int i = 0; i < stringArray.length; ++i) {
                    this._messages.add(string + stringArray[i]);
                }
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "No messages to process");
                }
                this._messages.add(string + "Action failed to process Signal.");
            }
        } else if ("org.omg.CosActivity.ActionSystemException".equals(string2)) {
            Serializable serializable = outcome.getExtendedValue();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "ActionSystemException outcome; contained exception is: " + serializable);
            }
            if (serializable instanceof COMM_FAILURE || serializable instanceof NO_RESPONSE) {
                this._messages.add(string + "Action failed to process Signal.");
            } else if (serializable instanceof OBJECT_NOT_EXIST) {
                this._resetOutcomeReceived = true;
            }
        } else if ("org.omg.CosActivity.ActionError".equals(string2)) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "ActionError outcome");
            }
            if (!this._actionError) {
                this._messages.add(ACTION_ERROR);
            }
            this._actionError = true;
        } else if (CHECKPOINT_OUTCOME.equals(string2)) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Outcome is CHECKPOINT");
            }
            this._checkpointOutcomeReceived = true;
        } else if (RESET_OUTCOME.equals(string2)) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Outcome is RESET");
            }
            this._resetOutcomeReceived = true;
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Unexpected outcome: " + string2 + " received - treat as FAILURE");
            }
            this._messages.add(string + "Action failed to process Signal.");
        }
        return new CoordinationInformation(true, false);
    }

    public Outcome getCurrentOutcome() {
        Outcome outcome = this.calculateOutcome();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getCurrentOutcome", "return=" + outcome);
        }
        return outcome;
    }

    public Outcome getOutcome() throws SignalSetActiveException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getOutcome");
        }
        if (!this._hasBeenUsed) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "SignalSet hasn't been used");
            }
            if (this._completionStatus == 0) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "set checkpointed to true");
                }
                this._checkpointed = true;
            }
            if (this._status == 1) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "set status to completed");
                }
                this._status = 2;
            }
        }
        Outcome outcome = this.calculateOutcome();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getOutcome", outcome);
        }
        return outcome;
    }

    private Outcome calculateOutcome() {
        Outcome outcome;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "calculateOutcome");
        }
        if (this._messages.isEmpty()) {
            if (this._checkpointed) {
                if (this._resetOutcomeReceived) {
                    if (this._checkpointOutcomeReceived) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Mixed outcome - create FAILURE outcome");
                        }
                        outcome = new Outcome(FAILURE_OUTCOME, this._messages);
                    } else {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "create RESET outcome");
                        }
                        outcome = new Outcome(RESET_OUTCOME, (Serializable)((Object)""));
                    }
                } else {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "create CHECKPOINT outcome");
                    }
                    outcome = new Outcome(CHECKPOINT_OUTCOME, (Serializable)((Object)""));
                }
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "create RESET outcome");
                }
                outcome = new Outcome(RESET_OUTCOME, (Serializable)((Object)""));
            }
        } else if (this._checkpointOutcomeReceived) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Mixed outcome - create FAILURE outcome");
            }
            outcome = new Outcome(FAILURE_OUTCOME, this._messages);
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "All resources failure - create RESET outcome");
            }
            outcome = new Outcome(RESET_OUTCOME, (Serializable)((Object)""));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "calculateOutcome", outcome);
        }
        return outcome;
    }

    public void setCompletionStatus(int n, int n2) {
        if (tc.isEntryEnabled()) {
            StringBuffer stringBuffer = new StringBuffer("completionStatus=");
            switch (n) {
                case 1: {
                    stringBuffer.append("CompletionStatusFail, status=");
                    break;
                }
                case 2: {
                    stringBuffer.append("CompletionStatusFailOnly, status=");
                    break;
                }
                case 0: {
                    stringBuffer.append("CompletionStatusSuccess, status=");
                }
            }
            switch (n2) {
                case 0: {
                    stringBuffer.append("StatusActive");
                    break;
                }
                case 2: {
                    stringBuffer.append("StatusCompleted");
                    break;
                }
                case 1: {
                    stringBuffer.append("StatusCompleting");
                    break;
                }
                case 3: {
                    stringBuffer.append("StatusNoActivity");
                    break;
                }
                case 4: {
                    stringBuffer.append("StatusUnknown");
                }
            }
            Tr.entry(tc, "setCompletionStatus", stringBuffer.toString());
        }
        if (this._status == 2 || this._status == 1) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Status' not updated as current status is Completing or Completed.");
            }
        } else {
            if (this._completionStatus != 2) {
                this._completionStatus = n;
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "CompletionStatus not set as current value is CompletionStatusFailOnly.");
            }
            this._status = n2;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setCompletionStatus");
        }
    }

    public int getCompletionStatus() throws SignalSetActiveException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCompletionStatus");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCompletionStatus", "return: " + this._completionStatus);
        }
        return this._completionStatus;
    }

    public void destroy() {
    }

    public void setActivityCoordinator(ActivityCoordinator activityCoordinator) throws SignalSetActiveException {
    }
}

