/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ActivitySession;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.ActivitySession.ActivitySessionAlreadyActiveException;
import com.ibm.websphere.ActivitySession.ActivitySessionPendingException;
import com.ibm.websphere.ActivitySession.ActivitySessionResetException;
import com.ibm.websphere.ActivitySession.ContextPendingException;
import com.ibm.websphere.ActivitySession.MixedOutcomeException;
import com.ibm.websphere.ActivitySession.NoActivitySessionException;
import com.ibm.websphere.ActivitySession.NotProcessedException;
import com.ibm.websphere.ActivitySession.NotSupportedException;
import com.ibm.websphere.ActivitySession.SystemException;
import com.ibm.websphere.ActivitySession.TimeoutOutOfRangeException;
import com.ibm.websphere.ActivitySession.TransactionPendingException;
import com.ibm.ws.ActivitySession.ActivityManagerAccess;
import com.ibm.ws.ActivitySession.ActivitySession;
import com.ibm.ws.ActivitySession.ActivitySessionAccess;
import com.ibm.ws.ActivitySession.ActivitySessionImpl;
import com.ibm.ws.ActivitySession.ActivitySessionService;
import com.ibm.ws.ActivitySession.WebSphereUserActivitySession;
import com.ibm.ws.activity.WebSphereUserActivity;
import com.ibm.ws.exception.RuntimeWarning;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.javax.activity.ActivityPendingException;
import com.ibm.ws.javax.activity.GlobalId;
import com.ibm.ws.javax.activity.NoActivityException;
import com.ibm.ws.javax.activity.NotOriginatorException;
import com.ibm.ws.javax.activity.Outcome;
import com.ibm.ws.uow.UOWScope;
import com.ibm.ws.uow.UOWScopeCallback;
import com.ibm.ws.uow.UOWScopeCallbackManager;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Hashtable;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.transaction.Synchronization;

public class UserActivitySessionImpl
implements WebSphereUserActivitySession {
    private static TraceComponent tc = Tr.register(UserActivitySessionImpl.class, "ActivitySession", "com.ibm.ws.ActivitySession.resources.ActivitySessionMessages");
    protected static ThreadLocal threadHttpRequest = null;
    private WebSphereUserActivity _activity;
    private static Hashtable _syncTable = null;
    protected static UOWScopeCallbackManager _userCallbackManager = new UOWScopeCallbackManager();

    public UserActivitySessionImpl() {
        block9: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "UserActivitySessionImpl");
            }
            if (!ActivitySessionService.isEnabled()) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "UserActivitySessionImpl", "UnsupportedOperationException");
                }
                throw new UnsupportedOperationException();
            }
            try {
                this._activity = ActivityManagerAccess.getUserActivity();
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.ActivitySession.UserActivitySessionImpl.UserActivitySessionImpl", "79", this);
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "Exception in UserActivitySessionImpl ctor: " + exception.toString());
                }
                if (!tc.isEntryEnabled()) break block9;
                Tr.exit(tc, "UserActivitySessionImpl");
            }
        }
        if (threadHttpRequest == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "create single ThreadLocal first time through");
            }
            threadHttpRequest = new ThreadLocal();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "UserActivitySessionImpl", this);
        }
    }

    public void beginSession() throws ActivitySessionAlreadyActiveException, TransactionPendingException, NotSupportedException, SystemException {
        this.beginSession(null);
    }

    protected void beginSession(HttpSession httpSession) throws ActivitySessionAlreadyActiveException, TransactionPendingException, NotSupportedException, SystemException {
        Object object;
        block27: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "beginSession", httpSession);
            }
            if (ActivitySessionAccess.globalTranExists()) {
                TransactionPendingException transactionPendingException = new TransactionPendingException();
                Tr.error(tc, "ERR_GLOBAL_TRAN_BEGIN");
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "beginSession", "Cannot begin an ActivitySession whilst a Global Transaction is active.");
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "beginSession", transactionPendingException);
                }
                throw transactionPendingException;
            }
            if (ActivitySessionAccess.sessionExists()) {
                ActivitySessionAlreadyActiveException activitySessionAlreadyActiveException = new ActivitySessionAlreadyActiveException();
                Tr.error(tc, "ERR_SESSION_ALREADY_ACTIVE");
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "beginSession", "Cannot begin new ActivitySession when one already exists on current thread.");
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "beginSession", activitySessionAlreadyActiveException);
                }
                throw activitySessionAlreadyActiveException;
            }
            try {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "inform registered callbacks before beginning session");
                }
                this.notifyCallbacks(0, null);
                ActivitySessionAccess.beginSession();
                if (!ActivityManagerAccess.isServerProcess()) break block27;
                try {
                    if (httpSession == null && (object = (HttpServletRequest)threadHttpRequest.get()) != null) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "HttpRequest is active on thread - get HttpSession from HttpRequest");
                        }
                        httpSession = object.getSession(false);
                    }
                    if (httpSession != null) {
                        this.setInHttpSession(httpSession);
                    }
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, "com.ibm.ws.ActivitySession.UserActivitySessionImpl.beginSession", "253", this);
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "beginSession", "SystemException");
                    }
                    throw new SystemException();
                }
            }
            catch (IllegalStateException illegalStateException) {
                FFDCFilter.processException((Throwable)illegalStateException, "com.ibm.ws.ActivitySession.UserActivitySessionImpl.beginSession", "188", this);
                NotSupportedException notSupportedException = new NotSupportedException();
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "beginSession", "Exception caught in PRE_BEGIN. ActivitySession begin aborted.");
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "beginSession", notSupportedException);
                }
                throw notSupportedException;
            }
        }
        try {
            object = (ActivitySessionImpl)this._activity.getPG("ActivitySession");
            this.notifyCallbacks(1, (UOWScope)object);
        }
        catch (IllegalStateException illegalStateException) {
            FFDCFilter.processException((Throwable)illegalStateException, "com.ibm.ws.ActivitySession.UserActivitySessionImpl.beginSession", "212", this);
            try {
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "Exception from post_begin callback; set ActivitySession to resetOnly");
                }
                this.setResetOnly();
            }
            catch (NoActivitySessionException noActivitySessionException) {
                FFDCFilter.processException((Throwable)noActivitySessionException, "com.ibm.ws.ActivitySession.UserActivitySessionImpl.beginSession", "220", this);
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "beginSession", "NoActivitySessionException caught setting ResetOnly.");
                }
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.ActivitySession.UserActivitySessionImpl.beginSession", "306", this);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "beginSession", "SystemException");
            }
            throw new SystemException(exception);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "beginSession");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endSession(int n) throws ActivitySessionPendingException, ContextPendingException, NoActivitySessionException, com.ibm.websphere.ActivitySession.NotOriginatorException, MixedOutcomeException, ActivitySessionResetException, NotSupportedException, SystemException {
        Serializable serializable;
        Object object;
        if (tc.isEntryEnabled()) {
            String string = "";
            if (n == 0) {
                string = "EndMode=CheckPoint";
            } else if (n == 1) {
                string = "EndMode=Reset";
            }
            Tr.entry(tc, "endSession", string);
        }
        boolean bl = false;
        if (!ActivitySessionAccess.sessionExists() || this._activity == null) {
            NoActivitySessionException noActivitySessionException = new NoActivitySessionException("No ActivitySession associated with current thread.");
            Tr.error(tc, "ERR_NO_SESSION");
            if (tc.isEventEnabled()) {
                Tr.event(tc, "endSession", "No ActivitySession associated with current thread.");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "endSession");
            }
            throw noActivitySessionException;
        }
        Outcome outcome = null;
        ActivitySessionImpl activitySessionImpl = null;
        ActivitySessionImpl activitySessionImpl2 = null;
        boolean bl2 = false;
        HttpSession httpSession = null;
        GlobalId globalId = null;
        if (ActivityManagerAccess.isServerProcess()) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Check for association with HttpSession");
            }
            activitySessionImpl = ActivitySessionAccess.getSession();
            object = (HttpServletRequest)threadHttpRequest.get();
            if (object != null && (httpSession = object.getSession(false)) != null) {
                try {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "HttpSession object retrieved - lookup ActivitySession token");
                    }
                    if ((activitySessionImpl2 = (ActivitySessionImpl)httpSession.getAttribute("WebSphereActivitySession")) != null && activitySessionImpl2.equals(activitySessionImpl)) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Ending Session found in HttpSession - remember to remove later");
                        }
                        bl2 = true;
                    }
                }
                catch (IllegalStateException illegalStateException) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "IllegalStateException from HttpSession access - must have just timed out");
                    }
                }
            }
        } else if (_syncTable != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "In client - get gid from Activity service for sync processing");
            }
            try {
                globalId = this._activity.getGlobalId();
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.ActivitySession.UserActivitySessionImpl.endSession", "355", this);
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "endSession", "Unexpected Exception getting id of completing Activity.");
                }
                SystemException systemException = new SystemException(exception);
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "endSession", systemException);
                }
                throw systemException;
            }
        }
        object = null;
        try {
            object = (ActivitySessionImpl)this._activity.getPG("ActivitySession");
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.ActivitySession.UserActivitySessionImpl.endSession", "463", this);
            if (tc.isEventEnabled()) {
                Tr.event(tc, "Exception caught getting ActivitySession property group");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "endSession", "SystemException");
            }
            throw new SystemException(exception);
        }
        if (object != null) {
            try {
                this.notifyCallbacks(2, (UOWScope)object);
            }
            catch (IllegalStateException illegalStateException) {
                FFDCFilter.processException((Throwable)illegalStateException, "com.ibm.ws.ActivitySession.UserActivitySessionImpl.endSession", "375", this);
                try {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Callback threw IllegalStateException on PRE_END. Mark ActivitySession ResetOnly.");
                    }
                    this.setResetOnly();
                }
                catch (NoActivitySessionException noActivitySessionException) {
                    FFDCFilter.processException((Throwable)noActivitySessionException, "com.ibm.ws.ActivitySession.UserActivitySessionImpl.endSession", "383", this);
                    if (tc.isEventEnabled()) {
                        Tr.event(tc, "endSession", "NoActivitySessionException caught setting ResetOnly.");
                    }
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "endSession", noActivitySessionException);
                    }
                    throw noActivitySessionException;
                }
            }
        }
        try {
            block84: {
                if (this._activity.getCompletionStatus() == 2) {
                    bl = true;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Reseting all resources due to setResetOnly() being called.");
                    }
                    if (object != null) {
                        ((ActivitySessionImpl)object).beforeCompletion(1);
                    }
                    outcome = this._activity.complete();
                } else {
                    if (object != null) {
                        ((ActivitySessionImpl)object).beforeCompletion(n);
                    }
                    outcome = this._activity.completeWithStatus(n);
                }
                if (!ActivityManagerAccess.isServerProcess() && globalId != null) {
                    try {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Looking for sync object for activity id: " + globalId.print());
                        }
                        if ((serializable = (Synchronization)_syncTable.remove(globalId)) != null) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "call afterCompletion on sync object");
                            }
                            serializable.afterCompletion(0);
                        }
                    }
                    catch (Exception exception) {
                        FFDCFilter.processException((Throwable)exception, "com.ibm.ws.ActivitySession.UserActivitySessionImpl.endSession", "378", this);
                        if (!tc.isEventEnabled()) break block84;
                        Tr.event(tc, "endSession", "Exception caught from sync processing: " + exception);
                    }
                }
            }
            try {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "inform callbacks of POST_END");
                }
                this.notifyCallbacks(3, null);
            }
            catch (IllegalStateException illegalStateException) {
                FFDCFilter.processException((Throwable)illegalStateException, "com.ibm.ws.ActivitySession.UserActivitySessionImpl.endSession", "438", this);
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "endSession", "Exception caught in POST_END");
                }
            }
        }
        catch (ActivityPendingException activityPendingException) {
            FFDCFilter.processException((Throwable)activityPendingException, "com.ibm.ws.ActivitySession.UserActivitySessionImpl.endSession", "240", this);
            ActivitySessionPendingException activitySessionPendingException = new ActivitySessionPendingException();
            if (tc.isEventEnabled()) {
                Tr.event(tc, "endSession", "Unexpected Exception during completion of ActivitySession.");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "endSession");
            }
            throw activitySessionPendingException;
        }
        catch (com.ibm.ws.javax.activity.ContextPendingException contextPendingException) {
            FFDCFilter.processException((Throwable)contextPendingException, "com.ibm.ws.ActivitySession.UserActivitySessionImpl.endSession", "245", this);
            ContextPendingException contextPendingException2 = new ContextPendingException();
            if (tc.isEventEnabled()) {
                Tr.event(tc, "endSession", "Unexpected Exception during completion of ActivitySession.");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "endSession");
            }
            throw contextPendingException2;
        }
        catch (NotOriginatorException notOriginatorException) {
            FFDCFilter.processException((Throwable)notOriginatorException, "com.ibm.ws.ActivitySession.UserActivitySessionImpl.endSession", "250", this);
            com.ibm.websphere.ActivitySession.NotOriginatorException notOriginatorException2 = new com.ibm.websphere.ActivitySession.NotOriginatorException();
            if (tc.isEventEnabled()) {
                Tr.event(tc, "endSession", "Unexpected Exception during completion of ActivitySession.");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "endSession");
            }
            throw notOriginatorException2;
        }
        catch (NoActivityException noActivityException) {
            FFDCFilter.processException((Throwable)noActivityException, "com.ibm.ws.ActivitySession.UserActivitySessionImpl.endSession", "255", this);
            this.endSessionCleanup(globalId);
            if (n == 0) {
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "endSession", "ActivitySession has timed out.");
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "endSession");
                }
                throw new ActivitySessionResetException("ActivitySession was reset during timeout");
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.ActivitySession.UserActivitySessionImpl.endSession", "459", this);
            this.endSessionCleanup(globalId);
            Tr.error(tc, "ERR_END_UNEXPECTED");
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "endSession", "SystemException");
            }
            throw new SystemException(exception);
        }
        if (outcome != null) {
            if (outcome.getName().equals("com.ibm.ws.ActivitySession.FailureOutcome")) {
                serializable = (HashSet)outcome.getExtendedValue();
                Exception[] exceptionArray = null;
                if (((HashSet)serializable).contains("ACTIONERROR")) {
                    exceptionArray = new Exception[2];
                    exceptionArray[1] = new SystemException("Unexpected error occurred whilst ending ActivitySession.");
                    ((HashSet)serializable).remove("ACTIONERROR");
                } else {
                    exceptionArray = new Exception[]{new NotProcessedException("Some Resources failed to complete during ActivitySession completion.", ((HashSet)serializable).toArray(new String[0]))};
                }
                MixedOutcomeException mixedOutcomeException = new MixedOutcomeException("Mixed outcomes were achieved by Resources during ActivitySession completion.", exceptionArray);
                Tr.error(tc, "ERR_MIXED_OUTCOME");
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "Mixed outcomes were achieved by Resources during ActivitySession completion.");
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "endSession", mixedOutcomeException);
                }
                throw mixedOutcomeException;
            }
            if (outcome.getName().equals("com.ibm.ws.ActivitySession.ResetOutcome")) {
                bl = true;
            }
        }
        if (bl2 && httpSession != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "remove token for ending session from HttpSession");
            }
            serializable = httpSession;
            synchronized (serializable) {
                httpSession.removeAttribute("WebSphereActivitySession");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Web Collaborator status set to ENDED");
                }
                activitySessionImpl2.setWebCollaboratorStatus(2);
                httpSession.notifyAll();
            }
        }
        if (bl && n == 0) {
            Tr.info(tc, "INF_RESET_ONLY");
            if (tc.isEventEnabled()) {
                Tr.event(tc, "ActivitySession was reset due to setResetOnly() being called.");
            }
            serializable = new ActivitySessionResetException("ActivitySession was reset due to setResetOnly() being called.");
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "endSession", serializable);
            }
            throw serializable;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "endSession");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void resetSession() throws ActivitySessionPendingException, NoActivitySessionException, com.ibm.websphere.ActivitySession.NotOriginatorException, NotSupportedException, SystemException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "resetSession");
        }
        if (ActivitySessionAccess.sessionExists() && this._activity != null) {
            try {
                boolean bl;
                block15: {
                    int n = this._activity.getCompletionStatus();
                    bl = false;
                    if (n == 0) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "set completion status of underlying activity to Fail");
                        }
                        this._activity.setCompletionStatus(1);
                        bl = true;
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "broadcast the reset to resources");
                    }
                    try {
                        this._activity.broadcast("com.ibm.ws.ActivitySession.ActivitySessionSignalSet");
                    }
                    catch (NoActivityException noActivityException) {
                        FFDCFilter.processException((Throwable)noActivityException, "com.ibm.ws.ActivitySession.UserActivitySessionImpl.resetSession", "430", this);
                        if (!tc.isEventEnabled()) break block15;
                        Tr.event(tc, "resetSession", "ActivitySession timed out and reset - swallow exception");
                    }
                }
                bl = true;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Restore previous completion status of success");
                }
                this._activity.setCompletionStatus(0);
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.ActivitySession.UserActivitySessionImpl.resetSession", "438", this);
                SystemException systemException = new SystemException("Unexpected error occurred whilst reseting ActivitySession.", exception);
                Tr.error(tc, "ERR_RESET_UNEXPECTED");
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "resetSession", "Unexpected error occurred whilst reseting ActivitySession.");
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "resetSession");
                }
                throw systemException;
            }
        }
        NoActivitySessionException noActivitySessionException = new NoActivitySessionException("No ActivitySession associated with current thread.");
        Tr.error(tc, "ERR_NO_SESSION");
        if (tc.isEventEnabled()) {
            Tr.event(tc, "resetSession", "No ActivitySession associated with current thread.");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "resetSession");
        }
        throw noActivitySessionException;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "resetSession");
        }
    }

    public void checkpointSession() throws ActivitySessionPendingException, NoActivitySessionException, com.ibm.websphere.ActivitySession.NotOriginatorException, MixedOutcomeException, ActivitySessionResetException, NotSupportedException, SystemException {
        Object object;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkpointSession");
        }
        boolean bl = false;
        if (ActivitySessionAccess.sessionExists() && this._activity != null) {
            object = null;
            boolean bl2 = false;
            try {
                if (this._activity.getCompletionStatus() == 2) {
                    bl = true;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Reseting all resources due to setResetOnly() being called.");
                    }
                } else {
                    this._activity.setCompletionStatus(0);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Broadcast ActivitySessionSignalSet to all actions");
                }
                try {
                    object = this._activity.broadcast("com.ibm.ws.ActivitySession.ActivitySessionSignalSet");
                }
                catch (NoActivityException noActivityException) {
                    FFDCFilter.processException((Throwable)noActivityException, "com.ibm.ws.ActivitySession.UserActivitySessionImpl.checkpointSession", "520", this);
                    bl2 = true;
                    if (tc.isEventEnabled()) {
                        Tr.event(tc, "Caught NoActivityException from broadcast - rethrowing as ActivitySessionResetException");
                    }
                    throw new ActivitySessionResetException("ActivitySession reset due to timeout");
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.ActivitySession.UserActivitySessionImpl.checkpointSession", "527", this);
                if (bl2) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "checkpointSession");
                    }
                    throw (ActivitySessionResetException)exception;
                }
                SystemException systemException = new SystemException("Unexpected error occurred whilst checkpointing ActivitySession.", exception);
                Tr.error(tc, "ERR_CHECKPOINT_UNEXPECTED");
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "checkpointSession", "Unexpected error occurred whilst checkpointing ActivitySession.");
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "checkpointSession");
                }
                throw systemException;
            }
            if (object != null) {
                if (((Outcome)object).getName().equals("com.ibm.ws.ActivitySession.FailureOutcome")) {
                    HashSet hashSet = (HashSet)((Outcome)object).getExtendedValue();
                    Exception[] exceptionArray = null;
                    if (hashSet.contains("ACTIONERROR")) {
                        exceptionArray = new Exception[2];
                        exceptionArray[1] = new SystemException("Unexpected error occurred whilst ending ActivitySession.");
                        hashSet.remove("ACTIONERROR");
                    } else {
                        exceptionArray = new Exception[]{new NotProcessedException("Some Resources failed to complete during ActivitySession completion.", (String[])hashSet.toArray())};
                    }
                    MixedOutcomeException mixedOutcomeException = new MixedOutcomeException("Mixed outcomes were achieved by Resources during ActivitySession completion.", exceptionArray);
                    Tr.error(tc, "ERR_MIXED_OUTCOME");
                    if (tc.isEventEnabled()) {
                        Tr.event(tc, "Mixed outcomes were achieved by Resources during ActivitySession completion.");
                    }
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "checkpointSession");
                    }
                    throw mixedOutcomeException;
                }
                if (((Outcome)object).getName().equals("com.ibm.ws.ActivitySession.ResetOutcome")) {
                    bl = true;
                }
            }
        } else {
            NoActivitySessionException noActivitySessionException = new NoActivitySessionException("No ActivitySession associated with current thread.");
            Tr.error(tc, "ERR_NO_SESSION");
            if (tc.isEventEnabled()) {
                Tr.event(tc, "No ActivitySession associated with current thread.");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "checkpointSession");
            }
            throw noActivitySessionException;
        }
        if (bl) {
            object = new ActivitySessionResetException("ActivitySession was reset due to setResetOnly() being called.");
            Tr.info(tc, "INF_RESET_ONLY");
            if (tc.isEventEnabled()) {
                Tr.event(tc, "ActivitySession was reset due to setResetOnly() being called.");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "checkpointSession");
            }
            throw object;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "checkpointSession");
        }
    }

    public int getStatus() throws SystemException {
        int n;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getStatus");
        }
        if (ActivitySessionAccess.sessionExists() && this._activity != null) {
            try {
                n = this._activity.getStatus();
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.ActivitySession.UserActivitySessionImpl.getStatus", "631", this);
                SystemException systemException = new SystemException("Unexpected error occurred whilst accessing status of current ActivitySession.", exception);
                Tr.error(tc, "ERR_SESSION_STATUS");
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "Unexpected error occurred whilst accessing status of current ActivitySession.");
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getStatus");
                }
                throw systemException;
            }
        } else {
            n = 3;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getStatus", "return=" + n);
        }
        return n;
    }

    public String getSessionName() throws SystemException {
        String string;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getSessionName");
        }
        if (ActivitySessionAccess.sessionExists() && this._activity != null) {
            try {
                string = this._activity.getName();
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.ActivitySession.UserActivitySessionImpl.getSessionName", "674", this);
                SystemException systemException = new SystemException("Unexpected error occurred whilst accessing the name of current ActivitySession.", exception);
                Tr.error(tc, "ERR_SESSION_NAME");
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "Unexpected error occurred whilst accessing the name of current ActivitySession.");
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getSessionName");
                }
                throw systemException;
            }
        } else {
            string = "";
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getSessionName", "return=" + string);
        }
        return string;
    }

    public void setResetOnly() throws NoActivitySessionException, SystemException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setResetOnly");
        }
        if (ActivitySessionAccess.sessionExists() && this._activity != null) {
            try {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "call setCompletionStatus on UserActivity");
                }
                this._activity.setCompletionStatus(2);
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.ActivitySession.UserActivitySessionImpl.setResetOnly", "716", this);
                SystemException systemException = new SystemException("Unexpected error occurred whilst setting ResetOnly flag.", exception);
                Tr.error(tc, "ERR_RESETONLY");
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "Unexpected error occurred whilst setting ResetOnly flag.");
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "setResetOnly");
                }
                throw systemException;
            }
        } else {
            NoActivitySessionException noActivitySessionException = new NoActivitySessionException("No ActivitySession currently acive on current thread.");
            Tr.error(tc, "ERR_NO_SESSION");
            if (tc.isEventEnabled()) {
                Tr.event(tc, "No ActivitySession currently acive on current thread.");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "setResetOnly");
            }
            throw noActivitySessionException;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setResetOnly");
        }
    }

    public void setSessionTimeout(int n) throws TimeoutOutOfRangeException, SystemException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setSessionTimeout", "Timeout=" + n);
        }
        if (n < -1 || n > 1000000000) {
            TimeoutOutOfRangeException timeoutOutOfRangeException = new TimeoutOutOfRangeException("Timeout value is not within defined range.");
            Tr.error(tc, "ERR_TIMEOUT_OUT_OF_RANGE");
            if (tc.isEventEnabled()) {
                Tr.event(tc, "setSessionTimeout", "Timeout value is not within defined range.");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "setSessionTimeout");
            }
            throw timeoutOutOfRangeException;
        }
        ActivitySessionAccess.setDefaultTimeout(n);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setSessionTimeout");
        }
    }

    public int getSessionTimeout() throws SystemException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getSessionTimeout");
        }
        int n = ActivitySessionAccess.getDefaultTimeout();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getSessionTimeout", "Timeout=" + n);
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setInHttpSession(HttpSession httpSession) throws ContextPendingException, SystemException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setInHttpSession", httpSession);
        }
        ActivitySessionImpl activitySessionImpl = null;
        try {
            activitySessionImpl = ActivitySessionAccess.getSession();
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.ActivitySession.UserActivitySessionImpl.setInHttpSession", "877", this);
            Object[] objectArray = new Object[]{"setInHttpSession", "com.ibm.ws.ActivitySession.UserActivitySessionImpl", throwable};
            Tr.error(tc, "ERR_INT_ERROR", objectArray);
            if (tc.isEventEnabled()) {
                Tr.event(tc, "Unexpected exception caught from getSession", throwable);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "setInHttpSession", "SystemException");
            }
            throw new SystemException();
        }
        if (activitySessionImpl == null) {
            if (tc.isEventEnabled()) {
                Tr.event(tc, "No activitySession on current thread, throwing SystemException");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "setInHttpSession", "SystemException");
            }
            throw new SystemException();
        }
        HttpSession httpSession2 = httpSession;
        synchronized (httpSession2) {
            ActivitySession activitySession = (ActivitySession)httpSession.getAttribute("WebSphereActivitySession");
            if (activitySession != null && !activitySession.equals(activitySessionImpl)) {
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "Another ActivitySession is pending for this HttpSession");
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "setInHttpSession", "ContextPendingException");
                }
                throw new ContextPendingException();
            }
            if (activitySession == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Setting status to PREINVOKE");
                }
                activitySessionImpl.setWebCollaboratorStatus(0);
                httpSession.setAttribute("WebSphereActivitySession", (Object)activitySessionImpl);
                activitySessionImpl.setHttpSession(httpSession);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setInHttpSession", "Activity Session token=" + activitySessionImpl);
        }
    }

    public void enlistSynchronization(Synchronization synchronization) throws IllegalStateException, SystemException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "enlistSynchronization", "Synchronization=" + synchronization);
        }
        if (ActivityManagerAccess.isServerProcess()) {
            ActivitySessionImpl activitySessionImpl = ActivitySessionAccess.getSession();
            if (activitySessionImpl == null) {
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "enlistSynchronization", "Throwing IllegalStateException as current ActivitySession is null");
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "enlistSynchronization");
                }
                throw new IllegalStateException();
            }
            activitySessionImpl.enlistSynchronization(synchronization);
        } else {
            GlobalId globalId = null;
            try {
                if (this._activity != null) {
                    globalId = this._activity.getGlobalId();
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.ActivitySession.UserActivitySessionImpl.enlistSynchronization", "1469", this);
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "enlistSynchronization", "Unexpected Exception occurred whilst retrieving id of current Activity.");
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "enlistSynchronization");
                }
                throw new SystemException();
            }
            if (globalId == null) {
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "enlistSynchronization", "Throwing IllegalStateException as current activity GlobalId is null");
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "enlistSynchronization");
                }
                throw new IllegalStateException();
            }
            if (_syncTable == null) {
                _syncTable = new Hashtable();
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "enlistSynchronization", "Adding sync for activity id: " + globalId.print());
            }
            _syncTable.put(globalId, synchronization);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "enlistSynchronization");
        }
    }

    public void serviceRequired(Object object) throws RuntimeWarning {
        if (!ActivitySessionService.isEnabled()) {
            Tr.error(tc, "ERR_ASSERVICE_REQUIRED", object);
            throw new RuntimeWarning("activitySessionControl value invalid when ActivitySessionService not enabled");
        }
    }

    public void registerCallback(UOWScopeCallback uOWScopeCallback) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "registerCallback", new Object[]{uOWScopeCallback, this});
        }
        _userCallbackManager.addCallback(uOWScopeCallback);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "registerCallback");
        }
    }

    protected void notifyCallbacks(int n, UOWScope uOWScope) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "notifyCallbacks", new Object[]{new Integer(n), uOWScope, this});
        }
        IllegalStateException illegalStateException = null;
        try {
            _userCallbackManager.notifyCallbacks(n, uOWScope);
        }
        catch (IllegalStateException illegalStateException2) {
            FFDCFilter.processException((Throwable)illegalStateException2, "com.ibm.ws.ActivitySession.UserActivitySessionImpl.notifyCallbacks", "1324", this);
            illegalStateException = illegalStateException2;
        }
        if (n == 1 || n == 2) {
            try {
                ActivitySessionService.notifyCallbacks(n, uOWScope);
            }
            catch (IllegalStateException illegalStateException3) {
                FFDCFilter.processException((Throwable)illegalStateException3, "com.ibm.ws.ActivitySession.UserActivitySessionImpl.notifyCallbacks", "1337", this);
                illegalStateException = illegalStateException3;
            }
        }
        if (illegalStateException != null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "notifyCallbacks", illegalStateException);
            }
            throw illegalStateException;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "notifyCallbacks");
        }
    }

    private void endSessionCleanup(GlobalId globalId) {
        block8: {
            block7: {
                if (!ActivityManagerAccess.isServerProcess() && globalId != null) {
                    try {
                        Synchronization synchronization;
                        if (tc.isEventEnabled()) {
                            Tr.event(tc, "endSession", "Looking for sync object for activity id: " + globalId.print());
                        }
                        if ((synchronization = (Synchronization)_syncTable.remove(globalId)) != null) {
                            synchronization.afterCompletion(0);
                        }
                    }
                    catch (Exception exception) {
                        FFDCFilter.processException((Throwable)exception, "com.ibm.ws.ActivitySession.UserActivitySessionImpl.endSession", "1375", this);
                        if (!tc.isEventEnabled()) break block7;
                        Tr.event(tc, "endSession", "Exception caught from sync processing: " + exception);
                    }
                }
            }
            try {
                this.notifyCallbacks(3, null);
            }
            catch (IllegalStateException illegalStateException) {
                FFDCFilter.processException((Throwable)illegalStateException, "com.ibm.ws.ActivitySession.UserActivitySessionImpl.endSession", "493", this);
                if (!tc.isEventEnabled()) break block8;
                Tr.event(tc, "Exception caught in POST_END");
            }
        }
    }
}

