/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.LocalTransaction;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.Transaction.TransactionManagerFactory;
import com.ibm.ws.Transaction.UOWCallback;
import com.ibm.ws.Transaction.UOWCoordinator;
import com.ibm.ws.Transaction.UOWCurrent;
import java.util.ArrayList;

public final class LTCCallbacks {
    private static LTCCallbacks _instance = new LTCCallbacks();
    private ArrayList _callbacks = new ArrayList();
    private static final UOWCurrent _uowCurrent = TransactionManagerFactory.getUOWCurrent();
    private static final TraceComponent tc = Tr.register(LTCCallbacks.class, "Transaction", "com.ibm.ws.LocalTransaction.resources.LocalTranMsgs");

    private LTCCallbacks() {
    }

    public static LTCCallbacks instance() {
        return _instance;
    }

    public void registerCallback(UOWCallback uOWCallback) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "registerCallback", uOWCallback);
        }
        if (!this._callbacks.contains(uOWCallback)) {
            this._callbacks.add(uOWCallback);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Number of registered Callbacks: " + this._callbacks.size());
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "registerCallback");
        }
    }

    public void contextChange(int n) throws IllegalStateException {
        Object object;
        if (tc.isEntryEnabled()) {
            object = "UNKNOWN";
            switch (n) {
                case 0: {
                    object = "PRE_BEGIN";
                    break;
                }
                case 1: {
                    object = "POST_BEGIN";
                    break;
                }
                case 2: {
                    object = "PRE_END";
                    break;
                }
                case 3: {
                    object = "POST_END";
                }
            }
            Tr.entry(tc, "contextChange", object);
        }
        object = null;
        if (n == 1 || n == 2) {
            object = _uowCurrent.getUOWCoord();
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Coordinator=" + object);
        }
        IllegalStateException illegalStateException = null;
        for (int i = 0; i < this._callbacks.size(); ++i) {
            UOWCallback uOWCallback = (UOWCallback)this._callbacks.get(i);
            try {
                uOWCallback.contextChange(n, (UOWCoordinator)object);
                continue;
            }
            catch (IllegalStateException illegalStateException2) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Exception caught during UOW callback at context change", illegalStateException2);
                }
                illegalStateException = illegalStateException2;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "contextChange");
        }
        if (illegalStateException != null) {
            throw illegalStateException;
        }
    }
}

