/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.LocalTransaction;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.csi.EJBMethodInfo;
import com.ibm.websphere.csi.LocalTranConfigData;
import com.ibm.ws.ActivitySession.ActivitySession;
import com.ibm.ws.ActivitySession.UserActivitySessionFactory;
import com.ibm.ws.ActivitySession.WebSphereUserActivitySession;
import com.ibm.ws.LocalTransaction.LTCCallbacks;
import com.ibm.ws.LocalTransaction.LocalTranCoordImpl;
import com.ibm.ws.LocalTransaction.LocalTranCurrentSet;
import com.ibm.ws.LocalTransaction.LocalTransactionCurrent;
import com.ibm.ws.Transaction.JTA.TransactionImpl;
import com.ibm.ws.Transaction.UtxFactory;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.runtime.metadata.ComponentMetaData;
import com.ibm.ws.runtime.metadata.ContainerComponentMetaData;
import com.ibm.ws.threadContext.ComponentMetaDataAccessorImpl;
import com.ibm.ws.threadContext.EJBMethodInfoAccessorImpl;
import com.ibm.ws.uow.UOWScope;
import com.ibm.ws.uow.UOWScopeCallback;
import com.ibm.ws.util.WSThreadLocal;

public final class LTCUOWCallback
implements UOWScopeCallback {
    private static final TraceComponent tc = Tr.register(LTCUOWCallback.class, "Transaction", "com.ibm.ws.LocalTransaction.resources.LocalTranMsgs");
    private final WSThreadLocal _context = new WSThreadLocal();
    private static final LocalTransactionCurrent _ltCurrent = LocalTranCurrentSet.instance();
    private int _uowType;
    private static final int UOW_TYPE_TRANSACTION = 0;
    private static final int UOW_TYPE_ACTIVITYSESSION = 1;

    protected static void createUserTransactionCallback() {
        new LTCUOWCallback(0);
    }

    protected static void createUserActivitySessionCallback() {
        new LTCUOWCallback(1);
    }

    private LTCUOWCallback(int n) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "LTCUOWCallback", new Integer(n));
        }
        this._uowType = n;
        if (this._uowType == 0) {
            UtxFactory.createUserTransaction().registerCallback(this);
        } else {
            try {
                ((WebSphereUserActivitySession)UserActivitySessionFactory.createUserActivitySession()).registerCallback(this);
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.LocalTransaction.LTCUOWCallback.LTCUOWCallback", "128", this);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "LTCUOWCallback", this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void contextChange(int n, UOWScope uOWScope) throws IllegalStateException {
        LocalTranCoordImpl localTranCoordImpl;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "contextChange", new Object[]{new Integer(n), uOWScope, this});
        }
        if (this._uowType == 1 && (localTranCoordImpl = (LocalTranCoordImpl)_ltCurrent.getLocalTranCoord()) != null && localTranCoordImpl.getConfiguredBoundary().equals(LocalTranCoordImpl.BOUNDARY_BEAN_METHOD)) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "The current LTC has a boundary of bean method. Ignoring UserAS-driven context change");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "contextChange");
            }
            return;
        }
        try {
            switch (n) {
                case 0: {
                    try {
                        LTCCallbacks.instance().contextChange(n);
                        break;
                    }
                    finally {
                        this.uowPreBegin();
                    }
                }
                case 1: {
                    try {
                        this.uowPostBegin(uOWScope);
                        break;
                    }
                    finally {
                        LTCCallbacks.instance().contextChange(n);
                    }
                }
                case 2: {
                    try {
                        LTCCallbacks.instance().contextChange(n);
                        break;
                    }
                    finally {
                        this.uowPreEnd(uOWScope);
                    }
                }
                case 3: {
                    try {
                        this.uowPostEnd();
                        break;
                    }
                    finally {
                        LTCCallbacks.instance().contextChange(n);
                    }
                }
                default: {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Unknown typeOfChange: " + n);
                    }
                }
            }
        }
        catch (IllegalStateException illegalStateException) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "contextChange", illegalStateException);
            }
            throw illegalStateException;
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "contextChange");
        }
    }

    private void uowPreBegin() throws IllegalStateException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "uowPreBegin", this);
        }
        LocalTranCoordImpl localTranCoordImpl = (LocalTranCoordImpl)_ltCurrent.getLocalTranCoord();
        this._context.set((Object)null);
        if (localTranCoordImpl != null) {
            if (localTranCoordImpl.hasWork()) {
                if (this._uowType == 0) {
                    Tr.error(tc, "ERR_BEGIN_GLOBAL_TX");
                } else {
                    Tr.error(tc, "ERR_BEGIN_LTC_ACT");
                }
                IllegalStateException illegalStateException = new IllegalStateException("Cannot start a new UOW. A LocalTransactionContainment is already active with work.");
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "transactionPreBegin", illegalStateException);
                }
                throw illegalStateException;
            }
            try {
                ActivitySession activitySession;
                if (this._uowType == 0 && (activitySession = localTranCoordImpl.getActivitySession()) != null) {
                    if (localTranCoordImpl.isContainerResolved()) {
                        activitySession.delistResource(localTranCoordImpl.getLTResource());
                    } else {
                        activitySession.delistSynchronization(localTranCoordImpl.getLTSync());
                    }
                }
                localTranCoordImpl.complete(1);
                this._context.set(localTranCoordImpl.getConfiguredBoundary());
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.LocalTransaction.LTCUOWCallback.uowPreBegin", "243", this);
                IllegalStateException illegalStateException = new IllegalStateException();
                illegalStateException.initCause(exception);
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "uowPreBegin", illegalStateException);
                }
                throw illegalStateException;
            }
        }
    }

    private void uowPostBegin(UOWScope uOWScope) throws IllegalStateException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "uowPostBegin", new Object[]{uOWScope, this});
        }
        if (uOWScope == null) {
            Byte by;
            if (tc.isEventEnabled()) {
                Tr.event(tc, "uowPostBegin detected null UOW scope");
            }
            if ((by = (Byte)this._context.get()) != null) {
                boolean bl = LocalTranCoordImpl.BOUNDARY_ACTIVITYSESSION.equals(by);
                _ltCurrent.begin(bl);
            }
            IllegalStateException illegalStateException = new IllegalStateException("Failed to start global transaction");
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "transactionPostBegin", illegalStateException);
            }
            throw illegalStateException;
        }
        Byte by = (Byte)this._context.get();
        if (this._uowType == 1) {
            ActivitySession activitySession = (ActivitySession)((Object)uOWScope);
            activitySession.setCompletedLTCBoundary(by);
        } else if (uOWScope instanceof TransactionImpl) {
            TransactionImpl transactionImpl = (TransactionImpl)uOWScope;
            transactionImpl.setCompletedLTCBoundary(by);
        }
        if (this._uowType == 1) {
            _ltCurrent.begin(this.isBoundaryAS());
        }
    }

    private void uowPreEnd(UOWScope uOWScope) throws IllegalStateException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "uowPreEnd", new Object[]{uOWScope, this});
        }
        this._context.set((Object)null);
        if (uOWScope != null) {
            Byte by = null;
            if (this._uowType == 1) {
                by = ((ActivitySession)((Object)uOWScope)).getCompletedLTCBoundary();
            } else if (uOWScope instanceof TransactionImpl) {
                by = ((TransactionImpl)uOWScope).getCompletedLTCBoundary();
            }
            this._context.set(by);
        }
    }

    private void uowPostEnd() throws IllegalStateException {
        Byte by;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "uowPostEnd", this);
        }
        if ((by = (Byte)this._context.get()) != null) {
            boolean bl = LocalTranCoordImpl.BOUNDARY_ACTIVITYSESSION.equals(by);
            _ltCurrent.begin(bl);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "uowPostEnd");
        }
    }

    private boolean isBoundaryAS() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isBoundaryAS");
        }
        boolean bl = false;
        ComponentMetaData componentMetaData = ComponentMetaDataAccessorImpl.getComponentMetaDataAccessor().getComponentMetaData();
        LocalTranConfigData localTranConfigData = null;
        if (componentMetaData instanceof ContainerComponentMetaData) {
            localTranConfigData = ((ContainerComponentMetaData)componentMetaData).getLocalTranConfigData();
        }
        if (localTranConfigData != null) {
            EJBMethodInfo eJBMethodInfo = EJBMethodInfoAccessorImpl.getEJBMethodInfoAccessor().getEJBMethodInfo();
            if (eJBMethodInfo != null) {
                if (!eJBMethodInfo.isHome()) {
                    bl = localTranConfigData.getValueBoundary() == 1;
                }
            } else {
                boolean bl2 = bl = localTranConfigData.getValueBoundary() == 1;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isBoundaryAS", new Boolean(bl));
        }
        return bl;
    }
}

