/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.LocalTransaction;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.ActivitySession.ActivitySessionException;
import com.ibm.websphere.ActivitySession.SystemException;
import com.ibm.websphere.csi.EJBMethodInfo;
import com.ibm.websphere.csi.LocalTranConfigData;
import com.ibm.ws.ActivitySession.ActivitySession;
import com.ibm.ws.ActivitySession.ActivitySessionManager;
import com.ibm.ws.ActivitySession.ActivitySessionManagerFactory;
import com.ibm.ws.ActivitySession.ActivitySessionResource;
import com.ibm.ws.ActivitySession.ActivitySessionService;
import com.ibm.ws.LocalTransaction.ContainerSynchronization;
import com.ibm.ws.LocalTransaction.InconsistentLocalTranException;
import com.ibm.ws.LocalTransaction.LTCSystemException;
import com.ibm.ws.LocalTransaction.LocalTranCurrentImpl;
import com.ibm.ws.LocalTransaction.LocalTransactionCoordinator;
import com.ibm.ws.LocalTransaction.LocalTransactionResource;
import com.ibm.ws.LocalTransaction.LocalTransactionSynchronization;
import com.ibm.ws.LocalTransaction.RolledbackException;
import com.ibm.ws.Transaction.JtsPerformanceMetrics;
import com.ibm.ws.Transaction.OnePhaseXAResource;
import com.ibm.ws.Transaction.TxProperties;
import com.ibm.ws.Transaction.UOWCoordinator;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.runtime.metadata.ComponentMetaData;
import com.ibm.ws.runtime.metadata.ContainerComponentMetaData;
import com.ibm.ws.threadContext.ComponentMetaDataAccessorImpl;
import com.ibm.ws.threadContext.EJBMethodInfoAccessorImpl;
import com.ibm.ws.uow.SynchronizationRegistryUOWScope;
import com.ibm.ws390.tx.ltc.NativeLocalTransactionContext;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.transaction.Synchronization;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;

public final class LocalTranCoordImpl
implements LocalTransactionCoordinator,
UOWCoordinator,
SynchronizationRegistryUOWScope {
    private static final TraceComponent tc = Tr.register(LocalTranCoordImpl.class, "Transaction", "com.ibm.ws.LocalTransaction.resources.LocalTranMsgs");
    private static long _localIdCounter;
    private long _localId;
    public static final int Running = 10;
    public static final int Completing = 11;
    public static final int Completed = 12;
    public static final int Suspended = 13;
    public static final Byte BOUNDARY_ACTIVITYSESSION;
    public static final Byte BOUNDARY_BEAN_METHOD;
    private Byte _configuredBoundary;
    private static ActivitySessionManager _manager;
    private static boolean _asmChecked;
    private ArrayList _enlistedResources;
    private ArrayList _cleanupResources;
    private ArrayList _syncs;
    private ContainerSynchronization _containerSync;
    private ActivitySessionResource _ASResource;
    private Synchronization _ASSync;
    private int _state;
    private boolean _unresActionIsCommit;
    private boolean _boundaryIsAS;
    private boolean _resolverIsCAB;
    private boolean _rollbackOnly;
    private boolean _rollbackOnlyFromApplicationCode;
    private boolean _outcomeRollback;
    private boolean _deferredConfig = true;
    private ActivitySession _session;
    private LocalTranCurrentImpl _current;
    private NativeLocalTransactionContext _nativeContext;
    private static JtsPerformanceMetrics perf;
    private long startTime;
    private String _taskId;
    private boolean _shareable;
    private Map _synchronizationRegistryResources;
    private List _interposedSynchronizations;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    LocalTranCoordImpl(boolean bl, boolean bl2, boolean bl3, LocalTranCurrentImpl localTranCurrentImpl) throws IllegalStateException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "LocalTranCoordImpl", "unresActionCommit=" + bl2 + ", boundaryIsAS=" + bl + ", resolverIsCAB=" + bl3);
        }
        this._state = 10;
        this._deferredConfig = false;
        this._current = localTranCurrentImpl;
        this._localId = -1L;
        this._unresActionIsCommit = bl2;
        this._resolverIsCAB = bl3;
        try {
            this._configuredBoundary = bl ? BOUNDARY_ACTIVITYSESSION : BOUNDARY_BEAN_METHOD;
            this._boundaryIsAS = this.initForActivitySessions(bl);
            if (TxProperties.NATIVE_CONTEXTS_USED) {
                this._nativeContext = NativeLocalTransactionContext.create(this);
            }
        }
        finally {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "LocalTranCoordImpl");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    LocalTranCoordImpl(boolean bl, LocalTranCurrentImpl localTranCurrentImpl) throws IllegalStateException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "LocalTranCoordImpl", "boundaryIsAS=" + bl);
        }
        this._state = 10;
        this._current = localTranCurrentImpl;
        this._localId = -1L;
        try {
            this._configuredBoundary = bl ? BOUNDARY_ACTIVITYSESSION : BOUNDARY_BEAN_METHOD;
            this._boundaryIsAS = this.initForActivitySessions(bl);
            if (TxProperties.NATIVE_CONTEXTS_USED) {
                this._nativeContext = NativeLocalTransactionContext.create(this);
            }
        }
        finally {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "LocalTranCoordImpl");
            }
        }
    }

    public void enlist(OnePhaseXAResource onePhaseXAResource) throws IllegalStateException, LTCSystemException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "enlist", onePhaseXAResource);
        }
        if (this._cleanupResources != null) {
            IllegalStateException illegalStateException = new IllegalStateException("Cannot enlist Resource. This LTC scope is being used for cleanup.");
            FFDCFilter.processException((Throwable)illegalStateException, "com.ibm.ws.LocalTransaction.LocalTranCoordImpl.enlist", "335", this);
            Tr.error(tc, "ERR_ENLIST_TX_CLEANUP");
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "enlist", illegalStateException);
            }
            throw illegalStateException;
        }
        if (this._rollbackOnly) {
            IllegalStateException illegalStateException = new IllegalStateException("Cannot enlist Resource. LocalTransaction is marked RollbackOnly.");
            FFDCFilter.processException((Throwable)illegalStateException, "com.ibm.ws.LocalTransaction.LocalTranCoordImpl.enlist", "344", this);
            Tr.error(tc, "ERR_STATE_RB_ONLY");
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "enlist", illegalStateException);
            }
            throw illegalStateException;
        }
        if (onePhaseXAResource == null) {
            IllegalStateException illegalStateException = new IllegalStateException("enlist failed. Resource specified was null.");
            FFDCFilter.processException((Throwable)illegalStateException, "com.ibm.ws.LocalTransaction.LocalTranCoordImpl.enlist", "354", this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "enlist", illegalStateException);
            }
            throw illegalStateException;
        }
        if (this._state != 10 && this._state != 13) {
            IllegalStateException illegalStateException = new IllegalStateException("Cannot enlist Resource. LocalTransaction is completing or completed.");
            FFDCFilter.processException((Throwable)illegalStateException, "com.ibm.ws.LocalTransaction.LocalTranCoordImpl.enlist", "362", this);
            Tr.error(tc, "ERR_ENLIST_LTC_COMPLETE");
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "enlist", illegalStateException);
            }
            throw illegalStateException;
        }
        try {
            onePhaseXAResource.start(null, 0);
            if (this._enlistedResources == null) {
                this._enlistedResources = new ArrayList();
                this.getComponentMetadataForLTC();
                if (perf != null) {
                    this.startTime = perf.started();
                }
            }
            this._enlistedResources.add(onePhaseXAResource);
        }
        catch (XAException xAException) {
            FFDCFilter.processException((Throwable)xAException, "com.ibm.ws.LocalTransaction.LocalTranCoordImpl.enlist", "232", this);
            Tr.error(tc, "ERR_XA_RESOURCE_START", new Object[]{onePhaseXAResource.getResourceName(), xAException});
            LTCSystemException lTCSystemException = new LTCSystemException("Resource enlistment failed due to failure in xa_start.");
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "enlist", lTCSystemException);
            }
            throw lTCSystemException;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "enlist");
        }
    }

    public void enlistForCleanup(OnePhaseXAResource onePhaseXAResource) throws IllegalStateException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "enlistForCleanup", onePhaseXAResource);
        }
        if (LocalTranCurrentImpl.globalTranExists()) {
            IllegalStateException illegalStateException = new IllegalStateException("Cannot enlist Resource for cleanup. A Global transaction is active.");
            FFDCFilter.processException((Throwable)illegalStateException, "com.ibm.ws.LocalTransaction.LocalTranCoordImpl.enlistForCleanup", "443", this);
            Tr.error(tc, "ERR_ENLIST_CLN_TX_GLB_ACT");
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "enlistForCleanup", illegalStateException);
            }
            throw illegalStateException;
        }
        if (this._enlistedResources != null) {
            IllegalStateException illegalStateException = new IllegalStateException("Cannot enlist Resource for cleanup. This LTC scope is being used for coordination.");
            FFDCFilter.processException((Throwable)illegalStateException, "com.ibm.ws.LocalTransaction.LocalTranCoordImpl.enlistForCleanup", "452", this);
            Tr.error(tc, "ERR_ENLIST_CLN_TX_CLEANUP");
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "enlistForCleanup", illegalStateException);
            }
            throw illegalStateException;
        }
        if (this._rollbackOnly) {
            IllegalStateException illegalStateException = new IllegalStateException("Cannot enlist Resource. LocalTransaction is marked RollbackOnly.");
            FFDCFilter.processException((Throwable)illegalStateException, "com.ibm.ws.LocalTransaction.LocalTranCoordImpl.enlistForCleanup", "461", this);
            Tr.error(tc, "ERR_STATE_RB_ONLY");
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "enlistForCleanup", illegalStateException);
            }
            throw illegalStateException;
        }
        if (onePhaseXAResource == null) {
            IllegalStateException illegalStateException = new IllegalStateException("enlistForCleanup failed. Resource specified was null.");
            FFDCFilter.processException((Throwable)illegalStateException, "com.ibm.ws.LocalTransaction.LocalTranCoordImpl.enlistForCleanup", "471", this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "enlistForCleanup", illegalStateException);
            }
            throw illegalStateException;
        }
        if (this._state != 10 && this._state != 13) {
            IllegalStateException illegalStateException = new IllegalStateException("Cannot enlist Resource for cleanup. LocalTransaction is completing or completed.");
            FFDCFilter.processException((Throwable)illegalStateException, "com.ibm.ws.LocalTransaction.LocalTranCoordImpl.enlistForCleanup", "478", this);
            Tr.error(tc, "ERR_ENLIST_CLN_LTC_COMPLETE");
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "enlistForCleanup", illegalStateException);
            }
            throw illegalStateException;
        }
        if (this._shareable) {
            IllegalStateException illegalStateException = new IllegalStateException("Cannot enlist Resource for cleanup.  LocalTransaction is shareable and resolver is Application.");
            FFDCFilter.processException((Throwable)illegalStateException, "com.ibm.ws.LocalTransaction.LocalTranCoordImpl.enlistForCleanup", "488", this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "enlistForCleanup", illegalStateException);
            }
            throw illegalStateException;
        }
        if (this._cleanupResources == null) {
            this._cleanupResources = new ArrayList();
            this.getComponentMetadataForLTC();
            if (perf != null) {
                this.startTime = perf.started();
            }
        }
        this._cleanupResources.add(onePhaseXAResource);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "enlistForCleanup");
        }
    }

    public void delistFromCleanup(OnePhaseXAResource onePhaseXAResource) throws IllegalStateException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "delistFromCleanup", onePhaseXAResource);
        }
        if (LocalTranCurrentImpl.globalTranExists()) {
            IllegalStateException illegalStateException = new IllegalStateException("Cannot delist Resource from cleanup. A Global transaction is active.");
            FFDCFilter.processException((Throwable)illegalStateException, "com.ibm.ws.LocalTransaction.LocalTranCoordImpl.delistFromCleanup", "525", this);
            Tr.error(tc, "ERR_DELIST_TX_GLB_ACT");
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "delistFromCleanup", illegalStateException);
            }
            throw illegalStateException;
        }
        if (this._cleanupResources == null) {
            IllegalStateException illegalStateException = new IllegalStateException("Cannot delist Resource. It is not enlisted for cleanup with this LocalTransactionCoordinator.");
            FFDCFilter.processException((Throwable)illegalStateException, "com.ibm.ws.LocalTransaction.LocalTranCoordImpl.delistFromCleanup", "534", this);
            Tr.error(tc, "ERR_DELIST_NOT_ENLISTED");
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "delistFromCleanup", illegalStateException);
            }
            throw illegalStateException;
        }
        if (this._state == 10 || this._state == 13) {
            int n = this._cleanupResources.indexOf(onePhaseXAResource);
            if (n == -1) {
                IllegalStateException illegalStateException = new IllegalStateException("Cannot delist Resource. It is not enlisted for cleanup with this LocalTransactionCoordinator.");
                FFDCFilter.processException((Throwable)illegalStateException, "com.ibm.ws.LocalTransaction.LocalTranCoordImpl.delistFromCleanup", "547", this);
                Tr.error(tc, "ERR_DELIST_NOT_ENLISTED");
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "delistFromCleanup", illegalStateException);
                }
                throw illegalStateException;
            }
            this._cleanupResources.remove(n);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "delistFromCleanup");
        }
    }

    public void enlistSynchronization(Synchronization synchronization) throws IllegalStateException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "enlistSynchronization", synchronization);
        }
        if (this._state != 10 && this._state != 13) {
            IllegalStateException illegalStateException = new IllegalStateException("Cannot enlist Synchronization. LocalTransactionCoordinator is completing or completed.");
            FFDCFilter.processException((Throwable)illegalStateException, "com.ibm.ws.LocalTransaction.LocalTranCoordImpl.enlistSynchronization", "591", this);
            Tr.error(tc, "ERR_ENLIST_SYNCH_LTC_COMPLETE");
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "enlistSynchronization", illegalStateException);
            }
            throw illegalStateException;
        }
        if (synchronization == null) {
            IllegalStateException illegalStateException = new IllegalStateException("Synchronization enlistment failed. Synchronization specified was null.");
            FFDCFilter.processException((Throwable)illegalStateException, "com.ibm.ws.LocalTransaction.LocalTranCoordImpl.enlistSynchronization", "600", this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "enlistSynchronization", illegalStateException);
            }
            throw illegalStateException;
        }
        if (synchronization instanceof ContainerSynchronization) {
            if (this._containerSync != null) {
                IllegalStateException illegalStateException = new IllegalStateException("Enlistment failed.  A ContainerSynchronization is already enlisted.");
                FFDCFilter.processException((Throwable)illegalStateException, "com.ibm.ws.LocalTransaction.LocalTranCoordImpl.enlistSynchronization", "618", this);
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "enlistSynchronization", illegalStateException);
                }
                throw illegalStateException;
            }
            this._containerSync = (ContainerSynchronization)synchronization;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "ContainerSynchronization Enlisted.");
            }
        } else {
            if (this._syncs == null) {
                this._syncs = new ArrayList();
            }
            this._syncs.add(synchronization);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "enlistSynchronization");
        }
    }

    public void complete(int n) throws InconsistentLocalTranException, RolledbackException, IllegalStateException {
        this.complete(n, true);
    }

    void complete(int n, boolean bl) throws InconsistentLocalTranException, RolledbackException, IllegalStateException {
        Object object;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "complete", (n == 0 ? "Commit" : "Rollback") + ", isCompleting=" + bl + " LTC=" + this);
        }
        if (this._state != 10) {
            IllegalStateException illegalStateException = new IllegalStateException("Cannot complete LocalTransactionContainment. LocalTransactionCoordinator is completing or completed.");
            FFDCFilter.processException((Throwable)illegalStateException, "com.ibm.ws.LocalTransaction.LocalTranCoordImpl.complete", "715", this);
            Tr.error(tc, "ERR_LTC_COMPLETE");
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "complete", illegalStateException);
            }
            throw illegalStateException;
        }
        this.ensureActive();
        boolean bl2 = false;
        if (this.startTime != 0L) {
            bl2 = true;
            perf.commitRequested();
        }
        this._outcomeRollback = false;
        if (n == 0 && !this._rollbackOnly) {
            this.informSynchronizations(bl);
        }
        this._state = 11;
        if (this._rollbackOnly || n == 1) {
            this._outcomeRollback = true;
        }
        ArrayList<String> arrayList = null;
        if (this._enlistedResources != null) {
            this._enlistedResources.trimToSize();
            for (int i = 0; i < this._enlistedResources.size(); ++i) {
                object = (OnePhaseXAResource)this._enlistedResources.get(i);
                try {
                    if (this._outcomeRollback) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug(tc, "Calling rollback on resource " + object);
                        }
                        object.rollback(null);
                        continue;
                    }
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "Calling commit on resource " + object);
                    }
                    object.commit(null, true);
                    continue;
                }
                catch (XAException xAException) {
                    FFDCFilter.processException((Throwable)xAException, "com.ibm.ws.LocalTransaction.LocalTranCoordImpl.complete", "593", this);
                    if (arrayList == null) {
                        arrayList = new ArrayList();
                    }
                    arrayList.add(object.getResourceName());
                    Tr.error(tc, "ERR_XA_RESOURCE_COMPLETE", new Object[]{object.getResourceName(), xAException});
                }
            }
        }
        if (this._nativeContext != null) {
            try {
                if (this._outcomeRollback) {
                    this._nativeContext.rollback();
                } else {
                    this._nativeContext.commit();
                }
            }
            catch (Throwable throwable) {
                if (arrayList == null) {
                    arrayList = new ArrayList<String>();
                }
                arrayList.add("Native RRS Unit of Recovery");
                Tr.error(tc, "ERR_LTC_COMPLETE", new Object[]{"RRS", throwable});
            }
            this._nativeContext = null;
        }
        this._state = 12;
        this.informSynchronizations(bl);
        this._cleanupResources = null;
        this._enlistedResources = null;
        this._syncs = null;
        this._nativeContext = null;
        if (bl) {
            if (this._current.getLocalTranCoord() == this) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Completed LTC is on thread so set current LTC to null");
                }
                this._current.setCoordinator(null);
            }
        } else {
            if (TxProperties.NATIVE_CONTEXTS_USED) {
                this._nativeContext = NativeLocalTransactionContext.create(this);
            }
            this._state = 10;
            if (this._containerSync != null) {
                this._containerSync.setCompleting(bl);
                if (this._outcomeRollback) {
                    this._containerSync.afterCompletion(4);
                } else {
                    this._containerSync.afterCompletion(3);
                }
            }
        }
        if (bl2) {
            perf.completed(0L, this.startTime, !this._outcomeRollback);
        }
        if (arrayList != null) {
            String[] stringArray = new String[arrayList.size()];
            object = new InconsistentLocalTranException("Resource(s) failed to complete.", arrayList.toArray(stringArray));
            FFDCFilter.processException((Throwable)object, "com.ibm.ws.LocalTransaction.LocalTranCoordImpl.complete", "914", this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "complete", object);
            }
            throw object;
        }
        if (this._rollbackOnly && n == 0) {
            RolledbackException rolledbackException = new RolledbackException("Resources rolled back due to setRollbackOnly.");
            Tr.error(tc, "ERR_XA_RESOURCE_ROLLEDBACK");
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "complete", rolledbackException);
            }
            throw rolledbackException;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "complete");
        }
    }

    public void cleanup() throws InconsistentLocalTranException, IllegalStateException, RolledbackException {
        Object object;
        ArrayList<String> arrayList;
        boolean bl;
        block38: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.entry(tc, "cleanup", this);
            }
            if (this._state != 10) {
                IllegalStateException illegalStateException = new IllegalStateException("Cannot cleanup LocalTransactionContainment. LocalTransactionCoordinator is completing or completed.");
                FFDCFilter.processException((Throwable)illegalStateException, "com.ibm.ws.LocalTransaction.LocalTranCoordImpl.cleanup", "958", this);
                Tr.error(tc, "ERR_LTC_COMPLETE");
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "cleanup", illegalStateException);
                }
                throw illegalStateException;
            }
            this.ensureActive();
            boolean bl2 = false;
            if (this._nativeContext != null && this._nativeContext.hasInterests()) {
                bl2 = true;
            }
            if (this._cleanupResources != null && !this._cleanupResources.isEmpty()) {
                bl2 = true;
            }
            this._outcomeRollback = bl2 ? this._rollbackOnly || !this._unresActionIsCommit : this._rollbackOnly;
            bl = false;
            if (this.startTime != 0L) {
                bl = true;
                perf.commitRequested();
            }
            if (!this._outcomeRollback) {
                this.informSynchronizations(true);
            }
            this._state = 11;
            if (this._cleanupResources != null && !this._cleanupResources.isEmpty()) {
                bl2 = true;
            }
            this._outcomeRollback = bl2 ? this._rollbackOnly || !this._unresActionIsCommit : this._rollbackOnly;
            arrayList = null;
            if (bl2 && this._cleanupResources != null) {
                for (int i = 0; i < this._cleanupResources.size(); ++i) {
                    object = (OnePhaseXAResource)this._cleanupResources.get(i);
                    try {
                        if (this._outcomeRollback) {
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                Tr.debug(tc, "Calling rollback on resource " + object);
                            }
                            object.rollback(null);
                            Tr.warning(tc, "WRN_RESOURCE_UNRESOLVED_LTC_ROLLEDBACK", object.getResourceName());
                            continue;
                        }
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug(tc, "Calling commit on resource " + object);
                        }
                        object.commit(null, true);
                        continue;
                    }
                    catch (XAException xAException) {
                        FFDCFilter.processException((Throwable)xAException, "com.ibm.ws.LocalTransaction.LocalTranCoordImpl.cleanup", "755", this);
                        if (arrayList == null) {
                            arrayList = new ArrayList();
                        }
                        arrayList.add(object.getResourceName());
                        Tr.error(tc, "ERR_XA_RESOURCE_COMPLETE", new Object[]{object.getResourceName(), xAException});
                    }
                }
            }
            if (this._nativeContext != null) {
                try {
                    if (this._outcomeRollback) {
                        this._nativeContext.rollback();
                    } else {
                        this._nativeContext.commit();
                    }
                }
                catch (Throwable throwable) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                        Tr.event(tc, "LTC end for RRS failed with exception", throwable);
                    }
                    if (arrayList == null) {
                        arrayList = new ArrayList<String>();
                    }
                    arrayList.add("Native RRS Unit of Recovery");
                    Tr.error(tc, "ERR_LTC_COMPLETE", new Object[]{"RRS", throwable});
                }
                this._nativeContext = null;
            }
            if (this._session != null) {
                try {
                    if (this._session.getStatus() == 0 && !this.isASScoped() && !this._resolverIsCAB) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug(tc, "Delisting LTSync from Activity Session");
                        }
                        this._session.delistSynchronization(this.getLTSync());
                    }
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, "com.ibm.ws.LocalTransaction.LocalTranCoordImpl.cleanup", "820", this);
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) break block38;
                    Tr.event(tc, "Exception thrown while attempting to delist LTSync from Activity Session", exception);
                }
            }
        }
        this._state = 12;
        this.informSynchronizations(true);
        if (bl) {
            perf.completed(0L, this.startTime, !this._outcomeRollback);
        }
        this._cleanupResources = null;
        this._enlistedResources = null;
        this._nativeContext = null;
        this._syncs = null;
        if (this._current.getLocalTranCoord() == this) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Completed LTC is on thread so set current LTC to null");
            }
            this._current.setCoordinator(null);
        }
        if (arrayList != null) {
            String[] stringArray = new String[arrayList.size()];
            object = new InconsistentLocalTranException("Resource(s) failed to complete.", arrayList.toArray(stringArray));
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "cleanup", object);
            }
            throw object;
        }
        if (this._outcomeRollback && !this._rollbackOnlyFromApplicationCode) {
            RolledbackException rolledbackException = null;
            if (this._rollbackOnly) {
                Tr.error(tc, "ERR_XA_RESOURCE_ROLLEDBACK");
                rolledbackException = new RolledbackException("Resources rolled back due to setRollbackOnly() being called.");
            } else {
                Tr.warning(tc, "WRN_LTC_UNRESOLVED_ROLLEDBACK");
                rolledbackException = new RolledbackException("Resources rolled back due to unresolved action of rollback.");
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "cleanup", rolledbackException);
            }
            throw rolledbackException;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "cleanup");
        }
    }

    public void end(int n) throws InconsistentLocalTranException, RolledbackException, IllegalStateException {
        if (this._resolverIsCAB) {
            this.complete(n);
        } else {
            this.cleanup();
        }
    }

    public void setRollbackOnly() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "setRollbackOnly");
        }
        this._rollbackOnly = true;
        if (this._boundaryIsAS) {
            try {
                LocalTranCoordImpl.getActivitySessionManager().setResetOnly();
            }
            catch (ActivitySessionException activitySessionException) {
                FFDCFilter.processException((Throwable)activitySessionException, "com.ibm.ws.LocalTransaction.LocalTranCoordImpl.setRollbackOnly", "869", this);
                Tr.error(tc, "ERR_AS_UNEXPECTED");
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "setRollbackOnly");
        }
    }

    public void setRollbackOnlyFromApplicationCode() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setRollbackOnlyFromApplicationCode", this);
        }
        this._rollbackOnlyFromApplicationCode = true;
        this.setRollbackOnly();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setRollbackOnlyFromApplicationCode");
        }
    }

    public boolean getRollbackOnly() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event(tc, "getRollbackOnly: " + this._rollbackOnly);
        }
        return this._rollbackOnly;
    }

    protected boolean hasWork() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "hasWork");
        }
        boolean bl = false;
        if (this._cleanupResources != null && !this._cleanupResources.isEmpty()) {
            bl = true;
        }
        if (this._enlistedResources != null) {
            bl = true;
        }
        if (this._nativeContext != null && this._nativeContext.hasInterests()) {
            bl = true;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "hasWork", new Boolean(bl));
        }
        return bl;
    }

    void suspend() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "suspend");
        }
        if (this._nativeContext != null) {
            this._nativeContext.suspend();
        }
        this._current = null;
        this._state = 13;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "suspend");
        }
    }

    void resume(LocalTranCurrentImpl localTranCurrentImpl) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "resume", localTranCurrentImpl);
        }
        if (this._nativeContext != null) {
            this._nativeContext.resume();
        }
        this._current = localTranCurrentImpl;
        this._state = 10;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "resume");
        }
    }

    private void informSynchronizations(boolean bl) {
        block20: {
            Synchronization synchronization;
            int n;
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.entry(tc, "informSynchronizations: isCompleting=" + bl);
            }
            this.ensureActive();
            boolean bl2 = true;
            if (this._state == 12 && this._interposedSynchronizations != null) {
                for (n = 0; n < this._interposedSynchronizations.size() && bl2; ++n) {
                    synchronization = (Synchronization)this._interposedSynchronizations.get(n);
                    bl2 = this.driveSynchronization(synchronization);
                }
            }
            if (this._syncs != null) {
                for (n = 0; n < this._syncs.size() && bl2; ++n) {
                    synchronization = (Synchronization)this._syncs.get(n);
                    bl2 = this.driveSynchronization(synchronization);
                }
            }
            if (this._state == 10 && this._interposedSynchronizations != null) {
                for (n = 0; n < this._interposedSynchronizations.size() && bl2; ++n) {
                    synchronization = (Synchronization)this._interposedSynchronizations.get(n);
                    bl2 = this.driveSynchronization(synchronization);
                }
            }
            if (this._containerSync != null) {
                if (this._state == 10) {
                    this._containerSync.setCompleting(bl);
                    if (!this._rollbackOnly) {
                        try {
                            this._containerSync.beforeCompletion();
                        }
                        catch (Throwable throwable) {
                            FFDCFilter.processException(throwable, "com.ibm.ws.LocalTransaction.LocalTranCoordImpl.informSynchronizations", "1524", this);
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                Tr.debug(tc, "ContainerSync threw an exception during beforeCompletion", throwable);
                            }
                            this.setRollbackOnly();
                        }
                    }
                } else if (bl && this._state == 12) {
                    this._containerSync.setCompleting(bl);
                    try {
                        if (this._outcomeRollback) {
                            this._containerSync.afterCompletion(4);
                        } else {
                            this._containerSync.afterCompletion(3);
                        }
                    }
                    catch (Throwable throwable) {
                        FFDCFilter.processException(throwable, "com.ibm.ws.LocalTransaction.LocalTranCoordImpl.informSynchronizations", "1441", this);
                        if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block20;
                        Tr.debug(tc, "ContainerSync threw an exception during afterCompletion", throwable);
                    }
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "informSynchronizations");
        }
    }

    private boolean driveSynchronization(Synchronization synchronization) {
        boolean bl;
        block10: {
            bl = true;
            if (this._state == 10) {
                try {
                    synchronization.beforeCompletion();
                }
                catch (Throwable throwable) {
                    FFDCFilter.processException(throwable, "com.ibm.ws.LocalTransaction.LocalTranCoordImpl.driveSynchronization", "1588", this);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "An Error occurred in beforeCompletion. Setting RollbackOnly=true.", throwable);
                    }
                    this.setRollbackOnly();
                    bl = false;
                }
            } else if (this._state == 12) {
                try {
                    if (this._outcomeRollback) {
                        synchronization.afterCompletion(4);
                    } else {
                        synchronization.afterCompletion(3);
                    }
                }
                catch (Throwable throwable) {
                    FFDCFilter.processException(throwable, "com.ibm.ws.LocalTransaction.LocalTranCoordImpl.driveSynchronization", "1619", this);
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block10;
                    Tr.debug(tc, "An Error occurred in afterCompletion.", throwable);
                }
            }
        }
        return bl;
    }

    public boolean isASScoped() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event(tc, "isASScoped: return=" + this._boundaryIsAS);
        }
        return this._boundaryIsAS;
    }

    public boolean isContainerResolved() {
        this.getComponentMetadataForLTC();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event(tc, "isContainerResolved: return=" + this._resolverIsCAB);
        }
        return this._resolverIsCAB;
    }

    public static void setPerformanceMetrics(JtsPerformanceMetrics jtsPerformanceMetrics) {
        perf = jtsPerformanceMetrics;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event(tc, "setPerformanceMetrics: " + jtsPerformanceMetrics);
        }
    }

    public boolean isGlobal() {
        return false;
    }

    public byte[] getTID() {
        if (this._nativeContext != null) {
            return this._nativeContext.getNativeTranID();
        }
        return null;
    }

    public int getTxType() {
        return 0;
    }

    ActivitySessionResource getLTResource() {
        if (this._ASResource == null) {
            this._ASResource = new LocalTransactionResource(this);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event(tc, "getLTResource: " + this._ASResource);
        }
        return this._ASResource;
    }

    Synchronization getLTSync() {
        if (this._ASSync == null) {
            this._ASSync = new LocalTransactionSynchronization(this);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event(tc, "getLTSync: " + this._ASSync);
        }
        return this._ASSync;
    }

    private void getComponentMetadataForLTC() {
        if (this._deferredConfig) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.entry(tc, "getComponentMetadataForLTC");
            }
            ComponentMetaData componentMetaData = ComponentMetaDataAccessorImpl.getComponentMetaDataAccessor().getComponentMetaData();
            LocalTranConfigData localTranConfigData = null;
            if (componentMetaData instanceof ContainerComponentMetaData) {
                localTranConfigData = ((ContainerComponentMetaData)componentMetaData).getLocalTranConfigData();
            }
            if (localTranConfigData != null) {
                this._unresActionIsCommit = localTranConfigData.getValueUnresolvedAction() == 1;
                boolean bl = this._resolverIsCAB = localTranConfigData.getValueResolver() == 1;
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "_unresActionIsCommit=" + this._unresActionIsCommit);
                    Tr.debug(tc, "_resolverIsCAB=" + this._resolverIsCAB);
                }
            }
            this._deferredConfig = false;
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "getComponentMetadataForLTC");
            }
        }
    }

    private boolean initForActivitySessions(boolean bl) throws IllegalStateException {
        EJBMethodInfo eJBMethodInfo;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "initForActivitySessions");
        }
        LocalTranCoordImpl.getActivitySessionManager();
        if (_manager == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "initForActivitySessions", new Boolean(false));
            }
            return false;
        }
        this.getComponentMetadataForLTC();
        EJBMethodInfoAccessorImpl eJBMethodInfoAccessorImpl = EJBMethodInfoAccessorImpl.getEJBMethodInfoAccessor();
        if (eJBMethodInfoAccessorImpl != null && (eJBMethodInfo = eJBMethodInfoAccessorImpl.getEJBMethodInfo()) != null && eJBMethodInfo.isHome()) {
            if (TraceComponent.isAnyTracingEnabled()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "EJBMethodInfo.isHome() is true, don't enlist with AS");
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "initForActivitySessions", Boolean.FALSE);
                }
            }
            return false;
        }
        try {
            this._session = _manager.getActivitySession();
        }
        catch (SystemException systemException) {
            FFDCFilter.processException((Throwable)systemException, "com.ibm.ws.LocalTransaction.LocalTranCoordImpl.initForActivitySessions", "1451", this);
            IllegalStateException illegalStateException = new IllegalStateException("An unexpected error occurred whilst interacting with the ActivitySession service.");
            Tr.error(tc, "ERR_AS_UNEXPECTED");
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "initForActivitySessions", illegalStateException);
            }
            throw illegalStateException;
        }
        if (this._session == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "initForActivitySessions", new Boolean(false));
            }
            return false;
        }
        if (bl) {
            try {
                if (this._resolverIsCAB) {
                    this._session.enlistResource(this.getLTResource());
                }
                this._session.enlistSynchronization(this.getLTSync());
            }
            catch (IllegalStateException illegalStateException) {
                FFDCFilter.processException((Throwable)illegalStateException, "com.ibm.ws.LocalTransaction.LocalTranCoordImpl.initForActivitySessions", "1487", this);
                IllegalStateException illegalStateException2 = new IllegalStateException("Cannot enlist with ActivitySession service. ActivitySession is in an illegal state.");
                Tr.error(tc, "ERR_AS_ILLEGAL_STATE");
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "initForActivitySessions", illegalStateException2);
                }
                throw illegalStateException2;
            }
            catch (SystemException systemException) {
                FFDCFilter.processException((Throwable)systemException, "com.ibm.ws.LocalTransaction.LocalTranCoordImpl.initForActivitySessions", "1497", this);
                IllegalStateException illegalStateException = new IllegalStateException("An unexpected error occurred whilst interacting with the ActivitySession service.");
                Tr.error(tc, "ERR_AS_UNEXPECTED");
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "initForActivitySessions", illegalStateException);
                }
                throw illegalStateException;
            }
        } else {
            this._session = null;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "initForActivitySessions", bl);
        }
        return bl;
    }

    public static ActivitySessionManager getActivitySessionManager() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getActivitySessionManager");
        }
        if (!_asmChecked) {
            if (ActivitySessionService.isEnabled()) {
                try {
                    _manager = ActivitySessionManagerFactory.getActivitySessionManager();
                    _asmChecked = true;
                }
                catch (SystemException systemException) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "Exception when atempting to get ActivitySessionManager");
                    }
                    FFDCFilter.processException(systemException, "com.ibm.ws.LocalTransaction.LocalTranCoordImpl.getActivitySessionManager", "1538");
                }
            } else {
                _asmChecked = true;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getActivitySessionManager", _manager);
        }
        return _manager;
    }

    void ensureActive() throws IllegalStateException {
        if (this._nativeContext != null && this._nativeContext.isSuspended()) {
            IllegalStateException illegalStateException = new IllegalStateException("Native work context is not associated with this thread");
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "ensureActive", illegalStateException);
            }
            throw illegalStateException;
        }
    }

    public String toString() {
        if (this._state != 0) {
            return super.toString() + ";" + LocalTranCoordImpl.stateToString(this._state) + ";" + (this._rollbackOnly ? "RollbackOnly" : "");
        }
        return super.toString();
    }

    static String stateToString(int n) {
        switch (n) {
            case 10: {
                return "RUNNING";
            }
            case 11: {
                return "COMPLETING";
            }
            case 12: {
                return "COMPLETED";
            }
            case 13: {
                return "SUSPENDED";
            }
        }
        return "UNKNOWN";
    }

    public Xid getXid() {
        return null;
    }

    public Byte getConfiguredBoundary() {
        return this._configuredBoundary;
    }

    public void setTaskId(String string) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "setTaskId", new Object[]{string, this});
        }
        this._taskId = string;
    }

    public String getTaskId() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "getTaskId", this._taskId);
        }
        return this._taskId;
    }

    public ActivitySession getActivitySession() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "getActivitySession", this._session);
        }
        return this._session;
    }

    public void putResource(Object object, Object object2) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "putResource", new Object[]{object, object2, this});
        }
        if (object == null) {
            NullPointerException nullPointerException = new NullPointerException();
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "putResource", nullPointerException);
            }
            throw nullPointerException;
        }
        if (this._synchronizationRegistryResources == null) {
            this._synchronizationRegistryResources = new HashMap();
        }
        this._synchronizationRegistryResources.put(object, object2);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "putResource");
        }
    }

    public Object getResource(Object object) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getResource", new Object[]{object, this});
        }
        if (object == null) {
            NullPointerException nullPointerException = new NullPointerException();
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "getResource", nullPointerException);
            }
            throw nullPointerException;
        }
        if (this._synchronizationRegistryResources == null) {
            this._synchronizationRegistryResources = new HashMap();
        }
        Object v = this._synchronizationRegistryResources.get(object);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getResource", v);
        }
        return v;
    }

    public long getLocalId() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getLocalId", this);
        }
        if (this._localId == -1L) {
            this._localId = LocalTranCoordImpl.generateLocalId();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getLocalId", new Long(this._localId));
        }
        return this._localId;
    }

    private static synchronized long generateLocalId() {
        return _localIdCounter++ | 0x4000000000000000L;
    }

    public int getUOWStatus() {
        int n;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getUOWStatus", this);
        }
        switch (this._state) {
            case 10: {
                if (this._rollbackOnly) {
                    n = 1;
                    break;
                }
                n = 0;
                break;
            }
            case 11: {
                n = 2;
                break;
            }
            case 12: {
                if (this._outcomeRollback) {
                    n = 4;
                    break;
                }
                n = 3;
                break;
            }
            default: {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "getUOWStatus", "IllegalStateException");
                }
                throw new IllegalStateException();
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getUOWStatus", new Integer(n));
        }
        return n;
    }

    public int getUOWType() {
        return 0;
    }

    public void registerInterposedSynchronization(Synchronization synchronization) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "registerInterposedSynchronization", new Object[]{synchronization, this});
        }
        if (this._state != 10) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "registerInterposedSynchronization", "IllegalStateException");
            }
            throw new IllegalStateException();
        }
        if (this._interposedSynchronizations == null) {
            this._interposedSynchronizations = new ArrayList();
        }
        this._interposedSynchronizations.add(synchronization);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "registerInterposedSynchronization");
        }
    }

    public boolean isShareable() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "isShareable", this._shareable);
        }
        return this._shareable;
    }

    void setShareable(boolean bl) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "setShareable", new Object[]{bl, this});
        }
        this._shareable = bl;
    }

    static {
        BOUNDARY_ACTIVITYSESSION = new Byte(0);
        BOUNDARY_BEAN_METHOD = new Byte(1);
    }
}

