/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.LocalTransaction;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.LocalTransaction.InconsistentLocalTranException;
import com.ibm.ws.LocalTransaction.LocalTranCoordImpl;
import com.ibm.ws.LocalTransaction.LocalTransactionCoordinator;
import com.ibm.ws.LocalTransaction.RolledbackException;
import com.ibm.ws.Transaction.TransactionManagerFactory;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.uow.UOWScopeCallbackManager;
import com.ibm.ws.util.PlatformHelperFactory;
import javax.transaction.SystemException;
import javax.transaction.TransactionManager;

public final class LocalTranCurrentImpl {
    private static TransactionManager _currentTM = TransactionManagerFactory.getTransactionManager();
    private LocalTranCoordImpl _coord;
    private static final TraceComponent tc = Tr.register(LocalTranCurrentImpl.class, "Transaction", "com.ibm.ws.LocalTransaction.resources.LocalTranMsgs");
    private static final boolean isZOS = PlatformHelperFactory.getPlatformHelper().isZOS();
    private UOWScopeCallbackManager _callbackManager;

    LocalTranCurrentImpl(UOWScopeCallbackManager uOWScopeCallbackManager) {
        this._callbackManager = uOWScopeCallbackManager;
    }

    public LocalTransactionCoordinator getLocalTranCoord() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "getLocalTranCoord", this._coord);
        }
        return this._coord;
    }

    public void begin() throws IllegalStateException {
        this.begin(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void begin(boolean bl) throws IllegalStateException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "begin", new Object[]{Boolean.toString(bl), this});
        }
        if (isZOS && LocalTranCurrentImpl.globalTranExists()) {
            IllegalStateException illegalStateException = new IllegalStateException("Cannot begin a LocalTransactionCoordinator. A Global transaction is active.");
            Tr.error(tc, "ERR_BEGIN_TX_GLB_ACT");
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "begin", illegalStateException);
            }
            throw illegalStateException;
        }
        if (this._coord != null) {
            IllegalStateException illegalStateException = new IllegalStateException("Cannot begin a LocalTransactionContainment. A LocalTransactionContainment is already active.");
            FFDCFilter.processException((Throwable)illegalStateException, "com.ibm.ws.LocalTransaction.LocalTranCurrentImpl.begin", "141", this);
            Tr.error(tc, "ERR_BEGIN_LTC_ACT");
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "begin", illegalStateException);
            }
            throw illegalStateException;
        }
        try {
            this._coord = new LocalTranCoordImpl(bl, this);
            try {
                this._callbackManager.notifyCallbacks(1, this._coord);
            }
            catch (IllegalStateException illegalStateException) {
                FFDCFilter.processException((Throwable)illegalStateException, "com.ibm.ws.LocalTransaction.LocalTranCurrentImpl.begin", "157", this);
                this._coord.setRollbackOnly();
            }
        }
        finally {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "begin");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void begin(boolean bl, boolean bl2, boolean bl3) throws IllegalStateException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "begin", new Object[]{bl, bl2, Boolean.toString(bl3), this});
        }
        if (isZOS && LocalTranCurrentImpl.globalTranExists()) {
            IllegalStateException illegalStateException = new IllegalStateException("Cannot begin a LocalTransactionCoordinator. A Global transaction is active.");
            Tr.error(tc, "ERR_BEGIN_TX_GLB_ACT");
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "begin", illegalStateException);
            }
            throw illegalStateException;
        }
        if (this._coord != null) {
            IllegalStateException illegalStateException = new IllegalStateException("Cannot begin a LocalTransactionContainment. A LocalTransactionContainment is already active.");
            FFDCFilter.processException((Throwable)illegalStateException, "com.ibm.ws.LocalTransaction.LocalTranCurrentImpl.begin", "205", this);
            Tr.error(tc, "ERR_BEGIN_LTC_ACT");
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "begin", illegalStateException);
            }
            throw illegalStateException;
        }
        try {
            this._coord = new LocalTranCoordImpl(bl, bl2, bl3, this);
        }
        finally {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "begin");
            }
        }
    }

    public void beginShareable(boolean bl, boolean bl2, boolean bl3) throws IllegalStateException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "beginShareable");
        }
        this.begin(bl, bl2, bl3);
        this._coord.setShareable(true);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "beginShareable");
        }
    }

    public LocalTransactionCoordinator suspend() {
        LocalTranCoordImpl localTranCoordImpl;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "suspend", this);
        }
        if ((localTranCoordImpl = this._coord) != null) {
            this._coord = null;
            localTranCoordImpl.suspend();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "suspend", localTranCoordImpl);
        }
        return localTranCoordImpl;
    }

    public void resume(LocalTransactionCoordinator localTransactionCoordinator) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "resume", new Object[]{localTransactionCoordinator, this});
        }
        if (isZOS && LocalTranCurrentImpl.globalTranExists()) {
            IllegalStateException illegalStateException = new IllegalStateException("Cannot begin a LocalTransactionCoordinator. A Global transaction is active.");
            Tr.error(tc, "ERR_RESUME_TX_GLB_ACT");
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "resume", illegalStateException);
            }
            throw illegalStateException;
        }
        if (localTransactionCoordinator != null && this._coord != null) {
            IllegalStateException illegalStateException = new IllegalStateException();
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "resume", illegalStateException);
            }
            throw illegalStateException;
        }
        this._coord = (LocalTranCoordImpl)localTransactionCoordinator;
        if (this._coord != null) {
            this._coord.resume(this);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "resume");
        }
    }

    public boolean hasOutstandingWork() {
        boolean bl;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "hasOutstandingWork", this);
        }
        boolean bl2 = bl = this._coord != null ? this._coord.hasWork() : false;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "hasOutstandingWork", bl);
        }
        return bl;
    }

    static boolean globalTranExists() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "globalTranExists");
        }
        boolean bl = false;
        try {
            bl = _currentTM.getTransaction() != null;
        }
        catch (SystemException systemException) {
            // empty catch block
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "globalTranExists", bl);
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void complete(int n) throws InconsistentLocalTranException, RolledbackException, IllegalStateException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "complete", new Object[]{new Integer(n), this});
        }
        if (this._coord == null) {
            IllegalStateException illegalStateException = new IllegalStateException("No LocalTransactionCoordinator to complete.");
            FFDCFilter.processException((Throwable)illegalStateException, "com.ibm.ws.LocalTransaction.LocalTranCurrentImpl.complete", "382", this);
            Tr.error(tc, "ERR_NO_LTC_COMPLETE");
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "complete", illegalStateException);
            }
            throw illegalStateException;
        }
        try {
            this._coord.complete(n);
        }
        finally {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "complete");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanup() throws InconsistentLocalTranException, IllegalStateException, RolledbackException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "cleanup", this);
        }
        if (this._coord == null) {
            IllegalStateException illegalStateException = new IllegalStateException("No LocalTransactionCoordinator to cleanup.");
            FFDCFilter.processException((Throwable)illegalStateException, "com.ibm.ws.LocalTransaction.LocalTranCurrentImpl.cleanup", "421", this);
            Tr.error(tc, "ERR_NO_LTC_CLEANUP");
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "cleanup", illegalStateException);
            }
            throw illegalStateException;
        }
        try {
            this._coord.cleanup();
        }
        finally {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "cleanup");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void end(int n) throws InconsistentLocalTranException, RolledbackException, IllegalStateException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "end", new Object[]{new Integer(n), this});
        }
        if (this._coord == null) {
            IllegalStateException illegalStateException = new IllegalStateException("No LocalTransactionCoordinator to end.");
            FFDCFilter.processException((Throwable)illegalStateException, "com.ibm.ws.LocalTransaction.LocalTranCurrentImpl.end", "469", this);
            Tr.error(tc, "ERR_NO_LTC_CLEANUP");
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "end", illegalStateException);
            }
            throw illegalStateException;
        }
        try {
            this._coord.end(n);
        }
        finally {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "end");
            }
        }
    }

    void setCoordinator(LocalTranCoordImpl localTranCoordImpl) {
        this._coord = localTranCoordImpl;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "setCoordinator: LTC=" + localTranCoordImpl);
        }
    }
}

