/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.Transaction.JTA;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.recoverylog.spi.FailureScope;

public final class EpochFailureScope
implements FailureScope {
    private static final TraceComponent tc = Tr.register(EpochFailureScope.class, "Transaction", "com.ibm.ws.Transaction.resources.TransactionMsgs");
    public static final int EFS_VERSION1 = 1;
    public static final int EFS_VERSION2 = 2;
    public static final int EFS_VERSION3 = 3;
    public static final int EFS_CURRENT_VERSION = 3;
    private Integer _hashCode;
    private long _epoch;
    private boolean _recovery;
    private int _version;
    private String _serverName;

    public EpochFailureScope(long l, boolean bl, String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "<init>", new Object[]{new Long(l), new Boolean(bl), string});
        }
        this._epoch = l;
        this._recovery = bl;
        this._serverName = string;
        this._version = 3;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "<init>", this);
        }
    }

    public boolean isContainedBy(FailureScope failureScope) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isContainedBy", failureScope);
        }
        boolean bl = false;
        if (failureScope instanceof EpochFailureScope && failureScope.serverName().equals(this.serverName())) {
            EpochFailureScope epochFailureScope = (EpochFailureScope)failureScope;
            if (epochFailureScope.getRecovery()) {
                if (this._epoch < epochFailureScope.getEpoch()) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Including this FailureScope because a recovery FailureScope was requested and this FailureScope has an epoch less than the requested epoch", this);
                    }
                    bl = true;
                }
            } else if (this._epoch >= epochFailureScope.getEpoch()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Including this FailureScope because a non-recovery FailureScope was requested and this FailureScope has an epoch greater than or equal to the requested epoch", this);
                }
                bl = true;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isContainedBy", new Boolean(bl));
        }
        return bl;
    }

    public long getEpoch() {
        return this._epoch;
    }

    public boolean getRecovery() {
        return this._recovery;
    }

    public int hashCode() {
        int n = 0;
        if (this._hashCode == null) {
            n += (int)(this._epoch % Integer.MAX_VALUE) / 4;
            n += this._version / 4;
            n += this._serverName.hashCode() / 4;
            if (this._recovery) {
                ++n;
            }
            this._hashCode = new Integer(n);
        } else {
            n = this._hashCode;
        }
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof EpochFailureScope) {
            EpochFailureScope epochFailureScope = (EpochFailureScope)object;
            if (epochFailureScope._version == this._version && epochFailureScope._recovery == this._recovery && epochFailureScope._epoch == this._epoch && epochFailureScope._serverName == this._serverName) {
                return true;
            }
        }
        return false;
    }

    public String serverName() {
        return this._serverName;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(super.toString());
        stringBuffer.append("(Version = ");
        stringBuffer.append(this._version);
        stringBuffer.append(", Epoch = ");
        stringBuffer.append(this._epoch);
        stringBuffer.append(", Recovery = ");
        stringBuffer.append(this._recovery);
        stringBuffer.append(", Server Name = ");
        stringBuffer.append(this._serverName);
        stringBuffer.append(") ");
        return stringBuffer.toString();
    }

    public boolean isSameExecutionZone(FailureScope failureScope) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isSameExecutionZone", failureScope);
            Tr.exit(tc, "isSameExecutionZone", new Boolean(false));
        }
        return false;
    }
}

