/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.Transaction.JTA;

import com.ibm.CORBA.iiop.ORB;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.Transaction.JTA.FailureScopeLifeCycle;
import com.ibm.ws.Transaction.JTA.FailureScopeLifeCycleHelper;
import com.ibm.ws.Transaction.JTA.PartnerLogTable;
import com.ibm.ws.Transaction.JTA.RecoveryManager;
import com.ibm.ws.Transaction.JTA.TransactionImpl;
import com.ibm.ws.Transaction.JTS.Configuration;
import com.ibm.ws.Transaction.JTS.CoordinatorResource;
import com.ibm.ws.Transaction.JTS.JTSServantManager;
import com.ibm.ws.Transaction.JTS.WSCoordinator;
import com.ibm.ws.Transaction.JTS.WSCoordinatorImpl;
import com.ibm.ws.Transaction.TxProperties;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.recoverylog.spi.FailureScope;
import com.ibm.ws.recoverylog.spi.RecoveryAgent;
import com.ibm.ws.recoverylog.spi.RecoveryDirectorFactory;
import com.ibm.ws.recoverylog.spi.RecoveryLog;
import com.ibm.ws.util.PlatformHelper;
import com.ibm.ws.util.PlatformHelperFactory;
import com.ibm.ws390.tx.TransactionJcaRecoveryCoordinator;
import com.ibm.wsspi.cluster.Identity;
import java.util.HashSet;
import javax.transaction.SystemException;
import org.omg.CosTransactions.Coordinator;
import org.omg.CosTransactions.RecoveryCoordinator;

public final class FailureScopeController {
    private static final TraceComponent tc = Tr.register(FailureScopeController.class, "Transaction", "com.ibm.ws.Transaction.resources.TransactionMsgs");
    private FailureScope _failureScope;
    private String _serverName;
    private RecoveryLog _tranLog;
    private RecoveryLog _xaLog;
    private RecoveryLog _recoverXaLog;
    private PartnerLogTable _partnerLogTable;
    private final boolean _localFailureScope;
    private WSCoordinatorImpl _WSCoordinator;
    private JTSServantManager _CoordinatorResourceServantManager;
    private JTSServantManager _RecoveryCoordinatorServantManager;
    private JTSServantManager _WSCoordinatorServantManager;
    private JTSServantManager _CoordinatorServantManager;
    private JTSServantManager _jcaRecoveryCoordinatorServantManager;
    private RecoveryCoordinator _jcaRecoveryCoordinator;
    private String jcaKeyString = "JCA_RECOVERY_COORDINATOR_KEY";
    private final byte[] JCA_REC_COORD_KEY = this.jcaKeyString.getBytes();
    private RecoveryManager _recoveryManager;
    private FailureScopeLifeCycle _fslc;
    private final HashSet _transactions;

    public FailureScopeController(FailureScope failureScope) throws SystemException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "FailureScopeController", failureScope);
        }
        this._failureScope = failureScope;
        this._serverName = failureScope.serverName();
        this._transactions = new HashSet();
        this._localFailureScope = this._serverName.equals(Configuration.getServerName());
        this._partnerLogTable = new PartnerLogTable(this);
        ORB oRB = (ORB)Configuration.getORB();
        Identity identity = null;
        try {
            identity = RecoveryDirectorFactory.recoveryDirector().clusterIdentity(failureScope);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.Transaction.JTA.FailureScopeController.FailureScopeController", "101", this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception caught whist obtaining RecoveryDirector reference", exception);
            }
            throw new SystemException(exception.toString());
        }
        PlatformHelper platformHelper = PlatformHelperFactory.getPlatformHelper();
        if (!platformHelper.isZOS() || platformHelper.isControlJvm()) {
            this._CoordinatorResourceServantManager = new JTSServantManager(oRB, "JTS/CR/" + this._serverName, this, identity);
            this._RecoveryCoordinatorServantManager = new JTSServantManager(oRB, "JTS/RC/" + this._serverName, this, identity);
            if (!platformHelper.isZOS()) {
                this._WSCoordinatorServantManager = new JTSServantManager(oRB, "JTS/WSC/" + this._serverName, this, identity);
            } else {
                this._CoordinatorServantManager = new JTSServantManager(oRB, "JTS/C/" + this._serverName, this, identity);
                this._jcaRecoveryCoordinatorServantManager = new JTSServantManager(oRB, "JTS/JRC/" + this._serverName, this, identity);
                this._jcaRecoveryCoordinator = new TransactionJcaRecoveryCoordinator();
                this._jcaRecoveryCoordinatorServantManager.register(this._jcaRecoveryCoordinator, this.JCA_REC_COORD_KEY);
            }
        }
        if (TxProperties.JTA2_INTEROP_SUPPORTED) {
            this._WSCoordinator = new WSCoordinatorImpl(this);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "FailureScopeController", this);
        }
    }

    public RecoveryLog getTransactionLog() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "getTransactionLog", new Object[]{this, this._tranLog});
        }
        return this._tranLog;
    }

    public RecoveryLog getPartnerLog() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "getPartnerLog", new Object[]{this, this._xaLog});
        }
        return this._xaLog;
    }

    public RecoveryLog getRecoveryPartnerLog() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "getRecoveryPartnerLog", new Object[]{this, this._recoverXaLog});
        }
        return this._recoverXaLog;
    }

    public PartnerLogTable getPartnerLogTable() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "getPartnerLogTable", new Object[]{this, this._partnerLogTable});
        }
        return this._partnerLogTable;
    }

    public WSCoordinator getWSCoordinator() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "getWSCoordinator", new Object[]{this, this._WSCoordinator});
        }
        return this._WSCoordinator;
    }

    public void registerWSCoordinator(byte[] byArray) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "registerWSCoordinator", new Object[]{this, byArray});
        }
        if (this._WSCoordinator != null) {
            this._WSCoordinator.setKey(byArray);
            this._WSCoordinatorServantManager.register(this._WSCoordinator, byArray);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "registerWSCoordinator");
        }
    }

    public void unregisterWSCoordinator(byte[] byArray) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "unregisterWSCoordinator", new Object[]{this, byArray});
        }
        if (this._WSCoordinator != null) {
            this._WSCoordinatorServantManager.unregister(byArray);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "unregisterWSCoordinator");
        }
    }

    public void registerCoordinatorResource(CoordinatorResource coordinatorResource, byte[] byArray) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "registerCoordinatorResource", new Object[]{this, coordinatorResource, byArray});
        }
        this._CoordinatorResourceServantManager.register(coordinatorResource, byArray);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "registerCoordinatorResource");
        }
    }

    public void unregisterCoordinatorResource(byte[] byArray) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "unregisterCoordinatorResource", new Object[]{this, byArray});
        }
        this._CoordinatorResourceServantManager.unregister(byArray);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "unregisterCoordinatorResource");
        }
    }

    public void registerCoordinator(Coordinator coordinator, byte[] byArray) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "registerCoordinator", new Object[]{coordinator, byArray});
        }
        if (this._CoordinatorServantManager != null) {
            this._CoordinatorServantManager.register(coordinator, byArray);
        } else if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event(tc, "No coordinator servant manager");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "registerCoordinator");
        }
    }

    public void unregisterCoordinator(byte[] byArray) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "unregisterCoordinator", byArray);
        }
        if (this._CoordinatorServantManager != null) {
            this._CoordinatorServantManager.unregister(byArray);
        } else if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event(tc, "No coordinator servant manager");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "unregisterCoordinator");
        }
    }

    public void registerRecoveryCoordinator(RecoveryCoordinator recoveryCoordinator, byte[] byArray) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "registerRecoveryCoordinator", new Object[]{this, recoveryCoordinator, byArray});
        }
        this._RecoveryCoordinatorServantManager.register(recoveryCoordinator, byArray);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "registerRecoveryCoordinator");
        }
    }

    public void unregisterRecoveryCoordinator(byte[] byArray) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "unregisterRecoveryCoordinator", new Object[]{this, byArray});
        }
        this._RecoveryCoordinatorServantManager.unregister(byArray);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "unregisterRecoveryCoordinator");
        }
    }

    public boolean localFailureScope() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "localFailureScope", new Object[]{this, new Boolean(this._localFailureScope)});
        }
        return this._localFailureScope;
    }

    public String serverName() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "serverName", new Object[]{this, this._serverName});
        }
        return this._serverName;
    }

    public RecoveryManager createRecoveryManager(RecoveryAgent recoveryAgent, RecoveryLog recoveryLog, RecoveryLog recoveryLog2, RecoveryLog recoveryLog3, byte[] byArray, int n) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "createRecoveryManager", new Object[]{this, recoveryAgent, recoveryLog, recoveryLog2, recoveryLog3, byArray, new Integer(n)});
        }
        this._tranLog = recoveryLog;
        this._xaLog = recoveryLog2;
        this._recoverXaLog = recoveryLog3;
        this._recoveryManager = new RecoveryManager(this, recoveryAgent, recoveryLog, recoveryLog2, recoveryLog3, byArray, n);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "createRecoveryManager", this._recoveryManager);
        }
        return this._recoveryManager;
    }

    public RecoveryManager getRecoveryManager() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "getRecoveryManager", new Object[]{this, this._recoveryManager});
        }
        return this._recoveryManager;
    }

    public void shutdown(boolean bl) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "shutdown", new Object[]{this, bl});
        }
        if (bl && !this._localFailureScope) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "shutdown", illegalArgumentException);
            }
            FFDCFilter.processException((Throwable)illegalArgumentException, "com.ibm.ws.Transaction.JTA.FailureScopeController.shutdown", "419", this);
            throw illegalArgumentException;
        }
        if (!(bl || this._recoveryManager != null && this._recoveryManager.recoveryPrevented())) {
            boolean bl2 = false;
            this._CoordinatorResourceServantManager.shutdown();
            this._RecoveryCoordinatorServantManager.shutdown();
            if (this._WSCoordinatorServantManager != null) {
                this._WSCoordinatorServantManager.shutdown();
            }
            if (this._CoordinatorServantManager != null) {
                this._CoordinatorServantManager.shutdown();
            }
            if (this._jcaRecoveryCoordinatorServantManager != null) {
                this._jcaRecoveryCoordinatorServantManager.unregister(this.JCA_REC_COORD_KEY);
                this._jcaRecoveryCoordinatorServantManager.shutdown();
            }
            if (this._recoveryManager != null) {
                this._recoveryManager.prepareToShutdown();
            }
            FailureScopeLifeCycleHelper.removeFromActiveList(this._fslc);
            if (this._localFailureScope) {
                this._partnerLogTable.terminate();
                TransactionImpl[] transactionImplArray = this.getAllTransactions();
                boolean bl3 = transactionImplArray != null && transactionImplArray.length > 0;
                boolean bl4 = true;
                try {
                    PartnerLogTable partnerLogTable = null;
                    if (this._recoveryManager != null) {
                        this._recoveryManager.preShutdown(bl3);
                        partnerLogTable = this._recoveryManager.getPartnerLogTable();
                    }
                    bl4 = this.shutdown(transactionImplArray, partnerLogTable);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (this._recoveryManager != null) {
                    this._recoveryManager.postShutdown(bl4);
                }
                if (!bl4) {
                    Tr.audit(tc, "WTRN0105_CLEAN_SHUTDOWN");
                } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled() && bl4) {
                    Tr.debug(tc, "Not a clean shutdown", new Object[]{new Boolean(bl), new Boolean(this._localFailureScope)});
                }
            } else if (this._recoveryManager != null) {
                this._recoveryManager.cleanupRemoteFailureScope();
            }
            this._tranLog = null;
            this._xaLog = null;
            this._recoverXaLog = null;
            this._recoveryManager = null;
            this._failureScope = null;
            this._serverName = null;
            this._partnerLogTable = null;
            this._WSCoordinator = null;
            this._CoordinatorResourceServantManager = null;
            this._RecoveryCoordinatorServantManager = null;
            this._WSCoordinatorServantManager = null;
            this._jcaRecoveryCoordinatorServantManager = null;
            this._fslc = null;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "shutdown");
        }
    }

    private boolean shutdown(TransactionImpl[] transactionImplArray, PartnerLogTable partnerLogTable) {
        boolean bl;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "shutdown", new Object[]{transactionImplArray, partnerLogTable});
        }
        if (transactionImplArray != null) {
            for (bl = false; bl < transactionImplArray.length; bl += 1) {
                TransactionImpl transactionImpl = transactionImplArray[bl];
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    Tr.event(tc, "Transaction " + transactionImpl + " is still active");
                }
                transactionImpl.shutdown();
            }
        }
        if (partnerLogTable != null) {
            this._partnerLogTable.merge(partnerLogTable);
        }
        bl = this._partnerLogTable.shutdown();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "shutdown", bl);
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerTransaction(TransactionImpl transactionImpl, boolean bl) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "registerTransaction", new Object[]{this, transactionImpl, new Boolean(bl)});
        }
        FailureScopeController failureScopeController = this;
        synchronized (failureScopeController) {
            this._transactions.add(transactionImpl);
            if (bl) {
                this._recoveryManager.registerTransaction(transactionImpl);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "registerTransaction");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deregisterTransaction(TransactionImpl transactionImpl, boolean bl) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "deregisterTransaction", new Object[]{this, transactionImpl, new Boolean(bl)});
        }
        FailureScopeController failureScopeController = this;
        synchronized (failureScopeController) {
            this._transactions.remove(transactionImpl);
            if (bl) {
                this._recoveryManager.deregisterTransaction(transactionImpl);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "deregisterTransaction");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TransactionImpl[] getAllTransactions() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getAllTransactions", this);
        }
        TransactionImpl[] transactionImplArray = null;
        FailureScopeController failureScopeController = this;
        synchronized (failureScopeController) {
            int n = this._transactions.size();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Found " + n + " active transaction(s)");
            }
            transactionImplArray = new TransactionImpl[n];
            this._transactions.toArray(transactionImplArray);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getAllTransactions", transactionImplArray);
        }
        return transactionImplArray;
    }

    public FailureScope failureScope() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "failureScope", this._failureScope);
        }
        return this._failureScope;
    }

    public FailureScopeLifeCycle getFailureScopeLifeCycle() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "getFailureScopeLifeCycle", this._fslc);
        }
        return this._fslc;
    }

    public void setFailureScopeLifeCycle(FailureScopeLifeCycle failureScopeLifeCycle) {
        this._fslc = failureScopeLifeCycle;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "setFailureScopeLifeCycle", this._fslc);
        }
    }

    public RecoveryCoordinator getJcaRecoveryCoordinator() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "getJcaRecoveryCoordinator", this._jcaRecoveryCoordinator);
        }
        return this._jcaRecoveryCoordinator;
    }
}

