/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.Transaction.JTA;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.LocalTransaction.LocalTranCurrentSet;
import com.ibm.ws.LocalTransaction.LocalTransactionCoordinator;
import com.ibm.ws.Transaction.JTA.HeuristicHazardException;
import com.ibm.ws.Transaction.JTA.JCARecoveryData;
import com.ibm.ws.Transaction.JTA.JCATranWrapper;
import com.ibm.ws.Transaction.JTA.ResourceWrapper;
import com.ibm.ws.Transaction.JTA.TranManagerSet;
import com.ibm.ws.Transaction.JTA.TransactionImpl;
import com.ibm.ws.Transaction.JTA.TxXATerminator;
import com.ibm.ws.ffdc.FFDCFilter;
import javax.transaction.HeuristicCommitException;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.InvalidTransactionException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;

public final class JCATranWrapperImpl
implements JCATranWrapper {
    private static final TraceComponent tc = Tr.register(JCATranWrapperImpl.class, "Transaction", "com.ibm.ws.Transaction.resources.TransactionMsgs");
    private final TransactionImpl _txn;
    private static final TranManagerSet _tranManager = TranManagerSet.instance();
    private boolean _prepared;
    private boolean _associated;
    private int _heuristic;
    private int _suspendedUOWType;
    private Object _suspendedUOW;

    public JCATranWrapperImpl(TransactionImpl transactionImpl, boolean bl, boolean bl2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "JCATranWrapper", new Object[]{transactionImpl, new Boolean(bl), new Boolean(bl2)});
        }
        this._txn = transactionImpl;
        this._prepared = bl;
        this._associated = bl2;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "JCATranWrapper", this);
        }
    }

    public JCATranWrapperImpl(int n, Xid xid, JCARecoveryData jCARecoveryData) throws SystemException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "JCATranWrapper", new Object[]{new Integer(n), xid, jCARecoveryData});
        }
        this.suspend();
        this._txn = new TransactionImpl(n, xid, jCARecoveryData);
        this._prepared = false;
        this._associated = true;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "JCATranWrapper", this);
        }
    }

    public int prepare(TxXATerminator txXATerminator) throws XAException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "prepare", this._txn);
        }
        if (_tranManager.isReplayComplete()) {
            this.suspend();
            try {
                _tranManager.resume(this._txn);
            }
            catch (InvalidTransactionException invalidTransactionException) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "prepare", new Object[]{"resume threw InvalidTransactionException", invalidTransactionException});
                }
                this.resume();
                throw new XAException(-3);
            }
            catch (IllegalStateException illegalStateException) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "prepare", new Object[]{"resume threw IllegalStateException", illegalStateException});
                }
                this.resume();
                throw new XAException(-6);
            }
            this._txn.setJCARecoveryData(txXATerminator.getJCARecoveryData());
            try {
                int n = this._txn.internalPrepare();
                switch (n) {
                    case 2: {
                        this._prepared = true;
                        if (tc.isEntryEnabled()) {
                            Tr.exit(tc, "prepare", "XAResource.XA_OK");
                        }
                        int n2 = 0;
                        return n2;
                    }
                    case 4: {
                        this._txn.notifyCompletion();
                        if (tc.isEntryEnabled()) {
                            Tr.exit(tc, "prepare", "XAResource.XA_RDONLY");
                        }
                        int n3 = 3;
                        return n3;
                    }
                }
                try {
                    this._txn.internalRollback();
                    this._txn.notifyCompletion();
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "prepare", "throwing XA_RBROLLBACK");
                    }
                    throw new XAException(100);
                }
                catch (HeuristicMixedException heuristicMixedException) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "prepare", "internalPrepare threw HeuristicMixedException");
                    }
                    try {
                        this._txn.internalRollback();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    throw new XAException(5);
                }
                catch (HeuristicHazardException heuristicHazardException) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "prepare", "internalPrepare threw HeuristicHazardException");
                    }
                    try {
                        this._txn.internalRollback();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    throw new XAException(8);
                }
                catch (HeuristicRollbackException heuristicRollbackException) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "prepare", "internalPrepare threw HeuristicRollbackException");
                    }
                    throw new XAException(6);
                }
                catch (HeuristicCommitException heuristicCommitException) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "prepare", "internalPrepare threw HeuristicCommitException");
                    }
                    throw new XAException(7);
                }
                catch (IllegalStateException illegalStateException) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "prepare", "internalPrepare threw IllegalStateException");
                    }
                    throw new XAException(-6);
                }
                catch (SystemException systemException) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "prepare", "internalPrepare threw SystemException");
                    }
                    throw new XAException(-3);
                }
            }
            finally {
                _tranManager.suspend();
                this.resume();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "prepare", "replay not finished");
        }
        throw new XAException(-7);
    }

    public void commit() throws XAException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "commit", this._txn);
        }
        if (_tranManager.isReplayComplete()) {
            int n = this._txn.getTransactionState().getState();
            switch (n) {
                case 2: {
                    try {
                        this.suspend();
                        try {
                            TranManagerSet.instance().resume(this._txn);
                        }
                        catch (InvalidTransactionException invalidTransactionException) {
                            if (tc.isEntryEnabled()) {
                                Tr.exit(tc, "prepare", new Object[]{"resume threw InvalidTransactionException", invalidTransactionException});
                            }
                            this.resume();
                            throw new XAException(-3);
                        }
                        catch (IllegalStateException illegalStateException) {
                            if (tc.isEntryEnabled()) {
                                Tr.exit(tc, "prepare", new Object[]{"resume threw IllegalStateException", illegalStateException});
                            }
                            this.resume();
                            throw new XAException(-6);
                        }
                        this._txn.getTransactionState().setState(3);
                        this._txn.internalCommit();
                        this._txn.notifyCompletion();
                        break;
                    }
                    catch (HeuristicMixedException heuristicMixedException) {
                        this._heuristic = 10;
                        break;
                    }
                    catch (HeuristicHazardException heuristicHazardException) {
                        this._heuristic = 11;
                        break;
                    }
                    catch (HeuristicRollbackException heuristicRollbackException) {
                        this._heuristic = 9;
                        break;
                    }
                    catch (SystemException systemException) {
                        if (tc.isEntryEnabled()) {
                            Tr.exit(tc, "commit", "internalCommit threw SystemException");
                        }
                        throw new XAException(-3);
                    }
                    finally {
                        this.resume();
                    }
                }
                case 7: 
                case 8: {
                    this._heuristic = this._txn.getResources().getHeuristicOutcome();
                    if (!tc.isDebugEnabled()) break;
                    Tr.debug(tc, "Heuristic was: " + ResourceWrapper.printResourceStatus(this._heuristic));
                    break;
                }
                case 3: 
                case 4: {
                    break;
                }
                case 5: 
                case 6: {
                    this._heuristic = 9;
                    break;
                }
                case -1: {
                    break;
                }
                default: {
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "commit", "transaction is not in a prepared state");
                    }
                    throw new XAException(-6);
                }
            }
            switch (this._heuristic) {
                case 0: {
                    break;
                }
                case 8: {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Swallowing HEURISTIC_COMMIT");
                    }
                    this._txn.notifyCompletion();
                    break;
                }
                case 9: {
                    this._txn.addHeuristic();
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "commit", "throwing XA_HEURB");
                    }
                    throw new XAException(6);
                }
                case 11: {
                    this._txn.addHeuristic();
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "commit", "throwing XA_HEURHAZ");
                    }
                    throw new XAException(8);
                }
                default: {
                    this._txn.addHeuristic();
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "commit", "throwing XA_HEURMIX");
                    }
                    throw new XAException(5);
                }
            }
        } else {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "commit", "throwing XAER_RMFAIL");
            }
            throw new XAException(-7);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "commit");
        }
    }

    public void commitOnePhase() throws XAException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "commitOnePhase", this._txn);
        }
        int n = this._txn.getTransactionState().getState();
        switch (n) {
            case 0: {
                this.suspend();
                try {
                    _tranManager.resume(this._txn);
                    this._txn.prolongFinish();
                    this._txn.commit_one_phase();
                    this._txn.notifyCompletion();
                    break;
                }
                catch (RollbackException rollbackException) {
                    this._txn.notifyCompletion();
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "commitOnePhase", "commit threw RollbackException");
                    }
                    throw new XAException(100);
                }
                catch (HeuristicMixedException heuristicMixedException) {
                    this._heuristic = 10;
                    break;
                }
                catch (HeuristicHazardException heuristicHazardException) {
                    this._heuristic = 11;
                    break;
                }
                catch (HeuristicRollbackException heuristicRollbackException) {
                    this._heuristic = 9;
                    break;
                }
                catch (IllegalStateException illegalStateException) {
                    this._txn.notifyCompletion();
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "commitOnePhase", "commit threw IllegalStateException");
                    }
                    throw new XAException(-6);
                }
                catch (InvalidTransactionException invalidTransactionException) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "commitOnePhase", "commit threw InvalidTransactionException");
                    }
                    throw new XAException(-3);
                }
                catch (SystemException systemException) {
                    this._txn.notifyCompletion();
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "commitOnePhase", "commit threw SystemException");
                    }
                    throw new XAException(-3);
                }
                finally {
                    this.resume();
                }
            }
            case 3: 
            case 4: {
                break;
            }
            case 5: 
            case 6: 
            case 8: {
                this._heuristic = 9;
                break;
            }
            case 7: {
                this._heuristic = 8;
                break;
            }
            case -1: {
                break;
            }
            default: {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "commitOnePhase", "transaction is in an incorrect state");
                }
                throw new XAException(-6);
            }
        }
        switch (this._heuristic) {
            case 0: {
                break;
            }
            case 9: {
                this._txn.notifyCompletion();
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "commitOnePhase", "heuristic rollback");
                }
                throw new XAException(100);
            }
            case 10: {
                this._txn.addHeuristic();
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "commitOnePhase", "heuristic mixed");
                }
                throw new XAException(5);
            }
            default: {
                this._txn.addHeuristic();
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "commitOnePhase", "heuristic hazard");
                }
                throw new XAException(8);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "commitOnePhase");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void rollback() throws XAException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "rollback", this._txn);
        }
        if (this._prepared && !_tranManager.isReplayComplete()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "rollback", "throwing XAER_RMFAIL(1)");
            }
            throw new XAException(-7);
        }
        int n = this._txn.getTransactionState().getState();
        switch (n) {
            case 0: 
            case 2: {
                try {
                    this.suspend();
                    try {
                        TranManagerSet.instance().resume(this._txn);
                    }
                    catch (InvalidTransactionException invalidTransactionException) {
                        if (tc.isEntryEnabled()) {
                            Tr.exit(tc, "prepare", new Object[]{"resume threw InvalidTransactionException", invalidTransactionException});
                        }
                        this.resume();
                        throw new XAException(-3);
                    }
                    catch (IllegalStateException illegalStateException) {
                        if (tc.isEntryEnabled()) {
                            Tr.exit(tc, "prepare", new Object[]{"resume threw IllegalStateException", illegalStateException});
                        }
                        this.resume();
                        throw new XAException(-6);
                    }
                    this._txn.getTransactionState().setState(5);
                    this._txn.internalRollback();
                    this._txn.notifyCompletion();
                    break;
                }
                catch (IllegalStateException illegalStateException) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "rollback", "throwing XAER_PROTO(1)");
                    }
                    throw new XAException(-6);
                }
                catch (SystemException systemException) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "rollback", "throwing XAER_RMERR");
                    }
                    throw new XAException(-3);
                }
                catch (HeuristicMixedException heuristicMixedException) {
                    this._heuristic = 10;
                    break;
                }
                catch (HeuristicHazardException heuristicHazardException) {
                    this._heuristic = 11;
                    break;
                }
                catch (HeuristicCommitException heuristicCommitException) {
                    this._heuristic = 8;
                    break;
                }
                finally {
                    this.resume();
                }
            }
            case 7: 
            case 8: {
                this._heuristic = this._txn.getResources().getHeuristicOutcome();
                break;
            }
            case 5: 
            case 6: {
                break;
            }
            case -1: {
                break;
            }
            default: {
                this._txn.notifyCompletion();
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "rollback", "throwing XAER_PROTO(2)");
                }
                throw new XAException(-6);
            }
        }
        switch (this._heuristic) {
            case 0: {
                break;
            }
            case 9: {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Swallowing HEURISTIC_ROLLBACK");
                }
                this._txn.notifyCompletion();
                break;
            }
            case 11: {
                this._txn.addHeuristic();
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "rollback", "throwing XA_HEURHAZ");
                }
                throw new XAException(8);
            }
            case 8: {
                this._txn.addHeuristic();
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "rollback", "throwing XA_HEURCOM");
                }
                throw new XAException(7);
            }
            default: {
                this._txn.addHeuristic();
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "rollback", "throwing XA_HEURMIX");
                }
                throw new XAException(5);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "rollback");
        }
    }

    public synchronized void forget() throws XAException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "forget", this._txn);
        }
        if (!_tranManager.isReplayComplete()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "forget", "throwing XAER_RMFAIL");
            }
            throw new XAException(-7);
        }
        this._heuristic = 0;
        this._txn.notifyCompletion();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "forget");
        }
    }

    public void suspend() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "suspend");
        }
        this._suspendedUOWType = _tranManager.getUOWType();
        switch (this._suspendedUOWType) {
            case 1: {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    Tr.event(tc, "suspending (local)");
                }
                this._suspendedUOW = LocalTranCurrentSet.instance().suspend();
                break;
            }
            case 2: {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    Tr.event(tc, "suspending (global)");
                }
                this._suspendedUOW = _tranManager.suspend();
                break;
            }
            case 0: {
                this._suspendedUOW = null;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "suspend", new Integer(this._suspendedUOWType));
        }
    }

    public void resume() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "resume");
        }
        switch (this._suspendedUOWType) {
            case 1: {
                LocalTranCurrentSet.instance().resume((LocalTransactionCoordinator)this._suspendedUOW);
                break;
            }
            case 2: {
                try {
                    _tranManager.resume((Transaction)this._suspendedUOW);
                    break;
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, "com.ibm.ws.Transaction.JTA.JCATranWrapperImpl.resume", "733", this);
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break;
                    Tr.debug(tc, "Failed to resume", new Object[]{this._suspendedUOW, exception});
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "resume");
        }
    }

    public TransactionImpl getTransaction() {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getTransaction", this._txn);
        }
        return this._txn;
    }

    public boolean isPrepared() {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "isPrepared", new Boolean(this._prepared));
        }
        return this._prepared;
    }

    public boolean hasAssociation() {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "hasAssociation", new Boolean(this._associated));
        }
        return this._associated;
    }

    public void addAssociation() {
        this._associated = true;
    }

    public void removeAssociation() {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "removeAssociation", new Boolean(this._associated));
        }
        this._associated = false;
    }

    public String toString() {
        return this._prepared + ":" + this._associated + ":" + this._heuristic + ":" + this._txn.toString();
    }
}

