/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.Transaction.JTA;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.Transaction.JTA.JTAResource;
import com.ibm.ws.Transaction.JTA.ResourceSupportsOnePhaseCommit;
import com.ibm.ws.Transaction.JTA.ResourceWrapper;
import com.ibm.ws.Transaction.JTA.Util;
import com.ibm.ws.Transaction.JTA.XAReturnCodeHelper;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.recoverylog.spi.RecoverableUnitSection;
import javax.transaction.SystemException;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.omg.CosTransactions.Vote;

public abstract class JTAResourceBase
extends ResourceWrapper
implements JTAResource,
ResourceSupportsOnePhaseCommit {
    protected int _state = 0;
    protected Xid _xid;
    protected XAResource _resource;
    protected boolean _supportSuspend = true;
    protected boolean _supportResume = true;
    protected Vote _vote;
    protected int _prepareXARC = 0;
    protected int _completionXARC = 0;
    protected boolean _completedCommit;
    public static final int OUTCOME_DIAGNOSTICS = 0;
    public static final int PREPARE_DIAGNOSTICS = 1;
    private static final TraceComponent tc = Tr.register(JTAResourceBase.class, "Transaction", "com.ibm.ws.Transaction.resources.TransactionMsgs");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void start() throws XAException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "start", new Object[]{this._resource, JTAResourceBase.printState(this._state)});
        }
        try {
            int n;
            switch (this._state) {
                case 0: {
                    n = 0;
                    break;
                }
                case 6: {
                    n = 0x200000;
                    break;
                }
                case 2: {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        Tr.exit(tc, "startAssociation");
                    }
                    return;
                }
                case 1: {
                    if (!this._supportResume) {
                        Tr.warning(tc, "WTRN0021_TMRESUME_NOT_SUPPORTED");
                        throw new XAException(-5);
                    }
                    n = 0x8000000;
                    break;
                }
                case 4: {
                    throw new XAException(100);
                }
                default: {
                    Tr.warning(tc, "WTRN0022_UNKNOWN_XARESOURCE_STATE");
                }
                case 3: 
                case 5: {
                    throw new XAException(-6);
                }
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event(tc, "xa_start with flag: " + Util.printFlag(n));
            }
            this._resource.start(this._xid, n);
            this._state = 2;
        }
        catch (XAException xAException) {
            this.processXAException("start", xAException);
            if (xAException.errorCode >= 100 && xAException.errorCode <= 107) {
                this._state = 4;
            } else if (xAException.errorCode != -9) {
                this._state = 3;
            }
            throw xAException;
        }
        catch (Throwable throwable) {
            this._state = 3;
            this.processThrowable("start", throwable);
        }
        finally {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "start");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void end(int n) throws XAException {
        int n2;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "end", new Object[]{this._resource, Util.printFlag(n), JTAResourceBase.printState(this._state)});
        }
        switch (n) {
            case 0x4000000: {
                if (this._state == 2 || this._state == 1) {
                    n2 = 5;
                    break;
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "end");
                }
                return;
            }
            case 0x20000000: {
                if (this._state == 4 || this._state == 5 || this._state == 3) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        Tr.exit(tc, "end");
                    }
                    return;
                }
                n2 = 4;
                break;
            }
            case 0x2000000: {
                if (!this._supportSuspend) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                        Tr.event(tc, "TMSUSPEND is not supported.");
                    }
                    throw new XAException(-5);
                }
                if (this._state == 3 || this._state == 5) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                        Tr.event(tc, "TMSUSPEND in invalid state.");
                    }
                    throw new XAException(-6);
                }
                if (this._state != 2) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        Tr.exit(tc, "end");
                    }
                    return;
                }
                n2 = 1;
                break;
            }
            default: {
                Tr.warning(tc, "WTRN0023_INVALID_XAEND_FLAG", Util.printFlag(n));
                throw new XAException(-5);
            }
        }
        try {
            this._resource.end(this._xid, n);
            this._state = n2;
        }
        catch (XAException xAException) {
            this.processXAException("end", xAException);
            this._state = xAException.errorCode >= 100 && xAException.errorCode <= 107 ? 4 : 3;
            throw xAException;
        }
        catch (Throwable throwable) {
            this._state = 3;
            this.processThrowable("end", throwable);
        }
        finally {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "end");
            }
        }
    }

    public void log(RecoverableUnitSection recoverableUnitSection) throws SystemException {
        throw new SystemException("Resource does not support logging");
    }

    public final Xid getXID() {
        return this._xid;
    }

    public final int getState() {
        return this._state;
    }

    public final void setState(int n) {
        this._state = n;
    }

    public final XAResource XAResource() {
        return this._resource;
    }

    protected void processXAException(String string, XAException xAException) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event(tc, "XAResource {0} threw an XAException during {1}.  The error code provided was {2}.", new Object[]{this._resource, string, XAReturnCodeHelper.convertXACode(xAException.errorCode)});
        }
        FFDCFilter.processException((Throwable)xAException, this.getClass().getName() + "." + string, "307", this);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Exception", xAException);
            Tr.debug(tc, "XID", this._xid);
        }
    }

    protected void processThrowable(String string, Throwable throwable) throws XAException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event(tc, "XAResource {0} threw an unchecked exception during {1}.  The original exception was {2}.", new Object[]{this._resource, string, throwable});
        }
        FFDCFilter.processException(throwable, this.getClass().getName() + "." + string, "341", this);
        XAException xAException = new XAException("XAResource threw an unchecked exception");
        xAException.errorCode = -3;
        throw xAException;
    }

    protected static String printState(int n) {
        switch (n) {
            case 2: {
                return "XARESOURCE_ACTIVE";
            }
            case 0: {
                return "XARESOURCE_NOTASSOCIATED";
            }
            case 6: {
                return "XARESOURCE_NOTASSOCIATED_TMJOIN";
            }
            case 3: {
                return "XARESOURCE_FAILED";
            }
            case 4: {
                return "XARESOURCE_ROLLBACK_ONLY";
            }
            case 1: {
                return "XARESOURCE_SUSPENDED";
            }
            case 5: {
                return "XARESOURCE_IDLE";
            }
        }
        return "XAResource State Error";
    }

    public void diagnose(TraceComponent traceComponent, int n) {
        int n2 = -1;
        switch (n) {
            case 1: {
                n2 = this._prepareXARC;
                break;
            }
            case 0: {
                n2 = this._completionXARC;
                break;
            }
            default: {
                return;
            }
        }
        if (n2 == 0) {
            switch (n) {
                case 1: {
                    Tr.error(traceComponent, "WTRN0089_PREPARED", new Object[]{this._resource, this.formatVote(this._vote)});
                    break;
                }
                case 0: {
                    Tr.error(traceComponent, "WTRN0090_COMPLETED", new Object[]{this._resource, this.formatVote(this._vote), this._completedCommit ? this.formatVote(Vote.VoteCommit) : this.formatVote(Vote.VoteRollback)});
                }
            }
        } else {
            Tr.error(traceComponent, "WTRN0088_EXCEPTION_DIAG", new Object[]{this._resource, XAReturnCodeHelper.convertXACode(n2)});
        }
    }

    private String formatVote(Vote vote) {
        if (vote == null) {
            return "none";
        }
        switch (vote.value()) {
            case 0: {
                return "commit";
            }
            case 2: {
                return "readonly";
            }
            case 1: {
                return "rollback";
            }
        }
        return "none";
    }
}

