/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.Transaction.JTA;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.Transaction.JTA.JTAResourceBase;
import com.ibm.ws.Transaction.JTA.JTAXAResource;
import com.ibm.ws.Transaction.JTA.PartnerLogData;
import com.ibm.ws.Transaction.JTA.PartnerLogTable;
import com.ibm.ws.Transaction.JTA.Util;
import com.ibm.ws.Transaction.JTA.XARecoveryData;
import com.ibm.ws.Transaction.JTA.XARecoveryWrapper;
import com.ibm.ws.Transaction.JTA.XAReturnCodeHelper;
import com.ibm.ws.Transaction.JTA.XARminst;
import com.ibm.ws.Transaction.JTA.XidImpl;
import com.ibm.ws.Transaction.XAResourceInfo;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.recoverylog.spi.RecoverableUnitSection;
import javax.transaction.SystemException;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.omg.CosTransactions.Vote;

public final class JTAXAResourceImpl
extends JTAResourceBase
implements JTAXAResource {
    private boolean _completed;
    private XARminst _recoveredRM;
    private XARecoveryData _recoveryData;
    private boolean _recovery;
    private static final TraceComponent tc = Tr.register(JTAXAResourceImpl.class, "Transaction", "com.ibm.ws.Transaction.resources.TransactionMsgs");

    public JTAXAResourceImpl(Xid xid, XAResource xAResource, XARecoveryData xARecoveryData) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "JTAXAResourceImpl", new Object[]{xid, xAResource, xARecoveryData});
        }
        this._xid = xid;
        this._resource = xAResource;
        this._recoveryData = xARecoveryData;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "JTAXAResourceImpl", this);
        }
    }

    public JTAXAResourceImpl(PartnerLogTable partnerLogTable, byte[] byArray, byte[] byArray2) throws Exception {
        PartnerLogData partnerLogData;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "JTAXAResourceImpl", new Object[]{partnerLogTable, com.ibm.ejs.util.Util.toHexString(byArray), com.ibm.ejs.util.Util.toHexString(byArray2)});
        }
        byte[] byArray3 = Util.duplicateByteArray(byArray2, 0, 8);
        int n = Util.getIntFromBytes(byArray2, 8, 4);
        int n2 = Util.getIntFromBytes(byArray2, 12, 2);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "recovered stoken is " + com.ibm.ejs.util.Util.toHexString(byArray3));
            Tr.debug(tc, "recovered recoveryId is " + n);
            Tr.debug(tc, "recovered seqNo is " + n2);
        }
        if (!((partnerLogData = partnerLogTable.findEntry(n)) instanceof XARecoveryData)) {
            throw new Exception("Invalid Xid/recoveryId in transaction log");
        }
        this._recoveryData = (XARecoveryData)partnerLogData;
        partnerLogData.incrementCount();
        this._xid = new XidImpl(byArray, n2, byArray3);
        this._state = 3;
        this._recovery = true;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "JTAXAResourceImpl", this);
        }
    }

    public final int prepare() throws XAException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "prepare", new Object[]{this._resource, this._xid});
        }
        int n = -1;
        try {
            try {
                this._recoveryData.logRecoveryEntry();
            }
            catch (Exception exception) {
                throw new XAException(-5);
            }
            n = this._resource.prepare(this._xid);
            if (n == 0) {
                this._vote = Vote.VoteCommit;
                int n2 = n;
                return n2;
            }
            if (n == 3) {
                this._vote = Vote.VoteReadOnly;
                this.destroy();
                int n3 = n;
                return n3;
            }
        }
        catch (XAException xAException) {
            FFDCFilter.processException((Throwable)xAException, "com.ibm.ws.Transaction.JTA.JTAXAResourceImpl.prepare", "259", this);
            this._prepareXARC = xAException.errorCode;
            if (this._prepareXARC >= 100 && this._prepareXARC <= 107) {
                this._vote = Vote.VoteRollback;
            }
            throw xAException;
        }
        finally {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                if (this._vote != null) {
                    Tr.exit(tc, "prepare", XAReturnCodeHelper.convertXACode(n) + " (" + this._vote.value() + ")");
                } else {
                    Tr.exit(tc, "prepare", XAReturnCodeHelper.convertXACode(n));
                }
            }
        }
        throw new XAException(-5);
    }

    public final void commit() throws XAException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "commit", new Object[]{this._resource, this._xid});
        }
        try {
            if (this._state == 3) {
                this._resource = this.reconnectRM();
            }
            this._resource.commit(this._xid, false);
            this._completedCommit = true;
            this.destroy();
        }
        catch (XAException xAException) {
            FFDCFilter.processException((Throwable)xAException, "com.ibm.ws.Transaction.JTA.JTAXAResourceImpl.commit", "317", this);
            this._completionXARC = xAException.errorCode;
            throw xAException;
        }
        finally {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "commit");
            }
        }
    }

    public final void commit_one_phase() throws XAException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "commit_one_phase", new Object[]{this._resource, this._xid});
        }
        try {
            this._resource.commit(this._xid, true);
            this._completedCommit = true;
            this._vote = Vote.VoteCommit;
            this.destroy();
        }
        catch (XAException xAException) {
            FFDCFilter.processException((Throwable)xAException, "com.ibm.ws.Transaction.JTA.JTAXAResourceImpl.commit_one_phase", "354", this);
            this._completionXARC = xAException.errorCode;
            throw xAException;
        }
        finally {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "commit_one_phase", new Integer(this._completionXARC));
            }
        }
    }

    public final void rollback() throws XAException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "rollback", new Object[]{this._resource, this._xid});
        }
        try {
            if (this._state == 3) {
                this._resource = this.reconnectRM();
            }
            this._resource.rollback(this._xid);
            this.destroy();
        }
        catch (XAException xAException) {
            FFDCFilter.processException((Throwable)xAException, "com.ibm.ws.Transaction.JTA.JTAXAResourceImpl.rollback", "386", this);
            this._completionXARC = xAException.errorCode;
            throw xAException;
        }
        finally {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "rollback");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void forget() throws XAException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "forget", new Object[]{this._resource, this._xid});
        }
        try {
            if (!this._completed && this._resource != null) {
                this._resource.forget(this._xid);
                this.destroy();
            }
        }
        finally {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "forget");
            }
        }
    }

    public void log(RecoverableUnitSection recoverableUnitSection) throws SystemException {
        if (TraceComponent.isAnyTracingEnabled()) {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "log", new Object[]{this, recoverableUnitSection});
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "about to log stoken " + com.ibm.ejs.util.Util.toHexString(((XidImpl)this._xid).getStoken()));
                Tr.debug(tc, "about to log recoveryId " + this.getRecoveryId());
                Tr.debug(tc, "about to log seqNo " + ((XidImpl)this._xid).getSequenceNumber());
                Tr.debug(tc, "ID from pld " + this._recoveryData._recoveryId);
            }
        }
        byte[] byArray = ((XidImpl)this._xid).getStoken();
        int n = (int)this.getRecoveryId();
        int n2 = ((XidImpl)this._xid).getSequenceNumber();
        byte[] byArray2 = new byte[byArray.length + 6];
        System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
        Util.setBytesFromInt(byArray2, byArray.length, 4, n);
        Util.setBytesFromInt(byArray2, byArray.length + 4, 2, n2);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "logging stoken " + com.ibm.ejs.util.Util.toHexString(byArray));
            Tr.debug(tc, "logging recoveryId " + n);
            Tr.debug(tc, "logging seqNo " + n2);
            Tr.debug(tc, "Actual data logged", com.ibm.ejs.util.Util.toHexString(byArray2));
        }
        try {
            recoverableUnitSection.addData(byArray2);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.Transaction.JTA.JTAXAResourceImpl.log", "326", this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event(tc, "Exception raised adding data to the transaction log", exception);
            }
            throw new SystemException(exception.toString());
        }
        finally {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "log");
            }
        }
    }

    public long getRecoveryId() {
        if (this._recoveryData != null) {
            return this._recoveryData._recoveryId;
        }
        return -1L;
    }

    public boolean getCompleted() {
        return this._completed;
    }

    public final void destroy() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "destroy", new Object[]{this._resource, this._xid});
        }
        if (!this._completed) {
            if (this._recoveredRM != null) {
                this._recoveredRM.closeConnection();
                this._recoveredRM = null;
                if (this._recovery && this._recoveryData != null) {
                    this._recoveryData.decrementCount();
                }
            }
            this._completed = true;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "destroy");
        }
    }

    XAResource reconnectRM() throws XAException {
        XAResource xAResource;
        block14: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.entry(tc, "reconnectRM");
            }
            xAResource = null;
            try {
                XARecoveryWrapper xARecoveryWrapper = null;
                if (this._recoveryData != null) {
                    xARecoveryWrapper = this._recoveryData.getXARecoveryWrapper();
                }
                if (xARecoveryWrapper == null && this._recovery) {
                    XAException xAException = new XAException(4);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        Tr.exit(tc, "reconnectRM", xAException);
                    }
                    throw xAException;
                }
                if (this._recoveredRM != null) {
                    this._recoveredRM.closeConnection();
                    this._recoveredRM = null;
                }
                if (xARecoveryWrapper == null) break block14;
                try {
                    this._recoveredRM = this._recoveryData.getXARminst();
                }
                catch (XAException xAException) {
                    FFDCFilter.processException((Throwable)xAException, "com.ibm.ws.Transaction.JTA.JTAXAResourceImpl.reconnectRM", "607", this);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        Tr.exit(tc, "reconnectRM", XAReturnCodeHelper.convertXACode(xAException.errorCode));
                    }
                    throw xAException;
                }
                if (this._recoveredRM != null) {
                    xAResource = this._recoveredRM.getXaResource();
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.Transaction.JTA.JTAXAResourceImpl.reconnectRM", "524", this);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "reconnectRM caught ", exception);
                }
                XAException xAException = new XAException(-7);
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "reconnectRM", xAException);
                }
                throw xAException;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "reconnectRM", xAResource);
        }
        return xAResource;
    }

    public final String toString() {
        String string = this._xid == null ? "" : "#" + this._xid.toString();
        return this.getClass().getName() + "@" + Integer.toHexString(System.identityHashCode(this)) + string;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof JTAXAResourceImpl && this._resource != null) {
            return this._resource.equals(((JTAXAResourceImpl)object)._resource);
        }
        return super.equals(object);
    }

    public String describe() {
        XAResourceInfo xAResourceInfo = this.getXAResourceInfo();
        if (xAResourceInfo != null) {
            return "XAResource: " + xAResourceInfo.getRMName();
        }
        return null;
    }

    public XAResourceInfo getXAResourceInfo() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getXAResourceInfo");
        }
        XARecoveryWrapper xARecoveryWrapper = null;
        if (this._recoveryData != null) {
            xARecoveryWrapper = this._recoveryData.getXARecoveryWrapper();
        }
        if (xARecoveryWrapper != null) {
            XAResourceInfo xAResourceInfo = xARecoveryWrapper.getXAResourceInfo();
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "getXAResourceInfo", xAResourceInfo);
            }
            return xAResourceInfo;
        }
        if (TraceComponent.isAnyTracingEnabled()) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "getXAResourceInfo", "still no wrapper");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getXAResourceInfo", null);
            }
        }
        return null;
    }
}

