/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.Transaction.JTA;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.Transaction.JTA.JCATranWrapper;
import com.ibm.ws.Transaction.JTA.TransactionImpl;
import com.ibm.ws.Transaction.JTA.TxXATerminator;
import com.ibm.ws.Transaction.JTA.XidImpl;
import javax.transaction.HeuristicMixedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.TransactionRequiredException;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;

public class NativeJCARecovery
implements JCATranWrapper {
    private static final TraceComponent tc = Tr.register(NativeJCARecovery.class, "Transaction", "com.ibm.ws.Transaction.resources.TransactionMsgs");
    private XidImpl xid = null;

    public NativeJCARecovery(Xid xid) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "NativeJCARecovery", xid);
        }
        this.xid = new XidImpl(xid);
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "NativeJCARecovery");
        }
    }

    public void commit() throws XAException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "commit");
        }
        try {
            this.nativeCommit(this.xid.toBytes());
        }
        catch (HeuristicMixedException heuristicMixedException) {
            String string = "Exception thrown while driving commit on a recovered transaction";
            if (tc.isEventEnabled()) {
                Tr.event(tc, string, (Object)heuristicMixedException);
            }
            throw new XAException(5);
        }
        catch (RollbackException rollbackException) {
            String string = "Exception thrown while driving commit on a recovered transaction";
            if (tc.isEventEnabled()) {
                Tr.event(tc, string, (Object)rollbackException);
            }
            throw new XAException(100);
        }
        catch (SystemException systemException) {
            String string = "Exception thrown while driving commit on a recovered transaction";
            if (tc.isEventEnabled()) {
                Tr.event(tc, string, (Object)systemException);
            }
            throw new XAException(-3);
        }
        catch (TransactionRequiredException transactionRequiredException) {
            String string = "Exception thrown while driving commit on a recovered transaction";
            if (tc.isEventEnabled()) {
                Tr.event(tc, string, (Object)transactionRequiredException);
            }
            throw new XAException(-4);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "commit");
        }
    }

    private final native void nativeCommit(byte[] var1) throws HeuristicMixedException, RollbackException, SystemException, TransactionRequiredException;

    public void rollback() throws XAException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "rollback");
        }
        try {
            this.nativeRollback(this.xid.toBytes());
        }
        catch (SystemException systemException) {
            String string = "Exception thrown while driving rollback on a recovered transaction";
            if (tc.isEventEnabled()) {
                Tr.event(tc, string, (Object)systemException);
            }
            throw new XAException(-3);
        }
        catch (TransactionRequiredException transactionRequiredException) {
            String string = "Exception thrown while driving rollback on a recovered transaction";
            if (tc.isEventEnabled()) {
                Tr.event(tc, string, (Object)transactionRequiredException);
            }
            throw new XAException(-4);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "rollback");
        }
    }

    private final native void nativeRollback(byte[] var1) throws SystemException, TransactionRequiredException;

    public void forget() throws XAException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "forget");
        }
        try {
            this.nativeForget(this.xid.toBytes());
        }
        catch (TransactionRequiredException transactionRequiredException) {
            String string = "Exception thrown while driving forget on a recovered transaction";
            if (tc.isEventEnabled()) {
                Tr.event(tc, string, (Object)transactionRequiredException);
            }
            throw new XAException(-4);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "forget");
        }
    }

    private final native void nativeForget(byte[] var1) throws TransactionRequiredException;

    public int prepare(TxXATerminator txXATerminator) throws XAException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "prepare");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "prepare");
        }
        String string = "Unable to execute prepare on thi path. Transaction not found";
        if (tc.isEventEnabled()) {
            Tr.event(tc, string);
        }
        throw new XAException(-4);
    }

    public void commitOnePhase() throws XAException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "commitOnePhase");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "commitOnePhase");
        }
        String string = "Unable to execute commitOnePhase on this Path. Transaction not found.";
        if (tc.isEventEnabled()) {
            Tr.event(tc, string);
        }
        throw new XAException(-4);
    }

    public void suspend() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "suspend");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "suspend");
        }
        String string = "Incorrect execution path during recovery";
        if (tc.isEventEnabled()) {
            Tr.event(tc, string);
        }
        throw new IllegalStateException();
    }

    public void resume() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "resume");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "resume");
        }
        String string = "Incorrect execution path during recovery";
        if (tc.isEventEnabled()) {
            Tr.event(tc, string);
        }
        throw new IllegalStateException();
    }

    public TransactionImpl getTransaction() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getTransaction");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getTransaction");
        }
        String string = "Incorrect execution path during recovery";
        if (tc.isEventEnabled()) {
            Tr.event(tc, string);
        }
        throw new IllegalStateException();
    }

    public boolean isPrepared() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isPrepared");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isPrepared");
        }
        String string = "Incorrect execution path during recovery";
        if (tc.isEventEnabled()) {
            Tr.event(tc, string);
        }
        throw new IllegalStateException();
    }

    public boolean hasAssociation() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "hasAssociation");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "hasAssociation");
        }
        String string = "Incorrect execution path during recovery";
        if (tc.isEventEnabled()) {
            Tr.event(tc, string);
        }
        throw new IllegalStateException();
    }

    public void addAssociation() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addAssociation");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addAssociation");
        }
        String string = "Incorrect execution path during recovery";
        if (tc.isEventEnabled()) {
            Tr.event(tc, string);
        }
        throw new IllegalStateException();
    }

    public void removeAssociation() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeAssociation");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removeAssociation");
        }
    }
}

