/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.Transaction.JTA;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.util.Util;
import com.ibm.ws.Transaction.JTA.FailureScopeController;
import com.ibm.ws.Transaction.JTA.RecoveryWrapper;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.recoverylog.spi.InternalLogException;
import com.ibm.ws.recoverylog.spi.RecoverableUnit;
import com.ibm.ws.recoverylog.spi.RecoverableUnitSection;
import com.ibm.ws.recoverylog.spi.RecoveryLog;
import com.ibm.ws.recoverylog.spi.WriteOperationFailedException;
import java.io.NotSerializableException;
import javax.transaction.xa.Xid;

public abstract class PartnerLogData {
    private static final TraceComponent tc = Tr.register(PartnerLogData.class, "Transaction", "com.ibm.ws.Transaction.resources.TransactionMsgs");
    protected byte[] _serializedLogData;
    protected RecoveryWrapper _logData;
    protected long _recoveryId;
    protected int _index;
    protected boolean _recovered;
    protected boolean _terminating;
    private boolean _logEarly;
    protected boolean _loggedToDisk;
    private FailureScopeController _fsc;
    private RecoveryLog _partnerLog;
    protected int _recoveredInUseCount = 1;
    protected int _sectionId;

    public PartnerLogData(RecoveryWrapper recoveryWrapper, FailureScopeController failureScopeController) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "PartnerLogData", new Object[]{recoveryWrapper, failureScopeController});
        }
        this._logData = recoveryWrapper;
        this._recovered = true;
        this._fsc = failureScopeController;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "PartnerLogData");
        }
    }

    public PartnerLogData(byte[] byArray, RecoveryWrapper recoveryWrapper, long l, RecoveryLog recoveryLog) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "PartnerLogData", new Object[]{new Long(l), recoveryWrapper, recoveryLog});
        }
        this._serializedLogData = byArray;
        this._logData = recoveryWrapper;
        this._recoveryId = l;
        this._loggedToDisk = true;
        this._partnerLog = recoveryLog;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "PartnerLogData");
        }
    }

    public synchronized void logRecoveryEntry() throws Exception {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "logRecoveryEntry", this);
        }
        if (!this._loggedToDisk) {
            if (this._terminating) {
                Tr.warning(tc, "WTRN0084_RESOURCE_ENDING");
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "logRecoveryEntry", "Terminating");
                }
                throw new IllegalStateException();
            }
            if (this._serializedLogData == null) {
                Tr.warning(tc, "WTRN0039_SERIALIZE_FAILED");
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "logRecoveryEntry", "NotSerializable");
                }
                throw new NotSerializableException("XAResource recovery information not serializable");
            }
            try {
                this.preLogData();
                this.logData(this._sectionId);
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.Transaction.JTA.XARecoveryData.logRecoveryEntry", "284", this);
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "logRecoveryEntry", exception);
                }
                throw exception;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "logRecoveryEntry");
        }
    }

    void preLogData() throws Exception {
    }

    protected void logData(int n) throws Exception {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "logData", new Integer(n));
        }
        if (this._partnerLog == null) {
            this._partnerLog = this._fsc.getPartnerLog();
        }
        if (this._partnerLog != null) {
            RecoverableUnit recoverableUnit = null;
            try {
                if (this._recoveryId == 0L) {
                    recoverableUnit = this._partnerLog.createRecoverableUnit();
                    if (recoverableUnit == null) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "logData", "RecoverableUnit returned from createRecoverableUnit was null - throwing InternalLogException");
                        }
                        throw new InternalLogException(null);
                    }
                    this._recoveryId = recoverableUnit.identity();
                } else {
                    recoverableUnit = this._partnerLog.lookupRecoverableUnit(this._recoveryId);
                    if (recoverableUnit == null) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "logData", "RecoverableUnit returned from lookupRecoverableUnit for " + this._recoveryId + " was null - throwing InternalLogException");
                        }
                        throw new InternalLogException(null);
                    }
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "logData", "section=" + n + ", recoveryId=" + this._recoveryId);
                }
                RecoverableUnitSection recoverableUnitSection = recoverableUnit.createSection(n, true);
                recoverableUnitSection.addData(this._serializedLogData);
                recoverableUnit.forceSections();
                this._loggedToDisk = true;
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.Transaction.JTA.PartnerLogData.logData", "285", this);
                try {
                    if (recoverableUnit != null) {
                        this._partnerLog.removeRecoverableUnit(recoverableUnit.identity());
                        this._recoveryId = 0L;
                    }
                }
                catch (Throwable throwable) {
                    FFDCFilter.processException(throwable, "com.ibm.ws.Transaction.JTA.PartnerLogData.logData", "156", this);
                }
                if (exception instanceof WriteOperationFailedException) {
                    Tr.error(tc, "WTRN0066_LOG_WRITE_ERROR", exception);
                } else {
                    Tr.error(tc, "WTRN0000_ERR_INT_ERROR", new Object[]{"logData", "com.ibm.ws.Transaction.JTA.PartnerLogData", exception});
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "logData", exception);
                }
                throw exception;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "logData");
        }
    }

    public void setSerializedLogData(byte[] byArray) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "setSerializedLogData", Util.toHexString(byArray));
        }
        this._serializedLogData = byArray;
    }

    public RecoveryWrapper getLogData() {
        return this._logData;
    }

    public long getRecoveryId() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "getRecoveryId", new Long(this._recoveryId));
        }
        return this._recoveryId;
    }

    public void setRecovered(boolean bl) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "setRecovered", new Object[]{"From " + this._recovered + " to " + bl, this});
        }
        this._recovered = bl;
    }

    public boolean getRecovered() {
        return this._recovered;
    }

    public synchronized void terminate() {
        this._terminating = true;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "terminate", this);
        }
    }

    public String toString() {
        String string = this._logData == null ? "<null>" : this._logData.toString();
        return "index=" + this._index + ", recoveryID=" + this._recoveryId + ", recovered=" + this._recovered + ", terminating=" + this._terminating + ", loggedToDisk=" + this._loggedToDisk + ", data=" + string;
    }

    public void setIndex(int n) {
        this._index = n;
    }

    public int getIndex() {
        return this._index;
    }

    public void setLogEarly(boolean bl) {
        this._logEarly = bl;
    }

    public boolean getLogEarly() {
        return this._logEarly;
    }

    public synchronized void incrementCount() {
        ++this._recoveredInUseCount;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "incrementCount", new Object[]{new Long(this._recoveryId), new Integer(this._recoveredInUseCount)});
        }
    }

    public synchronized int decrementCount() {
        --this._recoveredInUseCount;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "decrementCount", new Object[]{new Long(this._recoveryId), new Integer(this._recoveredInUseCount)});
        }
        return this._recoveredInUseCount;
    }

    public synchronized boolean clearIfNotInUse() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "clearIfNotInUse", new Object[]{new Long(this._recoveryId), new Integer(this._recoveredInUseCount)});
        }
        boolean bl = false;
        if (this._loggedToDisk && this._recoveredInUseCount == 0) {
            try {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "removing recoverable unit " + this._recoveryId);
                }
                this._partnerLog.removeRecoverableUnit(this._recoveryId);
                this._loggedToDisk = false;
                this._recoveryId = 0L;
                bl = true;
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.Transaction.JTA.PartnerLogData.clearIfNotInUse", "218", this);
                if (exception instanceof WriteOperationFailedException) {
                    Tr.error(tc, "WTRN0066_LOG_WRITE_ERROR", exception);
                }
                Tr.error(tc, "WTRN0000_ERR_INT_ERROR", new Object[]{"clearIfNotInUse", "com.ibm.ws.Transaction.JTA.PartnerLogData", exception});
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "clearIfNotInUse", new Boolean(bl));
        }
        return bl;
    }

    boolean recover(ClassLoader classLoader, Xid[] xidArray, byte[] byArray, byte[] byArray2, int n) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "recover", new Object[]{classLoader, xidArray, byArray, byArray2, new Integer(n)});
        }
        this.decrementCount();
        return true;
    }
}

