/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.Transaction.JTA;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.Transaction.JTA.FailureScopeController;
import com.ibm.ws.Transaction.JTA.PartnerLogData;
import com.ibm.ws.Transaction.JTA.RecoveryManager;
import com.ibm.ws.Transaction.JTA.RecoveryWrapper;
import com.ibm.ws.Transaction.JTA.XARecoveryData;
import com.ibm.ws.Transaction.JTA.XARecoveryWrapper;
import com.ibm.ws.Transaction.JTS.Configuration;
import com.ibm.ws.Transaction.TxProperties;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.recoverylog.spi.DistributedRecoveryLog;
import com.ibm.ws.recoverylog.spi.LogClosedException;
import com.ibm.ws.recoverylog.spi.LogCursor;
import com.ibm.ws.recoverylog.spi.RecoverableUnit;
import com.ibm.ws.recoverylog.spi.RecoverableUnitSection;
import com.ibm.ws.recoverylog.spi.RecoveryLog;
import java.util.ArrayList;
import javax.transaction.xa.Xid;

public final class PartnerLogTable {
    private static final TraceComponent tc = Tr.register(PartnerLogTable.class, "Transaction", "com.ibm.ws.Transaction.resources.TransactionMsgs");
    private final ArrayList _partnerLogTable;
    private final FailureScopeController _failureScopeController;

    public PartnerLogTable(FailureScopeController failureScopeController) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "PartnerLogTable", failureScopeController);
        }
        this._partnerLogTable = new ArrayList();
        this._failureScopeController = failureScopeController;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "PartnerLogTable");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PartnerLogData getEntry(int n) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getEntry", new Integer(n));
        }
        ArrayList arrayList = this._partnerLogTable;
        synchronized (arrayList) {
            try {
                PartnerLogData partnerLogData = (PartnerLogData)this._partnerLogTable.get(n - 1);
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "getEntry", partnerLogData);
                }
                return partnerLogData;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                FFDCFilter.processException((Throwable)indexOutOfBoundsException, "com.ibm.ws.Transaction.JTA.PartnerLogTable.getEntry", "122", this);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getEntry", null);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEntry(PartnerLogData partnerLogData) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "addEntry", partnerLogData);
        }
        ArrayList arrayList = this._partnerLogTable;
        synchronized (arrayList) {
            this.addPartnerEntry(partnerLogData);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "addEntry");
        }
    }

    private void addPartnerEntry(PartnerLogData partnerLogData) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "addPartnerEntry", partnerLogData);
        }
        int n = this._partnerLogTable.size();
        this._partnerLogTable.add(n, partnerLogData);
        partnerLogData.setIndex(n + 1);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "addPartnerEntry", new Integer(n + 1));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PartnerLogData findEntry(long l) {
        RecoverableUnit recoverableUnit;
        Object object;
        Object object2;
        block16: {
            block15: {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.entry(tc, "findEntry", new Long(l));
                }
                object2 = this._partnerLogTable;
                synchronized (object2) {
                    int n = this._partnerLogTable.size();
                    while (--n >= 0) {
                        object = (PartnerLogData)this._partnerLogTable.get(n);
                        if (l != ((PartnerLogData)object)._recoveryId) continue;
                        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                            Tr.exit(tc, "findEntry", object);
                        }
                        return object;
                    }
                }
                object2 = null;
                recoverableUnit = null;
                try {
                    object2 = this._failureScopeController.getPartnerLog();
                    if (object2 != null) {
                        recoverableUnit = object2.lookupRecoverableUnit(l);
                    }
                }
                catch (LogClosedException logClosedException) {
                    FFDCFilter.processException((Throwable)logClosedException, "com.ibm.ws.Transaction.JTA.PartnerLogTable.findEntry", "205", this);
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) break block15;
                    Tr.event(tc, "Partner log was closed", logClosedException);
                }
            }
            if (recoverableUnit == null && (object2 = this._failureScopeController.getRecoveryPartnerLog()) != null) {
                try {
                    recoverableUnit = object2.lookupRecoverableUnit(l);
                }
                catch (LogClosedException logClosedException) {
                    FFDCFilter.processException((Throwable)logClosedException, "com.ibm.ws.Transaction.JTA.PartnerLogTable.findEntry", "219", this);
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) break block16;
                    Tr.event(tc, "Restart partner log was closed", logClosedException);
                }
            }
        }
        if (recoverableUnit != null && (object = recoverableUnit.lookupSection(34)) != null) {
            byte[] byArray = object.lastData();
            XARecoveryData xARecoveryData = new XARecoveryData((RecoveryLog)object2, byArray, recoverableUnit.identity());
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "findEntry", xARecoveryData);
            }
            return xARecoveryData;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "findEntry", null);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    public PartnerLogData findEntry(RecoveryWrapper recoveryWrapper) {
        PartnerLogData partnerLogData;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "findEntry", recoveryWrapper);
        }
        ArrayList arrayList = this._partnerLogTable;
        synchronized (arrayList) {
            RecoveryWrapper recoveryWrapper2;
            Object object;
            int n = this._partnerLogTable.size();
            while (--n >= 0) {
                object = (PartnerLogData)this._partnerLogTable.get(n);
                recoveryWrapper2 = ((PartnerLogData)object).getLogData();
                if (recoveryWrapper2 == null || !recoveryWrapper.isSameAs(recoveryWrapper2)) continue;
                if (TraceComponent.isAnyTracingEnabled()) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Found entry in table");
                    }
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "findEntry", new Integer(n));
                    }
                }
                return object;
            }
            if (!TxProperties.SINGLE_PROCESS) {
                LogCursor logCursor = null;
                object = this._failureScopeController.getPartnerLog();
                try {
                    if (object == null) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug(tc, "No partner log to check for wrapper");
                        }
                    } else {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug(tc, "Checking recovery log for wrapper");
                        }
                        logCursor = object.recoverableUnits();
                    }
                    while (logCursor != null && logCursor.hasNext()) {
                        XARecoveryData xARecoveryData;
                        recoveryWrapper2 = Configuration.getClassLoader();
                        RecoverableUnit recoverableUnit = (RecoverableUnit)logCursor.next();
                        long l = recoverableUnit.identity();
                        RecoverableUnitSection recoverableUnitSection = recoverableUnit.lookupSection(34);
                        if (recoverableUnitSection == null) continue;
                        try {
                            byte[] byArray = recoverableUnitSection.lastData();
                            XARecoveryData xARecoveryData2 = new XARecoveryData((RecoveryLog)object, byArray, l);
                            xARecoveryData2.deserialize((ClassLoader)((Object)recoveryWrapper2));
                            XARecoveryWrapper xARecoveryWrapper = xARecoveryData2.getXARecoveryWrapper();
                            if (xARecoveryWrapper == null || !recoveryWrapper.isSameAs(xARecoveryWrapper)) continue;
                            this.addPartnerEntry(xARecoveryData2);
                            if (TraceComponent.isAnyTracingEnabled()) {
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Found entry in logstream");
                                }
                                if (tc.isEntryEnabled()) {
                                    Tr.exit(tc, "findEntry", xARecoveryData2);
                                }
                            }
                            xARecoveryData = xARecoveryData2;
                        }
                        catch (Throwable throwable) {
                            FFDCFilter.processException(throwable, "com.ibm.ws.Transaction.JTA.PartnerLogTable.findEntry", "334", this);
                            if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                            Tr.debug(tc, "Could not process this entry due to an exception", throwable);
                            continue;
                        }
                        return xARecoveryData;
                    }
                }
                catch (LogClosedException logClosedException) {
                    FFDCFilter.processException((Throwable)logClosedException, "com.ibm.ws.Transaction.JTA.PartnerLogTable.findEntry", "345", this);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "Can't use the log because it is closed", logClosedException);
                    }
                }
                finally {
                    if (logCursor != null) {
                        logCursor.close();
                    }
                }
            }
            partnerLogData = recoveryWrapper.container(this._failureScopeController);
            this.addPartnerEntry(partnerLogData);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "findEntry", partnerLogData);
        }
        return partnerLogData;
    }

    public void terminate() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "terminate");
        }
        int n = this._partnerLogTable.size();
        while (--n >= 0) {
            PartnerLogData partnerLogData = (PartnerLogData)this._partnerLogTable.get(n);
            partnerLogData.terminate();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "terminate");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean shutdown() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "shutdown");
        }
        boolean bl = false;
        RecoveryLog recoveryLog = this._failureScopeController.getPartnerLog();
        ArrayList arrayList = this._partnerLogTable;
        synchronized (arrayList) {
            int n = this._partnerLogTable.size();
            while (--n >= 0) {
                PartnerLogData partnerLogData = (PartnerLogData)this._partnerLogTable.get(n);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "processing: ", partnerLogData);
                }
                if (partnerLogData._recovered) {
                    if (!partnerLogData._loggedToDisk || recoveryLog == null) continue;
                    try {
                        recoveryLog.removeRecoverableUnit(partnerLogData._recoveryId);
                    }
                    catch (Exception exception) {
                        FFDCFilter.processException(exception, "com.ibm.ws.Transaction.JTA.PartnerLogTable.shutdown", "364");
                        Tr.error(tc, "WTRN0000_ERR_INT_ERROR", new Object[]{"shutdown", "com.ibm.ws.Transaction.JTA.PartnerLog", exception});
                        Tr.event(tc, "XAResources log - removeRecoverableUnit failed:", exception);
                        bl = true;
                    }
                    continue;
                }
                if (!partnerLogData._loggedToDisk && recoveryLog != null) {
                    Tr.warning(tc, "WTRN0039_SERIALIZE_FAILED");
                    continue;
                }
                bl = true;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "shutdown", bl);
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearUnused() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "clearUnused");
        }
        RecoveryLog recoveryLog = this._failureScopeController.getPartnerLog();
        ArrayList arrayList = this._partnerLogTable;
        synchronized (arrayList) {
            boolean bl = false;
            int n = this._partnerLogTable.size();
            while (--n >= 0) {
                PartnerLogData partnerLogData = (PartnerLogData)this._partnerLogTable.get(n);
                bl |= partnerLogData.clearIfNotInUse();
            }
            try {
                if (bl) {
                    ((DistributedRecoveryLog)recoveryLog).keypoint();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "clearUnused");
        }
    }

    protected boolean recover(RecoveryManager recoveryManager, ClassLoader classLoader, Xid[] xidArray) {
        boolean bl = true;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "recover", new Object[]{this, this._failureScopeController.serverName()});
        }
        int n = recoveryManager.getCurrentEpoch();
        byte[] byArray = recoveryManager.getApplId();
        int n2 = this._partnerLogTable.size();
        while (--n2 >= 0) {
            PartnerLogData partnerLogData = (PartnerLogData)this._partnerLogTable.get(n2);
            if (!partnerLogData.recover(classLoader, xidArray, null, byArray, n)) {
                bl = false;
            }
            if (!recoveryManager.shutdownInProgress()) continue;
            bl = false;
            break;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "recover", new Boolean(bl));
        }
        return bl;
    }

    public void merge(PartnerLogTable partnerLogTable) {
        PartnerLogData[] partnerLogDataArray;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "merge", partnerLogTable);
        }
        if (partnerLogTable != null && (partnerLogDataArray = partnerLogTable.toArray()) != null) {
            for (int i = 0; i < partnerLogDataArray.length; ++i) {
                this.addEntry(partnerLogDataArray[i]);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "merge");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PartnerLogData[] toArray() {
        ArrayList arrayList = this._partnerLogTable;
        synchronized (arrayList) {
            PartnerLogData[] partnerLogDataArray = new PartnerLogData[this._partnerLogTable.size()];
            return this._partnerLogTable.toArray(partnerLogDataArray);
        }
    }
}

