/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.Transaction.JTA;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.Transaction.JTA.EventSemaphore;
import com.ibm.ws.Transaction.JTA.FailureScopeController;
import com.ibm.ws.Transaction.JTA.FailureScopeLifeCycle;
import com.ibm.ws.Transaction.JTA.FailureScopeLifeCycleHelper;
import com.ibm.ws.Transaction.JTA.JCARecoveryData;
import com.ibm.ws.Transaction.JTA.PartnerLogTable;
import com.ibm.ws.Transaction.JTA.TranManagerSet;
import com.ibm.ws.Transaction.JTA.TransactionImpl;
import com.ibm.ws.Transaction.JTA.TxExecutionContextHandler;
import com.ibm.ws.Transaction.JTA.Util;
import com.ibm.ws.Transaction.JTA.WSCRecoveryData;
import com.ibm.ws.Transaction.JTA.XARecoveryData;
import com.ibm.ws.Transaction.JTS.Configuration;
import com.ibm.ws.Transaction.TxProperties;
import com.ibm.ws.bootstrap.ExtClassLoader;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.recoverylog.spi.DistributedRecoveryLog;
import com.ibm.ws.recoverylog.spi.FailureScope;
import com.ibm.ws.recoverylog.spi.LogAllocationException;
import com.ibm.ws.recoverylog.spi.LogCursor;
import com.ibm.ws.recoverylog.spi.LogIncompatibleException;
import com.ibm.ws.recoverylog.spi.RecoverableUnit;
import com.ibm.ws.recoverylog.spi.RecoverableUnitSection;
import com.ibm.ws.recoverylog.spi.RecoveryAgent;
import com.ibm.ws.recoverylog.spi.RecoveryDirectorFactory;
import com.ibm.ws.recoverylog.spi.RecoveryLog;
import com.ibm.ws.util.PlatformHelperFactory;
import com.ibm.ws390.tx.Enq;
import com.ibm.ws390.tx.NativeServerInstanceData;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.SortedSet;
import java.util.StringTokenizer;
import java.util.TreeSet;
import javax.transaction.SystemException;
import javax.transaction.xa.Xid;

public final class RecoveryManager
implements Runnable {
    private static final TraceComponent tc = Tr.register(RecoveryManager.class, "Transaction", "com.ibm.ws.Transaction.resources.TransactionMsgs");
    public static boolean recoveryOnlyMode;
    private final EventSemaphore _replayInProgress = new EventSemaphore();
    private boolean _replayCompleted;
    private final EventSemaphore _recoveryInProgress = new EventSemaphore();
    private boolean _recoveryCompleted;
    private static final EventSemaphore _ClassLoaderReady;
    private boolean _shutdownInProgress;
    private final RecoveryAgent _agent;
    private RecoveryLog _tranLog;
    private RecoveryLog _xaLog;
    private final RecoveryLog _recoverXaLog;
    private final PartnerLogTable _recoveryPartnerLogTable;
    private byte[] _ourApplId;
    private int _ourEpoch;
    private byte[] _recoveredApplId;
    private int _recoveredEpoch;
    private String _recoveredServerName;
    private int _partnerEntryLowWatermark = -1;
    private int _partnerEntryNextId = -1;
    private Enq _partnerLogEnq;
    private static final int TRANSACTION_SERVICE_ITEMS = 3;
    private static final int PARTNERLOG_SERVICE_ITEMS = 6;
    private RecoverableUnit _partnerServiceData;
    private RecoverableUnitSection _stateSection;
    private RecoverableUnitSection _classpathSection;
    private RecoverableUnitSection _partnerServerSection;
    private RecoverableUnitSection _partnerApplIdSection;
    private RecoverableUnitSection _partnerEpochSection;
    private RecoverableUnitSection _partnerLowWatermarkSection;
    private RecoverableUnitSection _partnerNextIdSection;
    private RecoverableUnit _tranlogServiceData;
    private RecoverableUnitSection _tranlogServerSection;
    private RecoverableUnitSection _tranlogApplIdSection;
    private RecoverableUnitSection _tranlogEpochSection;
    private String _classPath;
    private static String _loggedClassPath;
    private static String _extraPaths;
    private static boolean _appsAreLoaded;
    public static final int STARTING = 1;
    public static final int STOPPING = 3;
    private FailureScopeController _failureScopeController;
    private boolean _recoveryPrevented;
    private HashSet _recoveringTransactions;
    private final Object _recoveryMonitor = new Object();
    private boolean _cleanRemoteShutdown = false;

    RecoveryManager(FailureScopeController failureScopeController, RecoveryAgent recoveryAgent, RecoveryLog recoveryLog, RecoveryLog recoveryLog2, RecoveryLog recoveryLog3, byte[] byArray, int n) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "RecoveryManager", new Object[]{failureScopeController, recoveryAgent, recoveryLog, recoveryLog2, recoveryLog3, byArray == null ? "null" : com.ibm.ejs.util.Util.toHexString(byArray), new Integer(n)});
        }
        this._failureScopeController = failureScopeController;
        this._agent = recoveryAgent;
        this._tranLog = recoveryLog;
        this._xaLog = recoveryLog2;
        this._recoverXaLog = recoveryLog3;
        if (!(TxProperties.SINGLE_PROCESS || this._xaLog == null && this._recoverXaLog == null)) {
            this._partnerLogEnq = Enq.instance();
        }
        this._recoveryPartnerLogTable = new PartnerLogTable(failureScopeController);
        this._ourApplId = byArray;
        this._ourEpoch = n;
        this._recoveringTransactions = new HashSet();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "RecoveryManager");
        }
    }

    public PartnerLogTable getPartnerLogTable() {
        return this._recoveryPartnerLogTable;
    }

    byte[] getApplId() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "getApplId", this._ourApplId);
        }
        return this._ourApplId;
    }

    int getCurrentEpoch() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "getCurrentEpoch", new Integer(this._ourEpoch));
        }
        return this._ourEpoch;
    }

    FailureScopeController getFailureScopeController() {
        return this._failureScopeController;
    }

    private void replayTranLog() throws Exception {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "replayTranLog");
        }
        LogCursor logCursor = this._tranLog.recoverableUnits();
        LogCursor logCursor2 = null;
        int n = 0;
        boolean bl = false;
        boolean bl2 = false;
        try {
            while (logCursor.hasNext() && !bl) {
                Object object;
                RecoverableUnit recoverableUnit = (RecoverableUnit)logCursor.next();
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    Tr.event(tc, "Replaying record " + recoverableUnit.identity() + " from the transaction log");
                }
                logCursor2 = recoverableUnit.sections();
                boolean bl3 = false;
                block11: while (!bl3 && logCursor2.hasNext()) {
                    object = (RecoverableUnitSection)logCursor2.next();
                    int n2 = object.identity();
                    byte[] byArray = object.lastData();
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                        Tr.event(tc, "Replaying section " + n2, com.ibm.ejs.util.Util.toHexString(byArray));
                    }
                    switch (n2) {
                        case 255: {
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                Tr.debug(tc, "Server name data record");
                            }
                            if (this._tranlogServerSection != null) {
                                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                                    Tr.event(tc, "Multiple log SERVER_DATA_SECTIONs found");
                                }
                                Tr.warning(tc, "WTRN0019_LOGFILE_CORRUPTED", this._tranLog.logProperties().logName());
                                throw new IOException(this._tranLog.logProperties().logName() + " corrupted");
                            }
                            if (this._tranlogServiceData == null) {
                                this._tranlogServiceData = recoverableUnit;
                            } else if (this._tranlogServiceData != recoverableUnit) {
                                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                                    Tr.event(tc, "Multiple log service data records found");
                                }
                                Tr.warning(tc, "WTRN0019_LOGFILE_CORRUPTED", this._tranLog.logProperties().logName());
                                throw new IOException(this._tranLog.logProperties().logName() + " corrupted");
                            }
                            this._tranlogServerSection = object;
                            ++n;
                            if (byArray == null || byArray.length == 0) continue block11;
                            String string = com.ibm.ejs.util.Util.toString(byArray);
                            if (this._recoveredServerName == null) {
                                this._recoveredServerName = string;
                                if (this._failureScopeController.serverName().equals(this._recoveredServerName)) continue block11;
                                Tr.warning(tc, "WTRN0020_RECOVERING_TRANSACTIONS", this._recoveredServerName);
                                break;
                            }
                            if (this._recoveredServerName.equals(string)) continue block11;
                            Tr.error(tc, "WTRN0024_INCONSISTENT_LOGS");
                            throw new IOException("Inconsistent Transaction and XA Resource recovery logs");
                        }
                        case 253: {
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                Tr.debug(tc, "Applid data record");
                            }
                            if (this._tranlogApplIdSection != null) {
                                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                                    Tr.event(tc, "Multiple log APPLID_DATA_SECTIONs found");
                                }
                                Tr.warning(tc, "WTRN0019_LOGFILE_CORRUPTED", this._tranLog.logProperties().logName());
                                throw new IOException(this._tranLog.logProperties().logName() + " corrupted");
                            }
                            if (this._tranlogServiceData == null) {
                                this._tranlogServiceData = recoverableUnit;
                            } else if (this._tranlogServiceData != recoverableUnit) {
                                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                                    Tr.event(tc, "Multiple log service data records found");
                                }
                                Tr.warning(tc, "WTRN0019_LOGFILE_CORRUPTED", this._tranLog.logProperties().logName());
                                throw new IOException(this._tranLog.logProperties().logName() + " corrupted");
                            }
                            this._tranlogApplIdSection = object;
                            ++n;
                            if (byArray == null) continue block11;
                            if (this._recoveredApplId == null) {
                                this._recoveredApplId = byArray;
                                break;
                            }
                            if (com.ibm.ejs.util.Util.equal(this._recoveredApplId, byArray)) continue block11;
                            Tr.error(tc, "WTRN0024_INCONSISTENT_LOGS");
                            throw new IOException("Inconsistent Transaction and XA Resource recovery logs");
                        }
                        case 254: {
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                Tr.debug(tc, "Epoch data record");
                            }
                            if (this._tranlogEpochSection != null) {
                                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                                    Tr.event(tc, "Multiple log EPOCH_DATA_SECTIONs found");
                                }
                                Tr.warning(tc, "WTRN0019_LOGFILE_CORRUPTED", this._tranLog.logProperties().logName());
                                throw new IOException(this._tranLog.logProperties().logName() + " corrupted");
                            }
                            if (this._tranlogServiceData == null) {
                                this._tranlogServiceData = recoverableUnit;
                            } else if (this._tranlogServiceData != recoverableUnit) {
                                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                                    Tr.event(tc, "Multiple log service data records found");
                                }
                                Tr.warning(tc, "WTRN0019_LOGFILE_CORRUPTED", this._tranLog.logProperties().logName());
                                throw new IOException(this._tranLog.logProperties().logName() + " corrupted");
                            }
                            this._tranlogEpochSection = object;
                            ++n;
                            if (byArray == null || byArray.length <= 3) continue block11;
                            int n3 = Util.getIntFromBytes(byArray, 0, 4);
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                Tr.debug(tc, "Recovered epoch: " + n3);
                            }
                            if (n3 <= this._recoveredEpoch) continue block11;
                            this._recoveredEpoch = n3;
                            break;
                        }
                        default: {
                            bl3 = true;
                        }
                    }
                }
                logCursor2.close();
                logCursor2 = null;
                if (bl3) {
                    object = new TransactionImpl(this._failureScopeController);
                    if (((TransactionImpl)object).reconstruct(recoverableUnit, this._tranLog)) {
                        if (((TransactionImpl)object).isRAImport()) {
                            TxExecutionContextHandler.addTxn((TransactionImpl)object);
                        }
                        bl2 = true;
                    } else {
                        logCursor.remove();
                    }
                }
                bl = this.shutdownInProgress();
            }
            if (!bl) {
                if (bl2) {
                    if (n != 3) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                            Tr.event(tc, "Recoverable log records found without service data records");
                        }
                        Tr.warning(tc, "WTRN0019_LOGFILE_CORRUPTED", this._tranLog.logProperties().logName());
                        throw new IOException(this._tranLog.logProperties().logName() + " corrupted");
                    }
                } else if (n != 0 && n != 3) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                        Tr.event(tc, "Only a subset of service data records recovered");
                    }
                    Tr.warning(tc, "WTRN0019_LOGFILE_CORRUPTED", this._tranLog.logProperties().logName());
                    throw new IOException(this._tranLog.logProperties().logName() + " corrupted");
                }
            }
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.Transaction.JTA.RecoveryManager.replayTranLog", "512", this);
            if (logCursor2 != null) {
                logCursor2.close();
            }
            Tr.error(tc, "WTRN0025_TRAN_RECOVERY_FAILED", throwable);
            SystemException systemException = new SystemException(throwable.toString());
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "replayTranLog", (Object)systemException);
            }
            throw systemException;
        }
        finally {
            logCursor.close();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "replayTranLog");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void prepareToShutdown() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "prepareToShutdown");
        }
        Object object = this._recoveryMonitor;
        synchronized (object) {
            this._shutdownInProgress = true;
            this._recoveryMonitor.notify();
        }
        this.waitForRecoveryCompletion();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "prepareToShutdown");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    void preShutdown(boolean var1_1) throws Exception {
        block31: {
            if (TraceComponent.isAnyTracingEnabled() && RecoveryManager.tc.isEntryEnabled()) {
                Tr.entry(RecoveryManager.tc, "preShutdown", new Boolean(var1_1));
            }
            try {
                this._recoveryPartnerLogTable.terminate();
                if (!var1_1) {
                    if (TraceComponent.isAnyTracingEnabled() && RecoveryManager.tc.isDebugEnabled()) {
                        Tr.debug(RecoveryManager.tc, "There is no transaction data requiring future recovery");
                    }
                    if (this._tranlogServiceData != null) {
                        if (TraceComponent.isAnyTracingEnabled() && RecoveryManager.tc.isDebugEnabled()) {
                            Tr.debug(RecoveryManager.tc, "Erasing service data from transaction log");
                        }
                        try {
                            if (this._tranLog != null) {
                                this._tranLog.removeRecoverableUnit(this._tranlogServiceData.identity());
                            }
                            if (!TraceComponent.isAnyTracingEnabled() || !RecoveryManager.tc.isDebugEnabled()) ** GOTO lbl36
                            Tr.debug(RecoveryManager.tc, "_tranLog is null");
                        }
                        catch (Exception var2_2) {
                            FFDCFilter.processException((Throwable)var2_2, "com.ibm.ws.Transaction.JTA.RecoveryManager.shutdown", "359", this);
                            Tr.error(RecoveryManager.tc, "WTRN0029_ERROR_CLOSE_LOG_IN_SHUTDOWN");
                            throw var2_2;
                        }
                    } else if (TraceComponent.isAnyTracingEnabled() && RecoveryManager.tc.isDebugEnabled()) {
                        Tr.debug(RecoveryManager.tc, "No service data to erase from transaction log");
                    }
                } else {
                    if (TraceComponent.isAnyTracingEnabled() && RecoveryManager.tc.isDebugEnabled()) {
                        Tr.debug(RecoveryManager.tc, "There is transaction data requiring future recovery. Updating epoch");
                    }
                    try {
                        this._tranlogEpochSection.addData(Util.intToBytes(this._ourEpoch));
                        this._tranlogServiceData.forceSections();
                    }
                    catch (Exception var2_3) {
                        FFDCFilter.processException((Throwable)var2_3, "com.ibm.ws.Transaction.JTA.RecoveryManager.shutdown", "608", this);
                        if (TraceComponent.isAnyTracingEnabled() && RecoveryManager.tc.isDebugEnabled()) {
                            Tr.debug(RecoveryManager.tc, "Exception raised forcing tranlog at shutdown", var2_3);
                        }
                        throw var2_3;
                    }
                }
lbl36:
                // 5 sources

                var4_4 = null;
                if (this._failureScopeController.localFailureScope() && var1_1) break block31;
            }
            catch (Throwable var3_8) {
                var4_5 = null;
                if (!this._failureScopeController.localFailureScope() || !var1_1) {
                    try {
                        if (this._tranLog != null) {
                            this._tranLog.closeLog();
                        } else if (TraceComponent.isAnyTracingEnabled() && RecoveryManager.tc.isDebugEnabled()) {
                            Tr.debug(RecoveryManager.tc, "_tranLog is null");
                        }
                    }
                    catch (Exception var5_7) {
                        FFDCFilter.processException((Throwable)var5_7, "com.ibm.ws.Transaction.JTA.RecoveryManager.shutdown", "359", this);
                        Tr.error(RecoveryManager.tc, "WTRN0029_ERROR_CLOSE_LOG_IN_SHUTDOWN");
                        if (TraceComponent.isAnyTracingEnabled() && RecoveryManager.tc.isEntryEnabled()) {
                            Tr.exit(RecoveryManager.tc, "preShutdown");
                        }
                        throw var5_7;
                    }
                }
                if (TraceComponent.isAnyTracingEnabled() && RecoveryManager.tc.isEntryEnabled()) {
                    Tr.exit(RecoveryManager.tc, "preShutdown");
                }
                throw var3_8;
            }
            try {
                if (this._tranLog != null) {
                    this._tranLog.closeLog();
                } else if (TraceComponent.isAnyTracingEnabled() && RecoveryManager.tc.isDebugEnabled()) {
                    Tr.debug(RecoveryManager.tc, "_tranLog is null");
                }
            }
            catch (Exception var5_6) {
                FFDCFilter.processException((Throwable)var5_6, "com.ibm.ws.Transaction.JTA.RecoveryManager.shutdown", "359", this);
                Tr.error(RecoveryManager.tc, "WTRN0029_ERROR_CLOSE_LOG_IN_SHUTDOWN");
                if (TraceComponent.isAnyTracingEnabled() && RecoveryManager.tc.isEntryEnabled()) {
                    Tr.exit(RecoveryManager.tc, "preShutdown");
                }
                throw var5_6;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && RecoveryManager.tc.isEntryEnabled()) {
            Tr.exit(RecoveryManager.tc, "preShutdown");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void postShutdown(boolean bl) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "postShutdown", new Object[]{this, new Boolean(bl)});
        }
        try {
            if (this._xaLog != null) {
                if (bl) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "There is partner data requiring future recovery. Updating server state");
                    }
                    try {
                        this.updateServerState(3);
                        this._partnerServiceData.forceSections();
                    }
                    catch (Exception exception) {
                        FFDCFilter.processException((Throwable)exception, "com.ibm.ws.Transaction.JTA.RecoveryManager.postShutdown", "779", this);
                        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                            Tr.event(tc, "updateServerState failed at shutdown on XAResources log", exception);
                        }
                    }
                } else {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "There is no partner data requiring future recovery");
                    }
                    if (this._partnerServiceData != null) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug(tc, "Erasing service data from partner log");
                        }
                        try {
                            this._xaLog.removeRecoverableUnit(this._partnerServiceData.identity());
                        }
                        catch (Exception exception) {
                            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.Transaction.JTA.RecoveryManager.postShutdown", "793", this);
                            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                                Tr.event(tc, "removeRecoverableUnit failed at shutdown on XAResources log", exception);
                            }
                        }
                    } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "No service data to erase from partner log");
                    }
                }
            }
        }
        finally {
            try {
                if (this._xaLog != null) {
                    this._xaLog.closeLog();
                } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "_xaLog is null");
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.Transaction.JTA.RecoveryManager.postShutdown", "824", this);
                Tr.error(tc, "WTRN0029_ERROR_CLOSE_LOG_IN_SHUTDOWN");
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "postShutdown");
        }
    }

    private int replayPartnerLog() throws Exception {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "replayPartnerLog");
        }
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        LogCursor logCursor = null;
        LogCursor logCursor2 = null;
        ArrayList<RecoveryLog> arrayList = new ArrayList<RecoveryLog>(2);
        if (this._recoverXaLog != null) {
            arrayList.add(this._recoverXaLog);
        }
        arrayList.add(this._xaLog);
        Iterator iterator = arrayList.iterator();
        boolean bl = false;
        while (iterator.hasNext() && !bl) {
            RecoveryLog recoveryLog = (RecoveryLog)iterator.next();
            logCursor = recoveryLog.recoverableUnits();
            while (logCursor.hasNext() && !bl) {
                ++n3;
                RecoverableUnit recoverableUnit = (RecoverableUnit)logCursor.next();
                long l = recoverableUnit.identity();
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    Tr.event(tc, "Replaying record " + l + " from the partner log");
                }
                logCursor2 = recoverableUnit.sections();
                block18: while (logCursor2.hasNext()) {
                    RecoverableUnitSection recoverableUnitSection = (RecoverableUnitSection)logCursor2.next();
                    int n4 = recoverableUnitSection.identity();
                    byte[] byArray = recoverableUnitSection.lastData();
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                        Tr.event(tc, "Replaying section " + n4, com.ibm.ejs.util.Util.toHexString(byArray));
                    }
                    switch (n4) {
                        case 34: {
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                Tr.debug(tc, "XA resources data record");
                            }
                            if (byArray == null) continue block18;
                            if (recoveryLog != this._recoverXaLog) {
                                XARecoveryData xARecoveryData = new XARecoveryData(recoveryLog, byArray, l);
                                this._recoveryPartnerLogTable.addEntry(xARecoveryData);
                            }
                            ++n;
                            continue block18;
                        }
                        case 35: {
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                Tr.debug(tc, "WS coordinator data record");
                            }
                            if (byArray == null) continue block18;
                            try {
                                WSCRecoveryData wSCRecoveryData = new WSCRecoveryData(this._failureScopeController, byArray, l);
                                this._recoveryPartnerLogTable.addEntry(wSCRecoveryData);
                                continue block18;
                            }
                            catch (Exception exception) {
                                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.Transaction.JTA.RecoveryManager.replayPartnerLog", "824", this);
                                Tr.error(tc, "WTRN0030_XARESOURCE_RECOVER_FAILURE", exception);
                                throw exception;
                            }
                        }
                        case 36: {
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                Tr.debug(tc, "JCA provider data record");
                            }
                            if (byArray == null) continue block18;
                            JCARecoveryData jCARecoveryData = new JCARecoveryData(this, byArray, l);
                            this._recoveryPartnerLogTable.addEntry(jCARecoveryData);
                            continue block18;
                        }
                        case 33: {
                            if (this._failureScopeController.localFailureScope()) {
                                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Class path data record");
                                }
                                if (this._classpathSection != null) {
                                    if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                                        Tr.event(tc, "Multiple log CLASSPATH_SECTIONs found");
                                    }
                                    Tr.warning(tc, "WTRN0019_LOGFILE_CORRUPTED", this._xaLog.logProperties().logName());
                                    throw new IOException(this._xaLog.logProperties().logName() + " corrupted");
                                }
                                if (this._partnerServiceData == null) {
                                    this._partnerServiceData = recoverableUnit;
                                } else if (this._partnerServiceData != recoverableUnit) {
                                    if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                                        Tr.event(tc, "Multiple log service data records found");
                                    }
                                    Tr.warning(tc, "WTRN0019_LOGFILE_CORRUPTED", this._xaLog.logProperties().logName());
                                    throw new IOException(this._xaLog.logProperties().logName() + " corrupted");
                                }
                                this._classpathSection = recoverableUnitSection;
                                if (byArray != null && byArray.length > 0) {
                                    _loggedClassPath = com.ibm.ejs.util.Util.toString(byArray);
                                }
                            } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                Tr.debug(tc, "Ignoring class path data record from peer server");
                            }
                            this._classPath = Configuration.getClassLoader().getClassPath();
                            continue block18;
                        }
                        case 32: {
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                Tr.debug(tc, "Server state data record");
                            }
                            if (this._stateSection != null) {
                                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                                    Tr.event(tc, "Multiple log SERVER_STATE_SECTIONs found");
                                }
                                Tr.warning(tc, "WTRN0019_LOGFILE_CORRUPTED", this._xaLog.logProperties().logName());
                                throw new IOException(this._xaLog.logProperties().logName() + " corrupted");
                            }
                            if (this._partnerServiceData == null) {
                                this._partnerServiceData = recoverableUnit;
                            } else if (this._partnerServiceData != recoverableUnit) {
                                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                                    Tr.event(tc, "Multiple log service data records found");
                                }
                                Tr.warning(tc, "WTRN0019_LOGFILE_CORRUPTED", this._xaLog.logProperties().logName());
                                throw new IOException(this._xaLog.logProperties().logName() + " corrupted");
                            }
                            this._stateSection = recoverableUnitSection;
                            ++n2;
                            int n5 = -1;
                            if (byArray != null && byArray.length > 3) {
                                n5 = Util.getIntFromBytes(byArray, 0, 4);
                            }
                            if (n5 == 1) {
                                if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) continue block18;
                                Tr.event(tc, "previous server may have crashed");
                                continue block18;
                            }
                            if (n5 == 3) {
                                if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) continue block18;
                                Tr.event(tc, "previous server closed down cleanly with transactions still running");
                                continue block18;
                            }
                            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                                Tr.event(tc, "Invalid log record data in SERVER_STATE_SECTION");
                            }
                            Tr.warning(tc, "WTRN0019_LOGFILE_CORRUPTED", this._xaLog.logProperties().logName());
                            throw new IOException(this._xaLog.logProperties().logName() + " corrupted");
                        }
                        case 255: {
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                Tr.debug(tc, "Server name data record");
                            }
                            if (this._partnerServerSection != null) {
                                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                                    Tr.event(tc, "Multiple log SERVER_DATA_SECTIONs found");
                                }
                                Tr.warning(tc, "WTRN0019_LOGFILE_CORRUPTED", this._xaLog.logProperties().logName());
                                throw new IOException(this._xaLog.logProperties().logName() + " corrupted");
                            }
                            if (this._partnerServiceData == null) {
                                this._partnerServiceData = recoverableUnit;
                            } else if (this._partnerServiceData != recoverableUnit) {
                                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                                    Tr.event(tc, "Multiple log service data records found");
                                }
                                Tr.warning(tc, "WTRN0019_LOGFILE_CORRUPTED", this._xaLog.logProperties().logName());
                                throw new IOException(this._xaLog.logProperties().logName() + " corrupted");
                            }
                            this._partnerServerSection = recoverableUnitSection;
                            ++n2;
                            if (byArray == null || byArray.length == 0) continue block18;
                            this._recoveredServerName = com.ibm.ejs.util.Util.toString(byArray);
                            if (this._failureScopeController.serverName().equals(this._recoveredServerName)) continue block18;
                            Tr.warning(tc, "WTRN0020_RECOVERING_TRANSACTIONS", this._recoveredServerName);
                            continue block18;
                        }
                        case 253: {
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                Tr.debug(tc, "Applid data record");
                            }
                            if (this._partnerApplIdSection != null) {
                                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                                    Tr.event(tc, "Multiple log APPLID_DATA_SECTIONs found");
                                }
                                Tr.warning(tc, "WTRN0019_LOGFILE_CORRUPTED", this._xaLog.logProperties().logName());
                                throw new IOException(this._xaLog.logProperties().logName() + " corrupted");
                            }
                            if (this._partnerServiceData == null) {
                                this._partnerServiceData = recoverableUnit;
                            } else if (this._partnerServiceData != recoverableUnit) {
                                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                                    Tr.event(tc, "Multiple log service data records found");
                                }
                                Tr.warning(tc, "WTRN0019_LOGFILE_CORRUPTED", this._xaLog.logProperties().logName());
                                throw new IOException(this._xaLog.logProperties().logName() + " corrupted");
                            }
                            this._partnerApplIdSection = recoverableUnitSection;
                            ++n2;
                            if (byArray == null) continue block18;
                            this._recoveredApplId = byArray;
                            continue block18;
                        }
                        case 254: {
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                Tr.debug(tc, "Epoch data record");
                            }
                            if (this._partnerEpochSection != null) {
                                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                                    Tr.event(tc, "Multiple log EPOCH_DATA_SECTIONs found");
                                }
                                Tr.warning(tc, "WTRN0019_LOGFILE_CORRUPTED", this._xaLog.logProperties().logName());
                                throw new IOException(this._xaLog.logProperties().logName() + " corrupted");
                            }
                            if (this._partnerServiceData == null) {
                                this._partnerServiceData = recoverableUnit;
                            } else if (this._partnerServiceData != recoverableUnit) {
                                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                                    Tr.event(tc, "Multiple log service data records found");
                                }
                                Tr.warning(tc, "WTRN0019_LOGFILE_CORRUPTED", this._xaLog.logProperties().logName());
                                throw new IOException(this._xaLog.logProperties().logName() + " corrupted");
                            }
                            this._partnerEpochSection = recoverableUnitSection;
                            ++n2;
                            if (byArray == null || byArray.length <= 3) continue block18;
                            this._recoveredEpoch = Util.getIntFromBytes(byArray, 0, 4);
                            if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue block18;
                            Tr.debug(tc, "Recovered epoch: " + this._recoveredEpoch);
                            continue block18;
                        }
                        case 31: {
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                Tr.debug(tc, "Low Watermark section");
                            }
                            if (this._partnerLowWatermarkSection != null) {
                                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                                    Tr.event(tc, "Multiple log LOW_WATERMARKs found");
                                }
                                Tr.warning(tc, "WTRN0019_LOGFILE_CORRUPTED", this._xaLog.logProperties().logName());
                                throw new IOException(this._xaLog.logProperties().logName() + " corrupted");
                            }
                            if (this._partnerServiceData == null) {
                                this._partnerServiceData = recoverableUnit;
                            } else if (this._partnerServiceData != recoverableUnit) {
                                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                                    Tr.event(tc, "Multiple log service data records found");
                                }
                                Tr.warning(tc, "WTRN0019_LOGFILE_CORRUPTED", this._xaLog.logProperties().logName());
                                throw new IOException(this._xaLog.logProperties().logName() + " corrupted");
                            }
                            this._partnerLowWatermarkSection = recoverableUnitSection;
                            ++n2;
                            if (byArray != null && byArray.length > 3) {
                                this._partnerEntryLowWatermark = Util.getIntFromBytes(byArray, 0, 4);
                                continue block18;
                            }
                            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                                Tr.event(tc, "LowWatermark data is invalid");
                            }
                            Tr.warning(tc, "WTRN0019_LOGFILE_CORRUPTED", this._xaLog.logProperties().logName());
                            throw new IOException(this._xaLog.logProperties().logName() + " corrupted");
                        }
                        case 30: {
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                Tr.debug(tc, "Next Id section");
                            }
                            if (this._partnerNextIdSection != null) {
                                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                                    Tr.event(tc, "Multiple log NEXT_IDs found");
                                }
                                Tr.warning(tc, "WTRN0019_LOGFILE_CORRUPTED", this._xaLog.logProperties().logName());
                                throw new IOException(this._xaLog.logProperties().logName() + " corrupted");
                            }
                            if (this._partnerServiceData == null) {
                                this._partnerServiceData = recoverableUnit;
                            } else if (this._partnerServiceData != recoverableUnit) {
                                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                                    Tr.event(tc, "Multiple log service data records found");
                                }
                                Tr.warning(tc, "WTRN0019_LOGFILE_CORRUPTED", this._xaLog.logProperties().logName());
                                throw new IOException(this._xaLog.logProperties().logName() + " corrupted");
                            }
                            this._partnerNextIdSection = recoverableUnitSection;
                            ++n2;
                            if (byArray != null && byArray.length > 3) {
                                this._partnerEntryNextId = Util.getIntFromBytes(byArray, 0, 4);
                                continue block18;
                            }
                            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                                Tr.event(tc, "NextId data is invalid");
                            }
                            Tr.warning(tc, "WTRN0019_LOGFILE_CORRUPTED", this._xaLog.logProperties().logName());
                            throw new IOException(this._xaLog.logProperties().logName() + " corrupted");
                        }
                    }
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                        Tr.event(tc, "Invalid partner log data records found");
                    }
                    Tr.warning(tc, "WTRN0019_LOGFILE_CORRUPTED", this._xaLog.logProperties().logName());
                    throw new IOException(this._xaLog.logProperties().logName() + " corrupted");
                }
                logCursor2.close();
                if (!this.shutdownInProgress()) continue;
                bl = true;
            }
            logCursor.close();
        }
        if (!bl) {
            try {
                if (n3 > 1) {
                    if (n2 != 6) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                            Tr.event(tc, "Recoverable log records found without service data records. Got " + n2 + " expected " + 6);
                        }
                        Tr.warning(tc, "WTRN0019_LOGFILE_CORRUPTED", this._xaLog.logProperties().logName());
                        throw new IOException(this._xaLog.logProperties().logName() + " corrupted");
                    }
                } else if (n2 != 0 && n2 != 6) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                        Tr.event(tc, "Only a subset of service data records recovered");
                    }
                    Tr.warning(tc, "WTRN0019_LOGFILE_CORRUPTED", this._xaLog.logProperties().logName());
                    throw new IOException(this._xaLog.logProperties().logName() + " corrupted");
                }
            }
            catch (Throwable throwable) {
                FFDCFilter.processException(throwable, "com.ibm.ws.Transaction.JTA.RecoveryManager.replayPartnerLog", "980", this);
                if (logCursor2 != null) {
                    logCursor2.close();
                }
                if (logCursor != null) {
                    logCursor.close();
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "replayPartnerLog");
                }
                throw new SystemException(throwable.toString());
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "replayPartnerLog", new Integer(n));
        }
        return n;
    }

    void checkClassPath() throws Exception {
        this.checkClassPath(false);
    }

    private synchronized void checkClassPath(boolean bl) throws Exception {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "checkClassPath", new Boolean(bl));
        }
        if (this._failureScopeController.localFailureScope() && (this._xaLog != null || PlatformHelperFactory.getPlatformHelper().isCRAJvm())) {
            try {
                String string;
                Object object;
                if (this._partnerLogEnq != null) {
                    this._partnerLogEnq.obtainExclusive();
                    if (this._classpathSection == null) {
                        this._classpathSection = this._partnerServiceData.lookupSection(33);
                    }
                    if (this._classpathSection != null) {
                        try {
                            object = this._classpathSection.lastData();
                            if (object != null && ((Object)object).length > 0) {
                                _loggedClassPath = com.ibm.ejs.util.Util.toString((byte[])object);
                            }
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                }
                object = Configuration.getClassLoader().getClassPath();
                boolean bl2 = false;
                if (this._classPath == null) {
                    this._classPath = object;
                    bl2 = true;
                } else {
                    string = this.filterClassPaths(this._classPath, (String)object);
                    if (string != null && string.length() != 0) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            RecoveryManager.traceDebugClassPath(tc, "Classloader classpath:", (String)object);
                            Tr.debug(tc, "New classpaths: " + string);
                        }
                        this._classPath = string + File.pathSeparatorChar + this._classPath;
                        bl2 = true;
                    }
                }
                if (bl2 || bl) {
                    Object object2;
                    this.waitForReplayCompletion();
                    if (this._classpathSection == null) {
                        this._classpathSection = this._partnerServiceData.createSection(33, true);
                    }
                    string = this._classPath;
                    if (!NativeServerInstanceData.getRecoveryComplete() && (object2 = this.getExtraPaths()) != null && ((String)object2).length() > 0) {
                        string = (String)object2 + File.pathSeparator + this._classPath;
                    }
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        RecoveryManager.traceDebugClassPath(tc, "Saving classpath:", string);
                    }
                    object2 = com.ibm.ejs.util.Util.byteArray(string);
                    this._classpathSection.addData((byte[])object2);
                    this._partnerServiceData.forceSections();
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.Transaction.JTA.RecoveryManager.checkClassPath", "1059", this);
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "checkClassPath", exception);
                }
                throw exception;
            }
            finally {
                if (this._partnerLogEnq != null) {
                    this._partnerLogEnq.release();
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "checkClassPath");
        }
    }

    public static void traceDebugClassPath(TraceComponent traceComponent, String string, String string2) {
        Tr.debug(traceComponent, string);
        StringTokenizer stringTokenizer = new StringTokenizer(string2, File.pathSeparator);
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            Tr.debug(traceComponent, "classpath[" + n + "]=" + stringTokenizer.nextToken());
            ++n;
        }
    }

    public ExtClassLoader addExtraPaths() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "addExtraPaths");
        }
        ExtClassLoader extClassLoader = null;
        String string = this.getExtraPaths();
        if (string != null && string.length() != 0) {
            ExtClassLoader extClassLoader2 = Configuration.getClassLoader();
            extClassLoader = new ExtClassLoader(string, (ClassLoader)extClassLoader2);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "addExtraPaths", extClassLoader);
        }
        return extClassLoader;
    }

    private String filterClassPaths(String string, String string2) {
        String string3;
        Iterator iterator;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "filterClassPaths", new Object[]{string, string2});
        }
        HashSet<String> hashSet = new HashSet<String>();
        if (string != null) {
            iterator = new StringTokenizer(string, File.pathSeparator);
            while (((StringTokenizer)((Object)iterator)).hasMoreTokens()) {
                String string4 = ((StringTokenizer)((Object)iterator)).nextToken();
                if (hashSet.contains(string4)) continue;
                hashSet.add(string4);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "current classpath entries from hashset:");
            iterator = hashSet.iterator();
            int n = 0;
            while (iterator.hasNext()) {
                Tr.debug(tc, "classpath[" + n + "]=" + (String)iterator.next());
                ++n;
            }
            RecoveryManager.traceDebugClassPath(tc, "Logged classpath:", string2);
        }
        iterator = new StringBuffer();
        StringTokenizer stringTokenizer = new StringTokenizer(string2, File.pathSeparator);
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            string3 = stringTokenizer.nextToken();
            if (hashSet.contains(string3)) continue;
            if (n++ > 0) {
                ((StringBuffer)((Object)iterator)).append(File.pathSeparator);
            }
            ((StringBuffer)((Object)iterator)).append(string3);
        }
        string3 = n > 0 ? ((StringBuffer)((Object)iterator)).toString() : null;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "filterClassPaths", string3);
        }
        return string3;
    }

    private void updateTranLogServiceData() throws Exception {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "updateTranLogServiceData");
        }
        try {
            if (this._tranlogServiceData == null) {
                this._tranlogServiceData = this._tranLog.createRecoverableUnit();
                this._tranlogServerSection = this._tranlogServiceData.createSection(255, true);
                this._tranlogApplIdSection = this._tranlogServiceData.createSection(253, true);
                this._tranlogEpochSection = this._tranlogServiceData.createSection(254, true);
                this._tranlogServerSection.addData(com.ibm.ejs.util.Util.byteArray(this._failureScopeController.serverName()));
                this._tranlogApplIdSection.addData(this._ourApplId);
            }
            this._tranlogEpochSection.addData(Util.intToBytes(this._ourEpoch));
            this._tranlogServiceData.forceSections();
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.Transaction.JTA.RecoveryManager.updateTranLogSeviceData", "1130", this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "updateTranLogServiceData", exception);
            }
            throw exception;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "updateTranLogServiceData");
        }
    }

    private void updatePartnerServiceData() throws Exception {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "updatePartnerServiceData");
        }
        try {
            if (this._partnerServiceData == null) {
                this._partnerServiceData = this._recoverXaLog != null ? this._recoverXaLog.createRecoverableUnit() : this._xaLog.createRecoverableUnit();
                this._partnerServerSection = this._partnerServiceData.createSection(255, true);
                this._partnerApplIdSection = this._partnerServiceData.createSection(253, true);
                this._partnerEpochSection = this._partnerServiceData.createSection(254, true);
                this._partnerLowWatermarkSection = this._partnerServiceData.createSection(31, true);
                this._partnerNextIdSection = this._partnerServiceData.createSection(30, true);
                this._partnerServerSection.addData(com.ibm.ejs.util.Util.byteArray(this._failureScopeController.serverName()));
                this._partnerApplIdSection.addData(this._ourApplId);
                this._partnerEntryLowWatermark = 1;
                this._partnerLowWatermarkSection.addData(Util.intToBytes(this._partnerEntryLowWatermark));
                this._partnerEntryNextId = 2;
                this._partnerNextIdSection.addData(Util.intToBytes(this._partnerEntryNextId));
            }
            this._partnerEpochSection.addData(Util.intToBytes(this._ourEpoch));
            this.updateServerState(1);
            this._partnerServiceData.forceSections();
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.Transaction.JTA.RecoveryManager.updatePartnerSeviceData", "1224", this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "updatePartnerServiceData", exception);
            }
            throw exception;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "updatePartnerServiceData");
        }
    }

    private void updateServerState(int n) throws Exception {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "updateServerState", new Integer(n));
        }
        try {
            if (this._stateSection == null) {
                this._stateSection = this._partnerServiceData.createSection(32, true);
            }
            this._stateSection.addData(Util.intToBytes(n));
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.Transaction.JTA.RecoveryManager.updateServerState", "1250", this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "updateServerState", exception);
            }
            throw exception;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "updateServerState");
        }
    }

    public void waitForReplayCompletion() {
        block7: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.entry(tc, "waitForReplayCompletion");
            }
            if (!this._replayCompleted) {
                try {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                        Tr.event(tc, "starting to wait for replay completion");
                    }
                    this._replayInProgress.waitEvent();
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                        Tr.event(tc, "completed wait for replay completion");
                    }
                }
                catch (InterruptedException interruptedException) {
                    FFDCFilter.processException((Throwable)interruptedException, "com.ibm.ws.Transaction.JTA.RecoveryManager.waitForReplayCompletion", "1242", this);
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) break block7;
                    Tr.event(tc, "Wait for resync complete interrupted.");
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "waitForReplayCompletion");
        }
    }

    public void replayComplete() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "replayComplete");
        }
        FailureScopeLifeCycle failureScopeLifeCycle = FailureScopeLifeCycleHelper.addToActiveList(this._failureScopeController.failureScope(), this._failureScopeController.localFailureScope());
        this._failureScopeController.setFailureScopeLifeCycle(failureScopeLifeCycle);
        this._replayCompleted = true;
        this._replayInProgress.post();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "replayComplete");
        }
    }

    private void waitForRecoveryCompletion() {
        block7: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.entry(tc, "waitForRecoveryCompletion");
            }
            if (!this._recoveryCompleted) {
                try {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                        Tr.event(tc, "starting to wait for recovery completion");
                    }
                    this._recoveryInProgress.waitEvent();
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                        Tr.event(tc, "completed wait for recovery completion");
                    }
                }
                catch (InterruptedException interruptedException) {
                    FFDCFilter.processException((Throwable)interruptedException, "com.ibm.ws.Transaction.JTA.RecoveryManager.waitForRecoveryCompletion", "1242", this);
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) break block7;
                    Tr.event(tc, "Wait for recovery complete interrupted.");
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "waitForRecoveryCompletion");
        }
    }

    public void recoveryComplete() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "recoveryComplete");
        }
        if (!this._recoveryCompleted) {
            this._recoveryCompleted = true;
            this._recoveryInProgress.post();
            if (recoveryOnlyMode) {
                Configuration.getTxServiceImpl().recoveryComplete();
            }
        }
        if (this._agent != null) {
            try {
                RecoveryDirectorFactory.recoveryDirector().initialRecoveryComplete(this._agent, this._failureScopeController.failureScope());
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.Transaction.JTA.RecoveryManager.recoveryComplete", "1546", this);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "recoveryComplete");
        }
    }

    private void recoveryFailed(Throwable throwable) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "recoveryFailed");
        }
        if (!this._recoveryCompleted) {
            this._recoveryCompleted = true;
            this._recoveryInProgress.post();
            if (recoveryOnlyMode) {
                Configuration.getTxServiceImpl().recoveryComplete();
            }
        }
        if (this._failureScopeController.localFailureScope()) {
            Configuration.getTxServiceImpl().asynchRecoveryProcessingComplete(throwable);
        } else if (this._agent != null) {
            try {
                RecoveryDirectorFactory.recoveryDirector().initialRecoveryFailed(this._agent, this._failureScopeController.failureScope());
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.Transaction.JTA.RecoveryManager.recoveryComplete", "1546", this);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "recoveryFailed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean shutdownInProgress() {
        Object object = this._recoveryMonitor;
        synchronized (object) {
            if (this._shutdownInProgress && !this._recoveryCompleted) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    Tr.event(tc, "Shutdown is in progress, stopping recovery processing");
                }
                this.recoveryComplete();
                if (this._failureScopeController.localFailureScope()) {
                    Configuration.getTxServiceImpl().asynchRecoveryProcessingComplete(null);
                }
            }
        }
        return this._shutdownInProgress;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resync(int n) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "resync", new Integer(n));
        }
        boolean bl = n == 0;
        ExtClassLoader extClassLoader = Configuration.getClassLoader();
        if (!bl) {
            this.waitForClassLoader();
            String string = this.getExtraPaths();
            if (string != null && string.length() != 0) {
                extClassLoader = new ExtClassLoader(string, (ClassLoader)extClassLoader);
                Thread.currentThread().setContextClassLoader((ClassLoader)extClassLoader);
                if (TraceComponent.isAnyTracingEnabled()) {
                    if (tc.isEventEnabled()) {
                        Tr.event(tc, "New Class loader: ", extClassLoader);
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "New Class loader classpath: ", extClassLoader.getClassPath());
                    }
                }
            }
        }
        int n2 = 0;
        int n3 = TransactionImpl.heuristicRetryWait <= 0 ? 60 : TransactionImpl.heuristicRetryWait;
        boolean bl2 = true;
        boolean bl3 = this.shutdownInProgress();
        while (!bl3) {
            int n4;
            TransactionImpl[] transactionImplArray = new TransactionImpl[this._recoveringTransactions.size()];
            this._recoveringTransactions.toArray(transactionImplArray);
            if (!bl) {
                Xid[] xidArray = new Xid[transactionImplArray.length];
                for (int i = 0; i < transactionImplArray.length; ++i) {
                    xidArray[i] = transactionImplArray[i].getXid();
                }
                bl = this._recoveryPartnerLogTable.recover(this, (ClassLoader)extClassLoader, xidArray);
            }
            for (n4 = 0; n4 < transactionImplArray.length && !(bl3 = this.shutdownInProgress()); ++n4) {
                try {
                    if (recoveryOnlyMode && transactionImplArray[n4].isRAImport()) continue;
                    transactionImplArray[n4].recover();
                    if (!recoveryOnlyMode || transactionImplArray[n4].getTransactionState().getState() == -1) continue;
                    Tr.warning(tc, "WTRN0114_TRAN_RETRY_NEEDED", new Object[]{transactionImplArray[n4].getTranName(), new Integer(n3)});
                    continue;
                }
                catch (Throwable throwable) {
                    FFDCFilter.processException(throwable, "com.ibm.ws.Transaction.JTA.RecoveryManager.resync", "1654", this);
                    Tr.error(tc, "WTRN0016_EXC_DURING_RECOVERY", throwable);
                }
            }
            bl3 = this.shutdownInProgress();
            if (bl3) break;
            if (recoveryOnlyMode) {
                n4 = !this.recoveryModeTxnsComplete() ? 1 : 0;
            } else {
                int n5 = n4 = this._recoveringTransactions.size() > 0 ? 1 : 0;
            }
            if (!bl || n4 != 0) {
                block45: {
                    if (n2 == 0 && !recoveryOnlyMode && this._failureScopeController.localFailureScope()) {
                        this.recoveryComplete();
                        bl2 = false;
                    }
                    if (++n2 % 10 == 0 && n3 < 0x3FFFFFFF) {
                        n3 *= 2;
                    }
                    try {
                        Object object = this._recoveryMonitor;
                        synchronized (object) {
                            if (!this._shutdownInProgress) {
                                this._recoveryMonitor.wait((long)n3 * 1000L);
                            }
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block45;
                        Tr.debug(tc, "Resync wait interrupted");
                    }
                }
                bl3 = this.shutdownInProgress();
                continue;
            }
            if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break;
            Tr.debug(tc, "Resync completed");
            break;
        }
        if (bl3) {
            if (this._failureScopeController.localFailureScope()) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "local failure scope resync interupted");
                }
            } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Non-local failure scope resync interupted");
            }
        } else if (bl && this._recoveringTransactions.size() == 0) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Clearing any unused partners from partner log");
            }
            if (!this._failureScopeController.localFailureScope()) {
                this._cleanRemoteShutdown = true;
                try {
                    this.preShutdown(false);
                    this._recoveryPartnerLogTable.clearUnused();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.postShutdown(false);
            } else {
                boolean bl4 = false;
                if (this._tranLog != null && this._tranLog instanceof DistributedRecoveryLog) {
                    try {
                        ((DistributedRecoveryLog)this._tranLog).keypoint();
                    }
                    catch (Exception exception) {
                        FFDCFilter.processException((Throwable)exception, "com.ibm.ws.Transaction.JTA.RecoveryManager.resync", "1974", this);
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug(tc, "keypoint of transaction log failed ... partner log will not be tidied", exception);
                        }
                        bl4 = true;
                    }
                }
                if (!bl4) {
                    this._recoveryPartnerLogTable.clearUnused();
                }
            }
            if (bl2) {
                this.recoveryComplete();
            }
        } else {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Transactions were active. Not clearing any unused partners from partner log");
            }
            if (bl2) {
                this.recoveryComplete();
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "resync");
        }
    }

    void cleanupRemoteFailureScope() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "cleanupRemoteFailureScope");
        }
        if (!this._failureScopeController.localFailureScope()) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Stop processing. Clear down any transactions");
            }
            if (this._recoveringTransactions.size() > 0) {
                TransactionImpl[] transactionImplArray = new TransactionImpl[this._recoveringTransactions.size()];
                this._recoveringTransactions.toArray(transactionImplArray);
                for (int i = 0; i < transactionImplArray.length; ++i) {
                    try {
                        transactionImplArray[i].forgetTransaction(false);
                        continue;
                    }
                    catch (Throwable throwable) {
                        FFDCFilter.processException(throwable, "com.ibm.ws.Transaction.JTA.RecoveryManager.cleanupRemoteFailureScope", "2069", this);
                    }
                }
            }
            if (!this._cleanRemoteShutdown) {
                try {
                    this.preShutdown(true);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.postShutdown(true);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "cleanupRemoteFailureScope");
        }
    }

    private void closeLogs() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "closeLogs");
        }
        if (this._tranLog != null && this._tranLog instanceof DistributedRecoveryLog) {
            try {
                ((DistributedRecoveryLog)this._tranLog).closeLogImmediate();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this._tranLog = null;
        }
        if (this._xaLog != null && this._xaLog instanceof DistributedRecoveryLog) {
            try {
                ((DistributedRecoveryLog)this._xaLog).closeLogImmediate();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this._xaLog = null;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "closeLogs");
        }
    }

    private void waitForClassLoader() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "waitForClassLoader");
        }
        while (true) {
            try {
                _ClassLoaderReady.waitEvent();
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "waitForClassLoader");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runWithEnq() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "runWithEnq");
        }
        if (this._partnerLogEnq != null) {
            this._partnerLogEnq.obtainExclusive();
        }
        try {
            this.run();
        }
        finally {
            if (this._partnerLogEnq != null) {
                this._partnerLogEnq.release();
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "runWithEnq");
            }
        }
    }

    public void run() {
        int n;
        if (TraceComponent.isAnyTracingEnabled()) {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "run");
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Performing processing for " + this._failureScopeController.serverName());
            }
        }
        if (this._tranLog != null) {
            try {
                this._tranLog.openLog();
            }
            catch (LogIncompatibleException logIncompatibleException) {
                this.haltDownlevelRecovery();
                this.recoveryComplete();
                if (this._failureScopeController.localFailureScope()) {
                    Configuration.getTxServiceImpl().asynchRecoveryProcessingComplete(logIncompatibleException);
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "run");
                }
                return;
            }
            catch (LogAllocationException logAllocationException) {
                FFDCFilter.processException((Throwable)logAllocationException, "com.ibm.ws.Transaction.JTA.RecoveryManager.run", "1830", this);
                Tr.error(tc, "WTRN0111_LOG_ALLOCATION", this._tranLog);
                this.closeLogs();
                this.recoveryFailed(logAllocationException);
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "run");
                }
                return;
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.Transaction.JTA.RecoveryManager.run", "1698", this);
                Tr.error(tc, "WTRN0112_LOG_OPEN_FAILURE", this._tranLog);
                this.closeLogs();
                this.recoveryFailed(exception);
                if (TraceComponent.isAnyTracingEnabled()) {
                    if (tc.isEventEnabled()) {
                        Tr.event(tc, "Exception caught opening transaction recovery log!", exception);
                    }
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "run");
                    }
                }
                return;
            }
        }
        if (this.shutdownInProgress()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "run");
            }
            return;
        }
        if (this._xaLog != null) {
            try {
                this._xaLog.openLog();
                if (this._recoverXaLog != null) {
                    this._recoverXaLog.openLog();
                }
            }
            catch (LogIncompatibleException logIncompatibleException) {
                this.haltDownlevelRecovery();
                this.recoveryComplete();
                if (this._failureScopeController.localFailureScope()) {
                    Configuration.getTxServiceImpl().asynchRecoveryProcessingComplete(logIncompatibleException);
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "run");
                }
                return;
            }
            catch (LogAllocationException logAllocationException) {
                FFDCFilter.processException((Throwable)logAllocationException, "com.ibm.ws.Transaction.JTA.RecoveryManager.run", "1922", this);
                Tr.error(tc, "WTRN0111_LOG_ALLOCATION", this._xaLog);
                this.closeLogs();
                this.recoveryFailed(logAllocationException);
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "run");
                }
                return;
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.Transaction.JTA.RecoveryManager.run", "1723", this);
                Tr.error(tc, "WTRN0112_LOG_OPEN_FAILURE", this._xaLog);
                this.closeLogs();
                this.recoveryFailed(exception);
                if (TraceComponent.isAnyTracingEnabled()) {
                    if (tc.isEventEnabled()) {
                        Tr.event(tc, "Exception caught opening XA resources recovery log!", exception);
                    }
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "run");
                    }
                }
                return;
            }
        }
        if (this.shutdownInProgress()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "run");
            }
            return;
        }
        if (this._xaLog != null) {
            try {
                n = this.replayPartnerLog();
            }
            catch (Throwable throwable) {
                FFDCFilter.processException(throwable, "com.ibm.ws.Transaction.JTA.RecoveryManager.run", "1814", this);
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    Tr.event(tc, "An unexpected error occured during partner log replay: " + throwable);
                }
                this.closeLogs();
                this.recoveryFailed(throwable);
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "run");
                }
                return;
            }
        } else {
            n = 0;
        }
        if (this.shutdownInProgress()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "run");
            }
            return;
        }
        if (this._tranLog != null) {
            try {
                this.replayTranLog();
            }
            catch (Throwable throwable) {
                FFDCFilter.processException(throwable, "com.ibm.ws.Transaction.JTA.RecoveryManager.run", "1842", this);
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    Tr.event(tc, "An unexpected error occured during transaction log replay: " + throwable);
                }
                this.closeLogs();
                this.recoveryFailed(throwable);
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "run");
                }
                return;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "_recoveredApplId = " + this._recoveredApplId);
            Tr.debug(tc, "_recoveredEpoch = " + this._recoveredEpoch);
        }
        if (this.shutdownInProgress()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "run");
            }
            return;
        }
        if (TxProperties.SINGLE_PROCESS) {
            if (this._recoveredApplId != null) {
                this._ourApplId = this._recoveredApplId;
            }
            if (this._recoveredEpoch >= this._ourEpoch) {
                this._ourEpoch = this._recoveredEpoch + 1;
            }
        }
        if (this._failureScopeController.localFailureScope()) {
            Configuration.setApplId(this._ourApplId);
            Configuration.setCurrentEpoch(this._ourEpoch);
        }
        if (this._ourApplId != null) {
            this._failureScopeController.registerWSCoordinator(this._ourApplId);
        }
        if (this._xaLog != null) {
            try {
                if (this._failureScopeController.localFailureScope()) {
                    if (this._tranLog != null) {
                        this.updateTranLogServiceData();
                    }
                    this.updatePartnerServiceData();
                }
                if (this.shutdownInProgress()) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        Tr.exit(tc, "run");
                    }
                    return;
                }
                if (this._tranLog != null) {
                    this._tranLog.recoveryComplete();
                }
                if (this.shutdownInProgress()) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        Tr.exit(tc, "run");
                    }
                    return;
                }
                if (this._xaLog != null) {
                    this._xaLog.recoveryComplete();
                }
                if (this.shutdownInProgress()) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        Tr.exit(tc, "run");
                    }
                    return;
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.Transaction.JTA.RecoveryManager.run", "1866", this);
                Tr.error(tc, "WTRN0026_KEYPOINT_EXC_IN_RECOVERY", exception);
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    Tr.event(tc, "An unexpected error occured during keypointing: " + exception);
                }
                this.recoveryFailed(exception);
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "run");
                }
                return;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event(tc, "replay completed");
        }
        this.replayComplete();
        TranManagerSet.instance().replayComplete(this._failureScopeController.localFailureScope());
        if (TxProperties.SINGLE_PROCESS) {
            int n2 = this._recoveringTransactions.size();
            if (n2 == 1) {
                Tr.audit(tc, "WTRN0027_RECOVERING_TXN");
            } else {
                Tr.audit(tc, "WTRN0028_RECOVERING_TXNS", new Integer(n2));
            }
            this.resync(n);
        } else {
            this.recoveryComplete();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "run");
        }
    }

    private String getExtraPaths() {
        if (_extraPaths == null) {
            if (_loggedClassPath != null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Logged Classpath exists");
                }
                _extraPaths = this.filterClassPaths(Configuration.getClassLoader().getClassPath(), _loggedClassPath);
            } else {
                _extraPaths = "";
            }
        }
        return _extraPaths;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int allocateRecoveryId() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "allocateRecoveryId");
        }
        int n = -1;
        this._partnerLogEnq.obtainExclusive();
        try {
            LogCursor logCursor = this._partnerNextIdSection.data();
            byte[] byArray = (byte[])logCursor.last();
            n = Util.getIntFromBytes(byArray, 0, 4);
            logCursor.close();
            int n2 = 1;
            if (n == this._partnerEntryLowWatermark) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    Tr.event(tc, "Cannot allocate ID because the low watermark has been reached");
                }
            } else if (n != Integer.MAX_VALUE) {
                n2 = n + 1;
            }
            byArray = Util.intToBytes(n2);
            this._partnerNextIdSection.addData(byArray);
            this._partnerNextIdSection.force();
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.Transaction.JTA.RecoveryManager.allocateRecoveryId", "2109", this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event(tc, "Unable to allocate a new id", throwable);
            }
            n = -1;
        }
        finally {
            this._partnerLogEnq.release();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "allocateRecoveryId", new Integer(n));
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLowWatermark() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "setLowWatermark");
        }
        int n = 1;
        LogCursor logCursor = null;
        try {
            Object object;
            this._partnerLogEnq.obtainExclusive();
            logCursor = this._xaLog.recoverableUnits();
            if (logCursor != null && logCursor.initialSize() > 0) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Computing new low watermark");
                }
                object = new TreeSet();
                int n2 = this.getLowWatermark();
                while (logCursor.hasNext()) {
                    RecoverableUnit recoverableUnit = (RecoverableUnit)logCursor.next();
                    Integer n3 = new Integer((int)recoverableUnit.identity());
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "Processing RecoverableUnit", n3);
                    }
                    ((TreeSet)object).add(n3);
                }
                ((TreeSet)object).remove(new Integer((int)this._partnerServiceData.identity()));
                if (!((TreeSet)object).isEmpty()) {
                    int n4 = (Integer)((TreeSet)object).first();
                    int n5 = (Integer)((TreeSet)object).last();
                    if (n4 >= n2) {
                        n = n4;
                    } else if (n5 >= n2) {
                        SortedSet<Integer> sortedSet = ((TreeSet)object).tailSet(new Integer(n2));
                        n = sortedSet.first();
                    } else {
                        n = n4;
                    }
                } else {
                    n = n2;
                }
            } else {
                object = null;
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "The log is empty");
                }
                try {
                    object = this._partnerNextIdSection.data();
                    byte[] byArray = (byte[])object.last();
                    int n6 = Util.getIntFromBytes(byArray, 0, 4);
                    n = n6 == 1 ? Integer.MAX_VALUE : n6 - 1;
                }
                finally {
                    if (object != null) {
                        object.close();
                    }
                }
            }
            object = Util.intToBytes(n);
            this._partnerLowWatermarkSection.addData((byte[])object);
            this._partnerLowWatermarkSection.force();
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.Transaction.JTA.RecoveryManager.setLowWatermark", "1808", this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event(tc, "Unable to set low watermark", throwable);
            }
        }
        finally {
            this._partnerLogEnq.release();
            if (logCursor != null) {
                logCursor.close();
            }
        }
        try {
            this.checkClassPath(true);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "setLowWatermark", new Integer(n));
        }
    }

    int getLowWatermark() {
        return this._partnerEntryLowWatermark;
    }

    public static void classLoaderReady() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "classLoaderReady");
        }
        _ClassLoaderReady.post();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "classLoaderReady");
        }
    }

    public void registerTransaction(TransactionImpl transactionImpl) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "registerTransaction", new Object[]{this, transactionImpl});
        }
        this._recoveringTransactions.add(transactionImpl);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "registerTransaction", new Integer(this._recoveringTransactions.size()));
        }
    }

    public void deregisterTransaction(TransactionImpl transactionImpl) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "deregisterTransaction", new Object[]{this, transactionImpl});
        }
        this._recoveringTransactions.remove(transactionImpl);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "deregisterTransaction", new Integer(this._recoveringTransactions.size()));
        }
    }

    private boolean recoveryModeTxnsComplete() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "recoveryModeTxnsComplete");
        }
        boolean bl = true;
        if (this._recoveringTransactions != null) {
            Iterator iterator = this._recoveringTransactions.iterator();
            while (iterator.hasNext()) {
                TransactionImpl transactionImpl = (TransactionImpl)iterator.next();
                if (transactionImpl == null || transactionImpl.isRAImport()) continue;
                bl = false;
                break;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "recoveryModeTxnsComplete", new Boolean(bl));
        }
        return bl;
    }

    public boolean recoveryPrevented() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "recoveryPrevented", this._recoveryPrevented);
        }
        return this._recoveryPrevented;
    }

    public void haltDownlevelRecovery() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "haltDownlevelRecovery");
        }
        this._recoveryPrevented = true;
        FailureScope failureScope = this._failureScopeController.failureScope();
        Tr.warning(tc, "WTRN0113_LOG_DOWNLEVEL", failureScope);
        if (TraceComponent.isAnyTracingEnabled()) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Halting recovery processing of downlevel transaction recovery log for failure scope" + failureScope + ")");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "haltDownlevelRecovery");
            }
        }
    }

    public static void setAppsAreLoaded() {
        _appsAreLoaded = true;
    }

    public static boolean appsAreLoaded() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "appsAreLoaded", _appsAreLoaded);
        }
        return _appsAreLoaded;
    }

    static {
        _ClassLoaderReady = new EventSemaphore();
    }
}

