/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.Transaction.JTA;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.Transaction.IllegalResourceIn2PCTransactionException;
import com.ibm.ws.Transaction.JTA.ASWrapper;
import com.ibm.ws.Transaction.JTA.HeuristicHazardException;
import com.ibm.ws.Transaction.JTA.HeuristicOutcome;
import com.ibm.ws.Transaction.JTA.JTAResource;
import com.ibm.ws.Transaction.JTA.JTAResourceBase;
import com.ibm.ws.Transaction.JTA.JTAXAResource;
import com.ibm.ws.Transaction.JTA.JTAXAResourceImpl;
import com.ibm.ws.Transaction.JTA.OnePhaseResourceImpl;
import com.ibm.ws.Transaction.JTA.RecoveryManager;
import com.ibm.ws.Transaction.JTA.ResourceSupportsOnePhaseCommit;
import com.ibm.ws.Transaction.JTA.ResourceWrapper;
import com.ibm.ws.Transaction.JTA.TransactionImpl;
import com.ibm.ws.Transaction.JTA.TransactionState;
import com.ibm.ws.Transaction.JTA.Util;
import com.ibm.ws.Transaction.JTA.XAPdataWrapper;
import com.ibm.ws.Transaction.JTA.XARecoveryData;
import com.ibm.ws.Transaction.JTA.XAReturnCodeHelper;
import com.ibm.ws.Transaction.JTA.XidImpl;
import com.ibm.ws.Transaction.JTS.CORBAResourceWrapper;
import com.ibm.ws.Transaction.JTS.Configuration;
import com.ibm.ws.Transaction.JTS.RecoveryCoordinatorImpl;
import com.ibm.ws.Transaction.JTS.TransactionWrapper;
import com.ibm.ws.Transaction.JTS.WSCoordinatorImpl;
import com.ibm.ws.Transaction.JTS.WSCoordinatorWrapper;
import com.ibm.ws.Transaction.OnePhaseXAResource;
import com.ibm.ws.Transaction.XAResourceInfo;
import com.ibm.ws.Transaction.test.XAFlowCallbackControl;
import com.ibm.ws.Transaction.wstx.JTAAsyncResourceBase;
import com.ibm.ws.Transaction.wstx.JTAAsyncResponseHelper;
import com.ibm.ws.Transaction.wstx.JTAAsyncResponseTarget;
import com.ibm.ws.Transaction.wstx.Semaphore;
import com.ibm.ws.Transaction.wstx.WSATControlSet;
import com.ibm.ws.Transaction.wstx.WSATCoordinatorPortDistImpl;
import com.ibm.ws.Transaction.wstx.WSATParticipantWrapper;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.recoverylog.spi.InternalLogException;
import com.ibm.ws.recoverylog.spi.LogCursor;
import com.ibm.ws.recoverylog.spi.RecoverableUnit;
import com.ibm.ws.recoverylog.spi.RecoverableUnitSection;
import com.ibm.ws.runtime.metadata.ApplicationMetaData;
import com.ibm.ws.runtime.metadata.ComponentMetaData;
import com.ibm.ws.runtime.metadata.MetaDataSlot;
import com.ibm.ws.runtime.metadata.ModuleMetaData;
import com.ibm.ws.threadContext.ComponentMetaDataAccessorImpl;
import java.util.ArrayList;
import java.util.HashMap;
import javax.transaction.HeuristicCommitException;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;

public final class RegisteredResources {
    static final TraceComponent tc = Tr.register(RegisteredResources.class, "Transaction", "com.ibm.ws.Transaction.resources.TransactionMsgs");
    private static final boolean xaFlowCallbackEnabled = XAFlowCallbackControl.isEnabled();
    private static final int MAX_PDATA_SIZE = 3072;
    private final ArrayList _resourceObjects;
    private ArrayList _failedResourceList;
    private OnePhaseResourceImpl _onePhaseResourceEnlisted;
    private Xid _txServiceXid;
    private int _branchCount;
    private static MetaDataSlot _applicationSlotLPSEnabled;
    private boolean _LPSProhibited;
    private boolean _retryCompletion;
    final TransactionImpl _transaction;
    private HashMap _resourceTable;
    private RecoverableUnit _logUnit;
    private RecoverableUnitSection _logSection;
    private RecoverableUnitSection _xalogSection;
    private RecoverableUnitSection _wscResourceSection;
    private RecoverableUnitSection _hoSection;
    private RecoverableUnitSection _wsatAsyncSection;
    private boolean _resourcesLogged;
    private boolean _disableRmfailLogging;
    private int _heuristicOutcome;
    private Throwable _systemException;
    private boolean _retryRequired;
    private boolean _outcome;
    private Semaphore _asyncSemaphore;
    private int _errorCode;
    public static final int XA_OK = 0;
    public static final int XA_RDONLY = 3;
    public static final int ONE_PHASE_OPT = 10;
    public static final int ONE_PHASE_OPT_ROLLBACK = 11;
    public static final int ONE_PHASE_OPT_FAILED = 12;
    private static final String IGNORE_RMFAIL_FROM_WSAT_CLASS = "com.ibm.ws.Transaction.wstx.WSATParticipantWrapper";
    private boolean _disableTwoPhase;
    private boolean _diagnosticsRequired;
    private boolean _sorted;
    private boolean _gotCommitInLastPhaseResources;
    private boolean _isCheckingSameRM = false;
    private JTAXAResourceImpl _sameRMMasterResource;
    private JTAXAResourceImpl _sameRMResource;
    private boolean _LPSEnabledTx = false;
    private static boolean _acceptHeuristicHazard;

    RegisteredResources(TransactionImpl transactionImpl, boolean bl, boolean bl2) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "RegisteredResources", new Object[]{transactionImpl, bl, bl2});
        }
        this._resourceObjects = new ArrayList();
        this._transaction = transactionImpl;
        this._txServiceXid = transactionImpl.getXid();
        this._disableTwoPhase = bl;
        this._disableRmfailLogging = Configuration.getTxServiceImpl().disableRmfailLogging();
        this._LPSEnabledTx = bl2;
        if (_acceptHeuristicHazard) {
            this._LPSEnabledTx = true;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "RegisteredResources");
        }
    }

    boolean enlistResource(XAResource xAResource) throws RollbackException, SystemException, IllegalStateException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "enlistResource", xAResource);
        }
        if (this._disableTwoPhase && this._resourceObjects.size() > 0) {
            IllegalStateException illegalStateException = new IllegalStateException("Unable to enlist a second resource within the transaction. Two phase support is disabled as the recovery log was not available at transaction start");
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "enlistResource (SPI)", illegalStateException);
            }
            throw illegalStateException;
        }
        OnePhaseResourceImpl onePhaseResourceImpl = new OnePhaseResourceImpl((OnePhaseXAResource)xAResource, this._txServiceXid);
        boolean bl = true;
        if (this._onePhaseResourceEnlisted != null) {
            if (this._onePhaseResourceEnlisted.equals(onePhaseResourceImpl)) {
                bl = false;
                onePhaseResourceImpl = this._onePhaseResourceEnlisted;
            } else {
                Tr.error(tc, "WTRN0062_ILLEGAL_ENLIST_FOR_MULTIPLE_1PC_RESOURCES");
                IllegalResourceIn2PCTransactionException illegalResourceIn2PCTransactionException = new IllegalResourceIn2PCTransactionException("Illegal attempt to enlist multiple 1PC XAResources");
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "enlistResource (SPI)", illegalResourceIn2PCTransactionException);
                }
                throw illegalResourceIn2PCTransactionException;
            }
        }
        try {
            this.startRes(onePhaseResourceImpl);
            if (bl) {
                onePhaseResourceImpl.setResourceStatus(1);
                this._resourceObjects.add(0, onePhaseResourceImpl);
                this.checkLPSEnablement();
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    Tr.event(tc, "(SPI) RESOURCE registered with Transaction. TX: " + this._transaction.getLocalTID() + ", Resource: " + onePhaseResourceImpl);
                }
                this._onePhaseResourceEnlisted = onePhaseResourceImpl;
            }
        }
        catch (RollbackException rollbackException) {
            FFDCFilter.processException((Throwable)rollbackException, "com.ibm.ws.Transaction.JTA.RegisteredResources.enlistResource", "480", this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "enlistResource", (Object)rollbackException);
            }
            throw rollbackException;
        }
        catch (SystemException systemException) {
            FFDCFilter.processException((Throwable)systemException, "com.ibm.ws.Transaction.JTA.RegisteredResources.enlistResource", "487", this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "enlistResource", (Object)systemException);
            }
            throw systemException;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "enlistResource", Boolean.TRUE);
        }
        return true;
    }

    boolean enlistResource(XAResource xAResource, XARecoveryData xARecoveryData) throws RollbackException, SystemException, IllegalStateException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "enlistResource", new Object[]{xAResource, xARecoveryData});
        }
        if (this._disableTwoPhase && this._resourceObjects.size() > 0) {
            IllegalStateException illegalStateException = new IllegalStateException("Unable to enlist a second resource within the transaction. Two phase support is disabled as the recovery log was not available at transaction start");
            throw illegalStateException;
        }
        boolean bl = false;
        boolean bl2 = false;
        JTAXAResourceImpl jTAXAResourceImpl = (JTAXAResourceImpl)this.getResourceTable().get(xAResource);
        if (jTAXAResourceImpl == null) {
            Xid xid;
            int n;
            int n2;
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event(tc, "enlisting XAResource");
            }
            if ((n2 = XAPdataWrapper.computeSize((n = this._resourceObjects.size() - (this._onePhaseResourceEnlisted == null ? 0 : 1)) + 1)) > 3072) {
                String string = "Enlistment of resource would result in a persistent data buffer of " + n2 + "bytes, which is greater than the maximum of " + 3072 + "bytes";
                throw new RollbackException(string);
            }
            boolean bl3 = xARecoveryData.supportsIsSameRM();
            try {
                if (this._resourceObjects.isEmpty()) {
                    if (tc.isEventEnabled()) {
                        Tr.event(tc, "First resource - so we have to make a new branch xid");
                    }
                    xid = this.generateNewBranch();
                    if (bl3) {
                        if (tc.isEventEnabled()) {
                            Tr.event(tc, "First resource - does implement ResourceManagerSupportsIsSameRM");
                        }
                        this._isCheckingSameRM = true;
                    } else if (tc.isEventEnabled()) {
                        Tr.event(tc, "First resource - does not implement ResourceManagerSupportsIsSameRM");
                    }
                } else {
                    if (tc.isEventEnabled()) {
                        Tr.event(tc, "Second resource or later, so we should check for isSameRM");
                    }
                    if (this._isCheckingSameRM) {
                        if (xAResource.isSameRM(this._sameRMMasterResource.XAResource())) {
                            if (tc.isEventEnabled()) {
                                Tr.event(tc, "isSameRM match successful");
                            }
                            bl2 = true;
                            this._isCheckingSameRM = false;
                            xid = this._sameRMMasterResource.getXID();
                        } else {
                            if (tc.isEventEnabled()) {
                                Tr.event(tc, "isSameRM match was not successful, so we create a new branch xid");
                            }
                            xid = this.generateNewBranch();
                        }
                    } else {
                        if (tc.isEventEnabled()) {
                            Tr.event(tc, "We are not matching using isSameRM so we create a new branch xid");
                        }
                        xid = this.generateNewBranch();
                    }
                }
            }
            catch (XAException xAException) {
                this._errorCode = xAException.errorCode;
                throw (SystemException)new SystemException("XAResource RM instance matching error:" + XAReturnCodeHelper.convertXACode(this._errorCode)).initCause((Throwable)xAException);
            }
            jTAXAResourceImpl = new JTAXAResourceImpl(xid, xAResource, xARecoveryData);
            if (bl2) {
                jTAXAResourceImpl.setState(6);
            }
            if (this._isCheckingSameRM && this._sameRMMasterResource == null) {
                this._sameRMMasterResource = jTAXAResourceImpl;
            }
            bl = true;
            this.getResourceTable().put(xAResource, jTAXAResourceImpl);
        }
        if (xARecoveryData.getLogEarly()) {
            try {
                xARecoveryData.logRecoveryEntry();
            }
            catch (IllegalStateException illegalStateException) {
                FFDCFilter.processException((Throwable)illegalStateException, "com.ibm.ws.Transaction.JTA.TransactionImpl.enlistResource", "483", this);
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "enlistResource (SPI)", illegalStateException);
                }
                throw illegalStateException;
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.Transaction.JTA.TransactionImpl.enlistResource", "489", this);
                Throwable throwable = new SystemException(exception.getLocalizedMessage()).initCause((Throwable)exception);
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "enlistResource (SPI)", throwable);
                }
                throw (SystemException)throwable;
            }
        }
        try {
            this.startRes(jTAXAResourceImpl);
            if (bl) {
                jTAXAResourceImpl.setResourceStatus(1);
                if (bl2) {
                    this._sameRMResource = jTAXAResourceImpl;
                } else {
                    this._resourceObjects.add(jTAXAResourceImpl);
                }
                this.checkLPSEnablement();
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    Tr.event(tc, "(SPI) RESOURCE registered with Transaction. TX: " + this._transaction.getLocalTID() + ", Resource: " + jTAXAResourceImpl);
                }
            }
        }
        catch (RollbackException rollbackException) {
            FFDCFilter.processException((Throwable)rollbackException, "com.ibm.ws.Transaction.JTA.RegisterResources.enlistResource", "517", this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "enlistResource", (Object)rollbackException);
            }
            throw rollbackException;
        }
        catch (SystemException systemException) {
            FFDCFilter.processException((Throwable)systemException, "com.ibm.ws.Transaction.JTA.RegisterResources.enlistResource", "523", this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "enlistResource", (Object)systemException);
            }
            throw systemException;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "enlistResource", Boolean.TRUE);
        }
        return true;
    }

    boolean delistResource(XAResource xAResource, int n) throws SystemException {
        block18: {
            JTAResourceBase jTAResourceBase;
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.entry(tc, "delistResource", new Object[]{xAResource, Util.printFlag(n)});
            }
            if ((jTAResourceBase = (JTAResourceBase)this.getResourceTable().get(xAResource)) == null && this._onePhaseResourceEnlisted != null && this._onePhaseResourceEnlisted.XAResource().equals(xAResource)) {
                jTAResourceBase = this._onePhaseResourceEnlisted;
            }
            if (jTAResourceBase == null) {
                Tr.error(tc, "WTRN0065_XARESOURCE_NOT_KNOWN", xAResource);
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "delistResource", Boolean.FALSE);
                }
                return false;
            }
            try {
                jTAResourceBase.end(n);
            }
            catch (XAException xAException) {
                this._errorCode = xAException.errorCode;
                FFDCFilter.processException((Throwable)xAException, "com.ibm.ws.Transaction.JTA.RegisteredResources.delistResource", "568", this);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "XAException: error code " + XAReturnCodeHelper.convertXACode(this._errorCode), xAException);
                }
                Throwable throwable = null;
                if (this._errorCode >= 100 && this._errorCode <= 107) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                        Tr.event(tc, "Transaction branch has been marked rollback-only by the RM");
                    }
                } else if (this._errorCode == -7) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                        Tr.event(tc, "RM has failed");
                    }
                    jTAResourceBase.setResourceStatus(6);
                    jTAResourceBase.destroy();
                } else {
                    Tr.error(tc, "WTRN0079_END_FAILED", new Object[]{XAReturnCodeHelper.convertXACode(this._errorCode), xAException});
                    throwable = new SystemException("XAResource end association error:" + XAReturnCodeHelper.convertXACode(this._errorCode)).initCause((Throwable)xAException);
                }
                try {
                    this._transaction.setRollbackOnly();
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                        Tr.event(tc, "Transaction marked as rollback only.");
                    }
                }
                catch (IllegalStateException illegalStateException) {
                    FFDCFilter.processException((Throwable)illegalStateException, "com.ibm.ws.Transaction.JTA.RegisteredResource.delistResource", "457", this);
                    throwable = new SystemException(illegalStateException.getLocalizedMessage()).initCause((Throwable)illegalStateException);
                }
                if (throwable == null) break block18;
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "delistResource", throwable);
                }
                throw (SystemException)throwable;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "delistResource", Boolean.TRUE);
        }
        return true;
    }

    private Xid generateNewBranch() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "generateNewBranch");
        }
        XidImpl xidImpl = new XidImpl(this._txServiceXid, ++this._branchCount);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "generateNewBranch", xidImpl);
        }
        return xidImpl;
    }

    private HashMap getResourceTable() {
        if (this._resourceTable == null) {
            this._resourceTable = new HashMap();
        }
        return this._resourceTable;
    }

    protected static void setLPSMetaDataSlot(MetaDataSlot metaDataSlot) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "setLPSMetaDataSlot", metaDataSlot);
        }
        _applicationSlotLPSEnabled = metaDataSlot;
    }

    private void checkLPSEnablement() {
        ComponentMetaData componentMetaData;
        boolean bl;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "checkLPSEnablement");
        }
        if (this._LPSEnabledTx) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "checkLPSEnablement - LPSEnabledTx");
            }
            return;
        }
        boolean bl2 = bl = TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled();
        if (!bl && this._LPSProhibited) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "checkLPSEnablement");
            }
            return;
        }
        boolean bl3 = false;
        Object object = null;
        ComponentMetaDataAccessorImpl componentMetaDataAccessorImpl = ComponentMetaDataAccessorImpl.getComponentMetaDataAccessor();
        if (componentMetaDataAccessorImpl != null && (componentMetaData = componentMetaDataAccessorImpl.getComponentMetaData()) != null) {
            ApplicationMetaData applicationMetaData;
            ModuleMetaData moduleMetaData;
            if (bl) {
                Tr.debug(tc, "componentMetaData", componentMetaData);
            }
            if ((moduleMetaData = componentMetaData.getModuleMetaData()) != null && (applicationMetaData = moduleMetaData.getApplicationMetaData()) != null) {
                object = applicationMetaData.getMetaData(_applicationSlotLPSEnabled);
            }
        }
        if (object != null && object instanceof Boolean) {
            if (bl) {
                Tr.debug(tc, "LPSEnabled", object);
            }
            if (!(bl3 = ((Boolean)object).booleanValue())) {
                this._LPSProhibited = true;
            }
        } else {
            if (bl) {
                Tr.debug(tc, "LPSEnabled", "slot value unset");
            }
            this._LPSProhibited = true;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "checkLPSEnablement : LPSEnabled=" + bl3 + " LPSProhibited=" + this._LPSProhibited);
        }
    }

    void reconstruct(RecoveryManager recoveryManager, RecoverableUnit recoverableUnit) throws SystemException {
        Object object;
        Object object2;
        Object object3;
        int n;
        Object object4;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "reconstruct", new Object[]{recoveryManager, recoverableUnit});
        }
        this._retryCompletion = true;
        this._hoSection = recoverableUnit.lookupSection(8);
        if (this._hoSection != null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "reconstruct", "Recovering heuristic outcome");
            }
            try {
                object4 = this._hoSection.lastData();
                if (((byte[])object4).length != 1) {
                    throw new SystemException("Invalid heuristic outcome record data in log");
                }
                n = object4[0] & 0xFF;
                this.setHeuristicOutcome(n);
            }
            catch (Throwable throwable) {
                FFDCFilter.processException(throwable, "com.ibm.ws.Transaction.JTA.Registered.reconstruct", "764", this);
                Tr.fatal(tc, "WTRN0000_ERR_INT_ERROR", new Object[]{"reconstruct", "com.ibm.ws.Transaction.JTA.RegisteredResources", throwable});
                if (TraceComponent.isAnyTracingEnabled()) {
                    if (tc.isEventEnabled()) {
                        Tr.event(tc, "Unable to access heuristic outcome log record data");
                    }
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "reconstruct");
                    }
                }
                throw (SystemException)new SystemException(throwable.toString()).initCause(throwable);
            }
        }
        this._logSection = recoverableUnit.lookupSection(1);
        if (this._logSection != null) {
            object4 = null;
            try {
                object4 = this._logSection.data();
                while (object4.hasNext()) {
                    byte[] byArray = (byte[])object4.next();
                    try {
                        object3 = new CORBAResourceWrapper(byArray);
                        ((ResourceWrapper)object3).setResourceStatus(2);
                        this._resourceObjects.add(object3);
                    }
                    catch (Throwable throwable) {
                        FFDCFilter.processException(throwable, "com.ibm.ws.Transaction.JTA.RegisteredResources.reconstruct", "794", this);
                        Tr.error(tc, "WTRN0045_CANNOT_RECOVER_RESOURCE", new Object[]{com.ibm.ejs.util.Util.toHexString(byArray), throwable});
                        throw throwable;
                    }
                }
                object4.close();
            }
            catch (Throwable throwable) {
                FFDCFilter.processException(throwable, "com.ibm.ws.Transaction.JTA.RegisteredResources.reconstruct", "804", this);
                Tr.fatal(tc, "WTRN0000_ERR_INT_ERROR", new Object[]{"reconstruct", "com.ibm.ws.Transaction.JTA.RegisteredResources", throwable});
                if (object4 != null) {
                    object4.close();
                }
                if (TraceComponent.isAnyTracingEnabled()) {
                    if (tc.isEventEnabled()) {
                        Tr.event(tc, "Exception raised reconstructing corba resource");
                    }
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "reconstruct");
                    }
                }
                throw (SystemException)new SystemException(throwable.toString()).initCause(throwable);
            }
            if (this._resourceObjects.size() > 0) {
                new RecoveryCoordinatorImpl(recoveryManager.getFailureScopeController(), this._transaction).object();
            }
        }
        this._xalogSection = recoverableUnit.lookupSection(2);
        if (this._xalogSection != null) {
            object4 = this._transaction.getXidImpl().toBytes();
            LogCursor logCursor = null;
            try {
                logCursor = this._xalogSection.data();
                while (logCursor.hasNext()) {
                    object3 = (byte[])logCursor.next();
                    try {
                        object2 = new JTAXAResourceImpl(recoveryManager.getPartnerLogTable(), (byte[])object4, (byte[])object3);
                        ((ResourceWrapper)object2).setResourceStatus(2);
                        this._resourceObjects.add(object2);
                    }
                    catch (Throwable throwable) {
                        FFDCFilter.processException(throwable, "com.ibm.ws.Transaction.JTA.RegisteredResources.reconstruct", "843", this);
                        Tr.error(tc, "WTRN0045_CANNOT_RECOVER_RESOURCE", new Object[]{com.ibm.ejs.util.Util.toHexString((byte[])object3), throwable});
                        throw throwable;
                    }
                }
                logCursor.close();
            }
            catch (Throwable throwable) {
                FFDCFilter.processException(throwable, "com.ibm.ws.Transaction.JTA.RegisteredResources.reconstruct", "853", this);
                Tr.fatal(tc, "WTRN0000_ERR_INT_ERROR", new Object[]{"reconstruct", "com.ibm.ws.Transaction.JTA.RegisteredResources", throwable});
                if (logCursor != null) {
                    logCursor.close();
                }
                if (TraceComponent.isAnyTracingEnabled()) {
                    if (tc.isEventEnabled()) {
                        Tr.event(tc, "Exception raised reconstructing XA resource");
                    }
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "reconstruct");
                    }
                }
                throw (SystemException)new SystemException(throwable.toString()).initCause(throwable);
            }
        }
        this._wscResourceSection = recoverableUnit.lookupSection(5);
        int n2 = this._resourceObjects.size();
        if (this._wscResourceSection != null) {
            byte[] byArray = this._transaction.getXid().getGlobalTransactionId();
            object3 = null;
            try {
                object3 = this._wscResourceSection.data();
                while (object3.hasNext()) {
                    object2 = (byte[])object3.next();
                    try {
                        object = new WSCoordinatorWrapper(recoveryManager, byArray, (byte[])object2);
                        ((ResourceWrapper)object).setResourceStatus(2);
                        this._resourceObjects.add(object);
                    }
                    catch (Throwable throwable) {
                        FFDCFilter.processException(throwable, "com.ibm.ws.Transaction.JTA.RegisteredResources.reconstruct", "884", this);
                        Tr.error(tc, "WTRN0045_CANNOT_RECOVER_RESOURCE", new Object[]{com.ibm.ejs.util.Util.toHexString((byte[])object2), throwable});
                        throw throwable;
                    }
                }
                object3.close();
            }
            catch (Throwable throwable) {
                FFDCFilter.processException(throwable, "com.ibm.ws.Transaction.JTA.RegisteredResources.reconstruct", "894", this);
                Tr.fatal(tc, "WTRN0000_ERR_INT_ERROR", new Object[]{"reconstruct", "com.ibm.ws.Transaction.JTA.RegisteredResources", throwable});
                if (object3 != null) {
                    object3.close();
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "reconstruct");
                }
                throw (SystemException)new SystemException(throwable.toString()).initCause(throwable);
            }
            if (this._resourceObjects.size() > n2 && (object = ((WSCoordinatorImpl)(object2 = (WSCoordinatorImpl)recoveryManager.getFailureScopeController().getWSCoordinator())).lookupTransactionWrapper(byArray)) == null) {
                ((WSCoordinatorImpl)object2).storeTransactionWrapper(byArray, new TransactionWrapper(this._transaction));
            }
        }
        this._wsatAsyncSection = recoverableUnit.lookupSection(10);
        if (this._wsatAsyncSection != null) {
            n = this._resourceObjects.size();
            object3 = null;
            object2 = null;
            this._asyncSemaphore = new Semaphore(this._transaction);
            try {
                object3 = this._wsatAsyncSection.data();
                while (object3.hasNext()) {
                    object = (byte[])object3.next();
                    try {
                        object2 = new WSATParticipantWrapper((byte[])object);
                        ((JTAAsyncResourceBase)object2).setSemaphore(this._asyncSemaphore);
                        ((ResourceWrapper)object2).setResourceStatus(2);
                        this._resourceObjects.add(object2);
                        JTAAsyncResponseHelper jTAAsyncResponseHelper = WSATCoordinatorPortDistImpl.getJTAAsyncResponseHelper();
                        jTAAsyncResponseHelper.addResponseTarget((JTAAsyncResponseTarget)object2);
                    }
                    catch (Throwable throwable) {
                        FFDCFilter.processException(throwable, "com.ibm.ws.Transaction.JTA.RegisteredResources.reconstruct", "943", this);
                        Tr.error(tc, "WTRN0045_CANNOT_RECOVER_RESOURCE", new Object[]{object, throwable});
                        throw throwable;
                    }
                }
                object3.close();
            }
            catch (Throwable throwable) {
                FFDCFilter.processException(throwable, "com.ibm.ws.Transaction.JTA.RegisteredResources.reconstruct", "952", this);
                Tr.fatal(tc, "WTRN0000_ERR_INT_ERROR", new Object[]{"reconstruct", "com.ibm.ws.Transaction.JTA.RegisteredResources", throwable});
                if (object3 != null) {
                    object3.close();
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    Tr.event(tc, "Exception raised reconstructing WSAT Async resource");
                }
                throw (SystemException)new SystemException(throwable.toString()).initCause(throwable);
            }
            if (this._resourceObjects.size() > n) {
                object = ((WSATParticipantWrapper)object2).getWSATTxIdentifier();
                WSATControlSet.reconstruct(this._transaction, (String)object, recoveryManager.getFailureScopeController());
            }
        }
        this._logUnit = recoverableUnit;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "reconstruct");
        }
    }

    void addRes(JTAResource jTAResource) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "addRes", new Object[]{this, jTAResource});
        }
        jTAResource.setResourceStatus(1);
        this._resourceObjects.add(jTAResource);
        if (TraceComponent.isAnyTracingEnabled()) {
            if (tc.isEventEnabled()) {
                Tr.event(tc, "(SPI) SERVER registered with Transaction. TX: " + this._transaction.getLocalTID() + ", Resource: " + jTAResource);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "addRes");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addAsyncResource(JTAAsyncResourceBase jTAAsyncResourceBase) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "addAsyncResource", new Object[]{this, jTAAsyncResourceBase});
        }
        try {
            for (int i = 0; i < this._resourceObjects.size(); ++i) {
                Object e2 = this._resourceObjects.get(i);
                if (!(e2 instanceof JTAAsyncResourceBase)) continue;
                JTAAsyncResourceBase jTAAsyncResourceBase2 = (JTAAsyncResourceBase)e2;
                if (!jTAAsyncResourceBase.getKey().equals(jTAAsyncResourceBase2.getKey())) continue;
                throw new RuntimeException("Cannot register two asynchronous resources with the same keys");
            }
            if (this._asyncSemaphore == null) {
                this._asyncSemaphore = new Semaphore(this._transaction);
            }
            jTAAsyncResourceBase.setSemaphore(this._asyncSemaphore);
            this.addRes(jTAAsyncResourceBase);
        }
        finally {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "addAsyncResource");
            }
        }
    }

    private void startRes(JTAResource jTAResource) throws RollbackException, SystemException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "startRes", new Object[]{this, jTAResource});
        }
        try {
            jTAResource.start();
        }
        catch (XAException xAException) {
            this._errorCode = xAException.errorCode;
            FFDCFilter.processException((Throwable)xAException, "com.ibm.ws.Transaction.JTA.RegisteredResources.startRes", "1053", this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "XAException: error code " + XAReturnCodeHelper.convertXACode(this._errorCode), xAException);
            }
            if (this._errorCode == -9) {
                Throwable throwable = new RollbackException("XAResource working outside transaction").initCause((Throwable)xAException);
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    Tr.event(tc, "XAResource is doing work outside of the transaction.", throwable);
                }
                throw (RollbackException)throwable;
            }
            if (this._errorCode >= 100 && this._errorCode <= 107) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    Tr.event(tc, "Transaction branch has been marked rollback-only by the RM");
                }
                try {
                    this._transaction.setRollbackOnly();
                }
                catch (IllegalStateException illegalStateException) {
                    FFDCFilter.processException((Throwable)illegalStateException, "com.ibm.ws.Transaction.JTA.RegisteredResources.startRes", "1085", this);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                        Tr.event(tc, "Exception caught marking Transaction rollback only", illegalStateException);
                    }
                    throw (SystemException)new SystemException(illegalStateException.getLocalizedMessage()).initCause((Throwable)illegalStateException);
                }
                Throwable throwable = new RollbackException("Transaction has been marked as rollback only.").initCause((Throwable)xAException);
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    Tr.event(tc, "Marked transaction as rollback only.", throwable);
                }
                throw (RollbackException)throwable;
            }
            Tr.error(tc, "WTRN0078_START_FAILED", new Object[]{XAReturnCodeHelper.convertXACode(this._errorCode), xAException});
            throw (SystemException)new SystemException("XAResource start association error:" + XAReturnCodeHelper.convertXACode(this._errorCode)).initCause((Throwable)xAException);
        }
        finally {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "startRes");
            }
        }
    }

    public final int numRegistered() {
        int n = this._resourceObjects.size();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "numRegistered", new Integer(n));
        }
        return n;
    }

    boolean distributeEnd(int n) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "distributeEnd", Util.printFlag(n));
        }
        boolean bl = true;
        int n2 = this._resourceObjects.size();
        while (--n2 >= 0) {
            JTAResource jTAResource = (JTAResource)this._resourceObjects.get(n2);
            if (this.sendEnd(jTAResource, n)) continue;
            bl = false;
        }
        if (this._sameRMResource != null && !this.sendEnd(this._sameRMResource, n)) {
            bl = false;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "distributeEnd", new Boolean(bl));
        }
        return bl;
    }

    boolean sendEnd(JTAResource jTAResource, int n) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "sendEnd", new Object[]{jTAResource, new Integer(n), this});
        }
        boolean bl = true;
        try {
            jTAResource.end(n);
        }
        catch (XAException xAException) {
            this._errorCode = xAException.errorCode;
            if (this._errorCode >= 100 && this._errorCode <= 107) {
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "XA_RB* from end", xAException);
                }
            } else {
                FFDCFilter.processException((Throwable)xAException, "com.ibm.ws.Transaction.JTA.RegisteredResources.distributeEnd", "1157", this);
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "XAException (not XA_RB*) from end", xAException);
                }
                jTAResource.setResourceStatus(6);
                jTAResource.destroy();
            }
            bl = false;
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.Transaction.JTA.RegisteredResources.distributeEnd", "1171", this);
            if (tc.isEventEnabled()) {
                Tr.event(tc, "Throwable (not XAException) from end", throwable);
            }
            bl = false;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "sendEnd", new Boolean(bl));
        }
        return bl;
    }

    private int prepareResource(JTAResource jTAResource) throws RollbackException, SystemException, HeuristicMixedException, HeuristicHazardException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "prepareResource", new Object[]{this, jTAResource});
        }
        int n = 3;
        try {
            boolean bl = true;
            if (xaFlowCallbackEnabled) {
                bl = XAFlowCallbackControl.beforeXAFlow(1, 20);
            }
            if (bl) {
                n = jTAResource.prepare();
            }
            if (xaFlowCallbackEnabled) {
                XAFlowCallbackControl.afterXAFlow(1, 50);
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "prepareResource", XAReturnCodeHelper.convertXACode(n));
            }
            return n;
        }
        catch (XAException xAException) {
            this._errorCode = xAException.errorCode;
            FFDCFilter.processException((Throwable)xAException, "com.ibm.ws.Transaction.JTA.RegisteredResources.prepareResource", "1216", this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "XAException: error code " + XAReturnCodeHelper.convertXACode(this._errorCode), xAException);
            }
            if (xaFlowCallbackEnabled) {
                XAFlowCallbackControl.afterXAFlow(1, 51);
            }
            if (this._errorCode >= 100 && this._errorCode <= 107 || this._errorCode == -4) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    Tr.event(tc, "XA_RB* or XAER_NOTA on prepare. Marking resource as complete. Rollback tx");
                }
                jTAResource.setResourceStatus(6);
                jTAResource.destroy();
                Throwable throwable = new RollbackException().initCause((Throwable)xAException);
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "prepareResource", throwable);
                }
                throw (RollbackException)throwable;
            }
            if (this._errorCode == 5) {
                jTAResource.setResourceStatus(10);
                this.updateHeuristicOutcome(10);
                this._diagnosticsRequired = true;
                Throwable throwable = new HeuristicMixedException().initCause((Throwable)xAException);
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "prepareResource", throwable);
                }
                throw (HeuristicMixedException)throwable;
            }
            if (this._errorCode == 8) {
                jTAResource.setResourceStatus(11);
                this.updateHeuristicOutcome(11);
                this._diagnosticsRequired = true;
                Throwable throwable = new HeuristicHazardException().initCause(xAException);
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "prepareResource", throwable);
                }
                throw (HeuristicHazardException)throwable;
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Thrown from ", xAException.getStackTrace()[0].getClassName());
            }
            if (this._errorCode != -7 || !this._disableRmfailLogging || !IGNORE_RMFAIL_FROM_WSAT_CLASS.equalsIgnoreCase(xAException.getStackTrace()[0].getClassName())) {
                this._diagnosticsRequired = true;
                Tr.error(tc, "WTRN0046_PREPARE_FAILED", new Object[]{XAReturnCodeHelper.convertXACode(this._errorCode), xAException});
            }
            if (this._errorCode == -3 || this._errorCode == -7) {
                jTAResource.setResourceStatus(2);
            }
            if (this._errorCode == -7) {
                Throwable throwable = new RollbackException().initCause((Throwable)xAException);
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "prepareResource", throwable);
                }
                throw (RollbackException)throwable;
            }
            Throwable throwable = new SystemException().initCause((Throwable)xAException);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "prepareResource", throwable);
            }
            throw (SystemException)throwable;
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.Transaction.JTA.RegisteredResources.prepareResource", "1297", this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "RuntimeException", throwable);
            }
            if (xaFlowCallbackEnabled) {
                XAFlowCallbackControl.afterXAFlow(1, 51);
            }
            this._diagnosticsRequired = true;
            Tr.error(tc, "WTRN0046_PREPARE_FAILED", new Object[]{throwable.getLocalizedMessage(), throwable});
            jTAResource.setResourceStatus(2);
            Throwable throwable2 = new SystemException(throwable.toString()).initCause(throwable);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "prepareResource", throwable2);
            }
            throw (SystemException)throwable2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    int distributePrepare(boolean var1_1, boolean var2_2) throws RollbackException, SystemException, HeuristicMixedException, HeuristicHazardException, HeuristicRollbackException {
        if (TraceComponent.isAnyTracingEnabled() && RegisteredResources.tc.isEntryEnabled()) {
            Tr.entry(RegisteredResources.tc, "distributePrepare", new Object[]{this, new Boolean(var1_1), new Boolean(var2_2)});
        }
        this._diagnosticsRequired = false;
        var3_3 = 3;
        try {
            if (var1_1 && this._onePhaseResourceEnlisted != null) {
                Tr.error(RegisteredResources.tc, "WTRN0064_SUBORDINATE_COMMIT_OF_1PC_RESOURCE");
                if (TraceComponent.isAnyTracingEnabled()) {
                    if (RegisteredResources.tc.isEventEnabled()) {
                        Tr.event(RegisteredResources.tc, "Subordinate contains 1PC resource, rolling back transaction");
                    }
                    if (RegisteredResources.tc.isEntryEnabled()) {
                        Tr.exit(RegisteredResources.tc, "distributePrepare", "RollbackException");
                    }
                }
                throw new RollbackException();
            }
            var4_4 = 0;
            if (this._asyncSemaphore != null) {
                this._asyncSemaphore.reset();
                var5_5 = this._resourceObjects.size();
                while (--var5_5 >= 0) {
                    var6_7 = (JTAResource)this._resourceObjects.get(var5_5);
                    if (!(var6_7 instanceof JTAAsyncResourceBase)) continue;
                    try {
                        ((JTAAsyncResourceBase)var6_7).sendAsyncPrepare();
                    }
                    catch (XAException var7_9) {
                        this._errorCode = var7_9.errorCode;
                        FFDCFilter.processException((Throwable)var7_9, "com.ibm.ws.Transaction.JTA.RegisteredResources.distributePrepare", "1379", this);
                        if (TraceComponent.isAnyTracingEnabled() && RegisteredResources.tc.isDebugEnabled()) {
                            Tr.debug(RegisteredResources.tc, "XAException: error code " + XAReturnCodeHelper.convertXACode(this._errorCode), var7_9);
                        }
                        if (RegisteredResources.xaFlowCallbackEnabled) {
                            XAFlowCallbackControl.afterXAFlow(1, 51);
                        }
                        if (TraceComponent.isAnyTracingEnabled() && RegisteredResources.tc.isDebugEnabled()) {
                            Tr.debug(RegisteredResources.tc, "Thrown from ", var7_9.getStackTrace()[0].getClassName());
                        }
                        if (this._errorCode != -7 || !this._disableRmfailLogging || !"com.ibm.ws.Transaction.wstx.WSATParticipantWrapper".equalsIgnoreCase(var7_9.getStackTrace()[0].getClassName())) {
                            this._diagnosticsRequired = true;
                            Tr.error(RegisteredResources.tc, "WTRN0046_PREPARE_FAILED", new Object[]{XAReturnCodeHelper.convertXACode(this._errorCode), var7_9});
                        }
                        var6_7.setResourceStatus(2);
                        if (this._errorCode == -7) {
                            var8_14 = new RollbackException().initCause((Throwable)var7_9);
                            if (TraceComponent.isAnyTracingEnabled() && RegisteredResources.tc.isEntryEnabled()) {
                                Tr.exit(RegisteredResources.tc, "distributePrepare", var8_14);
                            }
                            throw (RollbackException)var8_14;
                        }
                        var8_15 = new SystemException().initCause((Throwable)var7_9);
                        if (TraceComponent.isAnyTracingEnabled() && RegisteredResources.tc.isEntryEnabled()) {
                            Tr.exit(RegisteredResources.tc, "distributePrepare", var8_15);
                        }
                        throw (SystemException)var8_15;
                    }
                }
            }
            var5_5 = this._resourceObjects.size();
            while (--var5_5 >= 0) {
                block48: {
                    var6_7 = (JTAResource)this._resourceObjects.get(var5_5);
                    if (var6_7 instanceof JTAAsyncResourceBase) continue;
                    if (var5_5 != 0 || var4_4 != 0 || !var2_2 || this._asyncSemaphore != null || !(var6_7 instanceof ResourceSupportsOnePhaseCommit) || this._onePhaseResourceEnlisted != null) break block48;
                    try {
                        this.flowCommitOnePhase(false);
                        var3_3 = 10;
                    }
                    catch (RollbackException var7_11) {
                        try {
                            var3_3 = 11;
                        }
                        catch (Throwable var9_18) {
                            if (TraceComponent.isAnyTracingEnabled() && RegisteredResources.tc.isEntryEnabled()) {
                                Tr.exit(RegisteredResources.tc, "distributePrepare", var3_3 == 10 ? "ONE_PHASE_OPT" : (var3_3 == 11 ? "ONE_PHASE_OPT_ROLLBACK" : "HEURISTIC"));
                            }
                            throw var9_18;
                        }
                        if (TraceComponent.isAnyTracingEnabled() && RegisteredResources.tc.isEntryEnabled()) {
                            Tr.exit(RegisteredResources.tc, "distributePrepare", var3_3 == 10 ? "ONE_PHASE_OPT" : (var3_3 == 11 ? "ONE_PHASE_OPT_ROLLBACK" : "HEURISTIC"));
                        } else {
                            ** GOTO lbl69
                        }
                    }
                    if (TraceComponent.isAnyTracingEnabled() && RegisteredResources.tc.isEntryEnabled()) {
                        Tr.exit(RegisteredResources.tc, "distributePrepare", var3_3 == 10 ? "ONE_PHASE_OPT" : (var3_3 == 11 ? "ONE_PHASE_OPT_ROLLBACK" : "HEURISTIC"));
                    }
                    var7_12 = var3_3;
                    return var7_12;
                }
                if (var5_5 == 0 && this._onePhaseResourceEnlisted != null && !var1_1) continue;
                var7_10 = this.prepareResource(var6_7);
                if (var7_10 == 0) {
                    var6_7.setResourceStatus(2);
                    if (var3_3 == 3) {
                        var3_3 = 0;
                    }
                    ++var4_4;
                } else {
                    var6_7.setResourceStatus(4);
                }
                if (!this._transaction.getRollbackOnly()) continue;
                var8_16 = new RollbackException();
                if (TraceComponent.isAnyTracingEnabled() && RegisteredResources.tc.isEntryEnabled()) {
                    Tr.exit(RegisteredResources.tc, "distributePrepare", (Object)var8_16);
                }
                throw var8_16;
            }
            if (this._asyncSemaphore != null) {
                var5_6 = this._asyncSemaphore;
                synchronized (var5_6) {
                    this.awaitAsyncResponses();
                    var6_8 = this._resourceObjects.size();
                    while (--var6_8 >= 0) {
                        var7_13 = (JTAResource)this._resourceObjects.get(var6_8);
                        if (!(var7_13 instanceof JTAAsyncResourceBase)) continue;
                        var8_17 = this.prepareResource(var7_13);
                        if (var8_17 == 0) {
                            var7_13.setResourceStatus(2);
                            if (var3_3 == 3) {
                                var3_3 = 0;
                            }
                            ++var4_4;
                            continue;
                        }
                        var7_13.setResourceStatus(4);
                    }
                }
            }
            if (this._onePhaseResourceEnlisted != null && var2_2) {
                var3_3 = this.commitLastAgent(var4_4 > 0, true);
                if (var4_4 > 0) {
                    ++var4_4;
                }
            }
            if (var4_4 == 1 && var2_2) {
                if (TraceComponent.isAnyTracingEnabled() && RegisteredResources.tc.isDebugEnabled()) {
                    Tr.debug(RegisteredResources.tc, "Transaction contains one non-READ-ONLY Resource, attempting to Optimize.");
                }
                var3_3 = 10;
                this.distributeCommit();
            } else if (var4_4 > 0) {
                this.logResources();
            }
        }
        finally {
            if (this._diagnosticsRequired) {
                this.logDiagnostics(1);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && RegisteredResources.tc.isEntryEnabled()) {
            Tr.exit(RegisteredResources.tc, "distributePrepare", XAReturnCodeHelper.convertXACode(var3_3));
        }
        return var3_3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    int commitLastAgent(boolean bl, boolean bl2) throws RollbackException, SystemException, HeuristicMixedException, HeuristicHazardException, HeuristicRollbackException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "commitLastAgent", new Object[]{this, bl, bl2});
        }
        int n = 3;
        if (!bl) {
            try {
                this.flowCommitOnePhase(false);
                n = 10;
            }
            catch (RollbackException rollbackException) {
                try {
                    n = 11;
                }
                catch (Throwable throwable) {
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isEntryEnabled()) throw throwable;
                    Tr.exit(tc, "commitLastAgent", n == 10 ? "ONE_PHASE_OPT" : (n == 11 ? "ONE_PHASE_OPT_ROLLBACK" : "HEURISTIC"));
                    throw throwable;
                }
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isEntryEnabled()) return n;
                Tr.exit(tc, "commitLastAgent", n == 10 ? "ONE_PHASE_OPT" : (n == 11 ? "ONE_PHASE_OPT_ROLLBACK" : "HEURISTIC"));
                return n;
            }
            if (!TraceComponent.isAnyTracingEnabled() || !tc.isEntryEnabled()) return n;
            Tr.exit(tc, "commitLastAgent", n == 10 ? "ONE_PHASE_OPT" : (n == 11 ? "ONE_PHASE_OPT_ROLLBACK" : "HEURISTIC"));
            return n;
        }
        try {
            if (this._LPSProhibited && bl2) {
                Tr.error(tc, "WTRN0063_ILLEGAL_COMMIT_OF_1PC_RESOURCE");
                this.logDiagnostics(1);
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) throw new RollbackException();
                Tr.event(tc, "LPS not enabled, rolling back transaction");
                throw new RollbackException();
            }
            this.logResources();
            this._transaction.logLPSState();
            this.flowCommitOnePhase(true);
            n = 0;
        }
        catch (RollbackException rollbackException) {
            if (!TraceComponent.isAnyTracingEnabled() || !tc.isEntryEnabled()) throw rollbackException;
            Tr.exit(tc, "commitLastAgent", (Object)rollbackException);
            throw rollbackException;
        }
        catch (HeuristicMixedException heuristicMixedException) {
            n = 12;
        }
        catch (HeuristicHazardException heuristicHazardException) {
            n = 12;
        }
        if (!TraceComponent.isAnyTracingEnabled() || !tc.isEntryEnabled()) return n;
        Tr.exit(tc, "commitLastAgent", XAReturnCodeHelper.convertXACode(n));
        return n;
    }

    private void logResources() throws SystemException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "logResources", this._resourcesLogged);
        }
        if (!this._resourcesLogged) {
            for (int i = 0; i < this._resourceObjects.size(); ++i) {
                JTAResource jTAResource = (JTAResource)this._resourceObjects.get(i);
                if (jTAResource.getResourceStatus() != 2) continue;
                this.recordLog(jTAResource);
            }
            this._resourcesLogged = true;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "logResources");
        }
    }

    private boolean deliverOutcome(JTAResource jTAResource) {
        boolean bl;
        block64: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.entry(tc, "deliverOutcome", jTAResource);
            }
            bl = false;
            boolean bl2 = true;
            int n = -1;
            boolean bl3 = true;
            try {
                switch (jTAResource.getResourceStatus()) {
                    case 2: {
                        jTAResource.setResourceStatus(3);
                    }
                    case 3: {
                        if (this._outcome) {
                            if (xaFlowCallbackEnabled) {
                                bl2 = XAFlowCallbackControl.beforeXAFlow(2, 30);
                                n = 2;
                            }
                            if (bl2) {
                                jTAResource.commit();
                            }
                            jTAResource.setResourceStatus(7);
                            break;
                        }
                        if (xaFlowCallbackEnabled) {
                            bl2 = XAFlowCallbackControl.beforeXAFlow(3, 40);
                            n = 3;
                        }
                        if (bl2) {
                            jTAResource.rollback();
                        }
                        jTAResource.setResourceStatus(6);
                        break;
                    }
                    case 5: {
                        bl3 = false;
                        if (this._outcome) {
                            if (xaFlowCallbackEnabled) {
                                bl2 = XAFlowCallbackControl.beforeXAFlow(2, 31);
                                n = 2;
                            }
                            if (bl2) {
                                jTAResource.commit_one_phase();
                            }
                            jTAResource.setResourceStatus(6);
                            break;
                        }
                        if (xaFlowCallbackEnabled) {
                            bl2 = XAFlowCallbackControl.beforeXAFlow(3, 40);
                            n = 3;
                        }
                        if (bl2) {
                            jTAResource.rollback();
                        }
                        jTAResource.setResourceStatus(6);
                        break;
                    }
                    case 1: {
                        bl3 = false;
                        if (this._outcome) break;
                        jTAResource.setResourceStatus(3);
                        if (xaFlowCallbackEnabled) {
                            bl2 = XAFlowCallbackControl.beforeXAFlow(3, 40);
                            n = 3;
                        }
                        if (bl2) {
                            jTAResource.rollback();
                        }
                        jTAResource.setResourceStatus(6);
                        break;
                    }
                }
                if (n != -1 && xaFlowCallbackEnabled) {
                    XAFlowCallbackControl.afterXAFlow(n, 50);
                }
            }
            catch (XAException xAException) {
                this._errorCode = xAException.errorCode;
                FFDCFilter.processException((Throwable)xAException, "com.ibm.ws.Transaction.JTA.RegisteredResources.deliverOutcome", "1923", this);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "XAException: error code " + XAReturnCodeHelper.convertXACode(this._errorCode), xAException);
                }
                if (xaFlowCallbackEnabled) {
                    XAFlowCallbackControl.afterXAFlow(n, 51);
                }
                if (this._errorCode == 6) {
                    jTAResource.setResourceStatus(9);
                    if (this._outcome) {
                        this._diagnosticsRequired = true;
                        Tr.error(tc, "WTRN0075_HEURISTIC_ON_COMMIT", this._transaction.getTranName());
                    }
                } else if (this._errorCode == 7) {
                    jTAResource.setResourceStatus(8);
                    if (!this._outcome) {
                        this._diagnosticsRequired = true;
                        Tr.error(tc, "WTRN0076_HEURISTIC_ON_ROLLBACK", this._transaction.getTranName());
                    }
                } else if (this._errorCode == 5) {
                    jTAResource.setResourceStatus(10);
                    this._diagnosticsRequired = true;
                    if (this._outcome) {
                        Tr.error(tc, "WTRN0075_HEURISTIC_ON_COMMIT", this._transaction.getTranName());
                    } else {
                        Tr.error(tc, "WTRN0076_HEURISTIC_ON_ROLLBACK", this._transaction.getTranName());
                    }
                } else if (this._errorCode == 8) {
                    jTAResource.setResourceStatus(11);
                    this._diagnosticsRequired = true;
                    if (this._outcome) {
                        Tr.error(tc, "WTRN0075_HEURISTIC_ON_COMMIT", this._transaction.getTranName());
                    } else {
                        Tr.error(tc, "WTRN0076_HEURISTIC_ON_ROLLBACK", this._transaction.getTranName());
                    }
                } else if (this._errorCode == -3) {
                    this.updateHeuristicOutcome(9);
                    jTAResource.setResourceStatus(6);
                    jTAResource.destroy();
                    if (this._outcome) {
                        this._diagnosticsRequired = true;
                        Tr.error(tc, "WTRN0047_XAER_RMERR_ON_COMMIT", jTAResource);
                    }
                } else if (this._errorCode == -7) {
                    if (!this._outcome && !bl3) {
                        jTAResource.setResourceStatus(6);
                        jTAResource.destroy();
                    } else {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug(tc, "Thrown from ", xAException.getStackTrace()[0].getClassName());
                        }
                        if (!this._disableRmfailLogging || !IGNORE_RMFAIL_FROM_WSAT_CLASS.equalsIgnoreCase(xAException.getStackTrace()[0].getClassName())) {
                            if (this._outcome) {
                                Tr.warning(tc, "WTRN0048_XAER_RMFAIL_ON_COMMIT", jTAResource);
                            } else {
                                Tr.warning(tc, "WTRN0049_XAER_RMFAIL_ON_ROLLBACK", jTAResource);
                            }
                        }
                        jTAResource.setState(3);
                        this.updateHeuristicOutcome(11);
                        this.addToFailedResources(jTAResource);
                        bl = true;
                    }
                } else if (this._errorCode == 4) {
                    jTAResource.setState(3);
                    this.updateHeuristicOutcome(11);
                    this.addToFailedResources(jTAResource);
                    bl = true;
                } else if (this._errorCode == -4) {
                    if (jTAResource.getResourceStatus() == 5) {
                        this.updateHeuristicOutcome(11);
                    } else if (this._outcome && !this._retryCompletion) {
                        this.updateHeuristicOutcome(11);
                    }
                    jTAResource.setResourceStatus(4);
                    jTAResource.destroy();
                } else if (this._errorCode >= 100 && this._errorCode <= 107) {
                    jTAResource.setResourceStatus(6);
                    jTAResource.destroy();
                } else {
                    jTAResource.setResourceStatus(4);
                    jTAResource.destroy();
                    this._diagnosticsRequired = true;
                    if (this._outcome) {
                        Tr.error(tc, "WTRN0050_UNEXPECTED_XA_ERROR_ON_COMMIT", XAReturnCodeHelper.convertXACode(this._errorCode));
                    } else {
                        Tr.error(tc, "WTRN0051_UNEXPECTED_XA_ERROR_ON_ROLLBACK", XAReturnCodeHelper.convertXACode(this._errorCode));
                    }
                    this._systemException = xAException;
                }
            }
            catch (Throwable throwable) {
                FFDCFilter.processException(throwable, "com.ibm.ws.Transaction.JTA.RegisteredResources.deliverOutcome", "2111", this);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "RuntimeException", throwable);
                }
                if (xaFlowCallbackEnabled) {
                    XAFlowCallbackControl.afterXAFlow(n, 51);
                }
                this.updateHeuristicOutcome(9);
                jTAResource.setResourceStatus(4);
                jTAResource.destroy();
                if (!this._outcome) break block64;
                this._diagnosticsRequired = true;
                Tr.error(tc, "WTRN0068_COMMIT_FAILED", throwable);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "deliverOutcome", bl);
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean distributeOutcome() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "distributeOutcome", this);
        }
        boolean bl = false;
        this._diagnosticsRequired = false;
        try {
            int n;
            this._gotCommitInLastPhaseResources = this.sortResources();
            int n2 = this._resourceObjects.size();
            if (this._asyncSemaphore != null) {
                this._asyncSemaphore.reset();
                for (n = 0; n < n2; ++n) {
                    boolean bl2 = true;
                    int n3 = -1;
                    boolean bl3 = true;
                    JTAResource jTAResource = (JTAResource)this._resourceObjects.get(n);
                    if (!(jTAResource instanceof JTAAsyncResourceBase)) continue;
                    try {
                        switch (jTAResource.getResourceStatus()) {
                            case 2: {
                                jTAResource.setResourceStatus(3);
                            }
                            case 3: {
                                if (this._outcome) {
                                    if (xaFlowCallbackEnabled) {
                                        bl2 = XAFlowCallbackControl.beforeXAFlow(2, 30);
                                        n3 = 2;
                                    }
                                    if (!bl2) break;
                                    ((JTAAsyncResourceBase)jTAResource).sendAsyncCommit();
                                    break;
                                }
                                if (xaFlowCallbackEnabled) {
                                    bl2 = XAFlowCallbackControl.beforeXAFlow(3, 40);
                                    n3 = 3;
                                }
                                if (!bl2) break;
                                ((JTAAsyncResourceBase)jTAResource).sendAsyncRollback();
                                break;
                            }
                            case 1: {
                                bl3 = false;
                                if (this._outcome) break;
                                jTAResource.setResourceStatus(3);
                                if (xaFlowCallbackEnabled) {
                                    bl2 = XAFlowCallbackControl.beforeXAFlow(3, 40);
                                    n3 = 3;
                                }
                                if (!bl2) break;
                                ((JTAAsyncResourceBase)jTAResource).sendAsyncRollback();
                                break;
                            }
                        }
                        continue;
                    }
                    catch (XAException xAException) {
                        this._errorCode = xAException.errorCode;
                        FFDCFilter.processException((Throwable)xAException, "com.ibm.ws.Transaction.JTA.RegisteredResources.distributeOutcome", "1929", this);
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug(tc, "XAException: error code " + XAReturnCodeHelper.convertXACode(this._errorCode), xAException);
                        }
                        if (xaFlowCallbackEnabled) {
                            XAFlowCallbackControl.afterXAFlow(n3, 51);
                        }
                        if (this._errorCode == -3) {
                            this.updateHeuristicOutcome(9);
                            jTAResource.setResourceStatus(6);
                            jTAResource.destroy();
                            if (!this._outcome) continue;
                            this._diagnosticsRequired = true;
                            Tr.error(tc, "WTRN0047_XAER_RMERR_ON_COMMIT", jTAResource);
                            continue;
                        }
                        if (this._errorCode == -7) {
                            if (!this._outcome && !bl3 && (jTAResource instanceof JTAXAResourceImpl || jTAResource instanceof OnePhaseResourceImpl)) {
                                jTAResource.setResourceStatus(6);
                                jTAResource.destroy();
                                continue;
                            }
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                Tr.debug(tc, "Thrown from ", xAException.getStackTrace()[0].getClassName());
                            }
                            if (!this._disableRmfailLogging || !IGNORE_RMFAIL_FROM_WSAT_CLASS.equalsIgnoreCase(xAException.getStackTrace()[0].getClassName())) {
                                if (this._outcome) {
                                    Tr.warning(tc, "WTRN0048_XAER_RMFAIL_ON_COMMIT", jTAResource);
                                } else {
                                    Tr.warning(tc, "WTRN0049_XAER_RMFAIL_ON_ROLLBACK", jTAResource);
                                }
                            }
                            jTAResource.setState(3);
                            this.updateHeuristicOutcome(11);
                            this.addToFailedResources(jTAResource);
                            bl = true;
                            continue;
                        }
                        jTAResource.setResourceStatus(4);
                        jTAResource.destroy();
                        this._diagnosticsRequired = true;
                        if (this._outcome) {
                            Tr.error(tc, "WTRN0050_UNEXPECTED_XA_ERROR_ON_COMMIT", XAReturnCodeHelper.convertXACode(this._errorCode));
                        } else {
                            Tr.error(tc, "WTRN0051_UNEXPECTED_XA_ERROR_ON_ROLLBACK", XAReturnCodeHelper.convertXACode(this._errorCode));
                        }
                        this._systemException = xAException;
                    }
                }
            }
            for (n = 0; n < n2; ++n) {
                JTAResource jTAResource = (JTAResource)this._resourceObjects.get(n);
                if (jTAResource instanceof JTAAsyncResourceBase || !this.deliverOutcome(jTAResource)) continue;
                bl = true;
            }
            if (this._asyncSemaphore != null) {
                Semaphore semaphore = this._asyncSemaphore;
                synchronized (semaphore) {
                    this.awaitAsyncResponses();
                }
            }
            for (n = 0; n < n2; ++n) {
                JTAResource jTAResource = (JTAResource)this._resourceObjects.get(n);
                if (!(jTAResource instanceof JTAAsyncResourceBase) || !this.deliverOutcome(jTAResource)) continue;
                bl = true;
            }
        }
        finally {
            this.updateHeuristicOutcome(this.calculateHeuristicOutcome());
            this._retryCompletion = true;
            if (this._diagnosticsRequired) {
                this.logDiagnostics(0);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "distributeOutcome", bl);
        }
        return bl;
    }

    private void awaitAsyncResponses() {
        if (this._asyncSemaphore.getCount() > 0) {
            long l = System.currentTimeMillis();
            long l2 = Configuration.getAsyncResponseTimeout();
            while (true) {
                try {
                    this._asyncSemaphore.wait(l2);
                }
                catch (InterruptedException interruptedException) {
                    long l3 = System.currentTimeMillis() - l;
                    if (l3 >= l2) break;
                    l2 -= l3;
                    continue;
                }
                break;
            }
        }
    }

    private int calculateHeuristicOutcome() {
        int n = 0;
        for (int i = 0; i < this._resourceObjects.size(); ++i) {
            JTAResource jTAResource = (JTAResource)this._resourceObjects.get(i);
            n = HeuristicOutcome.combineStates(n, jTAResource.getResourceStatus());
        }
        return n;
    }

    private void updateHeuristicState(boolean bl) throws SystemException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "updateHeuristicState", bl);
        }
        if (this._transaction.isSubordinate()) {
            TransactionState transactionState = this._transaction.getTransactionState();
            int n = transactionState.getState();
            if (bl) {
                if (n != 7) {
                    transactionState.setState(7);
                }
            } else if (n != 8 && n != 0) {
                transactionState.setState(8);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "updateHeuristicState");
        }
    }

    boolean distributeForget() throws SystemException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "distributeForget", this);
        }
        boolean bl = false;
        int n = this._resourceObjects.size();
        block3: for (int i = 0; i < n; ++i) {
            JTAResource jTAResource = (JTAResource)this._resourceObjects.get(i);
            switch (jTAResource.getResourceStatus()) {
                case 8: 
                case 9: 
                case 10: 
                case 11: {
                    if (!this.forgetResource(jTAResource)) continue block3;
                    bl = true;
                    this._retryRequired = true;
                    continue block3;
                }
            }
        }
        if (this._systemException != null) {
            Throwable throwable = new SystemException().initCause(this._systemException);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "distributeForget", throwable);
            }
            throw (SystemException)throwable;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "distributeForget", bl);
        }
        return bl;
    }

    private boolean forgetResource(JTAResource jTAResource) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "forgetResource", jTAResource);
        }
        boolean bl = false;
        try {
            boolean bl2 = true;
            if (xaFlowCallbackEnabled) {
                bl2 = XAFlowCallbackControl.beforeXAFlow(0, 10);
            }
            if (bl2) {
                jTAResource.forget();
            }
            jTAResource.setResourceStatus(4);
            if (xaFlowCallbackEnabled) {
                XAFlowCallbackControl.afterXAFlow(0, 50);
            }
        }
        catch (XAException xAException) {
            this._errorCode = xAException.errorCode;
            FFDCFilter.processException((Throwable)xAException, "com.ibm.ws.Transaction.JTA.RegisteredResources.forgetResource", "2859", this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "XAException: error code " + XAReturnCodeHelper.convertXACode(this._errorCode), xAException);
            }
            if (xaFlowCallbackEnabled) {
                XAFlowCallbackControl.afterXAFlow(0, 51);
            }
            if (this._errorCode == -3) {
                bl = true;
                this.addToFailedResources(jTAResource);
            } else if (this._errorCode == -7) {
                jTAResource.setState(3);
                bl = true;
                this.addToFailedResources(jTAResource);
            } else if (this._errorCode == -4) {
                jTAResource.setResourceStatus(4);
                jTAResource.destroy();
            } else {
                Tr.error(tc, "WTRN0054_XA_FORGET_ERROR", new Object[]{XAReturnCodeHelper.convertXACode(this._errorCode), xAException});
                jTAResource.setResourceStatus(4);
                this._systemException = xAException;
            }
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.Transaction.JTA.RegisteredResources.forgetResource", "2935", this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "RuntimeException", throwable);
            }
            if (xaFlowCallbackEnabled) {
                XAFlowCallbackControl.afterXAFlow(0, 51);
            }
            bl = true;
            this.addToFailedResources(jTAResource);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "forgetResource", bl);
        }
        return bl;
    }

    void distributeCommit() throws SystemException, HeuristicHazardException, HeuristicMixedException, HeuristicRollbackException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "distributeCommit");
        }
        TransactionState transactionState = this._transaction.getTransactionState();
        transactionState.setCommittingStateUnlogged();
        this._outcome = true;
        this._retryRequired = this.distributeOutcome();
        if (this._systemException != null) {
            Throwable throwable = new SystemException().initCause(this._systemException);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "distributeCommit", throwable);
            }
            throw (SystemException)throwable;
        }
        if (HeuristicOutcome.isHeuristic(this._heuristicOutcome)) {
            switch (this._heuristicOutcome) {
                case 8: {
                    break;
                }
                case 9: {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        Tr.exit(tc, "distributeCommit", "HeuristicRollbackException");
                    }
                    throw new HeuristicRollbackException();
                }
                case 11: {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        Tr.exit(tc, "distributeCommit", "HeuristicHazardException");
                    }
                    throw new HeuristicHazardException();
                }
                default: {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        Tr.exit(tc, "distributeCommit", "HeuristicMixedException");
                    }
                    throw new HeuristicMixedException();
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "distributeCommit");
        }
    }

    void flowCommitOnePhase(boolean bl) throws RollbackException, SystemException, HeuristicMixedException, HeuristicHazardException, HeuristicRollbackException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "flowCommitOnePhase", bl);
        }
        JTAResource jTAResource = (JTAResource)this._resourceObjects.get(0);
        boolean bl2 = true;
        boolean bl3 = false;
        try {
            jTAResource.setResourceStatus(5);
            if (xaFlowCallbackEnabled) {
                bl2 = XAFlowCallbackControl.beforeXAFlow(1, 21);
            }
            if (bl2) {
                jTAResource.commit_one_phase();
            }
            jTAResource.setResourceStatus(7);
            if (xaFlowCallbackEnabled) {
                XAFlowCallbackControl.afterXAFlow(1, 50);
            }
        }
        catch (XAException xAException) {
            this._errorCode = xAException.errorCode;
            FFDCFilter.processException((Throwable)xAException, "com.ibm.ws.Transaction.JTA.RegisteredResources.flowCommitOnePhase", "3031", this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "XAException: error code " + XAReturnCodeHelper.convertXACode(this._errorCode), xAException);
            }
            if (xaFlowCallbackEnabled) {
                XAFlowCallbackControl.afterXAFlow(1, 51);
            }
            if (this._errorCode >= 100 && this._errorCode <= 107) {
                jTAResource.setResourceStatus(6);
                jTAResource.destroy();
                Throwable throwable = new RollbackException().initCause((Throwable)xAException);
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "flowCommitOnePhase", throwable);
                }
                throw (RollbackException)throwable;
            }
            if (this._errorCode == 7) {
                jTAResource.setResourceStatus(8);
                this.updateHeuristicOutcome(8);
            }
            if (this._errorCode == 6) {
                jTAResource.setResourceStatus(9);
                Tr.error(tc, "WTRN0075_HEURISTIC_ON_COMMIT", this._transaction.getTranName());
                this.updateHeuristicOutcome(9);
            }
            if (this._errorCode == 5) {
                jTAResource.setResourceStatus(10);
                Tr.error(tc, "WTRN0075_HEURISTIC_ON_COMMIT", this._transaction.getTranName());
                this.updateHeuristicOutcome(10);
            }
            if (this._errorCode == 8) {
                jTAResource.setResourceStatus(11);
                Tr.error(tc, "WTRN0075_HEURISTIC_ON_COMMIT", this._transaction.getTranName());
                this.updateHeuristicOutcome(11);
            }
            if (this._errorCode == -3) {
                Tr.error(tc, "WTRN0047_XAER_RMERR_ON_COMMIT", jTAResource);
                jTAResource.setResourceStatus(6);
                jTAResource.destroy();
                Throwable throwable = new RollbackException().initCause((Throwable)xAException);
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "flowCommitOnePhase", throwable);
                }
                throw (RollbackException)throwable;
            }
            if (this._errorCode == -7) {
                if (jTAResource instanceof CORBAResourceWrapper || jTAResource instanceof WSCoordinatorWrapper) {
                    bl3 = true;
                } else {
                    Tr.warning(tc, "WTRN0052_XAER_RMFAIL_ON_COMMIT_ONE_PHASE", jTAResource);
                    jTAResource.setResourceStatus(4);
                    jTAResource.destroy();
                }
                this.updateHeuristicOutcome(11);
            }
            if (this._errorCode == -4) {
                jTAResource.setResourceStatus(4);
                jTAResource.destroy();
                Throwable throwable = new RollbackException().initCause((Throwable)xAException);
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "flowCommitOnePhase", throwable);
                }
                throw (RollbackException)throwable;
            }
            Tr.error(tc, "WTRN0053_UNEXPECTED_XA_ERROR_ON_COMMIT_ONE_PHASE", XAReturnCodeHelper.convertXACode(this._errorCode));
            jTAResource.setResourceStatus(4);
            jTAResource.destroy();
            Throwable throwable = new SystemException().initCause((Throwable)xAException);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "flowCommitOnePhase", throwable);
            }
            throw (SystemException)throwable;
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.Transaction.JTA.RegisteredResources.flowCommitOnePhase", "3172", this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "RuntimeException", throwable);
            }
            if (xaFlowCallbackEnabled) {
                XAFlowCallbackControl.afterXAFlow(1, 51);
            }
            Tr.error(tc, "WTRN0070_ONE_PHASE_COMMIT_FAILED", throwable);
            jTAResource.setResourceStatus(4);
            jTAResource.destroy();
            Throwable throwable2 = new RollbackException().initCause(throwable);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "flowCommitOnePhase", throwable2);
            }
            throw (RollbackException)throwable2;
        }
        if (this._systemException != null) {
            Throwable throwable = new SystemException().initCause(this._systemException);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "flowCommitOnePhase", throwable);
            }
            throw (SystemException)throwable;
        }
        if (bl3 && !bl) {
            this._outcome = true;
            this._retryRequired = true;
            if (HeuristicOutcome.isHeuristic(this._heuristicOutcome)) {
                switch (this._heuristicOutcome) {
                    case 8: {
                        break;
                    }
                    case 9: {
                        HeuristicRollbackException heuristicRollbackException = new HeuristicRollbackException();
                        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                            Tr.exit(tc, "flowCommitOnePhase", (Object)heuristicRollbackException);
                        }
                        throw heuristicRollbackException;
                    }
                    case 11: {
                        HeuristicHazardException heuristicHazardException = new HeuristicHazardException();
                        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                            Tr.exit(tc, "flowCommitOnePhase", heuristicHazardException);
                        }
                        throw heuristicHazardException;
                    }
                    default: {
                        HeuristicMixedException heuristicMixedException = new HeuristicMixedException();
                        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                            Tr.exit(tc, "flowCommitOnePhase", (Object)heuristicMixedException);
                        }
                        throw heuristicMixedException;
                    }
                }
            }
        } else if (HeuristicOutcome.isHeuristic(this._heuristicOutcome)) {
            switch (this._heuristicOutcome) {
                case 8: {
                    break;
                }
                case 9: {
                    if (!bl) {
                        HeuristicRollbackException heuristicRollbackException = new HeuristicRollbackException();
                        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                            Tr.exit(tc, "flowCommitOnePhase", (Object)heuristicRollbackException);
                        }
                        throw heuristicRollbackException;
                    }
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                        Tr.event(tc, "LPS resource rolled-back heuristically.  Throwing RollbackException.");
                    }
                    RollbackException rollbackException = new RollbackException();
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        Tr.exit(tc, "flowCommitOnePhase", (Object)rollbackException);
                    }
                    throw rollbackException;
                }
                case 11: {
                    HeuristicHazardException heuristicHazardException = new HeuristicHazardException();
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        Tr.exit(tc, "flowCommitOnePhase", heuristicHazardException);
                    }
                    throw heuristicHazardException;
                }
                default: {
                    HeuristicMixedException heuristicMixedException = new HeuristicMixedException();
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        Tr.exit(tc, "flowCommitOnePhase", (Object)heuristicMixedException);
                    }
                    throw heuristicMixedException;
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "flowCommitOnePhase");
        }
    }

    void distributeRollback() throws HeuristicMixedException, HeuristicHazardException, HeuristicCommitException, SystemException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "distributeRollback");
        }
        TransactionState transactionState = this._transaction.getTransactionState();
        transactionState.setRollingBackStateUnlogged();
        int n = this._heuristicOutcome;
        this._outcome = false;
        this._retryRequired = this.distributeOutcome();
        if (this._systemException != null) {
            Throwable throwable = new SystemException().initCause(this._systemException);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "distributeRollback", throwable);
            }
            throw (SystemException)throwable;
        }
        if (HeuristicOutcome.isHeuristic(this._heuristicOutcome) && n == 0) {
            switch (this._heuristicOutcome) {
                case 9: {
                    break;
                }
                case 11: {
                    HeuristicHazardException heuristicHazardException = new HeuristicHazardException();
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        Tr.exit(tc, "distributeRollback", heuristicHazardException);
                    }
                    throw heuristicHazardException;
                }
                case 8: {
                    HeuristicCommitException heuristicCommitException = new HeuristicCommitException();
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        Tr.exit(tc, "distributeRollback", (Object)heuristicCommitException);
                    }
                    throw heuristicCommitException;
                }
                default: {
                    HeuristicMixedException heuristicMixedException = new HeuristicMixedException();
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        Tr.exit(tc, "distributeRollback", (Object)heuristicMixedException);
                    }
                    throw heuristicMixedException;
                }
            }
        }
        if (n != 0) {
            this._heuristicOutcome = n;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "distributeRollback");
        }
    }

    void rollbackResources() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "rollbackResources", this);
        }
        this.distributeEnd(0x20000000);
        this._outcome = false;
        this._retryRequired = this.distributeOutcome();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "rollbackResources", this._retryRequired);
        }
    }

    private void recordLog(JTAResource jTAResource) throws SystemException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "recordLog", new Object[]{this, jTAResource});
        }
        if (this._logUnit == null) {
            this._logUnit = this._transaction.getLog();
        }
        if (this._logUnit != null) {
            RecoverableUnitSection recoverableUnitSection;
            if (jTAResource instanceof JTAXAResource) {
                if (this._xalogSection == null) {
                    this._xalogSection = this.createLogSection(2, this._logUnit);
                }
                recoverableUnitSection = this._xalogSection;
            } else if (jTAResource instanceof WSCoordinatorWrapper) {
                if (this._wscResourceSection == null) {
                    this._wscResourceSection = this.createLogSection(5, this._logUnit);
                }
                recoverableUnitSection = this._wscResourceSection;
            } else if (jTAResource instanceof WSATParticipantWrapper) {
                if (this._wscResourceSection == null) {
                    this._wscResourceSection = this.createLogSection(10, this._logUnit);
                }
                recoverableUnitSection = this._wscResourceSection;
            } else {
                if (this._logSection == null) {
                    this._logSection = this.createLogSection(1, this._logUnit);
                }
                recoverableUnitSection = this._logSection;
            }
            jTAResource.log(recoverableUnitSection);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "recordLog");
        }
    }

    private RecoverableUnitSection createLogSection(int n, RecoverableUnit recoverableUnit) throws SystemException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "createLogSection", new Object[]{new Integer(n), recoverableUnit});
        }
        RecoverableUnitSection recoverableUnitSection = null;
        try {
            recoverableUnitSection = recoverableUnit.createSection(n, false);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.Transaction.JTA.RegisteredResource.createLogSection", "2349", this);
            Throwable throwable = new SystemException(exception.toString()).initCause((Throwable)exception);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event(tc, "Exception raised creating log section", exception);
            }
            throw (SystemException)throwable;
        }
        finally {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "createLogSection", recoverableUnitSection);
            }
        }
        return recoverableUnitSection;
    }

    public ArrayList getResourceObjects() {
        return this._resourceObjects;
    }

    protected XAPdataWrapper getPersistentInterestData() {
        Object object;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getPersistentInterestData");
        }
        ArrayList arrayList = (ArrayList)this._resourceObjects.clone();
        int n = arrayList.size();
        while (--n >= 0) {
            object = (JTAResource)arrayList.get(n);
            if (object instanceof JTAXAResource) {
                if (object.getResourceStatus() != 4 && object.getResourceStatus() != 6) continue;
                arrayList.remove(n);
                continue;
            }
            arrayList.remove(n);
        }
        n = arrayList.size();
        object = null;
        if (n > 0) {
            object = new XAPdataWrapper(n);
            for (int i = 0; i < n; ++i) {
                JTAXAResource jTAXAResource = (JTAXAResource)arrayList.get(i);
                XidImpl xidImpl = (XidImpl)jTAXAResource.getXID();
                ((XAPdataWrapper)object).addResourceToken(jTAXAResource.getRecoveryId(), xidImpl.getSequenceNumber());
                if (i != 0) continue;
                ((XAPdataWrapper)object).setStoken(xidImpl.getStoken());
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getPersistentInterestData", object);
        }
        return object;
    }

    protected boolean isLastAgentEnlisted() {
        boolean bl;
        boolean bl2 = bl = this._onePhaseResourceEnlisted != null;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "isLastAgentEnlisted", bl);
        }
        return bl;
    }

    protected boolean isOnlyAgent() {
        boolean bl;
        boolean bl2 = bl = this._resourceObjects.size() == 1 && this._resourceObjects.get(0) instanceof ResourceSupportsOnePhaseCommit;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "isOnlyAgent", bl);
        }
        return bl;
    }

    private void addToFailedResources(JTAResource jTAResource) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "addToFailedResources", jTAResource);
        }
        if (jTAResource instanceof JTAXAResource) {
            if (this._failedResourceList == null) {
                this._failedResourceList = new ArrayList();
            }
            this._failedResourceList.add(jTAResource);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "addToFailedResources");
        }
    }

    XAPdataWrapper getFailedResourceData() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getFailedResourceData");
        }
        XAPdataWrapper xAPdataWrapper = null;
        if (this._failedResourceList != null) {
            int n = this._failedResourceList.size();
            xAPdataWrapper = new XAPdataWrapper(n);
            for (int i = n - 1; i >= 0; --i) {
                JTAXAResource jTAXAResource = (JTAXAResource)this._failedResourceList.get(i);
                XidImpl xidImpl = (XidImpl)jTAXAResource.getXID();
                long l = jTAXAResource.getRecoveryId();
                int n2 = xidImpl.getSequenceNumber();
                xAPdataWrapper.addResourceToken(l, n2);
                if (i != 0) continue;
                xAPdataWrapper.setStoken(xidImpl.getStoken());
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getFailedResourceData", xAPdataWrapper);
        }
        return xAPdataWrapper;
    }

    void destroyResources() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "destroyResources");
        }
        for (int i = 0; i < this._resourceObjects.size(); ++i) {
            JTAResource jTAResource = (JTAResource)this._resourceObjects.get(i);
            this.destroyResource(jTAResource);
        }
        if (this._sameRMResource != null) {
            this.destroyResource(this._sameRMResource);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "destroyResources");
        }
    }

    void destroyResource(JTAResource jTAResource) {
        int n;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "destroyResource", new Object[]{jTAResource, this});
        }
        if ((n = jTAResource.getResourceStatus()) != 4 && n != 6 && n != 7) {
            jTAResource.destroy();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "destroyResource");
        }
    }

    private void logDiagnostics(int n) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "logDiagnostics", new Integer(n));
        }
        String string = this._transaction.getTranName();
        switch (n) {
            case 1: {
                Tr.error(tc, "WTRN0086_PREPARE_DIAG", string);
                break;
            }
            case 0: {
                Tr.error(tc, "WTRN0087_COMPLETION_DIAG", string);
            }
        }
        int n2 = this._resourceObjects.size();
        while (--n2 >= 0) {
            JTAResource jTAResource = (JTAResource)this._resourceObjects.get(n2);
            this.diagnoseResource(jTAResource, n);
        }
        if (this._sameRMResource != null) {
            this.diagnoseResource(this._sameRMResource, n);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "logDiagnostics");
        }
    }

    private void diagnoseResource(JTAResource jTAResource, int n) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "diagnoseResource", new Object[]{jTAResource, new Integer(n), this});
        }
        if (jTAResource instanceof JTAResourceBase) {
            ((JTAResourceBase)jTAResource).diagnose(tc, n);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "diagnoseResource");
        }
    }

    void logHeuristicOutcome() throws SystemException {
        block12: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.entry(tc, "logHeuristicOutcome");
            }
            if (this._transaction.isSubordinate()) {
                boolean bl = false;
                if (this._hoSection == null) {
                    if (this._logUnit == null) {
                        this._logUnit = this._transaction.getLog();
                    }
                    if (this._logUnit != null) {
                        this._hoSection = this.createLogSection(8, this._logUnit);
                    }
                } else {
                    bl = true;
                }
                if (this._hoSection != null) {
                    byte[] byArray = new byte[]{(byte)this._heuristicOutcome};
                    try {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug(tc, "logHeuristicOutcome", ResourceWrapper.printResourceStatus(this._heuristicOutcome));
                        }
                        this._hoSection.addData(byArray);
                        if (bl) {
                            this._hoSection.force();
                        }
                    }
                    catch (InternalLogException internalLogException) {
                        FFDCFilter.processException((Throwable)internalLogException, "com.ibm.ws.Transaction.JTA.RegisteredResources.logHeuristicOutcome", "1576", this);
                        if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) break block12;
                        Tr.event(tc, "addData failed during logHeuristicOutcome", internalLogException);
                    }
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "logHeuristicOutcome");
        }
    }

    public int getHeuristicOutcome() {
        return this._heuristicOutcome;
    }

    void updateHeuristicOutcome(int n) {
        int n2 = HeuristicOutcome.combineStates(this._heuristicOutcome, n);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "updateHeuristicOutcome", "combining " + ResourceWrapper.printResourceStatus(this._heuristicOutcome) + " with " + ResourceWrapper.printResourceStatus(n) + " to get " + ResourceWrapper.printResourceStatus(n2));
        }
        this._heuristicOutcome = n2;
    }

    void setHeuristicOutcome(int n) {
        this._heuristicOutcome = n;
    }

    public void heuristicallyRollback() throws SystemException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "heuristicallyRollback");
        }
        try {
            this.distributeRollback();
            this.setHeuristicOutcome(9);
        }
        catch (HeuristicHazardException heuristicHazardException) {
            FFDCFilter.processException((Throwable)heuristicHazardException, "com.ibm.ws.Transaction.JTA.RegisteredResources.heuristicallyRollback", "3661", this);
            this.setHeuristicOutcome(11);
        }
        catch (HeuristicMixedException heuristicMixedException) {
            FFDCFilter.processException((Throwable)heuristicMixedException, "com.ibm.ws.Transaction.JTA.RegisteredResources.heuristicallyRollback", "3666", this);
            this.setHeuristicOutcome(10);
        }
        catch (HeuristicCommitException heuristicCommitException) {
            FFDCFilter.processException((Throwable)heuristicCommitException, "com.ibm.ws.Transaction.JTA.RegisteredResources.heuristicallyRollback", "3671", this);
            this.setHeuristicOutcome(8);
        }
        this.logHeuristic(false);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "heuristicallyRollback");
        }
    }

    public void heuristicallyCommit() throws SystemException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "heuristicallyCommit");
        }
        try {
            this.distributeCommit();
            this.setHeuristicOutcome(8);
        }
        catch (HeuristicHazardException heuristicHazardException) {
            FFDCFilter.processException((Throwable)heuristicHazardException, "com.ibm.ws.Transaction.JTA.RegisteredResources.heuristicallyCommit", "3696", this);
            this.setHeuristicOutcome(11);
        }
        catch (HeuristicMixedException heuristicMixedException) {
            FFDCFilter.processException((Throwable)heuristicMixedException, "com.ibm.ws.Transaction.JTA.RegisteredResources.heuristicallyCommit", "3701", this);
            this.setHeuristicOutcome(10);
        }
        catch (HeuristicRollbackException heuristicRollbackException) {
            FFDCFilter.processException((Throwable)heuristicRollbackException, "com.ibm.ws.Transaction.JTA.RegisteredResources.heuristicallyCommit", "3706", this);
            this.setHeuristicOutcome(9);
        }
        this.logHeuristic(true);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "heuristicallyCommit");
        }
    }

    public void logHeuristic(boolean bl) throws SystemException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "logHeuristic", bl);
        }
        this.logHeuristicOutcome();
        this.updateHeuristicState(bl);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "logHeuristic");
        }
    }

    public boolean referencesProvider(String string) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "referencesProvider", string);
        }
        int n = this._resourceObjects.size();
        while (--n >= 0) {
            Object e2 = this._resourceObjects.get(n);
            if (e2 instanceof JTAXAResourceImpl) {
                JTAXAResourceImpl jTAXAResourceImpl;
                XAResourceInfo xAResourceInfo;
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Resource is a JTAXAResourceImpl");
                }
                if ((xAResourceInfo = (jTAXAResourceImpl = (JTAXAResourceImpl)e2).getXAResourceInfo()) instanceof ASWrapper) {
                    ASWrapper aSWrapper = (ASWrapper)xAResourceInfo;
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "XAResourceInfo is an ASWrapper", aSWrapper.getActivationSpecWrapper().getProviderId());
                    }
                    if (!string.equals(aSWrapper.getActivationSpecWrapper().getProviderId())) continue;
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        Tr.exit(tc, "referencesProvider", Boolean.TRUE);
                    }
                    return true;
                }
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                Tr.debug(tc, "XAResourceInfo is not an ASWrapper", xAResourceInfo.getClass().getName());
                continue;
            }
            if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
            Tr.debug(tc, "Resource is not a JTAXAResourceImpl", e2.getClass().getName());
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "referencesProvider", Boolean.FALSE);
        }
        return false;
    }

    public boolean requireRetry() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "requireRetry", this._retryRequired);
        }
        return this._retryRequired;
    }

    public String[] listResources() {
        String[] stringArray = new String[this.numRegistered()];
        for (int i = 0; i < stringArray.length; ++i) {
            JTAResource jTAResource = (JTAResource)this._resourceObjects.get(i);
            stringArray[i] = jTAResource.describe();
        }
        return stringArray;
    }

    private boolean sortResources() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "sortResources", this._resourceObjects.toArray());
        }
        int n = this._resourceObjects.size();
        if (!this._sorted) {
            int n2;
            this._sorted = true;
            for (int i = n2 = n - 1; i >= 0; --i) {
                if (!this.isCommitInLastPhase(this._resourceObjects.get(i))) continue;
                this._gotCommitInLastPhaseResources = true;
                if (n2 != i) {
                    this._resourceObjects.add(n2, this._resourceObjects.remove(i));
                }
                --n2;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "sortResources", this._resourceObjects.toArray());
        }
        return this._gotCommitInLastPhaseResources;
    }

    private boolean isCommitInLastPhase(Object object) {
        return object instanceof JTAXAResourceImpl && ((JTAXAResourceImpl)object).getXAResourceInfo().commitInLastPhase();
    }

    static {
        _acceptHeuristicHazard = Configuration.getTxServiceImpl().acceptHeuristicHazard();
    }
}

