/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.Transaction.JTA;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.util.am.Alarm;
import com.ibm.ejs.util.am.AlarmListener;
import com.ibm.ejs.util.am.AlarmManager;
import com.ibm.ws.Transaction.JTA.TransactionImpl;
import java.util.Hashtable;

public final class TimeoutManager {
    private static final TraceComponent tc = Tr.register(TimeoutManager.class, "Transaction", "com.ibm.ws.Transaction.resources.TransactionMsgs");
    public static final int CANCEL_TIMEOUT = 0;
    public static final int NO_TIMEOUT = 0;
    public static final int ACTIVE_TIMEOUT = 1;
    public static final int IN_DOUBT_TIMEOUT = 2;
    public static final int REPEAT_TIMEOUT = 3;
    public static final int INACTIVITY_TIMEOUT = 4;
    private static final Hashtable pendingTimeouts = new Hashtable();
    private static final Hashtable inactivityTimeouts = new Hashtable();

    public static void setTimeout(TransactionImpl transactionImpl, int n, int n2) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "setTimeout", new Object[]{transactionImpl, new Integer(n), new Integer(n2)});
        }
        if (transactionImpl == null) {
            throw new IllegalArgumentException("setTimeout called with null tran");
        }
        TimeoutInfo timeoutInfo = null;
        switch (n) {
            case 1: 
            case 2: 
            case 3: {
                timeoutInfo = new TimeoutInfo(transactionImpl, n2, n);
                timeoutInfo = pendingTimeouts.put(transactionImpl, timeoutInfo);
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled() || timeoutInfo == null || n == 3) break;
                Tr.debug(tc, "Found existing timeout for transaction: " + timeoutInfo);
                break;
            }
            case 4: {
                if (n2 == 0) {
                    timeoutInfo = (TimeoutInfo)inactivityTimeouts.remove(transactionImpl);
                    if (null != timeoutInfo) {
                        timeoutInfo.cancelAlarm();
                        break;
                    }
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break;
                    Tr.debug(tc, "Failed to find existing timeout for transaction: " + transactionImpl);
                    break;
                }
                timeoutInfo = new TimeoutInfo(transactionImpl, n2, n);
                timeoutInfo = inactivityTimeouts.put(transactionImpl, timeoutInfo);
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled() || timeoutInfo == null) break;
                Tr.debug(tc, "Found existing inactivity timeout for transaction: " + timeoutInfo);
                break;
            }
            default: {
                timeoutInfo = (TimeoutInfo)pendingTimeouts.remove(transactionImpl);
                if (null != timeoutInfo) {
                    timeoutInfo.cancelAlarm();
                    break;
                }
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break;
                Tr.debug(tc, "Failed to find existing timeout for transaction: " + transactionImpl);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "setTimeout");
        }
    }

    static class TimeoutInfo
    implements AlarmListener {
        private final TransactionImpl _tran;
        private final int _duration;
        private final int _timeoutType;
        private Alarm _alarm;

        TimeoutInfo(TransactionImpl transactionImpl, int n, int n2) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.entry(tc, "TimeoutInfo", transactionImpl);
            }
            this._tran = transactionImpl;
            this._duration = n;
            this._timeoutType = n2;
            this._alarm = AlarmManager.createNonDeferrable((long)this._duration * 1000L, this, null);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "TimeoutInfo");
            }
        }

        public void alarm(Object object) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.entry(tc, "alarm", this._tran);
            }
            switch (this._timeoutType) {
                case 1: {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                        Tr.event(tc, "Transaction timeout", this._tran);
                    }
                    Tr.info(tc, "WTRN0006_TRANSACTION_HAS_TIMED_OUT", new Object[]{this._tran.getTranName(), new Integer(this._duration)});
                    this._tran.timeoutTransaction(true);
                    break;
                }
                case 3: {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                        Tr.event(tc, "Transaction repeat timeout", this._tran);
                    }
                    this._tran.timeoutTransaction(false);
                    break;
                }
                case 4: {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                        Tr.event(tc, "Transaction inactivity timeout", this._tran);
                    }
                    Tr.info(tc, "WTRN0080_CLIENT_INACTIVITY_TIMEOUT", new Object[]{this._tran.getTranName(), new Integer(this._duration)});
                    inactivityTimeouts.remove(this._tran);
                    this._tran.inactivityTimeout();
                    break;
                }
                case 2: {
                    pendingTimeouts.remove(this._tran);
                    this._tran.recover();
                    break;
                }
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "alarm");
            }
        }

        public void cancelAlarm() {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.entry(tc, "cancelAlarm", this._alarm);
            }
            if (this._alarm != null) {
                this._alarm.cancel();
                this._alarm = null;
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "cancelAlarm");
            }
        }
    }
}

