/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.Transaction.JTA;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.csi.GlobalTranConfigData;
import com.ibm.ws.LocalTransaction.LocalTranCurrentImpl;
import com.ibm.ws.LocalTransaction.LocalTranCurrentSet;
import com.ibm.ws.Transaction.JTA.TransactionImpl;
import com.ibm.ws.Transaction.JTA.Util;
import com.ibm.ws.Transaction.JTS.Configuration;
import com.ibm.ws.Transaction.OnePhaseXAResource;
import com.ibm.ws.Transaction.UOWCoordinator;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.runtime.metadata.ComponentMetaData;
import com.ibm.ws.runtime.metadata.ContainerComponentMetaData;
import com.ibm.ws.threadContext.ComponentMetaDataAccessorImpl;
import com.ibm.ws.uow.UOWScopeCallbackManager;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.InvalidTransactionException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionRolledbackException;
import javax.transaction.xa.XAResource;

public final class TranManagerImpl {
    private static final TraceComponent tc = Tr.register(TranManagerImpl.class, "Transaction", "com.ibm.ws.Transaction.resources.TransactionMsgs");
    private static final int DEFAULT_TX_TIMEOUT = 0;
    private int txTimeout;
    private int userTxTimeout = 0;
    private TransactionImpl tx;
    private LocalTranCurrentImpl ltc;
    private final UOWScopeCallbackManager _callbackManager;

    TranManagerImpl(UOWScopeCallbackManager uOWScopeCallbackManager) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "TranManagerImpl", uOWScopeCallbackManager);
        }
        this._callbackManager = uOWScopeCallbackManager;
        this.txTimeout = Configuration.getTotalTransactionTimeout();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "TranManagerImpl", this);
        }
    }

    public void begin() throws NotSupportedException, SystemException {
        GlobalTranConfigData globalTranConfigData;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "begin (SPI)");
        }
        if (this.tx != null) {
            Tr.error(tc, "WTRN0017_UNABLE_TO_BEGIN_NESTED_TRANSACTION");
            NotSupportedException notSupportedException = new NotSupportedException("Nested transactions are not supported.");
            FFDCFilter.processException((Throwable)notSupportedException, "com.ibm.ws.Transaction.TranManagerImpl.begin", "76", this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "begin (SPI)", notSupportedException);
            }
            throw notSupportedException;
        }
        int n = 0;
        ComponentMetaData componentMetaData = ComponentMetaDataAccessorImpl.getComponentMetaDataAccessor().getComponentMetaData();
        if (componentMetaData instanceof ContainerComponentMetaData && (globalTranConfigData = ((ContainerComponentMetaData)componentMetaData).getGlobalTranConfigData()) != null) {
            n = globalTranConfigData.getTransactionTimeout();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "component timeout = " + n);
            }
        }
        if (n == 0) {
            n = Configuration.getTotalTransactionTimeout();
        }
        this.tx = new TransactionImpl(n);
        this._callbackManager.notifyCallbacks(1, this.tx);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "begin (SPI)");
        }
    }

    public void beginUserTran() throws NotSupportedException, SystemException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "beginUserTran");
        }
        if (this.tx != null) {
            Tr.error(tc, "WTRN0017_UNABLE_TO_BEGIN_NESTED_TRANSACTION");
            NotSupportedException notSupportedException = new NotSupportedException("Nested transactions are not supported.");
            FFDCFilter.processException((Throwable)notSupportedException, "com.ibm.ws.Transaction.TranManagerImpl.beginUserTran", "159", this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "beginUserTran", notSupportedException);
            }
            throw notSupportedException;
        }
        int n = this.userTxTimeout;
        if (n == 0) {
            n = Configuration.getTotalTransactionTimeout();
        }
        this.tx = new TransactionImpl(n);
        this._callbackManager.notifyCallbacks(1, this.tx);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "beginUserTran");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, IllegalStateException, SystemException {
        block12: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.entry(tc, "commit (SPI)");
            }
            if (this.tx == null) {
                IllegalStateException illegalStateException = new IllegalStateException("No transaction associated with this thread");
                FFDCFilter.processException((Throwable)illegalStateException, "com.ibm.ws.Transaction.TranManagerImpl.commit", "167", this);
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "commit (SPI)", illegalStateException);
                }
                throw illegalStateException;
            }
            TransactionImpl transactionImpl = this.tx;
            try {
                this._callbackManager.notifyCallbacks(2, transactionImpl);
            }
            catch (IllegalStateException illegalStateException) {
                FFDCFilter.processException((Throwable)illegalStateException, "com.ibm.ws.Transaction.JTA.TranManagerImpl.commit", "207", this);
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    Tr.event(tc, "IllegalStateException caught notifying callbacks of tx PRE_END", illegalStateException);
                }
                try {
                    transactionImpl.setRollbackOnly();
                }
                catch (IllegalStateException illegalStateException2) {
                    FFDCFilter.processException((Throwable)illegalStateException2, "com.ibm.ws.Transaction.JTA.TranManagerImpl.commit", "217", this);
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) break block12;
                    Tr.event(tc, "IllegalStateException caught setting tx rollback only", illegalStateException2);
                }
            }
        }
        try {
            this.tx.commit();
        }
        finally {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "commit (SPI)");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback() throws IllegalStateException, SecurityException, SystemException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "rollback (SPI)");
        }
        if (this.tx == null) {
            IllegalStateException illegalStateException = new IllegalStateException("No transaction associated with this thread");
            FFDCFilter.processException((Throwable)illegalStateException, "com.ibm.ws.Transaction.TranManagerImpl.rollback", "193", this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "rollback (SPI)", illegalStateException);
            }
            throw illegalStateException;
        }
        try {
            this._callbackManager.notifyCallbacks(2, this.tx);
        }
        catch (IllegalStateException illegalStateException) {
            FFDCFilter.processException((Throwable)illegalStateException, "com.ibm.ws.Transaction.JTA.TranManagerImpl.rollback", "247", this);
        }
        try {
            this.tx.rollback();
        }
        finally {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "rollback (SPI)");
            }
        }
    }

    public Transaction suspend() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "suspend (SPI)");
        }
        TransactionImpl transactionImpl = null;
        if (this.tx != null) {
            if (this.tx._nativeContext != null) {
                this.tx._nativeContext.suspend();
            }
            transactionImpl = this.tx;
            this.tx = null;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "suspend (SPI)", transactionImpl);
        }
        return transactionImpl;
    }

    public void resume(Transaction transaction) throws InvalidTransactionException, IllegalStateException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "resume (SPI)", transaction);
        }
        if (this.tx != null) {
            IllegalStateException illegalStateException = new IllegalStateException("Thread is already associated with a transaction");
            FFDCFilter.processException((Throwable)illegalStateException, "com.ibm.ws.Transaction.TranManagerImpl.resume", "249", this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "resume (SPI)", illegalStateException);
            }
            throw illegalStateException;
        }
        try {
            if (transaction != null) {
                switch (((TransactionImpl)transaction).getTransactionState().getState()) {
                    case -1: 
                    case 4: 
                    case 6: {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug(tc, "Attempting to resume an inactive transaction");
                        }
                        throw new IllegalStateException();
                    }
                }
                this.tx = (TransactionImpl)transaction;
                if (this.tx._nativeContext != null) {
                    this.tx._nativeContext.resume();
                }
            }
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.Transaction.TranManagerImpl.resume", "201", this);
            if (TraceComponent.isAnyTracingEnabled()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Exception caught checking transaction state", throwable);
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "resume (SPI)");
                }
            }
            throw new InvalidTransactionException();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "resume (SPI)");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRollbackOnly() throws IllegalStateException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "setRollbackOnly (SPI)");
        }
        if (this.tx == null) {
            IllegalStateException illegalStateException = new IllegalStateException("No transaction associated with this thread");
            FFDCFilter.processException((Throwable)illegalStateException, "com.ibm.ws.Transaction.TranManagerImpl.setRollbackOnly", "303", this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "setRollbackOnly (SPI)", illegalStateException);
            }
            throw illegalStateException;
        }
        try {
            this.tx.setRollbackOnly();
        }
        finally {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "setRollbackOnly (SPI)");
            }
        }
    }

    public void setTransactionTimeout(int n) throws SystemException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "setTransactionTimeout (SPI)", new Integer(n));
        }
        if (n > 0) {
            this.txTimeout = n;
        } else if (n == 0) {
            this.txTimeout = Configuration.getTotalTransactionTimeout();
            if (this.txTimeout == 0) {
                this.txTimeout = 0;
            }
        } else {
            SystemException systemException = new SystemException("Transaction timeout value must be >= 0");
            FFDCFilter.processException((Throwable)systemException, "com.ibm.ws.Transaction.TranManagerImpl.setTransactionTimeout", "206", this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "setTransactionTimeout (SPI)", (Object)systemException);
            }
            throw systemException;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "setTransactionTimeout (SPI)", new Integer(this.txTimeout));
        }
    }

    public void setUserTransactionTimeout(int n) throws SystemException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "setUserTransactionTimeout (SPI)", new Integer(n));
        }
        if (n < 0) {
            SystemException systemException = new SystemException("Transaction timeout value must be >= 0");
            FFDCFilter.processException((Throwable)systemException, "com.ibm.ws.Transaction.TranManagerImpl.setUserTransactionTimeout", "427", this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "setUserTransactionTimeout (SPI)", (Object)systemException);
            }
            throw systemException;
        }
        this.userTxTimeout = n;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "setUserTransactionTimeout (SPI)", new Integer(this.userTxTimeout));
        }
    }

    public int getStatus() {
        int n = 6;
        if (this.tx != null) {
            n = this.tx.getStatus();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "getStatus (SPI)", Util.printStatus(n));
        }
        return n;
    }

    public Transaction getTransaction() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "getTransaction (SPI)", this.tx);
        }
        return this.tx;
    }

    public TransactionImpl getTransactionImpl() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "getTransactionImpl", this.tx);
        }
        return this.tx;
    }

    public String getGlobalGlobalID() {
        if (this.tx != null) {
            return this.tx.getGlobalGlobalID();
        }
        return "";
    }

    public UOWCoordinator getUOWCoord() {
        UOWCoordinator uOWCoordinator;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getUOWCoord");
        }
        if ((uOWCoordinator = this.tx) == null) {
            if (this.ltc == null) {
                this.ltc = LocalTranCurrentSet.instance().self();
            }
            uOWCoordinator = (UOWCoordinator)((Object)this.ltc.getLocalTranCoord());
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getUOWCoord", uOWCoordinator);
        }
        return uOWCoordinator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean enlist(XAResource xAResource, int n) throws RollbackException, IllegalStateException, SystemException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "enlist", new Object[]{xAResource, new Integer(n)});
        }
        if (this.tx == null) {
            IllegalStateException illegalStateException = new IllegalStateException("No transaction associated with this thread");
            FFDCFilter.processException((Throwable)illegalStateException, "com.ibm.ws.Transaction.TranManagerImpl.enlist", "470", this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "enlist", illegalStateException);
            }
            throw illegalStateException;
        }
        boolean bl = false;
        try {
            bl = this.tx.enlistResource(xAResource, n);
        }
        finally {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "enlist", new Boolean(bl));
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean enlistOnePhase(OnePhaseXAResource onePhaseXAResource) throws RollbackException, IllegalStateException, SystemException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "enlistOnePhase", onePhaseXAResource);
        }
        if (this.tx == null) {
            IllegalStateException illegalStateException = new IllegalStateException("No transaction associated with this thread");
            FFDCFilter.processException((Throwable)illegalStateException, "com.ibm.ws.Transaction.TranManagerImpl.enlist", "498", this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "enlistOnePhase", illegalStateException);
            }
            throw illegalStateException;
        }
        boolean bl = false;
        try {
            bl = this.tx.enlistResource(onePhaseXAResource);
        }
        finally {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "enlistOnePhase", new Boolean(bl));
            }
        }
        return bl;
    }

    public boolean delist(XAResource xAResource, int n) {
        boolean bl;
        block8: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.entry(tc, "delist", new Object[]{xAResource, Util.printFlag(n)});
            }
            if (this.tx == null) {
                if (TraceComponent.isAnyTracingEnabled()) {
                    if (tc.isEventEnabled()) {
                        Tr.event(tc, "The transaction was not found.");
                    }
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "delist", Boolean.FALSE);
                    }
                }
                return false;
            }
            bl = false;
            try {
                bl = this.tx.delistResource(xAResource, n);
            }
            catch (Exception exception) {
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) break block8;
                Tr.event(tc, "delist exception absorbed", exception);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "delist", new Boolean(bl));
        }
        return bl;
    }

    public void completeTxTimeout() throws TransactionRolledbackException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "completeTxTimeout");
        }
        if (this.tx != null && this.tx.isTimedOut()) {
            TransactionRolledbackException transactionRolledbackException;
            if (tc.isEventEnabled()) {
                Tr.event(tc, "Transaction has timed out");
            }
            if (this.tx.isEarlyRollbackAfterTimeoutDisabled()) {
                transactionRolledbackException = new TransactionRolledbackException("Transaction is marked rollback only due to timeout");
            } else {
                Tr.info(tc, "WTRN0041_TXN_ROLLED_BACK", this.tx.getTranName());
                this.tx.rollbackResources();
                transactionRolledbackException = new TransactionRolledbackException("Transaction is ended due to timeout");
            }
            FFDCFilter.processException((Throwable)transactionRolledbackException, "com.ibm.ws.Transaction.JTA.TranManagerImpl.completeTxTimeout", "589", this);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "completeTxTimeout", (Object)transactionRolledbackException);
            }
            throw transactionRolledbackException;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "completeTxTimeout");
        }
    }

    public void beforeCompletion() {
        block4: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.entry(tc, "beforeCompletion");
            }
            try {
                this.tx.internalPrepare();
            }
            catch (Throwable throwable) {
                FFDCFilter.processException(throwable, "com.ibm.ws.Transaction.TranManagerImpl.beforeCompletion", "666", this);
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) break block4;
                Tr.event(tc, "exception from internalPrepare absorbed", throwable);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "beforeCompletion");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterCompletion(boolean bl) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "afterCompletion", bl);
        }
        TransactionImpl transactionImpl = this.tx;
        try {
            if (bl) {
                transactionImpl.internalCommit();
            } else {
                transactionImpl.internalRollback();
            }
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.Transaction.TranManagerImpl.afterCompletion", "696", this);
            Tr.event(tc, "afterCompletion raised exception", throwable);
        }
        finally {
            transactionImpl.notifyCompletion();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "afterCompletion");
        }
    }

    public void disableEarlyRollbackAfterTimeout() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "disableEarlyRollbackAfterTimeout", this);
        }
        if (this.tx == null) {
            IllegalStateException illegalStateException = new IllegalStateException("No transaction associated with this thread.");
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "disableEarlyRollbackAfterTimeout", illegalStateException);
            }
            throw illegalStateException;
        }
        this.tx.disableEarlyRollbackAfterTimeout();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "disableEarlyRollbackAfterTimeout");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beginLPSEnabledTx() throws NotSupportedException, SystemException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "beginLPSEnabledTx", this);
        }
        try {
            this.begin();
            this.tx.enableLPS();
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "beginLPSEnabledTx", this);
            }
        }
    }
}

