/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.Transaction.JTA;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.util.am.Alarm;
import com.ibm.ejs.util.am.AlarmListener;
import com.ibm.ejs.util.am.AlarmManager;
import com.ibm.ws.Transaction.JTA.FailureScopeController;
import com.ibm.ws.Transaction.JTA.HeuristicHazardException;
import com.ibm.ws.Transaction.JTA.HeuristicOutcome;
import com.ibm.ws.Transaction.JTA.JCARecoveryData;
import com.ibm.ws.Transaction.JTA.JTAResource;
import com.ibm.ws.Transaction.JTA.JTAXAResourceImpl;
import com.ibm.ws.Transaction.JTA.LocalTIDTable;
import com.ibm.ws.Transaction.JTA.PartnerLogData;
import com.ibm.ws.Transaction.JTA.PartnerLogTable;
import com.ibm.ws.Transaction.JTA.RecoveryManager;
import com.ibm.ws.Transaction.JTA.RegisteredResources;
import com.ibm.ws.Transaction.JTA.RegisteredSyncs;
import com.ibm.ws.Transaction.JTA.ResourceWrapper;
import com.ibm.ws.Transaction.JTA.TimeoutManager;
import com.ibm.ws.Transaction.JTA.TranManagerSet;
import com.ibm.ws.Transaction.JTA.TransactionState;
import com.ibm.ws.Transaction.JTA.TxExecutionContextHandler;
import com.ibm.ws.Transaction.JTA.TxPrimaryKey;
import com.ibm.ws.Transaction.JTA.Util;
import com.ibm.ws.Transaction.JTA.WSCRecoveryData;
import com.ibm.ws.Transaction.JTA.WSCRecoveryWrapper;
import com.ibm.ws.Transaction.JTA.XAPdataWrapper;
import com.ibm.ws.Transaction.JTA.XARecoveryData;
import com.ibm.ws.Transaction.JTA.XidImpl;
import com.ibm.ws.Transaction.JTS.CORBAResourceWrapper;
import com.ibm.ws.Transaction.JTS.Configuration;
import com.ibm.ws.Transaction.JTS.CoordinatorImpl;
import com.ibm.ws.Transaction.JTS.CoordinatorResource;
import com.ibm.ws.Transaction.JTS.CoordinatorResourceImpl;
import com.ibm.ws.Transaction.JTS.ResourceCallback;
import com.ibm.ws.Transaction.JTS.TransactionWrapper;
import com.ibm.ws.Transaction.JTS.TxStatusHelper;
import com.ibm.ws.Transaction.JTS.WSCoordinator;
import com.ibm.ws.Transaction.JTS.WSCoordinatorImpl;
import com.ibm.ws.Transaction.JTS.WSCoordinatorWrapper;
import com.ibm.ws.Transaction.JtsPerformanceMetrics;
import com.ibm.ws.Transaction.OnePhaseXAResource;
import com.ibm.ws.Transaction.TxProperties;
import com.ibm.ws.Transaction.UOWCoordinator;
import com.ibm.ws.Transaction.WebSphereTransactionManager;
import com.ibm.ws.Transaction.wstx.JTAAsyncSynchronizationBase;
import com.ibm.ws.Transaction.wstx.WSATControlSet;
import com.ibm.ws.Transaction.wstx.WSATParticipantWrapper;
import com.ibm.ws.Transaction.wstx.WSATRecoveryCoordinator;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.jtaextensions.ExtendedJTATransactionFactory;
import com.ibm.ws.jtaextensions.ExtendedJTATransactionImpl;
import com.ibm.ws.recoverylog.spi.LogClosedException;
import com.ibm.ws.recoverylog.spi.RecoverableUnit;
import com.ibm.ws.recoverylog.spi.RecoverableUnitSection;
import com.ibm.ws.recoverylog.spi.RecoveryLog;
import com.ibm.ws.runtime.component.TxServiceImpl;
import com.ibm.ws.uow.SynchronizationRegistryUOWScope;
import com.ibm.ws.util.LongObjectHashMap;
import com.ibm.ws390.tx.NativeGlobalTransactionContext;
import com.ibm.ws390.tx.WSATCRAsyncResource;
import com.ibm.wsspi.transaction.ExtTransaction;
import com.ibm.wsspi.wsaddressing.EndpointReference;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import javax.transaction.HeuristicCommitException;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.INV_OBJREF;
import org.omg.CORBA.Object;
import org.omg.CORBA.TRANSACTION_ROLLEDBACK;
import org.omg.CosTransactions.Coordinator;
import org.omg.CosTransactions.Inactive;
import org.omg.CosTransactions.NotPrepared;
import org.omg.CosTransactions.RecoveryCoordinator;
import org.omg.CosTransactions.RecoveryCoordinatorHelper;
import org.omg.CosTransactions.Status;
import org.omg.WSCosTransactions.WSCosCoordinator;
import org.omg.WSCosTransactions.WSCosCoordinatorHelper;

public final class TransactionImpl
implements Transaction,
ExtTransaction,
UOWCoordinator,
ResourceCallback,
SynchronizationRegistryUOWScope {
    public static final String TRANSACTION_LOG_NAME = "tranlog";
    public static final String PARTNER_LOG_NAME = "partnerlog";
    public static final int TRAN_STATE_SECTION = 0;
    public static final int CORBA_RESOURCE_SECTION = 1;
    public static final int XARESOURCE_SECTION = 2;
    public static final int GLOBALID_SECTION = 3;
    public static final int RECOVERYCOORD_SECTION = 4;
    public static final int RESOURCE_WSC_SECTION = 5;
    public static final int RECCOORD_WSC_SECTION = 6;
    public static final int RESOURCE_ADAPTER_SECTION = 7;
    public static final int HEURISTIC_OUTCOME_SECTION = 8;
    public static final int RECCOORD_WSAT_SECTION = 9;
    public static final int WSAT_ASYNC_RESOURCE_SECTION = 10;
    public static final int NEXT_ID_SECTION = 30;
    public static final int LOW_WATERMARK_SECTION = 31;
    public static final int SERVER_STATE_SECTION = 32;
    public static final int CLASSPATH_SECTION = 33;
    public static final int XARESOURCEDATA_SECTION = 34;
    public static final int WSCOORDINATOR_SECTION = 35;
    public static final int JCAPROVIDER_SECTION = 36;
    public static final int APPLID_DATA_SECTION = 253;
    public static final int EPOCH_DATA_SECTION = 254;
    public static final int SERVER_DATA_SECTION = 255;
    private static Hashtable primaryKeyMap = new Hashtable();
    private TransactionState _status;
    private int _activeAssociations;
    private int _suspendedAssociations;
    private int _timeout;
    private boolean _subordinate;
    private volatile boolean _rollbackOnly;
    private volatile Throwable _originalException = null;
    private volatile boolean _timedOut;
    private RegisteredResources _resources;
    NativeGlobalTransactionContext _nativeContext;
    private boolean _isXALastAgent;
    private boolean _isNativeLastAgent;
    private RetryAlarm _retryAlarm;
    private RegisteredSyncs _syncs;
    private ArrayList _destroyCallbacks;
    private int _finishCount = 1;
    private RecoverableUnit _logUnit;
    private RecoveryLog _tranLog;
    private boolean _systemExceptionOccured;
    private Exception _heuristicOnPrepare;
    private RecoveryCoordinator _recovery;
    private CoordinatorResource _resource;
    private Object _recoveryObject;
    private WSCoordinator _superiorWSCoord;
    private WSATRecoveryCoordinator _wsatRC;
    private long _superiorRecoveryId;
    private int _retryAttempts;
    private int _retryWait = heuristicRetryWait <= 0 ? 60 : heuristicRetryWait;
    public static final int defaultRetryTime = 60;
    public static int heuristicRetryLimit;
    public static int heuristicRetryWait;
    public static boolean LPSLoggingEnabled;
    public static int lpsHeuristicCompletion;
    public static final int LPS_ROLLBACK = 0;
    public static final int LPS_COMMIT = 1;
    public static final int LPS_MANUAL = 2;
    private static final LongObjectHashMap _heuristicTxns;
    private long _expirationTime;
    private XidImpl _xid;
    private long _localTID;
    private String _tranName;
    private String _globalGlobalID;
    private Byte _completedLTCBoundary;
    private static JtsPerformanceMetrics _perfMetricsListener;
    protected TxPerformanceData _perf = _perfMetricsListener != null ? new TxPerformanceData() : null;
    private WebSphereTransactionManager.InactivityTimer _inactivityTimer;
    private boolean _inactivityTimerActive;
    private final int _inactivityTimeout = Configuration.getInactivityTimeout();
    private boolean _nonInterop;
    private JCARecoveryData _JCARecoveryData;
    private XidImpl _JCAXid;
    private boolean _disableTwoPhase;
    private boolean _needsManualCompletion;
    private final FailureScopeController _failureScopeController;
    private String _taskId;
    private boolean _inRecovery;
    private boolean _cascaded = false;
    private Map _synchronizationRegistryResources;
    private boolean _disableEarlyRollbackAfterTimeout = false;
    private boolean _LPSEnabled = false;
    private static TraceComponent tc;

    public TransactionImpl(FailureScopeController failureScopeController) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "TransactionImpl", failureScopeController);
        }
        this._failureScopeController = failureScopeController;
        this._nativeContext = null;
        this._perf = null;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "TransactionImpl");
        }
    }

    public TransactionImpl(int n) throws SystemException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "TransactionImpl", new java.lang.Object[]{new Integer(n)});
        }
        this._failureScopeController = Configuration.getFailureScopeController();
        if (TxProperties.NATIVE_CONTEXTS_USED) {
            this._nativeContext = NativeGlobalTransactionContext.create(this, n);
            this._xid = this._nativeContext.getNativeXID();
            this.initializeNativeTran(n);
        } else {
            this._nativeContext = null;
            TxPrimaryKey txPrimaryKey = this.initializeTran(n);
            this._xid = new XidImpl(txPrimaryKey);
        }
        ++this._activeAssociations;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "TransactionImpl");
        }
    }

    public TransactionImpl(int n, Xid xid) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "TransactionImpl", new java.lang.Object[]{new Integer(n), xid});
        }
        this._failureScopeController = Configuration.getFailureScopeController();
        if (this._perf != null) {
            this._perf.imported();
        }
        this._subordinate = true;
        this._nativeContext = null;
        TxPrimaryKey txPrimaryKey = this.initializeTran(n);
        this._xid = new XidImpl(xid, txPrimaryKey);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "TransactionImpl");
        }
    }

    public TransactionImpl(byte[] byArray, boolean bl) throws SystemException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "TransactionImpl", byArray);
        }
        this._failureScopeController = Configuration.getFailureScopeController();
        if (this._perf != null) {
            this._perf.imported();
        }
        this._cascaded = bl;
        this._subordinate = true;
        this._xid = new XidImpl(byArray);
        this._nativeContext = NativeGlobalTransactionContext.setupImportedTx(this, this._xid, false, false);
        this.initializeNativeTran(-1);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "TransactionImpl");
        }
    }

    public TransactionImpl() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "TransactionImpl");
        }
        this._failureScopeController = Configuration.getFailureScopeController();
        this._nativeContext = null;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "TransactionImpl");
        }
    }

    public TransactionImpl(int n, Xid xid, JCARecoveryData jCARecoveryData) throws SystemException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "TransactionImpl", new java.lang.Object[]{new Integer(n), xid, jCARecoveryData});
        }
        this._failureScopeController = Configuration.getFailureScopeController();
        if (this._perf != null) {
            this._perf.imported();
        }
        this._subordinate = true;
        if (TxProperties.NATIVE_CONTEXTS_USED) {
            this._nativeContext = NativeGlobalTransactionContext.setupImportedTx(this, new XidImpl(xid), true, false);
            this._xid = this._nativeContext.getNativeXID();
            this.initializeNativeTran(n);
        } else {
            this._nativeContext = null;
            TxPrimaryKey txPrimaryKey = this.initializeTran(n);
            this._xid = new XidImpl(xid, txPrimaryKey);
        }
        this._JCARecoveryData = jCARecoveryData;
        this._JCAXid = new XidImpl(xid);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "TransactionImpl");
        }
    }

    public TransactionImpl(int n, String string, byte[] byArray) throws SystemException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "TransactionImpl", new java.lang.Object[]{new Integer(n), string, byArray});
        }
        this._failureScopeController = Configuration.getFailureScopeController();
        if (this._perf != null) {
            this._perf.imported();
        }
        this._subordinate = true;
        if (TxProperties.NATIVE_CONTEXTS_USED) {
            this._xid = new XidImpl(byArray);
            this._nativeContext = NativeGlobalTransactionContext.setupImportedTx(this, this._xid, false, true);
            this.initializeNativeTran(-1);
        } else {
            this._nativeContext = null;
            TxPrimaryKey txPrimaryKey = this.initializeTran(n);
            this._xid = new XidImpl(txPrimaryKey);
        }
        this._globalGlobalID = string;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "TransactionImpl");
        }
    }

    private TxPrimaryKey initializeTran(int n) {
        this._localTID = LocalTIDTable.getLocalTID(this);
        TxPrimaryKey txPrimaryKey = new TxPrimaryKey(this._localTID, Configuration.getCurrentEpoch());
        this.initialize(n);
        if (this._timeout > 0) {
            this._expirationTime = txPrimaryKey.getTimeStamp() + (long)this._timeout * 1000L;
        }
        return txPrimaryKey;
    }

    private void initializeNativeTran(int n) {
        this._localTID = this._xid.getPrimaryKeySequenceNumber();
        LocalTIDTable.reserveLocalTID(this._localTID, this);
        this.initialize(n);
        this.addToPrimaryKeyMap();
        if (this._timeout > 0) {
            this._expirationTime = System.currentTimeMillis() + (long)this._timeout * 1000L;
        }
    }

    private void initialize(int n) {
        this._failureScopeController.registerTransaction(this, false);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event(tc, "(SPI) Transaction BEGIN occurred for TX: " + this._localTID);
        }
        if (this._failureScopeController.getRecoveryManager() == null) {
            this._disableTwoPhase = true;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "No recovery log is currently available. Transaction can only support 1PC protocol");
            }
        }
        this._status = new TransactionState(this);
        int n2 = Configuration.getMaximumTransactionTimeout();
        if (n2 > 0 && (n > n2 || n == 0)) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event(tc, "Timeout limited by maximumTransactionTimeout");
            }
            n = n2;
        }
        if (n > 0) {
            this._timeout = n;
            TimeoutManager.setTimeout(this, 1, n);
        }
        if (this._perf != null) {
            this._perf.started();
        }
        if (ExtendedJTATransactionImpl.callbacksRegistered()) {
            this._syncs = new RegisteredSyncs(this, (ExtendedJTATransactionImpl)ExtendedJTATransactionFactory.getExtendedJTATransaction());
        }
    }

    public long getExpirationTime() {
        return this._expirationTime;
    }

    public int getTimeout() {
        return this._timeout;
    }

    public void setRecoveryCoordinator(RecoveryCoordinator recoveryCoordinator) {
        this._recovery = recoveryCoordinator;
    }

    public RecoveryCoordinator getRecoveryCoordinator() {
        return this._recovery;
    }

    public void setCoordinatorResource(CoordinatorResource coordinatorResource) {
        this._resource = coordinatorResource;
    }

    public CoordinatorResource getCoordinatorResource() {
        return this._resource;
    }

    public void setSuperiorCoordinator(WSCoordinator wSCoordinator) {
        this._superiorWSCoord = wSCoordinator;
    }

    public WSCoordinator getSuperiorCoordinator() {
        return this._superiorWSCoord;
    }

    public void setWSATRecoveryCoordinator(WSATRecoveryCoordinator wSATRecoveryCoordinator) {
        this._wsatRC = wSATRecoveryCoordinator;
    }

    public WSATRecoveryCoordinator getWSATRecoveryCoordinator() {
        return this._wsatRC;
    }

    boolean reconstruct(RecoverableUnit recoverableUnit, RecoveryLog recoveryLog) throws SystemException {
        java.lang.Object object;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "reconstruct", new java.lang.Object[]{recoverableUnit, recoveryLog});
        }
        boolean bl = true;
        RecoveryManager recoveryManager = this._failureScopeController.getRecoveryManager();
        RecoverableUnitSection recoverableUnitSection = recoverableUnit.lookupSection(7);
        if (recoverableUnitSection != null) {
            this._subordinate = true;
            byte[] byArray = recoverableUnitSection.lastData();
            this._JCAXid = byArray.length > 20 ? new XidImpl(byArray, 8) : this._xid;
            long l = Util.getLongFromBytes(byArray, 0);
            object = recoveryManager.getPartnerLogTable().findEntry(l);
            if (object instanceof JCARecoveryData) {
                this._JCARecoveryData = (JCARecoveryData)object;
                this._JCARecoveryData.incrementCount();
                this.addDestroyCallback(this);
            } else {
                SystemException systemException = new SystemException();
                FFDCFilter.processException((Throwable)systemException, "com.ibm.ws.Transaction.JTA.TransactionImpl.reconstruct", "632", this);
                Tr.fatal(tc, "WTRN0000_ERR_INT_ERROR", new java.lang.Object[]{"reconstruct", this.getClass().getName(), systemException});
                throw systemException;
            }
        }
        this._status = new TransactionState(this);
        int n = this._status.reconstruct(recoverableUnit);
        if (n == -1 || n == 4 || n == 6) {
            bl = false;
        } else {
            RecoverableUnitSection recoverableUnitSection2;
            java.lang.Object object2;
            RecoverableUnitSection recoverableUnitSection3 = recoverableUnit.lookupSection(6);
            if (recoverableUnitSection3 != null) {
                try {
                    java.lang.Object object3;
                    long l = Util.getLongFromBytes(recoverableUnitSection3.lastData(), 0);
                    if (l >= 0L) {
                        object2 = recoveryManager.getPartnerLogTable().findEntry(l);
                        if (object2 instanceof WSCRecoveryData) {
                            object3 = (WSCRecoveryWrapper)((PartnerLogData)object2).getLogData();
                            this._superiorWSCoord = ((WSCRecoveryWrapper)object3).getWSCoordinator();
                            ((PartnerLogData)object2).incrementCount();
                            this.addDestroyCallback(this);
                        }
                        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                            Tr.event(tc, "object is", this._superiorWSCoord);
                        }
                        if (this._superiorWSCoord == null) {
                            throw new INV_OBJREF();
                        }
                    } else {
                        throw new SystemException("Invalid remote transaction coordinator record data in log");
                    }
                    this._superiorRecoveryId = l;
                    object3 = (WSCoordinatorImpl)this._failureScopeController.getWSCoordinator();
                    TransactionWrapper transactionWrapper = new TransactionWrapper(this);
                    ((WSCoordinatorImpl)object3).storeTransactionWrapper(this.getXid().getGlobalTransactionId(), transactionWrapper);
                    this._subordinate = true;
                }
                catch (Throwable throwable) {
                    FFDCFilter.processException(throwable, "com.ibm.ws.Transaction.JTA.TransactionImpl.reconstruct", "644", this);
                    Tr.fatal(tc, "WTRN0000_ERR_INT_ERROR", new java.lang.Object[]{"reconstruct", this.getClass().getName(), throwable});
                    throw new SystemException(throwable.getLocalizedMessage());
                }
            }
            if ((recoverableUnitSection2 = recoverableUnit.lookupSection(4)) != null) {
                if (this._subordinate) {
                    Tr.error(tc, "WTRN0001_ERR_INT_ERROR", new java.lang.Object[]{"reconstruct", this.getClass().getName()});
                    throw new SystemException();
                }
                try {
                    object = recoverableUnitSection2.lastData();
                    if (((java.lang.Object)object).length > 4) {
                        this._recoveryObject = Configuration.bytes_to_object((byte[])object);
                        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                            Tr.event(tc, "object is", this._recoveryObject);
                        }
                        if (this._recoveryObject == null) {
                            throw new INV_OBJREF();
                        }
                    } else {
                        throw new SystemException("Invalid remote recovery coordinator record data in log");
                    }
                    this._resource = new CoordinatorResourceImpl(this._failureScopeController, this).object();
                    this._subordinate = true;
                }
                catch (Throwable throwable) {
                    FFDCFilter.processException(throwable, "com.ibm.ws.Transaction.JTA.TransactionImpl.reconstruct", "695", this);
                    Tr.fatal(tc, "WTRN0000_ERR_INT_ERROR", new java.lang.Object[]{"reconstruct", this.getClass().getName(), throwable});
                    throw new SystemException(throwable.getLocalizedMessage());
                }
            }
            if ((object = recoverableUnit.lookupSection(9)) != null) {
                if (this._subordinate) {
                    Tr.error(tc, "WTRN0001_ERR_INT_ERROR", new java.lang.Object[]{"reconstruct", this.getClass().getName()});
                    throw new SystemException();
                }
                try {
                    this._subordinate = true;
                    object2 = object.lastData();
                    this._wsatRC = WSATRecoveryCoordinator.fromLogData((byte[])object2);
                    WSATControlSet.reconstruct(this, this._wsatRC, this._failureScopeController);
                    this._globalGlobalID = this._wsatRC.getIdentifier();
                }
                catch (Throwable throwable) {
                    FFDCFilter.processException(throwable, "com.ibm.ws.Transaction.JTA.TransactionImpl.reconstruct", "617", this);
                    Tr.fatal(tc, "WTRN0000_ERR_INT_ERROR", new java.lang.Object[]{"reconstruct", this.getClass().getName(), throwable});
                    throw new SystemException(throwable.getLocalizedMessage());
                }
            }
            this.getResources().reconstruct(recoveryManager, recoverableUnit);
            if (this._subordinate && (n == 7 || n == 8)) {
                this.prolongFinish();
            }
            this._localTID = LocalTIDTable.getLocalTID(this);
            this._failureScopeController.registerTransaction(this, true);
            this._inRecovery = true;
        }
        this._logUnit = recoverableUnit;
        this._tranLog = recoveryLog;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "reconstruct", new java.lang.Object[]{new Boolean(bl), new Boolean(this._subordinate)});
        }
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     */
    synchronized void recover() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "recover", this);
        }
        if (this._activeAssociations <= 0) {
            int n = this._status.getState();
            if (this._subordinate) {
                block0 : switch (n) {
                    case 3: 
                    case 4: 
                    case 7: {
                        this.recoverCommit(true);
                        break;
                    }
                    case 5: 
                    case 6: 
                    case 8: {
                        this.recoverRollback(true);
                        break;
                    }
                    default: {
                        if (this._JCARecoveryData != null) {
                            String string = this._JCARecoveryData.getWrapper().getProviderId();
                            if (TxServiceImpl.isProviderInstalled(string)) {
                                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break;
                                Tr.debug(tc, "recover", "Do nothing. Expect provider " + string + " will complete.");
                                break;
                            }
                            switch (lpsHeuristicCompletion) {
                                case 1: {
                                    Tr.error(tc, "WTRN0098_COMMIT_RA_UNINSTALLED", new java.lang.Object[]{this.getTranName(), string});
                                    this.recoverCommit(false);
                                    break block0;
                                }
                                case 2: {
                                    this._needsManualCompletion = true;
                                    Tr.info(tc, "WTRN0101_MANUAL_RA_UNINSTALLED", new java.lang.Object[]{this.getTranName(), string});
                                    break block0;
                                }
                            }
                            Tr.error(tc, "WTRN0099_ROLLBACK_RA_UNINSTALLED", new java.lang.Object[]{this.getTranName(), string});
                            this.recoverRollback(false);
                            break;
                        }
                        if (heuristicRetryLimit <= 0 || this._retryAttempts < heuristicRetryLimit) {
                            ++this._retryAttempts;
                            Status status = this.replay();
                            if (status == Status.StatusCommitting || status == Status.StatusCommitted) {
                                this.recoverCommit(true);
                                break;
                            }
                            if (status == Status.StatusRollingBack || status == Status.StatusRolledBack) {
                                this.recoverRollback(true);
                                break;
                            }
                            if (status == Status.StatusNoTransaction) {
                                this.recoverRollback(false);
                                break;
                            }
                            Tr.warning(tc, "WTRN0056_TRAN_RESYNC_FAILURE", this.getTranName());
                            if (this._inRecovery) break;
                            if (this._retryAttempts % 10 == 0 && this._retryWait < 0x3FFFFFFF) {
                                this._retryWait *= 2;
                            }
                            TimeoutManager.setTimeout(this, 2, this._retryWait);
                            break;
                        }
                        switch (lpsHeuristicCompletion) {
                            case 1: {
                                Tr.error(tc, "WTRN0093_COMMIT_REPLAY_COMPLETION", this.getTranName());
                                this.recoverCommit(false);
                                break block0;
                            }
                            case 2: {
                                this._needsManualCompletion = true;
                                Tr.info(tc, "WTRN0095_MANUAL_REPLAY_COMPLETION", this.getTranName());
                                break block0;
                            }
                        }
                        Tr.error(tc, "WTRN0094_ROLLBACK_REPLAY_COMPLETION", this.getTranName());
                        this.recoverRollback(false);
                        break;
                    }
                }
            } else if (n == 9) {
                switch (lpsHeuristicCompletion) {
                    case 1: {
                        Tr.error(tc, "WTRN0096_HEURISTIC_MAY_HAVE_OCCURED", this.getTranName());
                        this.recoverCommit(false);
                        break;
                    }
                    case 2: {
                        this._needsManualCompletion = true;
                        Tr.info(tc, "WTRN0097_HEURISTIC_MANUAL_COMPLETION", this.getTranName());
                        break;
                    }
                    default: {
                        Tr.error(tc, "WTRN0102_HEURISTIC_MAY_HAVE_OCCURED", this.getTranName());
                        this.recoverRollback(false);
                        break;
                    }
                }
            } else if (n == 3) {
                this.recoverCommit(false);
            } else {
                this.recoverRollback(false);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "recover");
        }
    }

    private Status replay() {
        java.lang.Object object;
        Status status;
        block7: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.entry(tc, "replay", this);
            }
            status = Status.StatusUnknown;
            try {
                object = new PrivilegedExceptionAction(){

                    public java.lang.Object run() throws NotPrepared {
                        if (TransactionImpl.this._superiorWSCoord != null) {
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                Tr.debug(tc, "Attempting to call replay_completion on superior coordinator", TransactionImpl.this._superiorWSCoord);
                            }
                            return TransactionImpl.this._superiorWSCoord.replay_completion(TransactionImpl.this.getXid().getGlobalTransactionId());
                        }
                        if (TransactionImpl.this._recovery == null) {
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                Tr.debug(tc, "Attempting to narrow remote recoveryCoordinator reference", TransactionImpl.this._recoveryObject);
                            }
                            if (TransactionImpl.this._recoveryObject != null) {
                                TransactionImpl.this._recovery = RecoveryCoordinatorHelper.narrow(TransactionImpl.this._recoveryObject);
                            }
                        }
                        if (TransactionImpl.this._recovery != null) {
                            return TransactionImpl.this._recovery.replay_completion(TransactionImpl.this._resource);
                        }
                        if (TransactionImpl.this._wsatRC != null) {
                            if (TransactionImpl.this._inRecovery) {
                                return TransactionImpl.this._wsatRC.replay_completion();
                            }
                            TransactionImpl.this._wsatRC.resendPrepared();
                            return Status.StatusUnknown;
                        }
                        throw new BAD_PARAM();
                    }
                };
                status = (Status)TxServiceImpl.runAsSystem((PrivilegedExceptionAction)object);
            }
            catch (Throwable throwable) {
                FFDCFilter.processException(throwable, "com.ibm.ws.Transaction.JTA.TransactionImpl.replay", "1394", this);
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    Tr.event(tc, "exception caught in recover", throwable);
                }
                if (throwable instanceof org.omg.CORBA.SystemException) {
                    XAException xAException = CORBAResourceWrapper.processCORBASystemException((org.omg.CORBA.SystemException)throwable);
                    if (xAException.errorCode == -4) {
                        status = Status.StatusNoTransaction;
                    }
                }
                if (!(throwable instanceof PrivilegedActionException) || !(throwable.getCause() instanceof org.omg.CORBA.SystemException)) break block7;
                XAException xAException = CORBAResourceWrapper.processCORBASystemException((org.omg.CORBA.SystemException)throwable.getCause());
                if (xAException.errorCode != -4) break block7;
                status = Status.StatusNoTransaction;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            object = status == null ? "null" : TxStatusHelper.getCORBAStatusAsString(status);
            Tr.exit(tc, "replay", object);
        }
        return status;
    }

    public boolean isSubordinate() {
        return this._subordinate;
    }

    public boolean isNonInterop() {
        return this._nonInterop;
    }

    public void setNonInterop() {
        this._nonInterop = true;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event(tc, "creating a non-interop transaction");
        }
        if (this._activeAssociations == 0) {
            ++this._activeAssociations;
            this._suspendedAssociations = this._activeAssociations;
        }
        if (this._status == null) {
            this._status = new TransactionState(this);
        }
    }

    public void commit() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, IllegalStateException, SystemException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "commit (SPI)");
        }
        try {
            this.processCommit();
        }
        catch (HeuristicHazardException heuristicHazardException) {
            HeuristicMixedException heuristicMixedException = new HeuristicMixedException(heuristicHazardException.getLocalizedMessage());
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "commit", (java.lang.Object)heuristicMixedException);
            }
            throw heuristicMixedException;
        }
        finally {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "commit (SPI)");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit_one_phase() throws RollbackException, HeuristicMixedException, HeuristicHazardException, HeuristicRollbackException, SecurityException, IllegalStateException, SystemException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "commit_one_phase");
        }
        this._subordinate = false;
        try {
            this.processCommit();
        }
        finally {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "commit_one_phase");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processCommit() throws RollbackException, HeuristicMixedException, HeuristicHazardException, HeuristicRollbackException, SecurityException, IllegalStateException, SystemException {
        int n = this.stage1CommitProcessing();
        try {
            this.stage2CommitProcessing(n);
        }
        finally {
            n = this._status.getState();
            this.notifyCompletion();
        }
        this.stage3CommitProcessing(n);
    }

    private int stage1CommitProcessing() throws HeuristicMixedException, HeuristicRollbackException, SystemException, HeuristicHazardException {
        int n;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "stage1CommitProcessing");
        }
        if (this.prePrepare()) {
            try {
                if (this._nativeContext != null && (this._resources == null || this._resources.numRegistered() == 0)) {
                    n = this.commitNativeContext();
                }
                if ((this._nativeContext == null || !this._nativeContext.hasInterests()) && this.getResources().isOnlyAgent()) {
                    n = this.commitXAResources();
                }
                n = this.prepareResources();
            }
            catch (HeuristicMixedException heuristicMixedException) {
                this.addHeuristic();
                this.notifyCompletion();
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "stage1CommitProcessing", (java.lang.Object)heuristicMixedException);
                }
                throw heuristicMixedException;
            }
            catch (HeuristicHazardException heuristicHazardException) {
                this.addHeuristic();
                this.notifyCompletion();
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "stage1CommitProcessing", heuristicHazardException);
                }
                throw heuristicHazardException;
            }
            catch (HeuristicRollbackException heuristicRollbackException) {
                this.addHeuristic();
                this.notifyCompletion();
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "stage1CommitProcessing", (java.lang.Object)heuristicRollbackException);
                }
                throw heuristicRollbackException;
            }
            catch (SystemException systemException) {
                FFDCFilter.processException((Throwable)systemException, "com.ibm.ws.Transaction.JTA.TransactionImpl.stage1CommitProcessing", "1545", this);
                this.notifyCompletion();
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "stage1CommitProcessing", (java.lang.Object)systemException);
                }
                throw systemException;
            }
            catch (Throwable throwable) {
                FFDCFilter.processException(throwable, "com.ibm.ws.Transaction.JTA.TransactionImpl.stage1CommitProcessing", "1551", this);
                this.notifyCompletion();
                SystemException systemException = new SystemException(throwable.getLocalizedMessage());
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "stage1CommitProcessing", new java.lang.Object[]{throwable, systemException});
                }
                throw systemException;
            }
        } else {
            this._status.setState(5);
            n = this._status.getState();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "stage1CommitProcessing", TransactionState.stateToString(n));
        }
        return n;
    }

    private void stage2CommitProcessing(int n) throws HeuristicMixedException, HeuristicHazardException, HeuristicRollbackException, SystemException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "stage2CommitProcessing", TransactionState.stateToString(n));
        }
        try {
            switch (n) {
                case 3: {
                    this.internalCommit();
                    break;
                }
                case 5: {
                    this.internalRollback();
                    break;
                }
                case 9: {
                    this.needsLPSHeuristicCompletion();
                }
            }
        }
        catch (HeuristicMixedException heuristicMixedException) {
            this.addHeuristic();
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "stage2CommitProcessing", (java.lang.Object)heuristicMixedException);
            }
            throw heuristicMixedException;
        }
        catch (HeuristicHazardException heuristicHazardException) {
            this.addHeuristic();
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "stage2CommitProcessing", heuristicHazardException);
            }
            throw heuristicHazardException;
        }
        catch (HeuristicCommitException heuristicCommitException) {
            this.addHeuristic();
            HeuristicMixedException heuristicMixedException = new HeuristicMixedException();
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "stage2CommitProcessing", (java.lang.Object)heuristicMixedException);
            }
            throw heuristicMixedException;
        }
        catch (HeuristicRollbackException heuristicRollbackException) {
            this.addHeuristic();
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "stage2CommitProcessing", (java.lang.Object)heuristicRollbackException);
            }
            throw heuristicRollbackException;
        }
        catch (SystemException systemException) {
            FFDCFilter.processException((Throwable)systemException, "com.ibm.ws.Transaction.JTA.TransactionImpl.stage2CommitProcessing", "1468", this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "stage2CommitProcessing", (java.lang.Object)systemException);
            }
            throw systemException;
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.Transaction.JTA.TransactionImpl.stage2CommitProcessing", "1480", this);
            SystemException systemException = new SystemException(throwable.getLocalizedMessage());
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "stage2CommitProcessing", new java.lang.Object[]{throwable, systemException});
            }
            throw systemException;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "stage2CommitProcessing");
        }
    }

    private void stage3CommitProcessing(int n) throws SystemException, RollbackException, HeuristicMixedException, HeuristicHazardException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "stage3CommitProcessing", TransactionState.stateToString(n));
        }
        switch (n) {
            case 5: 
            case 6: {
                RollbackException rollbackException;
                if (this._systemExceptionOccured) {
                    SystemException systemException = new SystemException();
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        Tr.exit(tc, "stage3CommitProcessing", (java.lang.Object)systemException);
                    }
                    throw systemException;
                }
                if (this._heuristicOnPrepare != null) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        Tr.exit(tc, "stage3CommitProcessing", this._heuristicOnPrepare);
                    }
                    if (this._heuristicOnPrepare instanceof HeuristicMixedException) {
                        throw (HeuristicMixedException)((java.lang.Object)this._heuristicOnPrepare);
                    }
                    throw (HeuristicHazardException)this._heuristicOnPrepare;
                }
                if (this.getOriginalException() == null) {
                    rollbackException = new RollbackException();
                } else {
                    rollbackException = new RollbackException();
                    rollbackException.initCause(this.getOriginalException());
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "stage3CommitProcessing", (java.lang.Object)rollbackException);
                }
                throw rollbackException;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "stage3CommitProcessing");
        }
    }

    private void needsLPSHeuristicCompletion() throws SystemException, HeuristicMixedException, HeuristicHazardException, HeuristicRollbackException, HeuristicCommitException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "needsLPSHeuristicCompletion");
        }
        try {
            switch (lpsHeuristicCompletion) {
                case 1: {
                    Tr.error(tc, "WTRN0096_HEURISTIC_MAY_HAVE_OCCURED", this.getTranName());
                    this._status.setState(3);
                    this.internalCommit();
                    break;
                }
                case 2: {
                    this._needsManualCompletion = true;
                    Tr.info(tc, "WTRN0097_HEURISTIC_MANUAL_COMPLETION", this.getTranName());
                    this.distributeAfter(3);
                    this.prolongFinish();
                    break;
                }
                default: {
                    Tr.error(tc, "WTRN0102_HEURISTIC_MAY_HAVE_OCCURED", this.getTranName());
                    this._status.setState(5);
                    this.internalRollback();
                }
            }
            throw new HeuristicHazardException();
        }
        catch (Throwable throwable) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "needsLPSHeuristicCompletion");
            }
            throw throwable;
        }
    }

    public void rollback() throws IllegalStateException, SystemException {
        int n;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "rollback (SPI)");
        }
        if ((n = this._status.getState()) == 0) {
            this.cancelAlarms();
            try {
                this._status.setState(5);
            }
            catch (SystemException systemException) {
                FFDCFilter.processException((Throwable)systemException, "com.ibm.ws.Transaction.JTA.TransactionImpl.rollback", "1587", this);
                if (TraceComponent.isAnyTracingEnabled()) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Exception caught setting state to ROLLING_BACK!", (java.lang.Object)systemException);
                    }
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "rollback (SPI)");
                    }
                }
                throw systemException;
            }
            try {
                this.internalRollback();
            }
            catch (HeuristicMixedException heuristicMixedException) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "HeuristicMixedException caught rollback processing", (java.lang.Object)heuristicMixedException);
                }
                this.addHeuristic();
            }
            catch (HeuristicHazardException heuristicHazardException) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "HeuristicHazardException caught rollback processing", heuristicHazardException);
                }
                this.addHeuristic();
            }
            catch (HeuristicCommitException heuristicCommitException) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "HeuristicHazardException caught rollback processing", (java.lang.Object)heuristicCommitException);
                }
                this.addHeuristic();
            }
            catch (SystemException systemException) {
                FFDCFilter.processException((Throwable)systemException, "com.ibm.ws.Transaction.JTA.TransactionImpl.rollback", "1626", this);
                if (TraceComponent.isAnyTracingEnabled()) {
                    if (tc.isEventEnabled()) {
                        Tr.event(tc, "SystemException caught during rollback", (java.lang.Object)systemException);
                    }
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "rollback (SPI)");
                    }
                }
                throw systemException;
            }
            catch (Throwable throwable) {
                FFDCFilter.processException(throwable, "com.ibm.ws.Transaction.JTA.TransactionImpl.rollback", "1633", this);
                if (TraceComponent.isAnyTracingEnabled()) {
                    if (tc.isEventEnabled()) {
                        Tr.event(tc, "Exception caught during rollback", throwable);
                    }
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "rollback (SPI)");
                    }
                }
                throw new SystemException(throwable.getLocalizedMessage());
            }
            finally {
                this.notifyCompletion();
            }
        } else {
            if (n == -1) {
                if (TraceComponent.isAnyTracingEnabled()) {
                    if (tc.isEventEnabled()) {
                        Tr.event(tc, "No transaction available!");
                    }
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "rollback (SPI)");
                    }
                }
                throw new IllegalStateException();
            }
            if (TraceComponent.isAnyTracingEnabled()) {
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "Invalid transaction state:" + n);
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "rollback (SPI)");
                }
            }
            throw new SystemException();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "rollback (SPI)");
        }
    }

    public int internalPrepare() throws HeuristicMixedException, HeuristicHazardException, HeuristicRollbackException, IllegalStateException, SystemException {
        int n;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "internalPrepare");
        }
        if ((n = this._status.getState()) != 0) {
            if (n == -1) {
                if (TraceComponent.isAnyTracingEnabled()) {
                    if (tc.isEventEnabled()) {
                        Tr.event(tc, "No transaction available!");
                    }
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "internalPrepare");
                    }
                }
                throw new IllegalStateException();
            }
            if (TraceComponent.isAnyTracingEnabled()) {
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "Invalid transaction state: ", TransactionState.stateToString(n));
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "internalPrepare");
                }
            }
            throw new SystemException();
        }
        this.prePrepare();
        int n2 = this.prepareResources();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "internalPrepare");
        }
        return n2;
    }

    private int prepareResources() throws HeuristicMixedException, HeuristicHazardException, HeuristicRollbackException, SystemException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "prepareResources");
        }
        if (this.distributeEnd()) {
            try {
                this._status.setState(1);
            }
            catch (SystemException systemException) {
                FFDCFilter.processException((Throwable)systemException, "com.ibm.ws.Transaction.JTA.TransactionImpl.prepareResources", "1745", this);
                if (TraceComponent.isAnyTracingEnabled()) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Exception caught setting state to PREPARING", (java.lang.Object)systemException);
                    }
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "prepareResources");
                    }
                }
                throw systemException;
            }
            if (this._perf != null) {
                this._perf.preparing();
            }
            try {
                boolean bl;
                int n;
                boolean bl2 = !this._subordinate && this._nativeContext == null;
                try {
                    n = this.getResources().distributePrepare(this._subordinate, bl2);
                    bl = n == 0;
                }
                catch (RollbackException rollbackException) {
                    FFDCFilter.processException((Throwable)rollbackException, "com.ibm.ws.Transaction.JTA.TransactionImpl.prepareResources", "1847", this);
                    this.setPrepareXAFailed();
                    throw rollbackException;
                }
                catch (SystemException systemException) {
                    FFDCFilter.processException((Throwable)systemException, "com.ibm.ws.Transaction.JTA.TransactionImpl.prepareResources", "1853", this);
                    this.setPrepareXAFailed();
                    throw systemException;
                }
                if (!bl2) {
                    this._isXALastAgent = this.getResources().isLastAgentEnlisted();
                }
                if (this._nativeContext != null) {
                    XAPdataWrapper xAPdataWrapper = null;
                    if (n == 0) {
                        xAPdataWrapper = this.getResources().getPersistentInterestData();
                        this._nativeContext.setXAInterestData(xAPdataWrapper);
                    }
                    if (this._subordinate) {
                        if (this._JCARecoveryData == null) {
                            this._nativeContext.logXAInterestData();
                            n = 0;
                        } else if (n != 3 || this._nativeContext.hasInterests()) {
                            this._nativeContext.prepare();
                            n = 0;
                        }
                    } else if (this._isXALastAgent) {
                        if (n != 3 || this._nativeContext.hasInterests()) {
                            n = this._nativeContext.prepare();
                        }
                    } else {
                        NativeGlobalTransactionContext nativeGlobalTransactionContext = this._nativeContext;
                        this._isNativeLastAgent = true;
                        if (xAPdataWrapper == null) {
                            this._nativeContext = null;
                        }
                        try {
                            nativeGlobalTransactionContext.commitOnePhase();
                        }
                        catch (HeuristicMixedException heuristicMixedException) {
                            if (this._JCARecoveryData != null) {
                                this._nativeContext = nativeGlobalTransactionContext;
                            }
                            throw heuristicMixedException;
                        }
                    }
                }
                if (this._isXALastAgent) {
                    n = this.getResources().commitLastAgent(n == 0, bl);
                }
                try {
                    switch (n) {
                        case 0: {
                            if (this._subordinate) {
                                this._status.setState(2);
                                break;
                            }
                            this._status.setState(3);
                            break;
                        }
                        case 10: {
                            if (this._perf != null) {
                                this._perf.onePhase();
                            }
                        }
                        case 3: {
                            this._status.setState(4);
                            this.postCompletion(3);
                            break;
                        }
                        case 11: {
                            this._status.setState(6);
                            if (this._perf != null) {
                                this._perf.onePhase();
                            }
                            this.postCompletion(4);
                            break;
                        }
                        case 12: {
                            if (LPSLoggingEnabled) break;
                            this._status.setState(9);
                        }
                    }
                }
                catch (SystemException systemException) {
                    FFDCFilter.processException((Throwable)systemException, "com.ibm.ws.Transaction.JTA.TransactionImpl.prepareResources", "1848", this);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "Exception caught setting state after PREPARE", (java.lang.Object)systemException);
                    }
                    throw systemException;
                }
            }
            catch (RollbackException rollbackException) {
                FFDCFilter.processException((Throwable)rollbackException, "com.ibm.ws.Transaction.JTA.TransactionImpl.prepareResources", "1857", this);
                try {
                    this._status.setState(5);
                }
                catch (SystemException systemException) {
                    FFDCFilter.processException((Throwable)systemException, "com.ibm.ws.Transaction.JTA.TransactionImpl.prepareResources", "1864", this);
                    if (TraceComponent.isAnyTracingEnabled()) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Exception caught setting state to ROLLING_BACK", (java.lang.Object)systemException);
                        }
                        if (tc.isEntryEnabled()) {
                            Tr.exit(tc, "prepareResources");
                        }
                    }
                    throw systemException;
                }
            }
            catch (HeuristicMixedException heuristicMixedException) {
                try {
                    this.logHeuristic(true);
                    if (this._status.getState() == 1) {
                        this._status.setState(5);
                    }
                }
                catch (SystemException systemException) {
                    FFDCFilter.processException((Throwable)systemException, "com.ibm.ws.Transaction.JTA.TransactionImpl.prepareResources", "1975", this);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        Tr.exit(tc, "prepareResources, se");
                    }
                    throw systemException;
                }
                if (!this._subordinate) {
                    this._heuristicOnPrepare = heuristicMixedException;
                }
                throw heuristicMixedException;
            }
            catch (HeuristicHazardException heuristicHazardException) {
                try {
                    this.logHeuristic(true);
                    if (this._status.getState() == 1) {
                        this._status.setState(5);
                    }
                }
                catch (SystemException systemException) {
                    FFDCFilter.processException((Throwable)systemException, "com.ibm.ws.Transaction.JTA.TransactionImpl.prepareResources", "2015", this);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        Tr.exit(tc, "prepareResources", (java.lang.Object)systemException);
                    }
                    throw systemException;
                }
                if (!this._subordinate) {
                    this._heuristicOnPrepare = heuristicHazardException;
                }
                throw heuristicHazardException;
            }
            catch (HeuristicRollbackException heuristicRollbackException) {
                this.postCompletion(3);
                if (this._subordinate) {
                    Tr.error(tc, "WTRN0057_HEURISTIC_ON_SUBORDINATE");
                    throw new SystemException();
                }
                throw heuristicRollbackException;
            }
            catch (SystemException systemException) {
                FFDCFilter.processException((Throwable)systemException, "com.ibm.ws.Transaction.JTA.TransactionImpl.prepareResources", "1138", this);
                this._systemExceptionOccured = true;
                try {
                    if (this._status.getState() == 1) {
                        this._status.setState(5);
                    }
                }
                catch (SystemException systemException2) {
                    FFDCFilter.processException((Throwable)systemException, "com.ibm.ws.Transaction.JTA.TransactionImpl.prepareResources", "1146", this);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        Tr.exit(tc, "prepareResources", (java.lang.Object)systemException2);
                    }
                    throw systemException2;
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "prepareResources");
        }
        return this._status.getState();
    }

    private void setPrepareXAFailed() {
        XAPdataWrapper xAPdataWrapper;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "setPrepareXAFailed");
        }
        this.setRBO();
        if (this._nativeContext != null && this._subordinate && this._JCARecoveryData == null && (xAPdataWrapper = this.getResources().getPersistentInterestData()) != null) {
            this._nativeContext.setXAInterestData(xAPdataWrapper);
            try {
                this._nativeContext.logXAInterestData();
            }
            catch (RollbackException rollbackException) {
                FFDCFilter.processException((Throwable)rollbackException, "com.ibm.ws.Transaction.JTA.TransactionImpl.setPrepareXAFailed", "2224", this);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "setPrepareXAFailed");
        }
    }

    private boolean prePrepare() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "prePrepare");
        }
        if (this._perf != null) {
            this._perf.commitRequested();
        }
        this.cancelAlarms();
        if (!this._rollbackOnly) {
            this.getSyncs().distributeBefore();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "prePrepare", !this._rollbackOnly);
        }
        return !this._rollbackOnly;
    }

    private void cancelAlarms() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "cancelAlarms");
        }
        if (this._timeout > 0) {
            TimeoutManager.setTimeout(this, 0, 0);
            this._timeout = 0;
        }
        if (this._inactivityTimerActive) {
            this.stopInactivityTimer();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "cancelAlarms");
        }
    }

    private boolean distributeEnd() throws SystemException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "distributeEnd");
        }
        if (!this.getResources().distributeEnd(0x4000000)) {
            this.setRBO();
        }
        if (this._rollbackOnly) {
            try {
                this._status.setState(5);
            }
            catch (SystemException systemException) {
                FFDCFilter.processException((Throwable)systemException, "com.ibm.ws.Transaction.JTA.TransactionImpl.distributeEnd", "1731", this);
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "distributeEnd", (java.lang.Object)systemException);
                }
                throw systemException;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "distributeEnd", new Boolean(!this._rollbackOnly));
        }
        return !this._rollbackOnly;
    }

    private int commitXAResources() throws HeuristicMixedException, HeuristicHazardException, HeuristicRollbackException, SystemException {
        block15: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.entry(tc, "commitXAResources");
            }
            if (this.distributeEnd()) {
                this._status.setState(1);
                if (this._perf != null) {
                    this._perf.preparing();
                }
                int n = 3;
                try {
                    this.getResources().flowCommitOnePhase(false);
                    if (this._perf != null) {
                        this._perf.onePhase();
                    }
                    this._status.setState(4);
                }
                catch (HeuristicMixedException heuristicMixedException) {
                    this.processC1PHeuristic();
                    n = 5;
                    throw heuristicMixedException;
                }
                catch (HeuristicHazardException heuristicHazardException) {
                    this.processC1PHeuristic();
                    n = 5;
                    throw heuristicHazardException;
                }
                catch (HeuristicRollbackException heuristicRollbackException) {
                    this.processC1PHeuristic();
                    n = 5;
                    throw heuristicRollbackException;
                }
                catch (RollbackException rollbackException) {
                    n = 4;
                    this._status.setState(6);
                }
                catch (SystemException systemException) {
                    FFDCFilter.processException((Throwable)systemException, "com.ibm.ws.Transaction.JTA.TransactionImpl.commitXAResources", "1978", this);
                    this._status.setState(6);
                    throw systemException;
                }
                finally {
                    this.postCompletion(n);
                    if (!this._systemExceptionOccured) break block15;
                    throw new SystemException();
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "commitXAResources");
        }
        return this._status.getState();
    }

    private void processC1PHeuristic() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "processC1PHeuristic");
        }
        if (this._nativeContext != null) {
            this._nativeContext.setHeuristic();
            try {
                this.rollbackRRS();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "processC1PHeuristic");
        }
    }

    private int commitNativeContext() throws HeuristicMixedException, SystemException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "commitNativeContext");
        }
        this._status.setState(1);
        if (this._perf != null) {
            this._perf.preparing();
        }
        int n = 3;
        try {
            NativeGlobalTransactionContext nativeGlobalTransactionContext = this._nativeContext;
            if (this.getResources().getPersistentInterestData() == null) {
                this._nativeContext = null;
            }
            try {
                nativeGlobalTransactionContext.commitOnePhase();
                if (this._perf != null) {
                    this._perf.onePhase();
                }
            }
            catch (HeuristicMixedException heuristicMixedException) {
                FFDCFilter.processException((Throwable)heuristicMixedException, "com.ibm.ws.Transaction.JTA.TransactionImpl.commitNativeContext", "2217", this);
                if (this._JCARecoveryData != null) {
                    this._nativeContext = nativeGlobalTransactionContext;
                }
                throw heuristicMixedException;
            }
            this._status.setState(4);
        }
        catch (RollbackException rollbackException) {
            n = 4;
            this._status.setState(6);
        }
        catch (SystemException systemException) {
            FFDCFilter.processException((Throwable)systemException, "com.ibm.ws.Transaction.JTA.TransactionImpl.commitNativeContext", "1978", this);
            this._status.setState(6);
            throw systemException;
        }
        finally {
            this.postCompletion(n);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "commitNativeContext");
        }
        return this._status.getState();
    }

    public void internalCommit() throws HeuristicMixedException, HeuristicHazardException, HeuristicRollbackException, SystemException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "internalCommit");
        }
        if (this._perf != null) {
            this._perf.committing();
        }
        HeuristicMixedException heuristicMixedException = null;
        try {
            if (!(this._nativeContext == null || this._isNativeLastAgent || this._subordinate && this._JCARecoveryData == null)) {
                try {
                    this._nativeContext.commit();
                }
                catch (HeuristicMixedException heuristicMixedException2) {
                    FFDCFilter.processException((Throwable)heuristicMixedException2, "com.ibm.ws.Transaction.JTA.TransactionImpl.internalCommit", "2041", this);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "HeuristicMixedException caught committing RRS", (java.lang.Object)heuristicMixedException2);
                    }
                    this._nativeContext.setHeuristic();
                    heuristicMixedException = heuristicMixedException2;
                }
            }
            this.getResources().distributeCommit();
        }
        catch (HeuristicMixedException heuristicMixedException3) {
            this.logHeuristic(true);
            throw heuristicMixedException3;
        }
        catch (HeuristicHazardException heuristicHazardException) {
            this.logHeuristic(true);
            throw heuristicHazardException;
        }
        catch (HeuristicRollbackException heuristicRollbackException) {
            this.logHeuristic(true);
            throw heuristicRollbackException;
        }
        finally {
            this.postCompletion(3);
            if (heuristicMixedException != null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "internalCommit", heuristicMixedException);
                }
                throw heuristicMixedException;
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "internalCommit");
            }
        }
    }

    private void rollbackRRS() throws HeuristicMixedException, SystemException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "rollbackRRS");
        }
        NativeGlobalTransactionContext nativeGlobalTransactionContext = this._nativeContext;
        XAPdataWrapper xAPdataWrapper = this.getResources().getPersistentInterestData();
        try {
            this._nativeContext.setXAInterestData(xAPdataWrapper);
            if (xAPdataWrapper == null) {
                this._nativeContext = null;
            }
            nativeGlobalTransactionContext.rollback();
        }
        catch (HeuristicMixedException heuristicMixedException) {
            FFDCFilter.processException((Throwable)heuristicMixedException, "com.ibm.ws.Transaction.JTA.TransactionImpl.rollbackRRS", "2079", this);
            if (this._JCARecoveryData != null) {
                this._nativeContext = nativeGlobalTransactionContext;
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "rollbackRRS", (java.lang.Object)heuristicMixedException);
            }
            throw heuristicMixedException;
        }
        catch (SystemException systemException) {
            FFDCFilter.processException((Throwable)systemException, "com.ibm.ws.Transaction.JTA.TransactionImpl.rollbackRRS", "2080", this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "rollbackRRS", (java.lang.Object)systemException);
            }
            throw systemException;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "rollbackRRS");
        }
    }

    public void internalRollback() throws HeuristicMixedException, HeuristicHazardException, HeuristicCommitException, SystemException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "internalRollback");
        }
        SystemException systemException = null;
        try {
            HeuristicMixedException heuristicMixedException = null;
            if (!(this._nativeContext == null || this._isNativeLastAgent || this._subordinate && this._JCARecoveryData == null)) {
                try {
                    this.rollbackRRS();
                }
                catch (HeuristicMixedException heuristicMixedException2) {
                    heuristicMixedException = heuristicMixedException2;
                }
                catch (SystemException systemException2) {
                    systemException = systemException2;
                }
            }
            this.getResources().distributeEnd(0x4000000);
            this.getResources().distributeRollback();
            if (heuristicMixedException != null) {
                throw heuristicMixedException;
            }
        }
        catch (HeuristicMixedException heuristicMixedException) {
            this.logHeuristic(false);
            throw heuristicMixedException;
        }
        catch (HeuristicHazardException heuristicHazardException) {
            this.logHeuristic(false);
            throw heuristicHazardException;
        }
        catch (HeuristicCommitException heuristicCommitException) {
            this.logHeuristic(false);
            throw heuristicCommitException;
        }
        finally {
            this.postCompletion(4);
            if (systemException != null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "internalRollback", (java.lang.Object)systemException);
                }
                throw systemException;
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "internalRollback");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recoverCommit(boolean bl) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "recoverCommit", new Boolean(bl));
        }
        int n = this._status.getState();
        try {
            if (n != 3 && n != 7 && n != 4) {
                this._status.setState(3);
            }
            this.getResources().distributeCommit();
        }
        catch (HeuristicMixedException heuristicMixedException) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "HeuristicMixedException caught commit processing", (java.lang.Object)heuristicMixedException);
            }
            this.logHeuristicInRecovery(true);
        }
        catch (HeuristicHazardException heuristicHazardException) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "HeuristicHazardException caught commit processing", heuristicHazardException);
            }
            this.logHeuristicInRecovery(true);
        }
        catch (HeuristicRollbackException heuristicRollbackException) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "HeuristicRollbackException caught commit processing", (java.lang.Object)heuristicRollbackException);
            }
            this.logHeuristicInRecovery(true);
        }
        catch (SystemException systemException) {
            FFDCFilter.processException((Throwable)systemException, "com.ibm.ws.Transaction.JTA.TransactionImpl.recoverCommit", "1096", this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "SystemException caught during recovery commit processing", (java.lang.Object)systemException);
            }
            Tr.error(tc, "WTRN0058_RECOVERY_EXCEPTION_IN_COMMIT", new java.lang.Object[]{this.getTranName(), systemException});
        }
        finally {
            if (bl && n != 7 && 7 == this._status.getState()) {
                this.prolongFinish();
            }
            this.postCompletion(3);
            this.notifyCompletion();
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "recoverCommit");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void recoverRollback(boolean bl) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "recoverRollback", new Boolean(bl));
        }
        int n = this._status.getState();
        try {
            if (n != 5 && n != 8 && n != 6) {
                this._status.setState(5);
            }
            if (n == 0) {
                this.getResources().distributeEnd(0x4000000);
            }
            this.getResources().distributeRollback();
        }
        catch (HeuristicMixedException heuristicMixedException) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "HeuristicMixedException caught rollback processing", (java.lang.Object)heuristicMixedException);
            }
            this.logHeuristicInRecovery(false);
        }
        catch (HeuristicCommitException heuristicCommitException) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "HeuristicCommitException caught rollback processing", (java.lang.Object)heuristicCommitException);
            }
            this.logHeuristicInRecovery(false);
        }
        catch (HeuristicHazardException heuristicHazardException) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "HeuristicHazardException caught rollback processing", heuristicHazardException);
            }
            this.logHeuristicInRecovery(false);
        }
        catch (SystemException systemException) {
            FFDCFilter.processException((Throwable)systemException, "com.ibm.ws.Transaction.JTA.TransactionImpl.recoverRollback", "1142", this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "SystemException caught during recovery rollback processing", (java.lang.Object)systemException);
            }
            Tr.error(tc, "WTRN0059_RECOVERY_EXCEPTION_IN_ROLLBACK", new java.lang.Object[]{this.getTranName(), systemException});
        }
        finally {
            if (bl && n != 8 && 8 == this._status.getState()) {
                this.prolongFinish();
            }
            this.postCompletion(4);
            this.notifyCompletion();
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "recoverRollback");
            }
        }
    }

    private void setRBO() {
        this.setRBO(true);
    }

    private void setRBO(boolean bl) {
        if (!this._rollbackOnly) {
            this._rollbackOnly = true;
            if (this._nativeContext != null && bl) {
                this._nativeContext.setRollbackOnly();
            }
        }
    }

    public void setOriginalException(Throwable throwable) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setOriginalException");
        }
        this._originalException = throwable;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setOriginalException");
        }
    }

    public Throwable getOriginalException() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getOriginalException");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getOriginalException", this._originalException);
        }
        return this._originalException;
    }

    public void setRollbackOnly() throws IllegalStateException {
        this.setRollbackOnly(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRollbackOnly(boolean bl) throws IllegalStateException {
        int n;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "setRollbackOnly (SPI)", new Boolean(bl));
        }
        if ((n = this._status.getState()) == -1 || n == 4 || n == 6) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "setRollbackOnly (SPI)");
            }
            throw new IllegalStateException("No transaction available");
        }
        boolean bl2 = this._rollbackOnly;
        this.setRBO(bl);
        if (this._subordinate && !bl2 && this._nativeContext == null) {
            Transaction transaction = null;
            try {
                transaction = TranManagerSet.instance().suspend();
                final TransactionImpl transactionImpl = this;
                PrivilegedExceptionAction privilegedExceptionAction = new PrivilegedExceptionAction(){

                    public java.lang.Object run() throws Inactive {
                        if (TransactionImpl.this._superiorWSCoord != null) {
                            TransactionImpl.this._superiorWSCoord.rollback_only(TransactionImpl.this.getXid().getGlobalTransactionId());
                        } else {
                            Coordinator coordinator;
                            CoordinatorImpl coordinatorImpl = CoordinatorImpl.lookupCoordinator(transactionImpl);
                            if (coordinatorImpl != null && (coordinator = coordinatorImpl.getParentCoordinator()) != null) {
                                if (coordinator._is_a("IDL:omg.org/WSCosTransactions/WSCosCoordinator:1.0")) {
                                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                        Tr.debug(tc, "Superior WSCosCoordinator");
                                    }
                                    WSCosCoordinator wSCosCoordinator = WSCosCoordinatorHelper.narrow(coordinator);
                                    wSCosCoordinator.mark_rollback();
                                } else {
                                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                        Tr.debug(tc, "Superior OTS CosCoordinator");
                                    }
                                    coordinator.rollback_only();
                                }
                            }
                        }
                        return null;
                    }
                };
                TxServiceImpl.runAsSystem(privilegedExceptionAction);
            }
            catch (Throwable throwable) {
                FFDCFilter.processException(throwable, "com.ibm.ws.Transaction.JTA.TransactionImpl.setRollbackOnly", "1684", this);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Error setting rollback_only on superior coordinator", throwable);
                }
            }
            finally {
                block19: {
                    try {
                        if (transaction != null) {
                            TranManagerSet.instance().resume(transaction);
                        }
                    }
                    catch (Throwable throwable) {
                        FFDCFilter.processException(throwable, "com.ibm.ws.Transaction.JTA.TransactionImpl.setRollbackOnly", "1719", this);
                        if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block19;
                        Tr.debug(tc, "Error resuming transaction", throwable);
                    }
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "setRollbackOnly (SPI)");
        }
    }

    void rollbackResources() {
        block5: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.entry(tc, "rollbackResources");
            }
            try {
                Transaction transaction = TranManagerSet.instance().suspend();
                this.getResources().rollbackResources();
                if (transaction != null) {
                    TranManagerSet.instance().resume(transaction);
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.Transaction.JTA.TransactionImpl.rollbackResources", "1502", this);
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block5;
                Tr.debug(tc, "Exception caught from rollbackResources()", exception);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "rollbackResources");
        }
    }

    public boolean enlistResource(XAResource xAResource) throws RollbackException, IllegalStateException, SystemException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "enlistResource (SPI)", xAResource);
        }
        switch (this._status.getState()) {
            case 0: {
                if (!this._timedOut) break;
            }
            case 5: 
            case 6: 
            case 8: {
                RollbackException rollbackException = new RollbackException("Transaction rolled back");
                FFDCFilter.processException((Throwable)rollbackException, "com.ibm.ws.Transaction.JTA.TransactionImpl.enlistResource", "1760", this);
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "enlistResource (SPI)", (java.lang.Object)rollbackException);
                }
                throw rollbackException;
            }
            default: {
                IllegalStateException illegalStateException = new IllegalStateException("Transaction is inactive or prepared");
                FFDCFilter.processException((Throwable)illegalStateException, "com.ibm.ws.Transaction.JTA.TransactionImpl.enlistResource", "1769", this);
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "enlistResource (SPI)", illegalStateException);
                }
                throw illegalStateException;
            }
        }
        if (xAResource instanceof OnePhaseXAResource) {
            try {
                this.getResources().enlistResource(xAResource);
            }
            catch (IllegalStateException illegalStateException) {
                FFDCFilter.processException((Throwable)illegalStateException, "com.ibm.ws.Transaction.JTA.TransactionImpl.enlistResource", "1858", this);
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "enlistResource (SPI)", illegalStateException);
                }
                throw illegalStateException;
            }
            catch (Throwable throwable) {
                FFDCFilter.processException(throwable, "com.ibm.ws.Transaction.JTA.TransactionImpl.enlistResource", "1868", this);
                this.setRollbackOnly();
                RollbackException rollbackException = new RollbackException(throwable.getMessage());
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "enlistResource (SPI)", (java.lang.Object)rollbackException);
                }
                throw rollbackException;
            }
        } else {
            IllegalStateException illegalStateException = xAResource == null ? new IllegalStateException("XAResource reference is null") : new IllegalStateException("Illegal attempt to enlist a 2PC XAResource");
            FFDCFilter.processException((Throwable)illegalStateException, "com.ibm.ws.Transaction.JTA.TransactionImpl.enlistResource", "2443", this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "enlistResource (SPI)", illegalStateException);
            }
            throw illegalStateException;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "enlistResource (SPI)", Boolean.TRUE);
        }
        return true;
    }

    public boolean enlistResource(XAResource xAResource, int n) throws RollbackException, IllegalStateException, SystemException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "enlistResource (SPI)", new java.lang.Object[]{xAResource, new Integer(n)});
        }
        switch (this._status.getState()) {
            case 0: {
                if (!this._timedOut) break;
            }
            case 5: 
            case 6: 
            case 8: {
                RollbackException rollbackException = new RollbackException("Transaction rolled back");
                FFDCFilter.processException((Throwable)rollbackException, "com.ibm.ws.Transaction.JTA.TransactionImpl.enlistResource", "1895", this);
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "enlistResource (SPI)", (java.lang.Object)rollbackException);
                }
                throw rollbackException;
            }
            default: {
                IllegalStateException illegalStateException = new IllegalStateException("Transaction is inactive or prepared");
                FFDCFilter.processException((Throwable)illegalStateException, "com.ibm.ws.Transaction.JTA.TransactionImpl.enlistResource", "1904", this);
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "enlistResource (SPI)", illegalStateException);
                }
                throw illegalStateException;
            }
        }
        if (xAResource == null) {
            IllegalStateException illegalStateException = new IllegalStateException("XAResource reference is null");
            FFDCFilter.processException((Throwable)illegalStateException, "com.ibm.ws.Transaction.JTA.TransactionImpl.enlistResource", "1914", this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "enlistResource (SPI)", illegalStateException);
            }
            throw illegalStateException;
        }
        if (xAResource instanceof OnePhaseXAResource) {
            IllegalStateException illegalStateException = new IllegalStateException("Illegal attempt to enlist a 1PC XAResource");
            FFDCFilter.processException((Throwable)illegalStateException, "com.ibm.ws.Transaction.JTA.TransactionImpl.enlistResource", "1923", this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "enlistResource (SPI)", illegalStateException);
            }
            throw illegalStateException;
        }
        if (n < 0) {
            IllegalStateException illegalStateException = new IllegalStateException("Illegal attempt to enlist 2PC XAResource without recovery information");
            FFDCFilter.processException((Throwable)illegalStateException, "com.ibm.ws.Transaction.JTA.TransactionImpl.enlistResource", "1934", this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "enlistResource (SPI)", illegalStateException);
            }
            throw illegalStateException;
        }
        PartnerLogTable partnerLogTable = this._failureScopeController.getPartnerLogTable();
        PartnerLogData partnerLogData = partnerLogTable.getEntry(n);
        if (partnerLogData instanceof XARecoveryData) {
            XARecoveryData xARecoveryData = (XARecoveryData)partnerLogData;
            try {
                this.getResources().enlistResource(xAResource, xARecoveryData);
            }
            catch (RollbackException rollbackException) {
                FFDCFilter.processException((Throwable)rollbackException, "com.ibm.ws.Transaction.JTA.TransactionImpl.enlistResource", "2035", this);
                this.setRollbackOnly();
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "enlistResource (SPI)", (java.lang.Object)rollbackException);
                }
                throw rollbackException;
            }
            catch (SystemException systemException) {
                FFDCFilter.processException((Throwable)systemException, "com.ibm.ws.Transaction.JTA.TransactionImpl.enlistResource", "2042", this);
                this.setRollbackOnly();
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "enlistResource (SPI)", (java.lang.Object)systemException);
                }
                throw systemException;
            }
            catch (Throwable throwable) {
                FFDCFilter.processException(throwable, "com.ibm.ws.Transaction.JTA.TransactionImpl.enlistResource", "2049", this);
                this.setRollbackOnly();
                SystemException systemException = new SystemException(throwable.getLocalizedMessage());
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "enlistResource (SPI)", throwable);
                }
                throw systemException;
            }
        } else {
            SystemException systemException = new SystemException("XAResource recovery data token invalid");
            FFDCFilter.processException((Throwable)systemException, "com.ibm.ws.Transaction.JTA.TransactionImpl.enlistResource", "1955", this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "enlistResource (SPI)", (java.lang.Object)systemException);
            }
            throw systemException;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "enlistResource (SPI)", Boolean.TRUE);
        }
        return true;
    }

    public void enlistResource(JTAResource jTAResource) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "enlistResource (SPI): args: ", jTAResource);
        }
        this.getResources().addRes(jTAResource);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "enlistResource (SPI)");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enlistAsyncResource(WSATParticipantWrapper wSATParticipantWrapper) throws SystemException {
        block8: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.entry(tc, "enlistAsyncResource (SPI): args: ", wSATParticipantWrapper);
            }
            try {
                if (this._nativeContext != null) {
                    EndpointReference endpointReference = wSATParticipantWrapper.getParticipantEPR();
                    EndpointReference endpointReference2 = wSATParticipantWrapper.getCoordinatorEPR();
                    String string = wSATParticipantWrapper.getWSATTxIdentifier();
                    String string2 = wSATParticipantWrapper.getWSATParticipantIdentifier();
                    try {
                        byte[] byArray = WSATCRAsyncResource.serialize(endpointReference, endpointReference2, string, string2);
                        this._nativeContext.registerParticipant(byArray);
                        break block8;
                    }
                    catch (Exception exception) {
                        FFDCFilter.processException((Throwable)exception, "com.ibm.ws.Transaction.JTA.TransactionImpl.enlistAsyncResource", "3100", this);
                        SystemException systemException = new SystemException();
                        systemException.initCause((Throwable)exception);
                        throw systemException;
                    }
                }
                this.getResources().addAsyncResource(wSATParticipantWrapper);
            }
            finally {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "enlistAsyncResource (SPI)");
                }
            }
        }
    }

    void logLPSState() throws SystemException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "logLPSState");
        }
        if (LPSLoggingEnabled) {
            this._status.setState(9);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "logLPSState");
        }
    }

    private void logHeuristic(boolean bl) throws SystemException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "logHeuristic", bl);
        }
        if (this._nativeContext != null) {
            this._nativeContext.setHeuristic();
        } else if (this._subordinate && this._status.getState() != 1) {
            this.getResources().logHeuristic(bl);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "logHeuristic");
        }
    }

    private void logHeuristicInRecovery(boolean bl) {
        try {
            this.logHeuristic(bl);
        }
        catch (SystemException systemException) {
            FFDCFilter.processException((Throwable)systemException, "com.ibm.ws.Transaction.JTA.TransactionImpl.logHeuristicInRecovery", "2955", this);
        }
    }

    public boolean delistResource(XAResource xAResource, int n) throws IllegalStateException, SystemException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.event(tc, "delistResource (SPI)", new java.lang.Object[]{xAResource, Util.printFlag(n)});
        }
        if (this._status.getState() != 0) {
            IllegalStateException illegalStateException = new IllegalStateException("Transaction is inactive or prepared");
            FFDCFilter.processException((Throwable)illegalStateException, "com.ibm.ws.Transaction.JTA.TransactionImpl.delistResource", "2212", this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "delistResource (SPI)", illegalStateException);
            }
            throw illegalStateException;
        }
        if (xAResource == null) {
            IllegalStateException illegalStateException = new IllegalStateException("XAResource reference is null");
            FFDCFilter.processException((Throwable)illegalStateException, "com.ibm.ws.Transaction.JTA.TransactionImpl.delistResource", "2224", this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "delistResource (SPI)", illegalStateException);
            }
            throw illegalStateException;
        }
        boolean bl = false;
        try {
            bl = this.getResources().delistResource(xAResource, n);
        }
        catch (SystemException systemException) {
            try {
                FFDCFilter.processException((Throwable)systemException, "com.ibm.ws.Transaction.JTA.TransactionImpl.delistResource", "1928", this);
                throw systemException;
            }
            catch (Throwable throwable) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "delistResource", new java.lang.Object[]{"(SPI)", new Boolean(bl)});
                }
                throw throwable;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "delistResource", new java.lang.Object[]{"(SPI)", new Boolean(bl)});
        }
        return bl;
    }

    public void registerAsyncSynchronization(JTAAsyncSynchronizationBase jTAAsyncSynchronizationBase) throws IllegalStateException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "registerAsyncSynchronization (SPI)");
        }
        this.getSyncs().addAsync(jTAAsyncSynchronizationBase);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "registerAsyncSynchronization (SPI)");
        }
    }

    public void registerSynchronization(Synchronization synchronization) throws RollbackException, IllegalStateException {
        this.registerSynchronization(synchronization, 1);
    }

    public void registerSynchronization(Synchronization synchronization, int n) throws RollbackException, IllegalStateException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "registerSynchronization (SPI)", new java.lang.Object[]{this, synchronization, new Integer(n)});
        }
        switch (this._status.getState()) {
            case 0: {
                if (!this._timedOut) break;
            }
            case 5: 
            case 6: 
            case 8: {
                RollbackException rollbackException = new RollbackException("Transaction rolled back");
                FFDCFilter.processException((Throwable)rollbackException, "com.ibm.ws.Transaction.JTA.TransactionImpl.registerSynchronization", "2289", this);
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "registerSynchronization (SPI)", (java.lang.Object)rollbackException);
                }
                throw rollbackException;
            }
            default: {
                IllegalStateException illegalStateException = new IllegalStateException("Transaction is inactive or prepared");
                FFDCFilter.processException((Throwable)illegalStateException, "com.ibm.ws.Transaction.JTA.TransactionImpl.registerSynchronization", "2297", this);
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "registerSynchronization (SPI)", illegalStateException);
                }
                throw illegalStateException;
            }
        }
        this.getSyncs().add(synchronization, n);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "registerSynchronization (SPI)");
        }
    }

    public int getStatus() {
        int n = 5;
        if (!this._nonInterop) {
            switch (this._status.getState()) {
                case -1: {
                    n = 6;
                    break;
                }
                case 0: {
                    if (this._rollbackOnly) {
                        n = 1;
                        break;
                    }
                    n = 0;
                    break;
                }
                case 1: 
                case 9: {
                    n = 7;
                    break;
                }
                case 2: {
                    n = 2;
                    break;
                }
                case 3: {
                    n = 8;
                    break;
                }
                case 4: 
                case 7: {
                    n = 3;
                    break;
                }
                case 5: {
                    n = 9;
                    break;
                }
                case 6: 
                case 8: {
                    n = 4;
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "getStatus (SPI)", Util.printStatus(n));
        }
        return n;
    }

    public RegisteredResources getResources() {
        if (this._resources == null) {
            this._resources = new RegisteredResources(this, this._disableTwoPhase, this._LPSEnabled);
        }
        return this._resources;
    }

    public RegisteredSyncs getSyncs() {
        if (this._syncs == null) {
            this._syncs = new RegisteredSyncs(this);
        }
        return this._syncs;
    }

    public int getExtJTASyncLevel() {
        if (this._syncs == null) {
            return -1;
        }
        return this._syncs.getExtJTASyncLevel();
    }

    public void addDestroyCallback(ResourceCallback resourceCallback) {
        if (this._destroyCallbacks == null) {
            this._destroyCallbacks = new ArrayList();
        }
        this._destroyCallbacks.add(resourceCallback);
    }

    public TransactionState getTransactionState() {
        return this._status;
    }

    public XidImpl getXidImpl() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getXidImpl", this);
        }
        if (this._xid == null) {
            this._xid = new XidImpl(new TxPrimaryKey(this._localTID, Configuration.getCurrentEpoch()));
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getXidImpl", this._xid);
        }
        return this._xid;
    }

    public void setXidImpl(XidImpl xidImpl) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "setXidImpl", new java.lang.Object[]{xidImpl, this});
        }
        this._xid = xidImpl;
    }

    public Xid getXid() {
        return this.getXidImpl();
    }

    public XidImpl getJCAXid() {
        if (TraceComponent.isAnyTracingEnabled()) {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getJCAXid", this);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getJCAXid", this._JCAXid);
            }
        }
        return this._JCAXid;
    }

    public String getTranName() {
        return com.ibm.ejs.util.Util.toHexString(this.getTID()).toUpperCase();
    }

    public long getLocalTID() {
        return this._localTID;
    }

    RecoverableUnit getLog() throws SystemException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getLog");
        }
        if (this._logUnit == null) {
            this._tranLog = this._failureScopeController.getTransactionLog();
            if (this._tranLog != null) {
                try {
                    this._logUnit = this._tranLog.createRecoverableUnit();
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, "com.ibm.ws.Transaction.JTA.TransactionImpl.getLog", "2134", this);
                    Tr.error(tc, "WTRN0066_LOG_WRITE_ERROR", exception);
                    this._rollbackOnly = true;
                    throw new SystemException(exception.getLocalizedMessage());
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getLog", this._logUnit);
        }
        return this._logUnit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void postCompletion(int n) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "postCompletion", new Integer(n));
        }
        if (this._perf != null) {
            this._perf.completed(n);
        }
        try {
            int n2;
            if (this._resources != null && HeuristicOutcome.isHeuristic(this._resources.getHeuristicOutcome())) {
                try {
                    this._resources.distributeForget();
                }
                catch (SystemException systemException) {
                    this._systemExceptionOccured = true;
                }
            }
            if (this._nativeContext != null) {
                XAPdataWrapper xAPdataWrapper = this.getResources().getFailedResourceData();
                this._nativeContext.setFailedResourceData(xAPdataWrapper);
            } else if (this._resources != null && this._resources.requireRetry()) {
                if (this._inRecovery) {
                    if (this._retryAlarm == null) {
                        this._retryAttempts = 0;
                        this._retryAlarm = new RetryAlarm();
                    }
                    if (heuristicRetryLimit <= 0 || this._retryAttempts < heuristicRetryLimit) {
                        ++this._retryAttempts;
                        this.prolongFinish();
                    } else {
                        Tr.warning(tc, "WTRN0055_GIVING_UP_OUTCOME_DELIVERY", this.getTranName());
                        this.getResources().destroyResources();
                        this.getResources().updateHeuristicOutcome(10);
                    }
                } else {
                    this._retryAlarm = new RetryAlarm();
                    this._retryAlarm.start();
                }
            } else if (this._inRecovery && ((n2 = this._status.getState()) == 7 || n2 == 8) && this._JCARecoveryData == null) {
                if (this._wsatRC == null) {
                    if (this.replay() == Status.StatusNoTransaction) {
                        this.notifyCompletion();
                    }
                } else {
                    this.notifyCompletion();
                }
            }
        }
        finally {
            this.distributeAfter(n);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "postCompletion");
        }
    }

    private void distributeAfter(int n) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "distributeAfter", new Integer(n));
        }
        TranManagerSet.instance().suspend();
        this.getSyncs().distributeAfter(n);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "distributeAfter");
        }
    }

    public final synchronized void prolongFinish() {
        ++this._finishCount;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "prolongFinish", new Integer(this._finishCount));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public final synchronized void notifyCompletion() {
        if (TraceComponent.isAnyTracingEnabled() && TransactionImpl.tc.isEntryEnabled()) {
            Tr.entry(TransactionImpl.tc, "notifyCompletion", "finishCount=" + this._finishCount);
        }
        --this._finishCount;
        if (this._finishCount == 0) {
            try {
                switch (this._status.getState()) {
                    case 3: 
                    case 7: {
                        this._status.setState(4);
                        ** break;
lbl10:
                        // 1 sources

                        break;
                    }
                    case 5: 
                    case 8: {
                        this._status.setState(6);
                        ** break;
lbl14:
                        // 1 sources

                        break;
                    }
                    case 1: {
                        this._status.setState(4);
                        break;
                    }
                    ** default:
lbl19:
                    // 1 sources

                    break;
                }
            }
            catch (SystemException var1_1) {
                FFDCFilter.processException((Throwable)var1_1, "com.ibm.ws.Transaction.JTA.TransactionImpl.notifyCompletion", "2416", this);
                if (TraceComponent.isAnyTracingEnabled() && TransactionImpl.tc.isDebugEnabled()) {
                    Tr.debug(TransactionImpl.tc, "SystemException setting state during completion processing", (java.lang.Object)var1_1);
                }
            }
            finally {
                this.forgetTransaction(true);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && TransactionImpl.tc.isEntryEnabled()) {
            Tr.exit(TransactionImpl.tc, "notifyCompletion");
        }
    }

    void forgetTransaction(boolean bl) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "forgetTransaction", new Boolean(bl));
        }
        if (this._nativeContext != null) {
            this._nativeContext.resume();
            this._nativeContext.cleanupTransaction();
            this._nativeContext = null;
        }
        if (this._destroyCallbacks != null) {
            for (int i = 0; i < this._destroyCallbacks.size(); ++i) {
                ((ResourceCallback)this._destroyCallbacks.get(i)).destroy();
            }
            this._destroyCallbacks.clear();
            this._destroyCallbacks = null;
        }
        if (this._logUnit != null && bl) {
            try {
                this._tranLog.removeRecoverableUnit(this._logUnit.identity());
            }
            catch (Exception exception) {
                if (exception instanceof LogClosedException && this._failureScopeController.getTransactionLog() == null) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                        Tr.event(tc, "Transaction log has been shut down");
                    }
                }
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.Transaction.JTA.TransactionImpl.forgetTransaction", "2181", this);
                Tr.error(tc, "WTRN0066_LOG_WRITE_ERROR", exception);
            }
            this._logUnit = null;
        }
        LocalTIDTable.removeLocalTID(this._localTID);
        if (TxProperties.NATIVE_CONTEXTS_USED) {
            this.removeFromPrimaryKeyMap();
        }
        this._failureScopeController.deregisterTransaction(this, this._inRecovery);
        if (this._JCARecoveryData != null) {
            TxExecutionContextHandler.removeTxn(this.getXid());
        }
        this._status.reset();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "forgetTransaction");
        }
    }

    public boolean isRAImport() {
        boolean bl;
        boolean bl2 = bl = this._JCARecoveryData != null;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "isRAImport", bl);
        }
        return bl;
    }

    public boolean isGlobal() {
        return true;
    }

    public byte[] getTID() {
        return this.getXidImpl().getOtidBytes();
    }

    public boolean getRollbackOnly() {
        return this._rollbackOnly;
    }

    public final boolean equals(java.lang.Object object) {
        TransactionImpl transactionImpl;
        if (object == this) {
            return true;
        }
        return object instanceof TransactionImpl && (transactionImpl = (TransactionImpl)object).getLocalTID() == this.getLocalTID();
    }

    public final int hashCode() {
        return (int)this._localTID;
    }

    public String toString() {
        String string = this._tranName;
        if (string == null) {
            String string2 = this._localTID == 0L ? "" : "#tid=" + this._localTID;
            string = this.getClass().getName() + "@" + Integer.toHexString(System.identityHashCode(this)) + string2;
            if (this._localTID != 0L) {
                this._tranName = string;
            }
        }
        return string;
    }

    public static void setPerformanceMetrics(JtsPerformanceMetrics jtsPerformanceMetrics) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "setPerformanceMetrics", jtsPerformanceMetrics);
        }
        _perfMetricsListener = jtsPerformanceMetrics;
    }

    boolean hasSuspendedAssociations() {
        boolean bl;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "hasSuspendedAssociations", new java.lang.Object[]{"_activeAssociations=" + this._activeAssociations, "_suspendedAssociations=" + this._suspendedAssociations});
        }
        boolean bl2 = bl = this._suspendedAssociations > 0;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "hasSuspendedAssociations", bl);
        }
        return bl;
    }

    public synchronized void addAssociation() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "addAssociation");
        }
        if (this._activeAssociations > this._suspendedAssociations) {
            block7: {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "addAssociation received incoming request for active context");
                }
                try {
                    this.setRollbackOnly();
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, "com.ibm.ws.Transaction.JTA.TransactionImpl.addAssociation", "1701", this);
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block7;
                    Tr.debug(tc, "setRollbackOnly threw exception", exception);
                }
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "addAssociation throwing rolledback");
            }
            throw new TRANSACTION_ROLLEDBACK("Context already active");
        }
        this.stopInactivityTimer();
        ++this._activeAssociations;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "addAssociation");
        }
    }

    public synchronized void removeAssociation() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "removeAssociation");
        }
        --this._activeAssociations;
        if (this._activeAssociations <= 0 && this._nativeContext == null) {
            this.startInactivityTimer(null);
        }
        this.notifyAll();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "removeAssociation");
        }
    }

    public synchronized void suspendAssociation() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "suspendAssociation");
        }
        ++this._suspendedAssociations;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "suspendAssociation");
        }
    }

    public synchronized void resumeAssociation() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "resumeAssociation");
        }
        boolean bl = false;
        while (this._activeAssociations > this._suspendedAssociations) {
            block10: {
                bl = true;
                try {
                    if (!this._rollbackOnly) {
                        this.setRollbackOnly();
                    }
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, "com.ibm.ws.Transaction.JTA.TransactionImpl.resumeAssociation", "1748", this);
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block10;
                    Tr.debug(tc, "setRollbackOnly threw exception", exception);
                }
            }
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        --this._suspendedAssociations;
        if (bl) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "resumeAssociation throwing rolledback");
            }
            throw new TRANSACTION_ROLLEDBACK("Context already active");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "resumeAssociation");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public synchronized void timeoutTransaction(boolean var1_1) {
        if (TraceComponent.isAnyTracingEnabled() && TransactionImpl.tc.isEntryEnabled()) {
            Tr.entry(TransactionImpl.tc, "timeoutTransaction", new Boolean(var1_1));
        }
        if (this._perf != null) {
            this._perf.timeout();
        }
        if (TraceComponent.isAnyTracingEnabled() && TransactionImpl.tc.isEventEnabled()) {
            Tr.event(TransactionImpl.tc, "(SPI) Transaction TIMEOUT occurred for TX: " + this.getLocalTID());
        }
        this._timedOut = true;
        if (this._nativeContext != null) {
            this.setRBO();
        } else if (var1_1) {
            this._rollbackOnly = true;
            if (this._status.getState() == 0) {
                if (this._timeout == 0) {
                    this._timeout = 10;
                }
                TimeoutManager.setTimeout(this, 3, this._timeout);
            }
            if (this._activeAssociations <= 0) {
                this.rollbackResources();
            }
        } else if (this._activeAssociations <= 0) {
            block24: {
                var2_2 = TranManagerSet.instance();
                var3_3 = false;
                try {
                    var2_2.resume(this);
                    var3_3 = true;
                }
                catch (Throwable var4_4) {
                    FFDCFilter.processException(var4_4, "com.ibm.ws.Transaction.JTA.TransactionImpl.timeoutTransaction", "3432", this);
                    if (!TraceComponent.isAnyTracingEnabled() || !TransactionImpl.tc.isDebugEnabled()) break block24;
                    Tr.debug(TransactionImpl.tc, "timeoutTransaction resume threw exception", var4_4);
                }
            }
            if (var3_3) {
                var4_5 = false;
                try {
                    var2_2.rollback();
                    var4_5 = true;
                }
                catch (Throwable var5_6) {
                    FFDCFilter.processException(var5_6, "com.ibm.ws.Transaction.JTA.TransactionImpl.timeoutTransaction", "3445", this);
                    if (!TraceComponent.isAnyTracingEnabled() || !TransactionImpl.tc.isDebugEnabled()) ** GOTO lbl54
                    Tr.debug(TransactionImpl.tc, "timeoutTransaction rollback threw exception", var5_6);
                }
                finally {
                    if (!var4_5) {
                        var2_2.suspend();
                    }
                }
            }
        } else {
            this._rollbackOnly = true;
            if (this._status.getState() == 0) {
                if (this._timeout == 0) {
                    this._timeout = 10;
                }
                TimeoutManager.setTimeout(this, 3, this._timeout);
            }
        }
lbl54:
        // 9 sources

        if (TraceComponent.isAnyTracingEnabled() && TransactionImpl.tc.isEntryEnabled()) {
            Tr.exit(TransactionImpl.tc, "timeoutTransaction");
        }
    }

    public boolean isTimedOut() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "isTimedOut", this._timedOut);
        }
        return this._timedOut;
    }

    public int getTxType() {
        int n;
        int n2 = n = this._nonInterop ? 2 : 1;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "getTxType", new Integer(n));
        }
        return n;
    }

    public void finish() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "finish");
        }
        int n = this._status.getState();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Transaction state is: " + this._status);
        }
        switch (n) {
            case 0: {
                this.cancelAlarms();
            }
            case 1: {
                try {
                    this.timeoutTransaction(false);
                    Tr.error(tc, "WTRN0082_OPERATOR_ROLLBACK", this.getTranName());
                }
                catch (Throwable throwable) {
                    FFDCFilter.processException(throwable, "com.ibm.ws.Transaction.JTA.TransactionImpl.finish", "2805", this);
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break;
                    Tr.debug(tc, "Unexpected exception caught during transaction ROLLBACK", throwable);
                }
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 9: {
                this.stopRetryAlarm();
                break;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "finish");
        }
    }

    public boolean startInactivityTimer(WebSphereTransactionManager.InactivityTimer inactivityTimer) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "startInactivityTimer", inactivityTimer);
        }
        if (this._inactivityTimeout > 0 && this._status.getState() == 0 && !this._inactivityTimerActive) {
            TimeoutManager.setTimeout(this, 4, this._inactivityTimeout);
            this._inactivityTimerActive = true;
            this._inactivityTimer = inactivityTimer;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "startInactivityTimer", this._inactivityTimerActive);
        }
        return this._inactivityTimerActive;
    }

    public synchronized void stopInactivityTimer() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "stopInactivityTimer");
        }
        if (this._inactivityTimerActive) {
            this._inactivityTimerActive = false;
            TimeoutManager.setTimeout(this, 4, 0);
            this._inactivityTimer = null;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "stopInactivityTimer");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    synchronized void inactivityTimeout() {
        block15: {
            if (TraceComponent.isAnyTracingEnabled() && TransactionImpl.tc.isEntryEnabled()) {
                Tr.entry(TransactionImpl.tc, "inactivityTimeout");
            }
            this._inactivityTimerActive = false;
            if (this._inactivityTimer != null) {
                try {
                    this._inactivityTimer.alarm();
                }
                catch (Throwable var1_1) {
                    FFDCFilter.processException(var1_1, "com.ibm.ws.Transaction.JTA.TransactionImpl.inactivityTimeout", "2611", this);
                    if (!TraceComponent.isAnyTracingEnabled() || !TransactionImpl.tc.isEventEnabled()) ** GOTO lbl34
                    Tr.event(TransactionImpl.tc, "exception caught in inactivityTimeout", var1_1);
                }
                finally {
                    this._inactivityTimer = null;
                }
            } else if (this._activeAssociations <= 0) {
                var1_2 = TranManagerSet.instance();
                try {
                    block14: {
                        var1_2.resume(this);
                        try {
                            var1_2.setRollbackOnly();
                        }
                        catch (Exception var2_4) {
                            FFDCFilter.processException((Throwable)var2_4, "com.ibm.ws.Transaction.JTA.TransactionImpl.inactivityTimeout", "4353", this);
                            if (!TraceComponent.isAnyTracingEnabled() || !TransactionImpl.tc.isDebugEnabled()) break block14;
                            Tr.debug(TransactionImpl.tc, "inactivityTimeout setRollbackOnly threw exception", var2_4);
                        }
                    }
                    var1_2.rollback();
                }
                catch (Exception var2_5) {
                    FFDCFilter.processException((Throwable)var2_5, "com.ibm.ws.Transaction.JTA.TransactionImpl.inactivityTimeout", "2628", this);
                    if (!TraceComponent.isAnyTracingEnabled() || !TransactionImpl.tc.isDebugEnabled()) break block15;
                    Tr.debug(TransactionImpl.tc, "inactivityTimeout resume/rollback threw exception", var2_5);
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && TransactionImpl.tc.isEntryEnabled()) {
            Tr.exit(TransactionImpl.tc, "inactivityTimeout");
        }
    }

    JCARecoveryData getJCARecoveryData() {
        return this._JCARecoveryData;
    }

    public void setJCARecoveryData(JCARecoveryData jCARecoveryData) {
        this._JCARecoveryData = jCARecoveryData;
    }

    public boolean isCascaded() {
        return this._cascaded;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void heuristicallyCommit() {
        if (TraceComponent.isAnyTracingEnabled() && TransactionImpl.tc.isEntryEnabled()) {
            Tr.entry(TransactionImpl.tc, "heuristicallyCommit");
        }
        this.cancelAlarms();
        try {
            var1_1 = this._status.getState();
            switch (var1_1) {
                case 0: {
                    this.heuristicallyCommitOnePhase();
                    ** break;
lbl10:
                    // 1 sources

                    break;
                }
                default: {
                    if (var1_1 != 3 && var1_1 != 7 && var1_1 != 4) {
                        this._status.setState(3);
                    }
                    this.getResources().heuristicallyCommit();
                    break;
                }
            }
        }
        catch (SystemException var1_2) {
            FFDCFilter.processException((Throwable)var1_2, "com.ibm.ws.Transaction.JTA.TransactionImpl.heuristicallyCommit", "1096", this);
            if (TraceComponent.isAnyTracingEnabled() && TransactionImpl.tc.isDebugEnabled()) {
                Tr.debug(TransactionImpl.tc, "SystemException caught during heuristic commit processing", (java.lang.Object)var1_2);
            }
            Tr.error(TransactionImpl.tc, "WTRN0058_RECOVERY_EXCEPTION_IN_COMMIT", new java.lang.Object[]{this.getTranName(), var1_2});
        }
        finally {
            this._needsManualCompletion = false;
            this.addHeuristic();
            this.prolongFinish();
            this.notifyCompletion();
        }
        if (TraceComponent.isAnyTracingEnabled() && TransactionImpl.tc.isEntryEnabled()) {
            Tr.exit(TransactionImpl.tc, "heuristicallyCommit");
        }
    }

    private void heuristicallyCommitOnePhase() throws SystemException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "heuristicallyCommitOnePhase");
        }
        int n = 8;
        this._subordinate = false;
        int n2 = this._status.getState();
        try {
            n2 = this.internalPrepare();
        }
        catch (HeuristicMixedException heuristicMixedException) {
            FFDCFilter.processException((Throwable)heuristicMixedException, "com.ibm.ws.Transaction.JTA.TransactionImpl.heuristicallyCommitOnePhase", "3664", this);
            n = 10;
        }
        catch (HeuristicHazardException heuristicHazardException) {
            FFDCFilter.processException((Throwable)heuristicHazardException, "com.ibm.ws.Transaction.JTA.TransactionImpl.heuristicallyCommitOnePhase", "3669", this);
            n = 10;
        }
        catch (HeuristicRollbackException heuristicRollbackException) {
            FFDCFilter.processException((Throwable)heuristicRollbackException, "com.ibm.ws.Transaction.JTA.TransactionImpl.heuristicallyCommitOnePhase", "3674", this);
            n = 9;
        }
        catch (IllegalStateException illegalStateException) {
            FFDCFilter.processException((Throwable)illegalStateException, "com.ibm.ws.Transaction.JTA.TransactionImpl.heuristicallyCommitOnePhase", "502", this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "heuristicallyCommitOnePhase", illegalStateException);
            }
            throw new SystemException(illegalStateException.getLocalizedMessage());
        }
        catch (SystemException systemException) {
            FFDCFilter.processException((Throwable)systemException, "com.ibm.ws.Transaction.JTA.TransactionImpl.heuristicallyCommitOnePhase", "509", this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "heuristicallyCommitOnePhase", (java.lang.Object)systemException);
            }
            throw systemException;
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.Transaction.JTA.TransactionImpl.heuristicallyCommitOnePhase", "516", this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "heuristicallyCommitOnePhase", throwable);
            }
            throw new SystemException(throwable.getLocalizedMessage());
        }
        if (n != 8) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "internalPrepare threw heuristic", ResourceWrapper.printResourceStatus(n));
            }
        } else {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "internalPrepare returned", TransactionState.stateToString(n2));
            }
            try {
                switch (n2) {
                    case 3: {
                        this.internalCommit();
                        break;
                    }
                    case 5: {
                        this.internalRollback();
                        break;
                    }
                    case 9: {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug(tc, "lpsHeuristicCompletion needed");
                        }
                        switch (lpsHeuristicCompletion) {
                            case 1: {
                                Tr.error(tc, "WTRN0096_HEURISTIC_MAY_HAVE_OCCURED", this.getTranName());
                                this._status.setState(3);
                                this.internalCommit();
                                break;
                            }
                            case 2: {
                                this._needsManualCompletion = true;
                                Tr.info(tc, "WTRN0097_HEURISTIC_MANUAL_COMPLETION", this.getTranName());
                                break;
                            }
                            default: {
                                Tr.error(tc, "WTRN0102_HEURISTIC_MAY_HAVE_OCCURED", this.getTranName());
                                this._status.setState(5);
                                this.internalRollback();
                            }
                        }
                        n = 11;
                        break;
                    }
                    default: {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug(tc, "Unhandled state", TransactionState.stateToString(n2));
                        }
                        break;
                    }
                }
            }
            catch (HeuristicMixedException heuristicMixedException) {
                FFDCFilter.processException((Throwable)heuristicMixedException, "com.ibm.ws.Transaction.JTA.TransactionImpl.heuristicallyCommitOnePhase", "3774", this);
                n = 10;
            }
            catch (HeuristicHazardException heuristicHazardException) {
                FFDCFilter.processException((Throwable)heuristicHazardException, "com.ibm.ws.Transaction.JTA.TransactionImpl.heuristicallyCommitOnePhase", "3779", this);
                n = 11;
            }
            catch (HeuristicRollbackException heuristicRollbackException) {
                FFDCFilter.processException((Throwable)heuristicRollbackException, "com.ibm.ws.Transaction.JTA.TransactionImpl.heuristicallyCommitOnePhase", "3784", this);
                n = 9;
            }
            catch (SystemException systemException) {
                FFDCFilter.processException((Throwable)systemException, "com.ibm.ws.Transaction.JTA.TransactionImpl.heuristicallyCommitOnePhase", "545", this);
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "heuristicallyCommitOnePhase", (java.lang.Object)systemException);
                }
                throw systemException;
            }
            catch (Throwable throwable) {
                FFDCFilter.processException(throwable, "com.ibm.ws.Transaction.JTA.TransactionImpl.heuristicallyCommitOnePhase", "539", this);
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "heuristicallyCommitOnePhase", throwable);
                }
                throw new SystemException(throwable.getLocalizedMessage());
            }
        }
        this._subordinate = true;
        this.getResources().setHeuristicOutcome(n);
        this.getResources().logHeuristic(true);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "heuristicallyCommitOnePhase");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void heuristicallyRollback() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "heuristicallyRollback");
        }
        this.cancelAlarms();
        try {
            int n = this._status.getState();
            if (n != 5 && n != 8 && n != 6) {
                this._status.setState(5);
            }
            this.getResources().heuristicallyRollback();
        }
        catch (SystemException systemException) {
            FFDCFilter.processException((Throwable)systemException, "com.ibm.ws.Transaction.JTA.TransactionImpl.heuristicallyRollback", "1142", this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "SystemException caught during heuristic rollback processing", (java.lang.Object)systemException);
            }
            Tr.error(tc, "WTRN0059_RECOVERY_EXCEPTION_IN_ROLLBACK", new java.lang.Object[]{this.getTranName(), systemException});
        }
        finally {
            this._needsManualCompletion = false;
            this.addHeuristic();
            this.prolongFinish();
            this.notifyCompletion();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "heuristicallyRollback");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeHeuristic(long l) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "removeHeuristic", new Long(l));
        }
        LongObjectHashMap longObjectHashMap = _heuristicTxns;
        synchronized (longObjectHashMap) {
            _heuristicTxns.remove(l);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "removeHeuristic");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addHeuristic() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "addHeuristic");
        }
        LongObjectHashMap longObjectHashMap = _heuristicTxns;
        synchronized (longObjectHashMap) {
            _heuristicTxns.put(this._localTID, this);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "addHeuristic");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TransactionImpl[] listHeuristicallyCompletedTransactions() {
        LongObjectHashMap longObjectHashMap = _heuristicTxns;
        synchronized (longObjectHashMap) {
            java.lang.Object[] objectArray = _heuristicTxns.values();
            ArrayList<TransactionImpl> arrayList = new ArrayList<TransactionImpl>();
            long l = System.currentTimeMillis() - 259200000L;
            for (int i = 0; i < objectArray.length; ++i) {
                TransactionImpl transactionImpl = (TransactionImpl)objectArray[i];
                XidImpl xidImpl = transactionImpl.getXidImpl();
                if (xidImpl == null) continue;
                TxPrimaryKey txPrimaryKey = xidImpl.getPrimaryKey();
                if (txPrimaryKey.getTimeStamp() < l) {
                    _heuristicTxns.remove(transactionImpl.getLocalTID());
                    continue;
                }
                arrayList.add(transactionImpl);
            }
            return arrayList.toArray(new TransactionImpl[arrayList.size()]);
        }
    }

    public static int heuristicTxnsCount() {
        return TransactionImpl.listHeuristicallyCompletedTransactions().length;
    }

    public boolean needsManualCompletion() {
        return this._needsManualCompletion;
    }

    public boolean isImportedAndPrepared() {
        return this._subordinate && this._status.getState() == 2;
    }

    public boolean isJCAImportedAndPrepared(String string) {
        return this._JCARecoveryData != null && this._status.getState() == 2 && this._JCARecoveryData.getWrapper().getProviderId().equals(string);
    }

    public boolean requireRetry() {
        return this._resources != null && this._resources.requireRetry();
    }

    public String[] listResources() {
        return this.getResources().listResources();
    }

    public void setCompletedLTCBoundary(Byte by) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "setCompletedLTCBoundary", new java.lang.Object[]{by});
        }
        this._completedLTCBoundary = by;
    }

    public Byte getCompletedLTCBoundary() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "getCompletedLTCBoundary", this._completedLTCBoundary);
        }
        return this._completedLTCBoundary;
    }

    public void setTaskId(String string) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "setTaskId", new java.lang.Object[]{string, this});
        }
        this._taskId = string;
    }

    public String getTaskId() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "getTaskId", this._taskId);
        }
        return this._taskId;
    }

    private void stopRetryAlarm() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "stopRetryAlarm");
        }
        if (this._retryAlarm != null) {
            this._retryAlarm.stop();
        } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "No retry alarm currently active.");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "stopRetryAlarm");
        }
    }

    public void destroy() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "destroy");
        }
        if (this._JCARecoveryData != null) {
            this._JCARecoveryData.decrementCount();
        }
        if (this._superiorWSCoord != null) {
            PartnerLogTable partnerLogTable = this._failureScopeController.getRecoveryManager().getPartnerLogTable();
            if (partnerLogTable != null) {
                PartnerLogData partnerLogData = partnerLogTable.findEntry(this._superiorRecoveryId);
                if (partnerLogData != null) {
                    partnerLogData.decrementCount();
                } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "plt.findEntry(" + this._superiorRecoveryId + ") returned null");
                }
            } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "_failureScopeController.getPartnerLogTable() returned null");
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "destroy");
        }
    }

    private void addToPrimaryKeyMap() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "addToPrimaryKeyMap");
        }
        primaryKeyMap.put(this._xid.getPrimaryKey(), this);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "addToPrimaryKeyMap");
        }
    }

    private void removeFromPrimaryKeyMap() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "removeFromPrimaryKeyMap");
        }
        primaryKeyMap.remove(this._xid.getPrimaryKey());
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "removeFromPrimaryKeyMap");
        }
    }

    public static TransactionImpl findInPrimaryKeyMap(java.lang.Object object) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "findInPrimaryKeyMap", object);
        }
        TransactionImpl transactionImpl = (TransactionImpl)primaryKeyMap.get(object);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "findInPrimaryKeyMap", transactionImpl);
        }
        return transactionImpl;
    }

    public void promoteToDistributedTx() throws SystemException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "promoteToDistributedTx");
        }
        if (this._nativeContext != null) {
            this._nativeContext.promoteToDistributedTx();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "promoteToDistributedTx");
        }
    }

    public void promoteToDistributedTx(String string) throws SystemException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "promoteToDistributedTx", string);
        }
        if (this._nativeContext != null && this._wsatRC == null) {
            this._nativeContext.promoteToDistributedTx(string);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "promoteToDistributedTx");
        }
    }

    public void decrementWSATCount() throws SystemException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "decrementWSATCount");
        }
        if (this._nativeContext != null) {
            this._nativeContext.decrementWSATCount();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "decrementWSATCount");
        }
    }

    public void fault() {
        this.getResources().updateHeuristicOutcome(11);
    }

    public String getGlobalGlobalID() {
        String string;
        if (this._globalGlobalID != null) {
            string = this._globalGlobalID;
        } else if (this._xid != null) {
            this._globalGlobalID = string = "com.ibm.ws.wstx:" + com.ibm.ejs.util.Util.toHexString(this._xid.getGlobalTransactionId());
        } else {
            string = "";
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "getGlobalGlobalID", string);
        }
        return string;
    }

    public void setGlobalGlobalID(String string) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "setGlobalGlobalID", string);
        }
        this._globalGlobalID = string;
    }

    public void putResource(java.lang.Object object, java.lang.Object object2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "putResource", new java.lang.Object[]{object, object2, this});
        }
        if (object == null) {
            NullPointerException nullPointerException = new NullPointerException();
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "putResource", nullPointerException);
            }
            throw nullPointerException;
        }
        if (this._synchronizationRegistryResources == null) {
            this._synchronizationRegistryResources = new HashMap();
        }
        this._synchronizationRegistryResources.put(object, object2);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "putResource");
        }
    }

    public java.lang.Object getResource(java.lang.Object object) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getResource", new java.lang.Object[]{object, this});
        }
        if (object == null) {
            NullPointerException nullPointerException = new NullPointerException();
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getResource", nullPointerException);
            }
            throw nullPointerException;
        }
        if (this._synchronizationRegistryResources == null) {
            this._synchronizationRegistryResources = new HashMap();
        }
        java.lang.Object v = this._synchronizationRegistryResources.get(object);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getResource", v);
        }
        return v;
    }

    public long getLocalId() {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getLocalId", this);
        }
        return this._localTID | 0x6000000000000000L;
    }

    public int getUOWType() {
        return 1;
    }

    public int getUOWStatus() {
        int n;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getUOWStatus", this);
        }
        int n2 = this.getStatus();
        switch (n2) {
            case 0: {
                n = 0;
                break;
            }
            case 1: {
                n = 1;
                break;
            }
            case 2: 
            case 7: 
            case 8: 
            case 9: {
                n = 2;
                break;
            }
            case 3: {
                n = 3;
                break;
            }
            case 4: {
                n = 4;
                break;
            }
            default: {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getUOWStatus", "IllegalStateException");
                }
                throw new IllegalStateException();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getUOWStatus", new Integer(n));
        }
        return n;
    }

    public void registerInterposedSynchronization(Synchronization synchronization) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "registerInterposedSynchronization", new java.lang.Object[]{synchronization, this});
        }
        this.getSyncs().add(synchronization, 2);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "registerInterposedSynchronization");
        }
    }

    public void disableEarlyRollbackAfterTimeout() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "disableEarlyRollbackAfterTimeout", this);
        }
        if (this.getStatus() != 0 || this._timedOut) {
            IllegalStateException illegalStateException = new IllegalStateException("Transaction is not active, or has already timed out");
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "disableEarlyRollbackAfterTimeout", illegalStateException);
            }
            throw illegalStateException;
        }
        this._disableEarlyRollbackAfterTimeout = true;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "disableEarlyRollbackAfterTimeout");
        }
    }

    public boolean isEarlyRollbackAfterTimeoutDisabled() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isEarlyRollbackAfterTimeoutDisabled", this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isEarlyRollbackAfterTimeoutDisabled", new Boolean(this._disableEarlyRollbackAfterTimeout));
        }
        return this._disableEarlyRollbackAfterTimeout;
    }

    public void enableLPS() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "enableLPS", this);
        }
        this._LPSEnabled = true;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "enableLPS", this);
        }
    }

    public void shutdown() {
        JTAXAResourceImpl jTAXAResourceImpl;
        java.lang.Object object;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "shutdown", this);
        }
        RegisteredResources registeredResources = this.getResources();
        ArrayList arrayList = registeredResources.getResourceObjects();
        for (int i = 0; i < arrayList.size(); ++i) {
            object = arrayList.get(i);
            if (!(object instanceof JTAXAResourceImpl) || !"WAS Compensation RA".equals((jTAXAResourceImpl = (JTAXAResourceImpl)object).getXAResourceInfo().getRMName())) continue;
            PartnerLogData partnerLogData = null;
            partnerLogData = this._inRecovery ? this._failureScopeController.getRecoveryManager().getPartnerLogTable().findEntry(jTAXAResourceImpl.getRecoveryId()) : this._failureScopeController.getPartnerLogTable().findEntry(jTAXAResourceImpl.getRecoveryId());
            if (partnerLogData == null) continue;
            partnerLogData.setRecovered(false);
        }
        if (this.getStatus() != 1) {
            WSCoordinator wSCoordinator = this.getSuperiorCoordinator();
            if (wSCoordinator != null) {
                object = null;
                object = this._inRecovery ? this._failureScopeController.getRecoveryManager().getPartnerLogTable().findEntry(new WSCRecoveryWrapper(wSCoordinator)) : this._failureScopeController.getPartnerLogTable().findEntry(new WSCRecoveryWrapper(wSCoordinator));
                if (object != null) {
                    ((PartnerLogData)object).setRecovered(false);
                }
            }
            if (this.isRAImport()) {
                this.getJCARecoveryData().setRecovered(false);
            }
            for (int i = 0; i < arrayList.size(); ++i) {
                jTAXAResourceImpl = arrayList.get(i);
                if (jTAXAResourceImpl instanceof JTAXAResourceImpl) {
                    long l = jTAXAResourceImpl.getRecoveryId();
                    PartnerLogData partnerLogData = null;
                    partnerLogData = this._inRecovery ? this._failureScopeController.getRecoveryManager().getPartnerLogTable().findEntry(l) : this._failureScopeController.getPartnerLogTable().findEntry(l);
                    if (partnerLogData == null) continue;
                    partnerLogData.setRecovered(false);
                    continue;
                }
                if (!(jTAXAResourceImpl instanceof WSCoordinatorWrapper)) continue;
                wSCoordinator = ((WSCoordinatorWrapper)((java.lang.Object)jTAXAResourceImpl)).getWSCoordinator();
                PartnerLogData partnerLogData = null;
                partnerLogData = this._inRecovery ? this._failureScopeController.getRecoveryManager().getPartnerLogTable().findEntry(new WSCRecoveryWrapper(wSCoordinator)) : this._failureScopeController.getPartnerLogTable().findEntry(new WSCRecoveryWrapper(wSCoordinator));
                if (partnerLogData == null) continue;
                partnerLogData.setRecovered(false);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "shutdown", this);
        }
    }

    static /* synthetic */ JtsPerformanceMetrics access$700() {
        return _perfMetricsListener;
    }

    static {
        LPSLoggingEnabled = true;
        _heuristicTxns = new LongObjectHashMap();
        tc = Tr.register(TransactionImpl.class, "Transaction", "com.ibm.ws.Transaction.resources.TransactionMsgs");
    }

    private class RetryAlarm
    implements AlarmListener {
        private int _count;
        private int _wait;
        private Alarm _alarm;
        private boolean _finished;

        public RetryAlarm() {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "RetryAlarm");
            }
        }

        public void start() {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.entry(tc, "RetryAlarm.start");
            }
            this._count = 0;
            this._wait = heuristicRetryWait <= 0 ? 60 : heuristicRetryWait;
            TransactionImpl.this.prolongFinish();
            this._alarm = AlarmManager.createDeferrable((long)this._wait * 1000L, this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "RetryAlarm.start");
            }
        }

        public synchronized void stop() {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.entry(tc, "RetryAlarm.stop");
            }
            if (!this._finished) {
                this._finished = true;
                if (this._alarm != null) {
                    this._alarm.cancel();
                    this._alarm = null;
                }
                Tr.error(tc, "WTRN0077_OPERATOR_CANCELLED", TransactionImpl.this.getTranName());
                TransactionImpl.this.getResources().destroyResources();
                this.finishTransaction();
                TransactionImpl.this.getResources().updateHeuristicOutcome(10);
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "RetryAlarm.stop");
            }
        }

        public synchronized void alarm(java.lang.Object object) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.entry(tc, "RetryAlarm.alarm");
            }
            if (!this._finished) {
                try {
                    boolean bl = TransactionImpl.this.getResources().distributeOutcome();
                    if (bl |= TransactionImpl.this.getResources().distributeForget()) {
                        ++this._count;
                        if (heuristicRetryLimit > 0 && this._count >= heuristicRetryLimit) {
                            Tr.warning(tc, "WTRN0055_GIVING_UP_OUTCOME_DELIVERY", TransactionImpl.this.getTranName());
                            TransactionImpl.this.getResources().destroyResources();
                            this.finishTransaction();
                            this._finished = true;
                            TransactionImpl.this.getResources().updateHeuristicOutcome(10);
                            return;
                        }
                        if (this._count % 10 == 0 && this._wait < 0x3FFFFFFF) {
                            this._wait *= 2;
                        }
                        this._alarm = AlarmManager.createDeferrable((long)this._wait * 1000L, this);
                    } else {
                        this._finished = true;
                        this.finishTransaction();
                    }
                }
                catch (Throwable throwable) {
                    FFDCFilter.processException(throwable, "com.ibm.ws.Transaction.JTA.TransactionImpl.RetryAlarm", "1327", this);
                    this._finished = true;
                    this.finishTransaction();
                }
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "RetryAlarm.alarm");
            }
        }

        private void finishTransaction() {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.entry(tc, "RetryAlarm.finishTransaction");
            }
            TransactionImpl.this.notifyCompletion();
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "RetryAlarm.finishTransaction");
            }
        }
    }

    protected final class TxPerformanceData {
        JtsPerformanceMetrics _perfMetrics = TransactionImpl.access$700();
        long _startedTime = 0L;
        long _commitRequestedTime = 0L;
        long _preparePhaseBeginTime = 0L;
        long _commitPhaseBeginTime = 0L;
        boolean timedOut = false;

        TxPerformanceData() {
        }

        void started() {
            this._startedTime = this._perfMetrics.started();
        }

        public void imported() {
            this._perfMetrics.imported();
        }

        void commitRequested() {
            this._commitRequestedTime = this._perfMetrics.commitRequested();
        }

        void preparing() {
            if (this._preparePhaseBeginTime == 0L) {
                this._preparePhaseBeginTime = this._perfMetrics.preparing(this._commitRequestedTime);
            }
        }

        void committing() {
            if (this._commitPhaseBeginTime == 0L) {
                this._commitPhaseBeginTime = this._perfMetrics.committing(this._preparePhaseBeginTime);
            }
        }

        void completed(int n) {
            boolean bl = n != 4;
            this._perfMetrics.completed(this._commitPhaseBeginTime, this._startedTime, bl);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Tx completed", this);
            }
        }

        void onePhase() {
            this._perfMetrics.onePhase();
        }

        void timeout() {
            if (!this.timedOut) {
                this._perfMetrics.timeout();
                this.timedOut = true;
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Tx timed out", this);
            }
        }

        public String toString() {
            return "Started: " + this._startedTime + ", " + "Commit requested: " + this._commitRequestedTime + ", " + "Prepare phase begin: " + this._preparePhaseBeginTime + ", " + "Commit phase begin: " + this._commitPhaseBeginTime + ", " + "Current time: " + System.currentTimeMillis();
        }
    }
}

