/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.Transaction.JTA;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.Transaction.JTA.PartnerLogTable;
import com.ibm.ws.Transaction.JTA.TransactionImpl;
import com.ibm.ws.Transaction.JTA.Util;
import com.ibm.ws.Transaction.JTA.WSCRecoveryData;
import com.ibm.ws.Transaction.JTA.WSCRecoveryWrapper;
import com.ibm.ws.Transaction.JTA.XidImpl;
import com.ibm.ws.Transaction.JTS.Configuration;
import com.ibm.ws.Transaction.JTS.WSCoordinator;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.recoverylog.spi.InternalLogException;
import com.ibm.ws.recoverylog.spi.LogFullException;
import com.ibm.ws.recoverylog.spi.RecoverableUnit;
import com.ibm.ws.recoverylog.spi.RecoverableUnitSection;
import javax.transaction.SystemException;

public final class TransactionState {
    public static final int STATE_NONE = -1;
    public static final int STATE_ACTIVE = 0;
    public static final int STATE_PREPARING = 1;
    public static final int STATE_PREPARED = 2;
    public static final int STATE_COMMITTING = 3;
    public static final int STATE_COMMITTED = 4;
    public static final int STATE_ROLLING_BACK = 5;
    public static final int STATE_ROLLED_BACK = 6;
    public static final int STATE_HEURISTIC_ON_COMMIT = 7;
    public static final int STATE_HEURISTIC_ON_ROLLBACK = 8;
    public static final int STATE_LAST_PARTICIPANT = 9;
    private static final TraceComponent tc = Tr.register(TransactionState.class, "Transaction", "com.ibm.ws.Transaction.resources.TransactionMsgs");
    private int _state;
    private TransactionImpl _tran;
    private RecoverableUnit _tranLog;
    private RecoverableUnitSection _logSection;
    private boolean _loggingFailed;
    private static final PartnerLogTable _partnerLogTable = Configuration.getFailureScopeController().getPartnerLogTable();
    private byte[] byteData = new byte[1];
    static final boolean[][] validStateChange = new boolean[][]{{false, true, false, false, false, true, false, false, false, false}, {false, false, true, true, true, true, true, true, true, true}, {false, false, false, true, false, true, false, false, false, true}, {false, false, false, false, true, false, false, true, false, false}, {false, false, false, false, false, false, false, false, false, false}, {false, false, false, false, false, false, true, false, true, false}, {false, false, false, false, false, false, false, false, false, false}, {false, false, false, false, true, false, true, false, false, false}, {false, false, false, false, false, false, true, false, false, false}, {false, false, false, true, false, true, false, false, false, false}};

    TransactionState(TransactionImpl transactionImpl) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "TransactionState", new Object[]{this, transactionImpl});
        }
        this._state = 0;
        this._tran = transactionImpl;
    }

    int reconstruct(RecoverableUnit recoverableUnit) throws SystemException {
        Object object;
        int n;
        block24: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.entry(tc, "reconstruct", new Object[]{this, recoverableUnit});
            }
            n = -1;
            int n2 = 0;
            this._logSection = recoverableUnit.lookupSection(0);
            if (this._logSection != null) {
                try {
                    object = this._logSection.lastData();
                    if (((byte[])object).length == 1) {
                        n2 = object[0] & 0xFF;
                        switch (n2) {
                            case 2: 
                            case 3: 
                            case 4: 
                            case 5: 
                            case 6: 
                            case 7: 
                            case 8: 
                            case 9: {
                                n = n2;
                                break block24;
                            }
                            default: {
                                throw new SystemException("Transaction recovered in invalid state");
                            }
                        }
                    }
                    throw new SystemException("Invalid transaction state record data in log");
                }
                catch (Throwable throwable) {
                    FFDCFilter.processException(throwable, "com.ibm.ws.Transaction.JTA.TransactionState.reconstruct", "274", this);
                    Tr.fatal(tc, "WTRN0000_ERR_INT_ERROR", new Object[]{"reconstruct", "com.ibm.ws.Transaction.JTA.TransactionState", throwable});
                    if (TraceComponent.isAnyTracingEnabled()) {
                        if (tc.isEventEnabled()) {
                            Tr.event(tc, "Unable to access transaction state log record data");
                        }
                        if (tc.isEntryEnabled()) {
                            Tr.exit(tc, "reconstruct");
                        }
                    }
                    throw new SystemException(throwable.toString());
                }
            }
            FFDCFilter.processException((Throwable)new InternalLogException(), "com.ibm.ws.Transaction.JTA.TransactionState.setState", "277", this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event(tc, "No log record data for transaction state - returning NONE");
            }
            this._state = -1;
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "reconstruct", TransactionState.stateToString(this._state));
            }
            return this._state;
        }
        this._state = n;
        this._tranLog = recoverableUnit;
        object = recoverableUnit.lookupSection(3);
        if (object != null) {
            try {
                byte[] byArray = object.lastData();
                if (byArray.length <= 12) {
                    throw new SystemException("Invalid transaction global identifier record data in log");
                }
                XidImpl xidImpl = new XidImpl(byArray, 0);
                this._tran.setXidImpl(xidImpl);
            }
            catch (Throwable throwable) {
                FFDCFilter.processException(throwable, "com.ibm.ws.Transaction.JTA.TransactionState.reconstruct", "334", this);
                Tr.fatal(tc, "WTRN0000_ERR_INT_ERROR", new Object[]{"reconstruct", "com.ibm.ws.Transaction.JTA.TransactionState", throwable});
                if (TraceComponent.isAnyTracingEnabled()) {
                    if (tc.isEventEnabled()) {
                        Tr.event(tc, "Unable to access global transaction id log record data");
                    }
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "reconstruct");
                    }
                }
                throw new SystemException(throwable.toString());
            }
        } else {
            FFDCFilter.processException((Throwable)new InternalLogException(), "com.ibm.ws.Transaction.JTA.TransactionState.setState", "336", this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event(tc, "No log record data for global transaction id - returning NONE");
            }
            this._state = -1;
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "reconstruct", TransactionState.stateToString(this._state));
            }
            return this._state;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "reconstruct", TransactionState.stateToString(n));
        }
        return n;
    }

    /*
     * Unable to fully structure code
     */
    public void setState(int var1_1) throws SystemException {
        block51: {
            block48: {
                block46: {
                    if (TraceComponent.isAnyTracingEnabled() && TransactionState.tc.isEntryEnabled()) {
                        Tr.entry(TransactionState.tc, "setState", "from " + TransactionState.stateToString(this._state) + " to " + TransactionState.stateToString(var1_1));
                    }
                    var2_2 = this._state;
                    if (!TransactionState.validStateChange[this._state][var1_1]) break block48;
                    this._state = var1_1;
                    if (var1_1 != 3 && var1_1 != 9 && (!this._tran.isSubordinate() || var1_1 != 2 && var1_1 != 7 && var1_1 != 8)) break block46;
                    this.byteData[0] = (byte)this._state;
                    if (this._logSection != null) {
                        try {
                            this._logSection.addData(this.byteData);
                            if (TraceComponent.isAnyTracingEnabled() && TransactionState.tc.isDebugEnabled()) {
                                Tr.debug(TransactionState.tc, "State logged ok");
                            }
                            break block46;
                        }
                        catch (Exception var3_3) {
                            FFDCFilter.processException((Throwable)var3_3, "com.ibm.ws.Transaction.JTA.TransactionState.setState", "416", this);
                            if (TraceComponent.isAnyTracingEnabled() && TransactionState.tc.isEventEnabled()) {
                                Tr.event(TransactionState.tc, "addData failed during setState!");
                            }
                            break block46;
                        }
                    }
                    if (this._loggingFailed) break block46;
                    try {
                        block50: {
                            block49: {
                                this._tranLog = this._tran.getLog();
                                if (this._tranLog == null) break block46;
                                if (TraceComponent.isAnyTracingEnabled() && TransactionState.tc.isDebugEnabled()) {
                                    Tr.debug(TransactionState.tc, "Create sections in the Log for Recovery Coordinator");
                                }
                                if (!this._tran.isRAImport()) break block49;
                                var3_4 = this._tran.getJCARecoveryData();
                                if (TraceComponent.isAnyTracingEnabled() && TransactionState.tc.isEventEnabled()) {
                                    Tr.event(TransactionState.tc, "TX is imported from provider: " + var3_4.getWrapper().getProviderId());
                                }
                                var3_4.logRecoveryEntry();
                                var4_8 = this._tranLog.createSection(7, true);
                                var5_11 = Util.longToBytes(var3_4.getRecoveryId());
                                var6_15 = this._tran.getJCAXid().toBytes();
                                var7_17 = new byte[var6_15.length + var5_11.length];
                                System.arraycopy(var5_11, 0, var7_17, 0, var5_11.length);
                                System.arraycopy(var6_15, 0, var7_17, var5_11.length, var6_15.length);
                                var4_8.addData(var7_17);
                                break block50;
                            }
                            if (!this._tran.isSubordinate()) ** GOTO lbl70
                            if (TraceComponent.isAnyTracingEnabled() && TransactionState.tc.isEventEnabled()) {
                                Tr.event(TransactionState.tc, "Subordinate transaction; logging recovery or superior coordinator");
                            }
                            if ((var3_4 = this._tran.getSuperiorCoordinator()) != null) {
                                var4_9 = (WSCRecoveryData)TransactionState._partnerLogTable.findEntry(new WSCRecoveryWrapper((WSCoordinator)var3_4));
                                var4_9.logRecoveryEntry();
                                var5_12 = this._tranLog.createSection(6, true);
                                var5_12.addData(Util.longToBytes(var4_9.getRecoveryId()));
                                if (TraceComponent.isAnyTracingEnabled() && TransactionState.tc.isEventEnabled()) {
                                    Tr.event(TransactionState.tc, "SuperiorCoordinator logged ", var3_4);
                                }
                            } else {
                                var4_10 = this._tran.getRecoveryCoordinator();
                                if (var4_10 != null) {
                                    var5_13 = this._tranLog.createSection(4, true);
                                    var5_13.addData(Configuration.object_to_bytes(var4_10));
                                    if (TraceComponent.isAnyTracingEnabled() && TransactionState.tc.isEventEnabled()) {
                                        Tr.event(TransactionState.tc, "RecoveryCoordinator logged ", var4_10);
                                    }
                                } else {
                                    var5_14 = this._tran.getWSATRecoveryCoordinator();
                                    if (var5_14 != null) {
                                        var6_16 = this._tranLog.createSection(9, true);
                                        var6_16.addData(var5_14.toLogData());
                                        if (TraceComponent.isAnyTracingEnabled() && TransactionState.tc.isEventEnabled()) {
                                            Tr.event(TransactionState.tc, "WSATRecoveryCoordinator logged ", var5_14);
                                        }
                                    } else {
                                        if (TraceComponent.isAnyTracingEnabled() && TransactionState.tc.isEventEnabled()) {
                                            Tr.event(TransactionState.tc, "Null recovery coordinator for subordinate transaction.");
                                        }
                                        if (TraceComponent.isAnyTracingEnabled() && TransactionState.tc.isEntryEnabled()) {
                                            Tr.exit(TransactionState.tc, "setState");
                                        }
                                        throw new SystemException();
lbl70:
                                        // 1 sources

                                        if (TraceComponent.isAnyTracingEnabled() && TransactionState.tc.isEventEnabled()) {
                                            Tr.event(TransactionState.tc, "Superior transaction.");
                                        }
                                    }
                                }
                            }
                        }
                        if (TraceComponent.isAnyTracingEnabled() && TransactionState.tc.isDebugEnabled()) {
                            Tr.debug(TransactionState.tc, "Create sections in the Log for XID and TransactionState");
                        }
                        var3_4 = this._tranLog.createSection(3, true);
                        var3_4.addData(this._tran.getXidImpl().toBytes());
                        this._logSection = this._tranLog.createSection(0, true);
                        this._logSection.addData(this.byteData);
                    }
                    catch (Exception var3_5) {
                        FFDCFilter.processException((Throwable)var3_5, "com.ibm.ws.Transaction.JTA.TransactionState.setState", "408", this);
                        if (TraceComponent.isAnyTracingEnabled() && TransactionState.tc.isEntryEnabled()) {
                            Tr.exit(TransactionState.tc, "setState : CreateSection failed", var3_5);
                        }
                        this._logSection = null;
                        this._loggingFailed = true;
                        throw new SystemException(var3_5.toString());
                    }
                }
                if (this._logSection != null) {
                    block47: {
                        if (var1_1 == 4 || var1_1 == 6 || var1_1 == 5 || this._tran.isSubordinate() && var1_1 == 8) {
                            this.byteData[0] = (byte)this._state;
                            try {
                                this._logSection.addData(this.byteData);
                            }
                            catch (Exception var3_6) {
                                FFDCFilter.processException((Throwable)var3_6, "com.ibm.ws.Transaction.JTA.TransactionState.setState", "500", this);
                                if (!TraceComponent.isAnyTracingEnabled() || !TransactionState.tc.isEventEnabled()) break block47;
                                Tr.event(TransactionState.tc, "addData failed during setState!");
                            }
                        }
                    }
                    try {
                        switch (var1_1) {
                            case 2: {
                                if (!this._tran.isSubordinate()) break;
                                this._tranLog.forceSections();
                                break;
                            }
                            case 3: 
                            case 5: {
                                this._tranLog.forceSections();
                                break;
                            }
                            case 7: 
                            case 8: {
                                if (!this._tran.isSubordinate()) break;
                                this._tranLog.forceSections();
                                break;
                            }
                            case 4: 
                            case 6: {
                                break;
                            }
                            case 9: {
                                this._tranLog.forceSections();
                            }
                        }
                    }
                    catch (Exception var3_7) {
                        FFDCFilter.processException((Throwable)var3_7, "com.ibm.ws.Transaction.JTA.TransactionState.setState", "505", this);
                        if (var3_7 instanceof LogFullException) {
                            Tr.error(TransactionState.tc, "WTRN0083_LOG_FULL_ERROR", this._tran.getTranName());
                        } else {
                            Tr.error(TransactionState.tc, "WTRN0066_LOG_WRITE_ERROR", var3_7);
                        }
                        if (var2_2 == 1) {
                            this._logSection = null;
                            this._loggingFailed = true;
                            this._state = var2_2;
                        }
                        if (TraceComponent.isAnyTracingEnabled() && TransactionState.tc.isEntryEnabled()) {
                            Tr.exit(TransactionState.tc, "setState: Error writing log record", var3_7);
                        }
                        throw new SystemException(var3_7.toString());
                    }
                }
                break block51;
            }
            if (TraceComponent.isAnyTracingEnabled()) {
                if (TransactionState.tc.isDebugEnabled()) {
                    Tr.debug(TransactionState.tc, "TransactionState change FAILED from: " + TransactionState.stateToString(this._state) + ", to: " + TransactionState.stateToString(var1_1));
                }
                if (TransactionState.tc.isEntryEnabled()) {
                    Tr.exit(TransactionState.tc, "setState");
                }
            }
            throw new SystemException();
        }
        if (TraceComponent.isAnyTracingEnabled() && TransactionState.tc.isEntryEnabled()) {
            Tr.exit(TransactionState.tc, "setState");
        }
    }

    public void setCommittingStateUnlogged() {
        if (this._state == 1 || this._state == 9) {
            this._state = 3;
        }
    }

    public void setRollingBackStateUnlogged() {
        if (this._state == 1 || this._state == 9) {
            this._state = 5;
        }
    }

    public int getState() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "getState", TransactionState.stateToString(this._state));
        }
        return this._state;
    }

    void reset() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "reset");
        }
        this._state = -1;
    }

    public static String stateToString(int n) {
        switch (n) {
            case -1: {
                return "STATE_NONE";
            }
            case 0: {
                return "STATE_ACTIVE";
            }
            case 1: {
                return "STATE_PREPARING";
            }
            case 2: {
                return "STATE_PREPARED";
            }
            case 3: {
                return "STATE_COMMITTING";
            }
            case 4: {
                return "STATE_COMMITTED";
            }
            case 5: {
                return "STATE_ROLLING_BACK";
            }
            case 6: {
                return "STATE_ROLLED_BACK";
            }
            case 7: {
                return "STATE_HEURISTIC_ON_COMMIT";
            }
            case 8: {
                return "STATE_HEURISTIC_ON_ROLLBACK";
            }
            case 9: {
                return "STATE_LAST_PARTICIPANT";
            }
        }
        return "STATE_NONE";
    }

    public String toString() {
        return TransactionState.stateToString(this._state);
    }
}

