/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.Transaction.JTA;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.util.ByteArray;
import com.ibm.ws.Transaction.JTA.JCARecoveryData;
import com.ibm.ws.Transaction.JTA.JCATranWrapper;
import com.ibm.ws.Transaction.JTA.JCATranWrapperImpl;
import com.ibm.ws.Transaction.JTA.LocalTIDTable;
import com.ibm.ws.Transaction.JTA.TranManagerSet;
import com.ibm.ws.Transaction.JTA.TransactionImpl;
import com.ibm.ws.Transaction.JTA.TxXATerminator;
import com.ibm.ws.Transaction.JTA.Util;
import com.ibm.ws.Transaction.JTA.XidImpl;
import com.ibm.ws.Transaction.JTS.Configuration;
import com.ibm.ws.Transaction.TxProperties;
import com.ibm.ws.j2c.work.ExecutionContextHandler;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import javax.resource.spi.work.ExecutionContext;
import javax.resource.spi.work.WorkCompletedException;
import javax.transaction.InvalidTransactionException;
import javax.transaction.SystemException;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;

public final class TxExecutionContextHandler
implements ExecutionContextHandler {
    private static final TraceComponent tc = Tr.register(TxExecutionContextHandler.class, "Transaction", "com.ibm.ws.Transaction.resources.TransactionMsgs");
    private static final HashMap txnTable = new HashMap();

    public void associate(ExecutionContext executionContext, String string) throws WorkCompletedException {
        TxExecutionContextHandler.doAssociate(executionContext, string);
    }

    static void doAssociate(ExecutionContext executionContext, String string) throws WorkCompletedException {
        JCATranWrapper jCATranWrapper;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "doAssociate", new Object[]{executionContext, string});
        }
        if (null == executionContext) {
            WorkCompletedException workCompletedException = new WorkCompletedException("Invalid ExecutionContext", "3");
            Tr.error(tc, "WTRN0091_ASSOCIATE_FAILED", new Object[]{null, null});
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "doAssociate", "Invalid ExecutionContext");
            }
            throw workCompletedException;
        }
        Xid xid = executionContext.getXid();
        if (null == xid) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "doAssociate", "Null Xid");
            }
            return;
        }
        if (!TxXATerminator.isValid(xid)) {
            WorkCompletedException workCompletedException = new WorkCompletedException("Invalid Xid", "3");
            Tr.error(tc, "WTRN0091_ASSOCIATE_FAILED", new Object[]{executionContext, new Long(executionContext.getTransactionTimeout())});
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "doAssociate", "Invalid Xid");
            }
            throw workCompletedException;
        }
        if (TranManagerSet.instance().getUOWType() == 2) {
            WorkCompletedException workCompletedException = new WorkCompletedException("Already associated", "3");
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "doAssociate", "Already associated");
            }
            throw workCompletedException;
        }
        if (string == null) {
            WorkCompletedException workCompletedException = new WorkCompletedException("Invalid providerId: " + string, "3");
            Tr.error(tc, "WTRN0091_ASSOCIATE_FAILED", new Object[]{executionContext, new Long(executionContext.getTransactionTimeout())});
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "doAssociate", "Invalid providerId: " + string);
            }
            throw workCompletedException;
        }
        try {
            jCATranWrapper = TxExecutionContextHandler.findTxWrapper((int)executionContext.getTransactionTimeout(), xid, string);
        }
        catch (WorkCompletedException workCompletedException) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "doAssociate", "Can't create new tx while quiescing");
            }
            throw workCompletedException;
        }
        if (jCATranWrapper == null) {
            WorkCompletedException workCompletedException = new WorkCompletedException("Already have an association or already prepared", "2");
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "doAssociate", "Already have an association or already prepared");
            }
            throw workCompletedException;
        }
        try {
            TranManagerSet.instance().resume(jCATranWrapper.getTransaction());
        }
        catch (InvalidTransactionException invalidTransactionException) {
            WorkCompletedException workCompletedException = new WorkCompletedException("resume threw InvalidTransactionException", (Throwable)invalidTransactionException);
            workCompletedException.setErrorCode("3");
            Tr.error(tc, "WTRN0091_ASSOCIATE_FAILED", new Object[]{executionContext, new Long(executionContext.getTransactionTimeout())});
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "doAssociate", "resume threw InvalidTransactionException");
            }
            throw workCompletedException;
        }
        catch (IllegalStateException illegalStateException) {
            WorkCompletedException workCompletedException = new WorkCompletedException("resume threw IllegalStateException", (Throwable)illegalStateException);
            workCompletedException.setErrorCode("3");
            Tr.error(tc, "WTRN0091_ASSOCIATE_FAILED", new Object[]{executionContext, new Long(executionContext.getTransactionTimeout())});
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "doAssociate", "resume threw IllegalStateException");
            }
            throw workCompletedException;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "doAssociate");
        }
    }

    public void dissociate() {
        TxExecutionContextHandler.doDissociate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static TransactionImpl doDissociate() {
        TransactionImpl transactionImpl;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "doDissociate");
        }
        if ((transactionImpl = TranManagerSet.instance().getTransactionImpl()) != null) {
            JCATranWrapper jCATranWrapper;
            TranManagerSet.instance().suspend();
            Xid xid = transactionImpl.getXid();
            ByteArray byteArray = new ByteArray(xid.getGlobalTransactionId());
            HashMap hashMap = txnTable;
            synchronized (hashMap) {
                jCATranWrapper = (JCATranWrapper)txnTable.get(byteArray);
                if (null == jCATranWrapper) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "doDissociate", transactionImpl);
                    }
                    return transactionImpl;
                }
                jCATranWrapper.removeAssociation();
            }
            jCATranWrapper.resume();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "doDissociate", transactionImpl);
        }
        return transactionImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static JCATranWrapper getTxWrapper(Xid xid, boolean bl) throws XAException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getTxWrapper", new Object[]{xid, new Boolean(bl)});
        }
        ByteArray byteArray = new ByteArray(xid.getGlobalTransactionId());
        HashMap hashMap = txnTable;
        // MONITORENTER : hashMap
        JCATranWrapper jCATranWrapper = (JCATranWrapper)txnTable.get(byteArray);
        if (jCATranWrapper == null) {
            if (!tc.isEntryEnabled()) throw new XAException(-4);
            Tr.exit(tc, "getTxWrapper", "throwing XAER_NOTA");
            throw new XAException(-4);
        }
        if (bl) {
            if (jCATranWrapper.hasAssociation()) {
                if (!tc.isEntryEnabled()) throw new XAException(-6);
                Tr.exit(tc, "getTxWrapper", "throwing XAER_PROTO");
                throw new XAException(-6);
            }
            jCATranWrapper.addAssociation();
        }
        // MONITOREXIT : hashMap
        if (!tc.isEntryEnabled()) return jCATranWrapper;
        Tr.exit(tc, "getTxWrapper", jCATranWrapper);
        return jCATranWrapper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private static final JCATranWrapper findTxWrapper(int n, Xid xid, String string) throws WorkCompletedException {
        JCATranWrapper jCATranWrapper;
        block14: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "findTxWrapper", new Object[]{new Integer(n), xid, string});
            }
            ByteArray byteArray = new ByteArray(xid.getGlobalTransactionId());
            HashMap hashMap = txnTable;
            // MONITORENTER : hashMap
            if (!txnTable.containsKey(byteArray)) {
                if (TranManagerSet.instance().isQuiesced()) {
                    if (!tc.isEntryEnabled()) throw new WorkCompletedException("In quiesce period", "3");
                    Tr.exit(tc, "findTxWrapper", "quiescing");
                    throw new WorkCompletedException("In quiesce period", "3");
                }
                JCARecoveryData jCARecoveryData = (JCARecoveryData)TranManagerSet.instance().registerJCAProvider(string);
                try {
                    jCATranWrapper = new JCATranWrapperImpl(n, xid, jCARecoveryData);
                }
                catch (SystemException systemException) {
                    WorkCompletedException workCompletedException = new WorkCompletedException("Error creating transaction wrapper", (Throwable)systemException);
                    workCompletedException.setErrorCode("-1");
                    throw workCompletedException;
                }
                txnTable.put(byteArray, jCATranWrapper);
            } else {
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "Already encountered", byteArray);
                }
                if (!(jCATranWrapper = (JCATranWrapper)txnTable.get(byteArray)).hasAssociation()) {
                    if (!jCATranWrapper.isPrepared()) {
                        jCATranWrapper.addAssociation();
                        jCATranWrapper.suspend();
                        break block14;
                    } else {
                        if (tc.isEntryEnabled()) {
                            Tr.exit(tc, "findTxWrapper", "already prepared");
                        }
                        // MONITOREXIT : hashMap
                        return null;
                    }
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "findTxWrapper", "already associated");
                }
                // MONITOREXIT : hashMap
                return null;
            }
        }
        // MONITOREXIT : hashMap
        if (!tc.isEntryEnabled()) return jCATranWrapper;
        Tr.exit(tc, "findTxWrapper", jCATranWrapper);
        return jCATranWrapper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void addTxn(TransactionImpl transactionImpl) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addTxn", transactionImpl);
        }
        ByteArray byteArray = new ByteArray(transactionImpl.getXid().getGlobalTransactionId());
        HashMap hashMap = txnTable;
        synchronized (hashMap) {
            if (!txnTable.containsKey(byteArray)) {
                txnTable.put(byteArray, new JCATranWrapperImpl(transactionImpl, true, false));
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addTxn");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void removeTxn(Xid xid) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeTxn", xid);
        }
        ByteArray byteArray = new ByteArray(xid.getGlobalTransactionId());
        HashMap hashMap = txnTable;
        synchronized (hashMap) {
            txnTable.remove(byteArray);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removeTxn");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void stoppingProvider(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "stoppingProvider", string);
        }
        if (string == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "stoppingProvider", string);
            }
            return;
        }
        TransactionImpl transactionImpl = TxExecutionContextHandler.doDissociate();
        try {
            TransactionImpl[] transactionImplArray = LocalTIDTable.getAllTransactions();
            for (int i = 0; i < transactionImplArray.length; ++i) {
                TransactionImpl transactionImpl2 = transactionImplArray[i];
                if (transactionImpl2.getXidImpl().getEpoch() != Configuration.getCurrentEpoch() || !transactionImpl2.getResources().referencesProvider(string)) continue;
                transactionImpl2.recoverRollback(false);
            }
        }
        finally {
            if (transactionImpl != null) {
                TxExecutionContextHandler.reAssociate(transactionImpl);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "stoppingProvider");
        }
    }

    private static void reAssociate(TransactionImpl transactionImpl) {
        block8: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "reAssociate", transactionImpl);
            }
            if (transactionImpl.isRAImport()) {
                ExecutionContext executionContext = new ExecutionContext();
                executionContext.setXid(transactionImpl.getXid());
                try {
                    TxExecutionContextHandler.doAssociate(executionContext, transactionImpl.getJCARecoveryData().getWrapper().getProviderId());
                }
                catch (WorkCompletedException workCompletedException) {
                    if (tc.isEventEnabled()) {
                        Tr.exit(tc, "reAssociate", (Object)workCompletedException);
                    }
                    break block8;
                }
            }
            try {
                TranManagerSet.instance().resume(transactionImpl);
            }
            catch (Exception exception) {
                if (!tc.isEventEnabled()) break block8;
                Tr.event(tc, "reAssociate", exception);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "reAssociate");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final Xid[] recover(int n) throws XAException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "recover", Util.printFlag(n));
        }
        if (TranManagerSet.instance().isReplayComplete()) {
            Xid[] xidArray;
            HashMap hashMap = txnTable;
            synchronized (hashMap) {
                ArrayList arrayList = new ArrayList();
                if (TxProperties.NATIVE_CONTEXTS_USED) {
                    arrayList = TxExecutionContextHandler.getZXidsToRecover(arrayList);
                } else {
                    Iterator iterator = txnTable.values().iterator();
                    while (iterator.hasNext()) {
                        JCATranWrapper jCATranWrapper = (JCATranWrapper)iterator.next();
                        TransactionImpl transactionImpl = jCATranWrapper.getTransaction();
                        switch (transactionImpl.getTransactionState().getState()) {
                            case 2: 
                            case 7: 
                            case 8: {
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "recovering txn with state: " + transactionImpl.getTransactionState());
                                }
                                XidImpl xidImpl = transactionImpl.getJCAXid();
                                arrayList.add(xidImpl);
                                break;
                            }
                        }
                    }
                }
                xidArray = arrayList.toArray(new Xid[0]);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "recover", xidArray);
            }
            return xidArray;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "recover", "throwing XAER_RMFAIL");
        }
        throw new XAException(-7);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeAssociation(JCATranWrapper jCATranWrapper) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeAssociation", jCATranWrapper);
        }
        HashMap hashMap = txnTable;
        synchronized (hashMap) {
            jCATranWrapper.removeAssociation();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removeAssociation");
        }
    }

    private static ArrayList getZXidsToRecover(ArrayList arrayList) {
        byte[] byArray;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getZXidsToRecover");
        }
        if ((byArray = TxExecutionContextHandler.zosRecover()) != null) {
            ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
            byteBuffer.position(0);
            while (byteBuffer.hasRemaining()) {
                int n = byteBuffer.getInt();
                byte[] byArray2 = new byte[n];
                byteBuffer.get(byArray2, 0, n);
                XidImpl xidImpl = new XidImpl(byArray2);
                arrayList.add(xidImpl);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getZXidsToRecover", arrayList);
        }
        return arrayList;
    }

    private static native byte[] zosRecover();
}

