/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.Transaction.JTA;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.csi.EJBComponentMetaData;
import com.ibm.websphere.csi.LocalTranConfigData;
import com.ibm.websphere.models.extensions.helpers.ApplicationDataHelper;
import com.ibm.websphere.models.extensions.helpers.PMEApplicationExtensionHelper;
import com.ibm.websphere.models.extensions.lpsapplicationext.LastParticipantSupportExtension;
import com.ibm.ws.Transaction.TransactionManagerFactory;
import com.ibm.ws.exception.RuntimeError;
import com.ibm.ws.exception.RuntimeWarning;
import com.ibm.ws.runtime.metadata.ApplicationMetaData;
import com.ibm.ws.runtime.metadata.MetaData;
import com.ibm.ws.runtime.metadata.MetaDataEvent;
import com.ibm.ws.runtime.metadata.MetaDataListener;
import com.ibm.ws.runtime.metadata.MetaDataSlot;
import com.ibm.ws.runtime.service.MetaDataService;
import com.ibm.ws.wccm.services.pme.metadata.MetaDataHelperService;

public class TxMetaDataListener
implements MetaDataListener {
    private static final TraceComponent tc = Tr.register(TxMetaDataListener.class, "Transaction", "com.ibm.ws.Transaction.resources.TransactionMsgs");
    private static final TxMetaDataListener _instance = new TxMetaDataListener();
    private MetaDataSlot _applicationSlotLAOEnabled;
    private boolean _activitySessionServiceInstalled;
    private static MetaDataHelperService _metaDataHelperService;

    private TxMetaDataListener() {
        block4: {
            try {
                Object obj = Class.forName("com.ibm.ws.ActivitySession.ActivitySessionComponentImpl").newInstance();
                if (obj != null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "ActivitySession service installed - don't check associated LocalTran attributes in MetaDataListener");
                    }
                    this._activitySessionServiceInstalled = true;
                }
            }
            catch (Exception exception) {
                if (!tc.isDebugEnabled()) break block4;
                Tr.debug(tc, "ActivitySession service NOT installed - check associated LocalTran attributes in MetaDataListener");
            }
        }
    }

    public static TxMetaDataListener instance() {
        return _instance;
    }

    public void start(MetaDataService metaDataService, MetaDataHelperService metaDataHelperService) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "start", new Object[]{metaDataService, metaDataHelperService, this});
        }
        _metaDataHelperService = metaDataHelperService;
        this._applicationSlotLAOEnabled = metaDataService.reserveSlot(ApplicationMetaData.class);
        TransactionManagerFactory.getTransactionManager().setLPSMetaDataSlot(this._applicationSlotLAOEnabled);
        metaDataService.addMetaDataListener(this);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "start");
        }
    }

    public void metaDataCreated(MetaDataEvent metaDataEvent) throws RuntimeWarning, RuntimeError {
        MetaData metaData;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "metaDataCreated", new Object[]{metaDataEvent, this});
        }
        if ((metaData = metaDataEvent.getMetaData()) instanceof ApplicationMetaData) {
            this.LPSCheck((ApplicationMetaData)metaData);
        } else if (metaData instanceof EJBComponentMetaData) {
            this.localTranDeployCheck((EJBComponentMetaData)metaData);
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Ignoring meta data", metaData);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "metaDataCreated");
        }
    }

    private void LPSCheck(ApplicationMetaData applicationMetaData) {
        LastParticipantSupportExtension lastParticipantSupportExtension;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "LPSCheck", new Object[]{applicationMetaData, this});
        }
        ApplicationDataHelper applicationDataHelper = _metaDataHelperService.getExtensionHelper(applicationMetaData);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "ApplicationDataHelper", applicationDataHelper);
        }
        if (applicationDataHelper instanceof PMEApplicationExtensionHelper && (lastParticipantSupportExtension = ((PMEApplicationExtensionHelper)applicationDataHelper).getLastParticipantSupportExtension()) != null) {
            boolean bl = lastParticipantSupportExtension.isAcceptHeuristicHazard();
            applicationMetaData.setMetaData(this._applicationSlotLAOEnabled, new Boolean(bl));
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "LAOacceptHeuristicHazard value", new Boolean(bl));
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "LPSCheck");
        }
    }

    private void localTranDeployCheck(EJBComponentMetaData eJBComponentMetaData) throws RuntimeWarning {
        LocalTranConfigData localTranConfigData;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "localTranDeployCheck", new Object[]{eJBComponentMetaData, this});
        }
        if ((localTranConfigData = eJBComponentMetaData.getLocalTranConfigData()) != null) {
            int n;
            if (!this._activitySessionServiceInstalled && ((n = eJBComponentMetaData.getActivationPolicy()) == 1 || n == 0 && localTranConfigData.getValueBoundary() == 1)) {
                String string;
                String string2;
                switch (n) {
                    case 0: {
                        string2 = "ONCE";
                        break;
                    }
                    case 1: {
                        string2 = "ACTIVITY_SESSION";
                        break;
                    }
                    case 2: {
                        string2 = "TRANSACTION";
                        break;
                    }
                    default: {
                        string2 = "UNKNOWN";
                    }
                }
                switch (localTranConfigData.getValueBoundary()) {
                    case 1: {
                        string = "ACTIVITY_SESSION";
                        break;
                    }
                    case 0: {
                        string = "BEAN_METHOD";
                        break;
                    }
                    default: {
                        string = "UNKNOWN";
                    }
                }
                Object[] objectArray = new Object[]{eJBComponentMetaData.getJndiName(), string2, string};
                Tr.error(tc, "ERR_DEPLOY", objectArray);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "localTranDeployCheck", "Failing application install due to unsafe LocalTransaction attributes:\nactivationPolicy is: " + n + "\nLocalTranBoundary is: " + localTranConfigData.getValueBoundary());
                }
                RuntimeWarning runtimeWarning = new RuntimeWarning("Unsafe LocalTransaction attributes set on application");
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "localTranDeployCheck", runtimeWarning);
                }
                throw runtimeWarning;
            }
            if (eJBComponentMetaData.getEJBTransactionPolicy() == 1 && localTranConfigData.getValueResolver() == 1) {
                Object[] objectArray = new Object[]{eJBComponentMetaData.getJndiName()};
                Tr.error(tc, "ERR_DEPLOY_RESOLUTION", objectArray);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "localTranDeployCheck", "Failing application install due to unsupported LocalTransaction attributes:\ntransactions are bean managed but resolution control is ContainerAtBoundary");
                }
                RuntimeWarning runtimeWarning = new RuntimeWarning("Unsupported LocalTransaction attributes set on bean");
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "localTranDeployCheck", runtimeWarning);
                }
                throw runtimeWarning;
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "localTranData from EJBComponentMetaData is null - cannot perform test");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "localTranDeployCheck");
        }
    }

    public void metaDataDestroyed(MetaDataEvent metaDataEvent) {
    }
}

