/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.Transaction.JTA;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.Transaction.JTA.Util;

public final class TxPrimaryKey {
    private static final TraceComponent tc = Tr.register(TxPrimaryKey.class, "Transaction", "com.ibm.ws.Transaction.resources.TransactionMsgs");
    private final long _timestamp;
    private final int _epochNumber;
    private final int _sequenceNumber;
    private String _stringValue;

    public TxPrimaryKey(long l) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "<init>", Long.toHexString(l));
        }
        this._epochNumber = (int)(l >>> 32);
        this._sequenceNumber = (int)(l & 0xFFFFFFFFL);
        this._timestamp = System.nanoTime();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "<init>", this);
        }
    }

    public TxPrimaryKey(byte[] byArray) {
        this(byArray, 0);
    }

    TxPrimaryKey(byte[] byArray, int n) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "<init>", new Object[]{byArray, new Integer(n)});
        }
        byte[] byArray2 = byArray;
        this._epochNumber = Util.getIntFromBytes(byArray2, 8, 4);
        this._sequenceNumber = Util.getIntFromBytes(byArray2, 12, 4);
        this._timestamp = ((long)Util.getIntFromBytes(byArray2, 0, 4) & 0xFFFFFFFFL) << 32 | (long)Util.getIntFromBytes(byArray2, 4, 4) & 0xFFFFFFFFL;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "<init>", this);
        }
    }

    TxPrimaryKey(long l, int n) {
        this((int)l, n);
    }

    TxPrimaryKey(int n, int n2) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "<init>", new Object[]{new Integer(n), new Integer(n2)});
        }
        this._epochNumber = n2;
        this._sequenceNumber = n;
        this._timestamp = System.currentTimeMillis();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "<init>", this);
        }
    }

    public int getEpochNumber() {
        return this._epochNumber;
    }

    public int getSequenceNumber() {
        return this._sequenceNumber;
    }

    public long getTimeStamp() {
        return this._timestamp;
    }

    public int hashCode() {
        return this._sequenceNumber;
    }

    public byte[] toBytes() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "toBytes");
        }
        byte[] byArray = new byte[16];
        int n = (int)(this._timestamp >> 32 & 0xFFFFFFFFL);
        int n2 = (int)(this._timestamp & 0xFFFFFFFFL);
        Util.setBytesFromInt(byArray, 0, 4, n);
        Util.setBytesFromInt(byArray, 4, 4, n2);
        Util.setBytesFromInt(byArray, 8, 4, this._epochNumber);
        Util.setBytesFromInt(byArray, 12, 4, this._sequenceNumber);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "toBytes", com.ibm.ejs.util.Util.toHexString(byArray));
        }
        return byArray;
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof TxPrimaryKey) {
            TxPrimaryKey txPrimaryKey = (TxPrimaryKey)object;
            if (this._timestamp == txPrimaryKey._timestamp && this._sequenceNumber == txPrimaryKey._sequenceNumber && this._epochNumber == txPrimaryKey._epochNumber) {
                return true;
            }
        }
        return false;
    }

    public String toString() {
        if (this._stringValue == null) {
            this._stringValue = super.toString() + ";" + Long.toHexString(this._timestamp).toUpperCase() + ":" + Integer.toHexString(this._epochNumber).toUpperCase() + ":" + Integer.toHexString(this._sequenceNumber).toUpperCase();
        }
        return this._stringValue;
    }
}

