/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.Transaction.JTA;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.Transaction.JTA.JCARecoveryData;
import com.ibm.ws.Transaction.JTA.JCATranWrapper;
import com.ibm.ws.Transaction.JTA.NativeJCARecovery;
import com.ibm.ws.Transaction.JTA.TranManagerSet;
import com.ibm.ws.Transaction.JTA.TransactionImpl;
import com.ibm.ws.Transaction.JTA.TxExecutionContextHandler;
import com.ibm.ws.Transaction.JTA.Util;
import com.ibm.ws.Transaction.JTA.XAReturnCodeHelper;
import com.ibm.ws.Transaction.TxProperties;
import java.util.HashMap;
import javax.resource.spi.XATerminator;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;

public final class TxXATerminator
implements XATerminator {
    private static final TraceComponent tc = Tr.register(TxXATerminator.class, "Transaction", "com.ibm.ws.Transaction.resources.TransactionMsgs");
    private static final HashMap _txXATerminators = new HashMap();
    private JCARecoveryData _JCARecoveryData;
    private final String _providerId;

    private TxXATerminator(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "TxXATerminator", string);
        }
        this._providerId = string;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "TxXATerminator", this._providerId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TxXATerminator instance(String string) {
        TxXATerminator txXATerminator;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "instance", string);
        }
        HashMap hashMap = _txXATerminators;
        synchronized (hashMap) {
            if (_txXATerminators.containsKey(string)) {
                txXATerminator = (TxXATerminator)_txXATerminators.get(string);
            } else {
                txXATerminator = new TxXATerminator(string);
                _txXATerminators.put(string, txXATerminator);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "instance", txXATerminator);
        }
        return txXATerminator;
    }

    public void commit(Xid xid, boolean bl) throws XAException {
        JCATranWrapper jCATranWrapper;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "commit", new Object[]{xid, new Boolean(bl)});
        }
        try {
            this.validateXid(xid);
            jCATranWrapper = this.getTxWrapper(xid, true);
        }
        catch (XAException xAException) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "commit", "caught XAException: " + XAReturnCodeHelper.convertXACode(xAException.errorCode));
            }
            throw xAException;
        }
        try {
            if (bl) {
                jCATranWrapper.commitOnePhase();
            } else {
                jCATranWrapper.commit();
            }
        }
        catch (XAException xAException) {
            TxExecutionContextHandler.removeAssociation(jCATranWrapper);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "commit", "rethrowing XAException: " + XAReturnCodeHelper.convertXACode(xAException.errorCode));
            }
            throw xAException;
        }
        TxExecutionContextHandler.removeAssociation(jCATranWrapper);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "commit");
        }
    }

    public void forget(Xid xid) throws XAException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "forget", xid);
        }
        try {
            this.validateXid(xid);
            JCATranWrapper jCATranWrapper = this.getTxWrapper(xid, false);
            jCATranWrapper.forget();
        }
        catch (XAException xAException) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "forget", new Object[]{"rethrowing XAException", xAException});
            }
            throw xAException;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "forget");
        }
    }

    public int prepare(Xid xid) throws XAException {
        int n;
        JCATranWrapper jCATranWrapper;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "prepare", xid);
        }
        try {
            this.validateXid(xid);
            jCATranWrapper = this.getTxWrapper(xid, true);
        }
        catch (XAException xAException) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "prepare", new Object[]{"caught XAException", xAException});
            }
            throw xAException;
        }
        try {
            n = jCATranWrapper.prepare(this);
        }
        catch (XAException xAException) {
            TxExecutionContextHandler.removeAssociation(jCATranWrapper);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "prepare", new Object[]{"prepare threw XAException", xAException});
            }
            throw xAException;
        }
        TxExecutionContextHandler.removeAssociation(jCATranWrapper);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "prepare", new Integer(n));
        }
        return n;
    }

    public Xid[] recover(int n) throws XAException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "recover", Util.printFlag(n));
        }
        Xid[] xidArray = TxExecutionContextHandler.recover(n);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "recover", xidArray);
        }
        return xidArray;
    }

    public void rollback(Xid xid) throws XAException {
        JCATranWrapper jCATranWrapper;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "rollback", xid);
        }
        try {
            this.validateXid(xid);
            jCATranWrapper = this.getTxWrapper(xid, true);
        }
        catch (XAException xAException) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "rollback", "caught XAException: " + XAReturnCodeHelper.convertXACode(xAException.errorCode));
            }
            throw xAException;
        }
        try {
            jCATranWrapper.rollback();
        }
        catch (XAException xAException) {
            TxExecutionContextHandler.removeAssociation(jCATranWrapper);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "rollback", "rethrowing XAException: " + XAReturnCodeHelper.convertXACode(xAException.errorCode));
            }
            throw xAException;
        }
        TxExecutionContextHandler.removeAssociation(jCATranWrapper);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "rollback");
        }
    }

    private JCATranWrapper getTxWrapper(Xid xid, boolean bl) throws XAException {
        JCATranWrapper jCATranWrapper;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getTxWrapper", xid);
        }
        try {
            jCATranWrapper = TxExecutionContextHandler.getTxWrapper(xid, bl);
            TransactionImpl transactionImpl = jCATranWrapper.getTransaction();
            if (transactionImpl == null) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getTxWrapper", "no transaction was found for the specified XID");
                }
                throw new XAException(-4);
            }
        }
        catch (XAException xAException) {
            if (xAException.errorCode == -4 && TxProperties.NATIVE_CONTEXTS_USED) {
                jCATranWrapper = new NativeJCARecovery(xid);
            }
            throw xAException;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getTxWrapper", jCATranWrapper);
        }
        return jCATranWrapper;
    }

    private void validateXid(Xid xid) throws XAException {
        if (!TxXATerminator.isValid(xid)) {
            throw new XAException(-5);
        }
    }

    /*
     * Unable to fully structure code
     */
    public static boolean isValid(Xid var0) {
        if (null == var0 || -1 == var0.getFormatId() || null == var0.getGlobalTransactionId() || 0 > var0.getGlobalTransactionId().length) ** GOTO lbl-1000
        if (64 >= var0.getGlobalTransactionId().length) {
            v0 = true;
        } else lbl-1000:
        // 2 sources

        {
            v0 = var1_1 = false;
        }
        if (TxXATerminator.tc.isDebugEnabled()) {
            Tr.debug(TxXATerminator.tc, "isValid", new Boolean(var1_1));
        }
        return var1_1;
    }

    public String toString() {
        return "TxXATerminator: providerId=" + this._providerId;
    }

    public JCARecoveryData getJCARecoveryData() {
        if (this._JCARecoveryData == null) {
            this._JCARecoveryData = (JCARecoveryData)TranManagerSet.instance().registerJCAProvider(this._providerId);
        }
        return this._JCARecoveryData;
    }
}

