/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.Transaction.JTA;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;

public final class Util {
    private static TraceComponent tc = Tr.register(Util.class, "Transaction", "com.ibm.ws.Transaction.resources.TransactionMsgs");

    public static String printStatus(int n) {
        switch (n) {
            case 0: {
                return "Status.STATUS_ACTIVE";
            }
            case 3: {
                return "Status.STATUS_COMMITTED";
            }
            case 8: {
                return "Status.STATUS_COMMITTING";
            }
            case 1: {
                return "Status.STATUS_MARKED_ROLLBACK";
            }
            case 6: {
                return "Status.STATUS_NO_TRANSACTION";
            }
            case 2: {
                return "Status.STATUS_PREPARED";
            }
            case 7: {
                return "Status.STATUS_PREPARING";
            }
            case 4: {
                return "Status.STATUS_ROLLEDBACK";
            }
            case 9: {
                return "Status.STATUS_ROLLING_BACK";
            }
        }
        return "Status.STATUS_UNKNOWN";
    }

    public static String printFlag(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(Integer.toHexString(n));
        stringBuffer.append("=");
        if (n == 0) {
            stringBuffer.append("TMNOFLAGS");
        } else {
            if ((n & 0x800000) != 0) {
                stringBuffer.append("TMENDRSCAN|");
            }
            if ((n & 0x20000000) != 0) {
                stringBuffer.append("TMFAIL|");
            }
            if ((n & 0x200000) != 0) {
                stringBuffer.append("TMJOIN|");
            }
            if ((n & 0x40000000) != 0) {
                stringBuffer.append("TMONEPHASE|");
            }
            if ((n & 0x8000000) != 0) {
                stringBuffer.append("TMRESUME|");
            }
            if ((n & 0x1000000) != 0) {
                stringBuffer.append("TMSTARTRSCAN|");
            }
            if ((n & 0x4000000) != 0) {
                stringBuffer.append("TMSUCCESS|");
            }
            if ((n & 0x2000000) != 0) {
                stringBuffer.append("TMSUSPEND|");
            }
            stringBuffer.deleteCharAt(stringBuffer.length() - 1);
        }
        return stringBuffer.toString();
    }

    public static String identity(Object object) {
        if (object == null) {
            return "" + object;
        }
        return object.getClass().getName() + "@" + Integer.toHexString(System.identityHashCode(object));
    }

    public static byte[] duplicateByteArray(byte[] byArray) {
        if (byArray == null) {
            return null;
        }
        return Util.duplicateByteArray(byArray, 0, byArray.length);
    }

    public static byte[] duplicateByteArray(byte[] byArray, int n, int n2) {
        if (byArray == null) {
            return null;
        }
        byte[] byArray2 = new byte[n2];
        System.arraycopy(byArray, n, byArray2, 0, n2);
        return byArray2;
    }

    public static int getIntFromBytes(byte[] byArray, int n, int n2) {
        int n3 = 0;
        switch (n2) {
            case 4: {
                n3 |= byArray[n + 3] & 0xFF;
            }
            case 3: {
                n3 |= (byArray[n + 2] & 0xFF) << 8;
            }
            case 2: {
                n3 |= (byArray[n + 1] & 0xFF) << 16;
            }
            case 1: {
                n3 |= (byArray[n + 0] & 0xFF) << 24;
                break;
            }
            default: {
                IllegalArgumentException illegalArgumentException = new IllegalArgumentException("byteCount is not between 1 and 4");
                FFDCFilter.processException(illegalArgumentException, "com.ibm.ws.Transaction.JTA.Util.getIntFromBytes", "553");
                throw illegalArgumentException;
            }
        }
        return n3 >>= (4 - n2) * 8;
    }

    public static void setBytesFromInt(byte[] byArray, int n, int n2, int n3) {
        long l = (1L << 8 * n2) - 1L;
        if ((long)n3 > l) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("value too large for byteCount");
            FFDCFilter.processException(illegalArgumentException, "com.ibm.ws.Transaction.JTA.Util.setBytesFromInt", "579");
            throw illegalArgumentException;
        }
        switch (n2) {
            case 4: {
                byArray[n++] = (byte)(n3 >> 24 & 0xFF);
            }
            case 3: {
                byArray[n++] = (byte)(n3 >> 16 & 0xFF);
            }
            case 2: {
                byArray[n++] = (byte)(n3 >> 8 & 0xFF);
            }
            case 1: {
                byArray[n++] = (byte)(n3 & 0xFF);
                break;
            }
            default: {
                IllegalArgumentException illegalArgumentException = new IllegalArgumentException("byteCount is not between 1 and 4");
                FFDCFilter.processException(illegalArgumentException, "com.ibm.ws.Transaction.JTA.Util.setBytesFromInt", "598");
                throw illegalArgumentException;
            }
        }
    }

    public static long getLongFromBytes(byte[] byArray, int n) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getLongFromBytes: length = " + byArray.length + ", data = " + com.ibm.ejs.util.Util.toHexString(byArray));
        }
        long l = -1L;
        if (byArray.length >= n + 8) {
            l = ((byArray[0 + n] & 0xFF) << 56) + ((byArray[1 + n] & 0xFF) << 48) + ((byArray[2 + n] & 0xFF) << 40) + ((byArray[3 + n] & 0xFF) << 32) + ((byArray[4 + n] & 0xFF) << 24) + ((byArray[5 + n] & 0xFF) << 16) + ((byArray[6 + n] & 0xFF) << 8) + (byArray[7 + n] & 0xFF);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getLongFromBytes " + l);
        }
        return l;
    }

    public static byte[] longToBytes(long l) {
        return new byte[]{(byte)(l >> 56), (byte)(l >> 48), (byte)(l >> 40), (byte)(l >> 32), (byte)(l >> 24), (byte)(l >> 16), (byte)(l >> 8), (byte)l};
    }

    public static byte[] intToBytes(int n) {
        return new byte[]{(byte)(n >> 24), (byte)(n >> 16), (byte)(n >> 8), (byte)n};
    }
}

