/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.Transaction.JTA;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.util.ByteArray;
import com.ibm.ws.Transaction.JTA.FailureScopeController;
import com.ibm.ws.Transaction.JTA.PartnerLogData;
import com.ibm.ws.Transaction.JTA.RecoveryWrapper;
import com.ibm.ws.Transaction.JTA.WSCRecoveryData;
import com.ibm.ws.Transaction.JTS.Configuration;
import com.ibm.ws.Transaction.JTS.WSCoordinator;
import com.ibm.ws.Transaction.JTS.WSCoordinatorHelper;
import com.ibm.ws.ffdc.FFDCFilter;
import org.omg.CORBA.INV_OBJREF;

public final class WSCRecoveryWrapper
implements RecoveryWrapper {
    private static final TraceComponent tc = Tr.register(WSCRecoveryWrapper.class, "Transaction", "com.ibm.ws.Transaction.resources.TransactionMsgs");
    private final WSCoordinator _WSCoordinator;

    public WSCRecoveryWrapper(WSCoordinator wSCoordinator) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "WSCRecoveryWrapper", wSCoordinator);
        }
        this._WSCoordinator = wSCoordinator;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "WSCRecoveryWrapper");
        }
    }

    WSCRecoveryWrapper(byte[] byArray) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "WSCRecoveryWrapper", new ByteArray(byArray));
        }
        try {
            this._WSCoordinator = WSCoordinatorHelper.unchecked_narrow(Configuration.bytes_to_object(byArray));
            if (tc.isEventEnabled()) {
                Tr.event(tc, "object is", this._WSCoordinator);
            }
            if (this._WSCoordinator == null) {
                throw new INV_OBJREF();
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException(exception, "com.ibm.ws.Transaction.JTA.WSCRecoveryWrapper", "70");
            Tr.error(tc, "WTRN0040_OBJECT_DESERIALIZE_FAILED", exception);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "WSCRecoveryWrapper");
            }
            throw exception;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "WSCRecoveryWrapper");
        }
    }

    public WSCoordinator getWSCoordinator() {
        return this._WSCoordinator;
    }

    public boolean isSameAs(RecoveryWrapper recoveryWrapper) {
        if (recoveryWrapper instanceof WSCRecoveryWrapper && this._WSCoordinator != null) {
            return this._WSCoordinator._is_equivalent(((WSCRecoveryWrapper)recoveryWrapper).getWSCoordinator());
        }
        return false;
    }

    public byte[] serialize() {
        return Configuration.object_to_bytes(this._WSCoordinator);
    }

    public PartnerLogData container(FailureScopeController failureScopeController) {
        return new WSCRecoveryData(failureScopeController, this);
    }
}

