/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.Transaction.JTA;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.transaction.SystemException;

public class XAPdataWrapper {
    private static final int XA_PDATA_VERSION1 = 1;
    private static final int XA_PDATA_VERSION2 = 2;
    private static final int XA_PDATA_CURRENT_VERSION = 2;
    private static final int XA_PDATA_HEADER_SIZE = 16;
    private static final int XA_PDATA_ELEMENT_SIZE = 10;
    private static final TraceComponent tc = Tr.register(XAPdataWrapper.class, "Transaction", "com.ibm.ws.Transaction.resources.TransactionMsgs");
    private long[] _resourceTokens = null;
    private int[] _sequenceNumbers;
    private int _tokenCount;
    private byte[] _stoken = new byte[8];
    private boolean _isNormal;
    private int _expectedSize;

    public static int computeSize(int n) {
        return 16 + n * 10;
    }

    public XAPdataWrapper(int n) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "<init>", new Integer(n));
        }
        this._resourceTokens = new long[n];
        this._sequenceNumbers = new int[n];
        this._expectedSize = n;
        this._tokenCount = 0;
        this._isNormal = true;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "<init>");
        }
    }

    public XAPdataWrapper(byte[] byArray) throws SystemException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "<init>", byArray);
        }
        if (byArray == null || byArray.length > 0 && byArray.length < 16) {
            if (tc.isEventEnabled()) {
                Tr.event(tc, "Invalid persistent interest data", byArray);
            }
            SystemException systemException = new SystemException("Invalid persistent interest data");
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "<init>", (Object)systemException);
            }
            throw systemException;
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
        boolean bl = byArray.length == 0;
        try {
            int n;
            int n2 = n = bl ? 2 : dataInputStream.readInt();
            if (n != 1 && n != 2) {
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "Unexpected persistent data version", new Integer(n));
                }
                SystemException systemException = new SystemException("Unexpected persistent data version");
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "<init>", (Object)systemException);
                }
                throw systemException;
            }
            if (bl) {
                this._tokenCount = 0;
            } else {
                dataInputStream.readFully(this._stoken);
                this._tokenCount = dataInputStream.readInt();
            }
            this._expectedSize = this._tokenCount;
            this._resourceTokens = new long[this._tokenCount];
            this._sequenceNumbers = new int[this._tokenCount];
            for (int i = 0; i < this._tokenCount; ++i) {
                this._resourceTokens[i] = n == 1 ? (long)dataInputStream.readInt() : dataInputStream.readLong();
                this._sequenceNumbers[i] = dataInputStream.readShort();
            }
        }
        catch (IOException iOException) {
            FFDCFilter.processException((Throwable)iOException, this.getClass().getName() + ".<init>", "209", this);
            if (tc.isEventEnabled()) {
                Tr.event(tc, "Unexpected IO exception", iOException);
            }
            SystemException systemException = new SystemException(iOException.getMessage());
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "<init>", (Object)systemException);
            }
            throw systemException;
        }
        this._isNormal = false;
        if (tc.isEntryEnabled()) {
            Object[] objectArray = new Object[]{new Integer(this._tokenCount), this._stoken};
            Tr.exit(tc, "<init>", objectArray);
        }
    }

    public void addResourceToken(long l, int n) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addResourceToken", new Object[]{new Long(l), new Integer(n)});
        }
        if (!this._isNormal) {
            IllegalStateException illegalStateException = new IllegalStateException("Illegal attempt to modifiy restart data");
            FFDCFilter.processException((Throwable)illegalStateException, this.getClass().getName() + ".addResourceToken", "253", this);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "addResourceToken", illegalStateException);
            }
            throw illegalStateException;
        }
        if (this._tokenCount >= this._expectedSize) {
            if (tc.isEventEnabled()) {
                Tr.event(tc, "Resource token count exceeds expected value", new Integer(this._tokenCount));
            }
            IndexOutOfBoundsException indexOutOfBoundsException = new IndexOutOfBoundsException("Resource token count exceeds expected value");
            FFDCFilter.processException((Throwable)indexOutOfBoundsException, this.getClass().getName() + ".addResourceToken", "268", this);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "addResourceToken", indexOutOfBoundsException);
            }
            throw indexOutOfBoundsException;
        }
        this._resourceTokens[this._tokenCount] = l;
        this._sequenceNumbers[this._tokenCount] = n;
        ++this._tokenCount;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addResourceToken");
        }
    }

    public byte[] getBytes() throws SystemException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getBytes");
        }
        if (this._expectedSize != this._tokenCount) {
            if (tc.isEventEnabled()) {
                Tr.event(tc, "XAPdataWrapper error: getBytes has {0} resource tokens but should have {1} resource tokens", new Object[]{new Integer(this._tokenCount), new Integer(this._expectedSize)});
            }
            SystemException systemException = new SystemException("Not enough resource tokens");
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getBytes", (Object)systemException);
            }
            throw systemException;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        try {
            dataOutputStream.writeInt(2);
            dataOutputStream.write(this._stoken, 0, this._stoken.length);
            dataOutputStream.writeInt(this._expectedSize);
            for (int i = 0; i < this._expectedSize; ++i) {
                dataOutputStream.writeLong(this._resourceTokens[i]);
                dataOutputStream.writeShort(this._sequenceNumbers[i]);
            }
            dataOutputStream.flush();
        }
        catch (IOException iOException) {
            FFDCFilter.processException((Throwable)iOException, this.getClass().getName() + ".getBytes", "340", this);
            if (tc.isEventEnabled()) {
                Tr.event(tc, "Unexpected IO exception", iOException);
            }
            SystemException systemException = new SystemException(iOException.getMessage());
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getBytes", (Object)systemException);
            }
            throw systemException;
        }
        byte[] byArray = byteArrayOutputStream.toByteArray();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getBytes", byArray);
        }
        return byArray;
    }

    public int getNumberOfResources() {
        return this._tokenCount;
    }

    public long getResourceToken(int n) {
        return this._resourceTokens[n];
    }

    public byte[] getStoken() {
        return this._stoken;
    }

    public void setStoken(byte[] byArray) {
        this._stoken = byArray;
    }

    public int getSequenceNumber(int n) {
        return this._sequenceNumbers[n];
    }
}

