/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.Transaction.JTA;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.util.Util;
import com.ibm.ws.Transaction.JTA.FailureScopeController;
import com.ibm.ws.Transaction.JTA.PartnerLogData;
import com.ibm.ws.Transaction.JTA.RecoveryManager;
import com.ibm.ws.Transaction.JTA.XARecoveryWrapper;
import com.ibm.ws.Transaction.JTA.XAReturnCodeHelper;
import com.ibm.ws.Transaction.JTA.XARminst;
import com.ibm.ws.Transaction.JTA.XidImpl;
import com.ibm.ws.Transaction.JTS.Configuration;
import com.ibm.ws.Transaction.ResourceManagerSupportsIsSameRM;
import com.ibm.ws.Transaction.Ws390UnknownFailureScopeException;
import com.ibm.ws.Transaction.Ws390XAResourceFactory;
import com.ibm.ws.Transaction.XARecoveryCollaborator;
import com.ibm.ws.Transaction.XAResourceFactory;
import com.ibm.ws.Transaction.XAResourceInfo;
import com.ibm.ws.Transaction.XAResourceNotAvailableException;
import com.ibm.ws.classloader.ExtJarClassLoader;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.j2c.ProviderAccessor;
import com.ibm.ws.recoverylog.spi.RecoveryLog;
import com.ibm.ws.runtime.component.TxServiceImpl;
import com.ibm.ws.security.util.AccessController;
import java.io.File;
import java.security.PrivilegedAction;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.StringTokenizer;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;

public final class XARecoveryData
extends PartnerLogData {
    private static final TraceComponent tc = Tr.register(XARecoveryData.class, "Transaction", "com.ibm.ws.Transaction.resources.TransactionMsgs");
    private static HashSet systemClassPathSet = new HashSet();
    private boolean _supportsIsSameRM = false;
    private ClassLoader _recoveryClassLoader;
    private byte[] _wrapperData = null;
    private final String[] _extDirs;

    XARecoveryData(FailureScopeController failureScopeController, XARecoveryWrapper xARecoveryWrapper) {
        super(xARecoveryWrapper, failureScopeController);
        this._sectionId = 34;
        this._extDirs = xARecoveryWrapper.getXAResourceFactoryClasspath();
        if (xARecoveryWrapper.getXAResourceInfo() instanceof ResourceManagerSupportsIsSameRM && !Configuration.getTxServiceImpl().disableIsSameRM()) {
            this._supportsIsSameRM = true;
        }
    }

    public XARecoveryData(RecoveryLog recoveryLog, byte[] byArray, long l) {
        super(byArray, null, l, recoveryLog);
        int n = 0;
        for (int i = 0; i < byArray.length; ++i) {
            if (byArray[i] != 0) continue;
            n = i;
            break;
        }
        this._wrapperData = new byte[byArray.length - n - 1];
        System.arraycopy(byArray, n + 1, this._wrapperData, 0, this._wrapperData.length);
        if (n > 0) {
            byte[] byArray2 = new byte[n];
            System.arraycopy(byArray, 0, byArray2, 0, byArray2.length);
            String string = new String(byArray2);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Classpath data recovered", string);
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string, File.pathSeparator);
            this._extDirs = new String[stringTokenizer.countTokens()];
            for (int i = 0; i < this._extDirs.length; ++i) {
                this._extDirs[i] = stringTokenizer.nextToken();
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "_extDirs[" + i + "] = " + this._extDirs[i]);
            }
        } else {
            this._extDirs = null;
        }
    }

    void preLogData() throws Exception {
        Configuration.getFailureScopeController().getRecoveryManager().checkClassPath();
    }

    public void deserialize(ClassLoader classLoader) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "deserialize", new Object[]{this, classLoader});
        }
        this._recoveryClassLoader = XARecoveryData.buildRecoveryClassLoader(this._extDirs, classLoader);
        XARecoveryWrapper xARecoveryWrapper = XARecoveryWrapper.deserialize(this._wrapperData, this._recoveryClassLoader);
        if (xARecoveryWrapper != null) {
            if (this._extDirs != null) {
                xARecoveryWrapper.setXAResourceFactoryClasspath(this._extDirs);
            }
            this._logData = xARecoveryWrapper;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "deserialize");
        }
    }

    public XARecoveryWrapper getXARecoveryWrapper() {
        return (XARecoveryWrapper)this._logData;
    }

    static ClassLoader buildRecoveryClassLoader(String[] stringArray, ClassLoader classLoader) {
        String[] stringArray2;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "buildRecoveryClassLoader", stringArray);
        }
        final ClassLoader classLoader2 = classLoader;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "parent classloader", classLoader2);
        }
        if ((stringArray2 = XARecoveryData.nonSystemClassPathSubset(stringArray)).length == 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "given classpath is subset of system classpath");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "buildRecoveryClassLoader", classLoader2);
            }
            return classLoader2;
        }
        ExtJarClassLoader extJarClassLoader = (ExtJarClassLoader)AccessController.doPrivileged((PrivilegedAction)new PrivilegedAction(){

            public Object run() {
                return new ExtJarClassLoader(stringArray2, classLoader2, null, false);
            }
        });
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "buildRecoveryClassLoader", extJarClassLoader);
        }
        return extJarClassLoader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String[] nonSystemClassPathSubset(String[] stringArray) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "nonSystemClassPathSubset", stringArray);
        }
        if (stringArray == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "nonSystemClassPathSubset", "empty");
            }
            return new String[0];
        }
        AbstractCollection abstractCollection = systemClassPathSet;
        synchronized (abstractCollection) {
            if (systemClassPathSet.isEmpty()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Building systemClassPathSet");
                }
                String string = Configuration.getClassLoader().getClassPath();
                StringTokenizer stringTokenizer = new StringTokenizer(string, File.pathSeparator);
                while (stringTokenizer.hasMoreTokens()) {
                    systemClassPathSet.add(new File(stringTokenizer.nextToken()));
                }
            }
        }
        abstractCollection = new ArrayList();
        int n = stringArray.length;
        while (--n >= 0) {
            if (systemClassPathSet.contains(new File(stringArray[n]))) continue;
            ((ArrayList)abstractCollection).add(stringArray[n]);
            if (!tc.isDebugEnabled()) continue;
            Tr.debug(tc, "New path: " + stringArray[n]);
        }
        String[] stringArray2 = ((ArrayList)abstractCollection).toArray(new String[((ArrayList)abstractCollection).size()]);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "nonSystemClassPathSubset", stringArray2);
        }
        return stringArray2;
    }

    XARminst getXARminst() throws XAException {
        return this.getXARminst(null);
    }

    public XARminst getXARminst(byte[] byArray) throws XAException {
        XAResource xAResource;
        XAResourceFactory xAResourceFactory;
        ClassLoader classLoader;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getXARminst", new Object[]{byArray, this});
        }
        if ((classLoader = this._recoveryClassLoader) == null) {
            classLoader = XARecoveryData.buildRecoveryClassLoader(this._extDirs, (ClassLoader)Configuration.getClassLoader());
        }
        XARecoveryWrapper xARecoveryWrapper = (XARecoveryWrapper)this._logData;
        String string = xARecoveryWrapper.getXAResourceFactoryClassName();
        Class<?> clazz = null;
        try {
            try {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "calling Class.forName", string);
                }
                clazz = Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "forName returns", classNotFoundException);
                }
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "forName returns", noClassDefFoundError);
                }
            }
            catch (Throwable throwable) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "forName returns", throwable);
                }
                throw throwable;
            }
            if (clazz == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "calling recovery classloader Class.forName", string);
                }
                clazz = Class.forName(string, true, classLoader);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "xaResFactoryClass", new Object[]{clazz, clazz.getClassLoader()});
            }
            xAResourceFactory = (XAResourceFactory)clazz.newInstance();
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.Transaction.JTA.XARecoveryData.getXARminst", "419");
            Tr.error(tc, "WTRN0004_CANT_CREATE_XARESOURCEFACTORY", new Object[]{string, throwable});
            XAException xAException = new XAException(-3);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getXARminst", xAException);
            }
            throw xAException;
        }
        XAResourceInfo xAResourceInfo = null;
        ClassLoader classLoader2 = null;
        try {
            if (classLoader != null) {
                classLoader2 = Thread.currentThread().getContextClassLoader();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Setting recovery classloader on thread");
                }
                Thread.currentThread().setContextClassLoader(classLoader);
            }
            if (!this.canProceed(xAResourceInfo = xARecoveryWrapper.getXAResourceInfo())) {
                throw new XAResourceNotAvailableException();
            }
            if (xAResourceFactory instanceof Ws390XAResourceFactory) {
                xAResource = ((Ws390XAResourceFactory)xAResourceFactory).getXAResource(xAResourceInfo, byArray);
            } else {
                xAResource = xAResourceFactory.getXAResource(xAResourceInfo);
                if (null == xAResource) {
                    throw new XAResourceNotAvailableException();
                }
            }
        }
        catch (Ws390UnknownFailureScopeException ws390UnknownFailureScopeException) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event(tc, "UnknownFailureScopeException", ws390UnknownFailureScopeException);
            }
            Throwable throwable = new XAException(5).initCause(ws390UnknownFailureScopeException);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "getXARminst", throwable);
            }
            throw (XAException)throwable;
        }
        catch (XAResourceNotAvailableException xAResourceNotAvailableException) {
            int n;
            FFDCFilter.processException((Throwable)xAResourceNotAvailableException, "com.ibm.ws.Transaction.JTA.XARecoveryData.getXARminst", "491", this);
            String string2 = null;
            if (xAResourceInfo instanceof ProviderAccessor) {
                string2 = ((ProviderAccessor)((Object)xAResourceInfo)).getProviderId();
            }
            if (!TxServiceImpl.isProviderInstalled(string2)) {
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "Cannot create XAResource object because provider has been uninstalled", xAResourceNotAvailableException);
                }
                n = 5;
            } else {
                n = -7;
            }
            if (RecoveryManager.recoveryOnlyMode || RecoveryManager.appsAreLoaded()) {
                Tr.warning(tc, "WTRN0005_CANT_RECREATE_XARESOURCE", new Object[]{xAResourceInfo, xAResourceNotAvailableException});
            }
            Throwable throwable = new XAException(n).initCause(xAResourceNotAvailableException);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getXARminst", throwable);
            }
            throw (XAException)throwable;
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.Transaction.JTA.PartnerLogTable.getXARminst", "563");
            Tr.error(tc, "WTRN0005_CANT_RECREATE_XARESOURCE", new Object[]{xAResourceInfo, throwable});
            Throwable throwable2 = new XAException(-3).initCause(throwable);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getXARminst", throwable2);
            }
            throw (XAException)throwable2;
        }
        finally {
            if (classLoader2 != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Taking recovery classloader off thread");
                }
                Thread.currentThread().setContextClassLoader(classLoader2);
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "xaResource", new Object[]{xAResource, xAResource.getClass().getClassLoader()});
        }
        XARminst xARminst = new XARminst(xAResource, xAResourceFactory);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getXARminst", xARminst);
        }
        return xARminst;
    }

    public boolean recover(ClassLoader classLoader, Xid[] xidArray, byte[] byArray, byte[] byArray2, int n) {
        Object object;
        int n2;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "recover", new Object[]{classLoader, xidArray, byArray, byArray2, new Integer(n), this});
        }
        if (this._recovered) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "recover", "recovered");
            }
            return true;
        }
        if (this._terminating) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "recover", "terminating");
            }
            return false;
        }
        if (this._logData == null) {
            this.deserialize(classLoader);
            if (this._logData == null) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "recover", "deserialize failed");
                }
                return RecoveryManager.recoveryOnlyMode;
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "recovering", this._logData);
        }
        XARminst xARminst = null;
        try {
            xARminst = this.getXARminst(byArray);
            if (xARminst == null) {
                throw new XAException(-3);
            }
        }
        catch (XAException xAException) {
            boolean bl;
            switch (xAException.errorCode) {
                case 5: {
                    this.decrementCount();
                    this._recovered = true;
                }
                case -7: {
                    bl = this._recovered;
                    break;
                }
                default: {
                    bl = RecoveryManager.recoveryOnlyMode;
                }
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "recover", new Boolean(bl));
            }
            return bl;
        }
        Xid[] xidArray2 = null;
        int n3 = 0;
        try {
            xidArray2 = xARminst.recover();
            this._recovered = true;
            n3 = xidArray2.length;
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.Transaction.JTA.XARecoveryData.recover", "564", this);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Resource returned " + n3 + " Xids");
            for (int i = 0; i < n3; ++i) {
                if (xidArray2[i] == null) continue;
                n2 = xidArray2[i].getFormatId();
                object = xidArray2[i].getGlobalTransactionId();
                byte[] byArray3 = xidArray2[i].getBranchQualifier();
                Tr.debug(tc, "Trace Xid[" + i + "] FormatID: " + Integer.toHexString(n2));
                Tr.debug(tc, "Trace Xid[" + i + "] Gtrid: " + Util.toHexString((byte[])object));
                Tr.debug(tc, "Trace Xid[" + i + "] Bqual: " + Util.toHexString(byArray3));
            }
        }
        ArrayList arrayList = this.filterXidsByType(xidArray2);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "After type filter, Xids to recover " + arrayList.size());
        }
        if (byArray != null && byArray.length != 0) {
            arrayList = this.filterXidsByStoken(arrayList, byArray);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "After filter by failed stoken, Xids to recover " + arrayList.size());
            }
        } else {
            arrayList = this.filterXidsByCruuidAndEpoch(arrayList, byArray2, n);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "After filter by cruuid and epoch, Xids to recover " + arrayList.size());
            }
        }
        for (n2 = 0; n2 < arrayList.size(); ++n2) {
            object = (XidImpl)arrayList.get(n2);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Recovering Xid[" + n2 + "]", object);
            }
            if (xidArray != null && !this.canWeForgetXid((XidImpl)object, xidArray)) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Found XID with no associated transaction");
            }
            try {
                xARminst.rollback((Xid)object);
                continue;
            }
            catch (XAException xAException) {
                FFDCFilter.processException((Throwable)xAException, "com.ibm.ws.Transaction.JTA.XARecoveryData.recover", "660", this);
                int n4 = xAException.errorCode;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "XAException: error code " + XAReturnCodeHelper.convertXACode(n4), xAException);
                }
                if (n4 != -7 && n4 != -3) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Forcing retry of recovery");
                }
                this._recovered = false;
            }
        }
        xARminst.closeConnection();
        if (this._recovered) {
            this.decrementCount();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "recover", new Boolean(this._recovered));
        }
        return this._recovered;
    }

    private ArrayList filterXidsByType(Xid[] xidArray) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "filterXidsByType", xidArray);
        }
        ArrayList<XidImpl> arrayList = new ArrayList<XidImpl>();
        if (xidArray != null) {
            for (int i = 0; i < xidArray.length; ++i) {
                if (xidArray[i] == null) {
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "RM has returned null inDoubt Xid entry - " + i);
                    continue;
                }
                if (!XidImpl.isOurFormatId(xidArray[i].getFormatId())) continue;
                XidImpl xidImpl = null;
                if (xidArray[i] instanceof XidImpl) {
                    xidImpl = (XidImpl)xidArray[i];
                } else {
                    xidImpl = new XidImpl(xidArray[i]);
                    if (xidImpl.getBranchQualifier().length != 54) {
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "Xid is wrong length - " + i);
                        continue;
                    }
                }
                arrayList.add(xidImpl);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "filterXidsByType", arrayList);
        }
        return arrayList;
    }

    private ArrayList filterXidsByCruuidAndEpoch(ArrayList arrayList, byte[] byArray, int n) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "filterXidsByCruuidAndEpoch", new Object[]{arrayList, byArray, new Integer(n)});
        }
        for (int i = arrayList.size() - 1; i >= 0; --i) {
            XidImpl xidImpl = (XidImpl)arrayList.get(i);
            byte[] byArray2 = xidImpl.getCruuid();
            int n2 = xidImpl.getEpoch();
            if (Arrays.equals(byArray, byArray2) && n2 < n) continue;
            arrayList.remove(i);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "filterXidsByCruuidAndEpoch", arrayList);
        }
        return arrayList;
    }

    private ArrayList filterXidsByStoken(ArrayList arrayList, byte[] byArray) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "filterXidsByStoken", new Object[]{arrayList, byArray});
        }
        for (int i = arrayList.size() - 1; i >= 0; --i) {
            XidImpl xidImpl = (XidImpl)arrayList.get(i);
            byte[] byArray2 = xidImpl.getStoken();
            if (Arrays.equals(byArray, byArray2)) continue;
            arrayList.remove(i);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "filterXidsByStoken", arrayList);
        }
        return arrayList;
    }

    private boolean canWeForgetXid(XidImpl xidImpl, Xid[] xidArray) {
        boolean bl;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "canWeForgetXid", new Object[]{xidImpl, xidArray});
        }
        if (tc.isDebugEnabled()) {
            for (bl = false; bl < xidArray.length; bl += 1) {
                Tr.debug(tc, "tx xid[" + (int)(bl ? 1 : 0) + "] " + xidArray[bl]);
            }
        }
        bl = true;
        int n = xidImpl.getFormatId();
        byte[] byArray = xidImpl.getGlobalTransactionId();
        byte[] byArray2 = xidImpl.getBranchQualifier();
        byte[] byArray3 = null;
        for (int i = 0; i < xidArray.length && bl; ++i) {
            if (i == 0) {
                int n2 = xidArray[i].getBranchQualifier().length;
                byArray3 = new byte[n2];
                System.arraycopy(byArray2, 0, byArray3, 0, n2);
            }
            int n3 = xidArray[i].getFormatId();
            byte[] byArray4 = xidArray[i].getGlobalTransactionId();
            byte[] byArray5 = xidArray[i].getBranchQualifier();
            if (n != n3 || !Arrays.equals(byArray, byArray4) || !Arrays.equals(byArray3, byArray5)) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Xid has been matched to a transaction:", xidImpl);
            }
            bl = false;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "canWeForgetXid", new Boolean(bl));
        }
        return bl;
    }

    public synchronized boolean clearIfNotInUse() {
        boolean bl = super.clearIfNotInUse();
        if (bl) {
            this._recoveryClassLoader = null;
        }
        return bl;
    }

    private boolean canProceed(XAResourceInfo xAResourceInfo) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "canProceed", xAResourceInfo);
        }
        if (RecoveryManager.appsAreLoaded()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "canProceed", Boolean.TRUE);
            }
            return true;
        }
        if (xAResourceInfo instanceof XARecoveryCollaborator) {
            boolean bl;
            boolean bl2 = bl = !((XARecoveryCollaborator)((Object)xAResourceInfo)).recoverWhenServerStarted();
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "canProceed", bl);
            }
            return bl;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "canProceed", Boolean.TRUE);
        }
        return true;
    }

    public ClassLoader getRecoveryClassLoader() {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getRecoveryClassLoader", this._recoveryClassLoader);
        }
        return this._recoveryClassLoader;
    }

    public boolean supportsIsSameRM() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "supportsIsSameRM");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "supportsIsSameRM", this._supportsIsSameRM);
        }
        return this._supportsIsSameRM;
    }
}

