/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.Transaction.JTA;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.Transaction.JTA.FailureScopeController;
import com.ibm.ws.Transaction.JTA.PartnerLogData;
import com.ibm.ws.Transaction.JTA.RecoveryWrapper;
import com.ibm.ws.Transaction.JTA.XARecoveryData;
import com.ibm.ws.Transaction.JTS.Configuration;
import com.ibm.ws.Transaction.XAResourceInfo;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.util.WsObjectInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;

public final class XARecoveryWrapper
implements RecoveryWrapper {
    private static final TraceComponent tc = Tr.register(XARecoveryWrapper.class, "Transaction", "com.ibm.ws.Transaction.resources.TransactionMsgs");
    private static final long serialVersionUID = -4128788408195351556L;
    private final String _xaResFactoryClassName;
    private final XAResourceInfo _xaResInfo;
    private transient String[] _xaResFactoryClasspath;

    public XARecoveryWrapper(String string, XAResourceInfo xAResourceInfo) {
        this(string, xAResourceInfo, null);
    }

    public XARecoveryWrapper(String string, XAResourceInfo xAResourceInfo, String[] stringArray) {
        this._xaResFactoryClassName = string;
        this._xaResInfo = xAResourceInfo;
        this._xaResFactoryClasspath = this.canonicalise(stringArray);
    }

    public boolean isSameAs(RecoveryWrapper recoveryWrapper) {
        if (this == recoveryWrapper) {
            return true;
        }
        if (recoveryWrapper != null && recoveryWrapper instanceof XARecoveryWrapper) {
            XARecoveryWrapper xARecoveryWrapper = (XARecoveryWrapper)recoveryWrapper;
            if (((Object)this._xaResInfo).equals(xARecoveryWrapper.getXAResourceInfo())) {
                if (this._xaResFactoryClassName.equals(xARecoveryWrapper.getXAResourceFactoryClassName())) {
                    Object[] objectArray = this.getXAResourceFactoryClasspath();
                    Object[] objectArray2 = xARecoveryWrapper.getXAResourceFactoryClasspath();
                    if (objectArray != null && objectArray.length == 0) {
                        objectArray = null;
                    }
                    if (objectArray2 != null && objectArray2.length == 0) {
                        objectArray2 = null;
                    }
                    if (Arrays.equals(objectArray, objectArray2)) {
                        return true;
                    }
                    if (tc.isDebugEnabled()) {
                        int n;
                        Tr.debug(tc, "XAResFactoryClasspaths differ");
                        if (this._xaResFactoryClasspath != null) {
                            for (n = 0; n < this._xaResFactoryClasspath.length; ++n) {
                                Tr.debug(tc, "this classpath[" + n + "]=" + this._xaResFactoryClasspath[n]);
                            }
                        }
                        if (xARecoveryWrapper._xaResFactoryClasspath != null) {
                            for (n = 0; n < xARecoveryWrapper._xaResFactoryClasspath.length; ++n) {
                                Tr.debug(tc, "other classpath[" + n + "]=" + xARecoveryWrapper._xaResFactoryClasspath[n]);
                            }
                        }
                    }
                } else if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "XAResFactoryClassNames differ", new Object[]{this._xaResFactoryClassName, xARecoveryWrapper.getXAResourceFactoryClassName()});
                }
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "XAResInfos differ", new Object[]{this._xaResInfo, xARecoveryWrapper.getXAResourceInfo()});
            }
        }
        return false;
    }

    public byte[] serialize() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "serialize", this);
        }
        byte[] byArray = null;
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(this);
            objectOutputStream.flush();
            objectOutputStream.close();
            byArray = byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            FFDCFilter.processException(iOException, "com.ibm.ws.Transaction.JTA.XARecoveryWrapper.serialize", "162");
            if (tc.isEventEnabled()) {
                Tr.event(tc, "Unable to serialize an object to the byte stream", iOException);
            }
            byArray = null;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "serialize", byArray);
        }
        return byArray;
    }

    public PartnerLogData container(FailureScopeController failureScopeController) {
        Serializable serializable;
        Object object;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "container", failureScopeController);
        }
        XARecoveryData xARecoveryData = new XARecoveryData(failureScopeController, this);
        byte[] byArray = this.serialize();
        String[] stringArray = this._xaResFactoryClasspath;
        if (byArray == null) {
            Tr.warning(tc, "WTRN0039_SERIALIZE_FAILED");
            object = new NotSerializableException("XAResource recovery information failed serialization");
            Tr.audit(tc, "WTRN0045_CANNOT_RECOVER_RESOURCE", new Object[]{this._xaResInfo, object});
        } else {
            try {
                object = XARecoveryData.buildRecoveryClassLoader(stringArray, (ClassLoader)Configuration.getClassLoader());
                serializable = XARecoveryWrapper.deserialize(byArray, (ClassLoader)object);
                if (serializable != null) {
                    ((XARecoveryWrapper)serializable).setXAResourceFactoryClasspath(stringArray);
                }
                if (!this.isSameAs((RecoveryWrapper)serializable)) {
                    Tr.error(tc, "WTRN0040_OBJECT_DESERIALIZE_FAILED", null);
                    Tr.audit(tc, "WTRN0045_CANNOT_RECOVER_RESOURCE", new Object[]{this._xaResInfo, null});
                    byArray = null;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "XAResourceInfo fails equality test");
                    }
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException(exception, "com.ibm.ws.Transaction.JTA.XARecoveryWrapper.container", "193");
                Tr.error(tc, "WTRN0040_OBJECT_DESERIALIZE_FAILED", exception);
                Tr.audit(tc, "WTRN0045_CANNOT_RECOVER_RESOURCE", new Object[]{this._xaResInfo, exception});
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "XAResourceInfo fails deserialization test", exception);
                }
                byArray = null;
            }
        }
        if (byArray != null) {
            object = null;
            if (stringArray != null) {
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "XAResourceInfo classpath data found. Adding to log data");
                }
                serializable = new StringBuffer();
                if (tc.isDebugEnabled()) {
                    Tr.event(tc, "Creating String from array elements.");
                }
                for (int i = 0; i < stringArray.length; ++i) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Element [" + i + "] = " + stringArray[i]);
                    }
                    ((StringBuffer)serializable).append(stringArray[i]);
                    ((StringBuffer)serializable).append(File.pathSeparator);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "ResourceInfo classpath", ((StringBuffer)serializable).toString());
                }
                byte[] byArray2 = ((StringBuffer)serializable).toString().getBytes();
                object = new byte[byArray2.length + 1 + byArray.length];
                System.arraycopy(byArray2, 0, object, 0, byArray2.length);
                object[byArray2.length] = false;
                System.arraycopy(byArray, 0, object, byArray2.length + 1, byArray.length);
            } else {
                object = new byte[1 + byArray.length];
                object[0] = false;
                System.arraycopy(byArray, 0, object, 1, byArray.length);
            }
            xARecoveryData.setSerializedLogData((byte[])object);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "container", xARecoveryData);
        }
        return xARecoveryData;
    }

    static XARecoveryWrapper deserialize(byte[] byArray, ClassLoader classLoader) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "deserialize", classLoader);
        }
        XARecoveryWrapper xARecoveryWrapper = null;
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            WsObjectInputStream wsObjectInputStream = new WsObjectInputStream(byteArrayInputStream, classLoader);
            xARecoveryWrapper = (XARecoveryWrapper)wsObjectInputStream.readObject();
            wsObjectInputStream.close();
        }
        catch (ClassNotFoundException classNotFoundException) {
            FFDCFilter.processException(classNotFoundException, "com.ibm.ws.Transaction.JTA.XARecoveryWrapper.deserialize", "298");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Unable to deserialize an object from byte stream", classNotFoundException);
            }
            String string = classNotFoundException.getMessage();
            int n = string.indexOf(":");
            string = string.substring(n + 1);
            Tr.error(tc, "WTRN0002_UNABLE_TO_FIND_RESOURCE_CLASS", string);
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.Transaction.JTA.XARecoveryWrapper.deserialize", "306");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Unable to deserialize an object from byte stream", throwable);
            }
            Tr.error(tc, "WTRN0040_OBJECT_DESERIALIZE_FAILED", throwable);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "deserialize", xARecoveryWrapper);
        }
        return xARecoveryWrapper;
    }

    public String getXAResourceFactoryClassName() {
        return this._xaResFactoryClassName;
    }

    public XAResourceInfo getXAResourceInfo() {
        return this._xaResInfo;
    }

    public void setXAResourceFactoryClasspath(String[] stringArray) {
        this._xaResFactoryClasspath = stringArray;
    }

    public String[] getXAResourceFactoryClasspath() {
        return this._xaResFactoryClasspath;
    }

    public String toString() {
        String string = "";
        if (this._xaResFactoryClasspath != null && this._xaResFactoryClasspath.length > 0) {
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < this._xaResFactoryClasspath.length; ++i) {
                stringBuffer.append(this._xaResFactoryClasspath[i]);
                stringBuffer.append(File.pathSeparator);
            }
            string = stringBuffer.toString();
        }
        return this._xaResFactoryClassName + ", " + this._xaResInfo.toString() + ", " + string;
    }

    private String[] canonicalise(String[] stringArray) {
        String[] stringArray2;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "canonicalise", stringArray);
        }
        if (stringArray != null) {
            ArrayList<String> arrayList = new ArrayList<String>();
            for (int i = 0; i < stringArray.length; ++i) {
                String string;
                if (stringArray[i] == null) continue;
                try {
                    string = new File(stringArray[i]).getCanonicalPath();
                }
                catch (Throwable throwable) {
                    FFDCFilter.processException(throwable, "com.ibm.ws.Transaction.JTA.TranManagerSet.canonicalise", "512", this);
                    string = stringArray[i];
                }
                arrayList.add(string);
            }
            stringArray2 = arrayList.toArray(new String[arrayList.size()]);
        } else {
            stringArray2 = null;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "canonicalise", stringArray2);
        }
        return stringArray2;
    }
}

