/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.Transaction.JTA;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.Transaction.JTA.Util;
import com.ibm.ws.Transaction.JTA.XAReturnCodeHelper;
import com.ibm.ws.Transaction.XAResourceFactory;
import com.ibm.ws.Transaction.XAResourceNotAvailableException;
import com.ibm.ws.ffdc.FFDCFilter;
import java.lang.reflect.Method;
import javax.transaction.SystemException;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;

public final class XARminst {
    XAResource _XARes;
    XAResourceFactory _XAResourceFactory;
    private static final TraceComponent tc = Tr.register(XARminst.class, "Transaction", "com.ibm.ws.Transaction.resources.TransactionMsgs");

    public XARminst(XAResource xAResource, XAResourceFactory xAResourceFactory) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "XARminst", new Object[]{xAResource, xAResourceFactory});
        }
        this._XARes = xAResource;
        this._XAResourceFactory = xAResourceFactory;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "XARminst");
        }
    }

    public XAResource getXaResource() {
        return this._XARes;
    }

    public Xid[] recover() throws XAResourceNotAvailableException, SystemException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "recover", this._XARes);
        }
        Xid[] xidArray = null;
        if (this._XARes != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Driving xares.recover() on resource with flags", new Object[]{this._XARes, Util.printFlag(0x1800000)});
            }
            try {
                xidArray = this._XARes.recover(0x1800000);
            }
            catch (XAException xAException) {
                FFDCFilter.processException((Throwable)xAException, this.getClass().getName() + ".recover", "109", this);
                int n = xAException.errorCode;
                if (n == -7) {
                    Tr.warning(tc, "WTRN0037_XA_RECOVER_ERROR", new Object[]{this._XARes, XAReturnCodeHelper.convertXACode(n), xAException});
                    throw new XAResourceNotAvailableException(xAException);
                }
                if (n == -3) {
                    Tr.error(tc, "WTRN0037_XA_RECOVER_ERROR", new Object[]{this._XARes, XAReturnCodeHelper.convertXACode(n), xAException});
                    Class<?> clazz = xAException.getClass();
                    if (clazz.getName().equals("oracle.jdbc.xa.OracleXAException")) {
                        try {
                            Method method2 = clazz.getMethod("getOracleError", null);
                            Integer n2 = (Integer)method2.invoke(clazz, null);
                            Tr.error(tc, "WTRN0100_GENERIC_ERROR", "Oracle error returned - " + n2);
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                    throw new XAResourceNotAvailableException(xAException);
                }
                if (n == -5) {
                    Xid[] xidArray2 = null;
                    Xid[] xidArray3 = null;
                    try {
                        int n3;
                        xidArray2 = this._XARes.recover(0x1000000);
                        xidArray3 = this._XARes.recover(0x800000);
                        if (xidArray2 == null) {
                            xidArray2 = new Xid[]{};
                        }
                        if (xidArray3 == null) {
                            xidArray3 = new Xid[]{};
                        }
                        xidArray = new Xid[xidArray2.length + xidArray3.length];
                        for (n3 = 0; n3 < xidArray2.length; ++n3) {
                            xidArray[n3] = xidArray2[n3];
                        }
                        for (n3 = 0; n3 < xidArray3.length; ++n3) {
                            xidArray[n3 + xidArray2.length] = xidArray3[n3];
                        }
                    }
                    catch (Throwable throwable) {
                        if (tc.isEventEnabled()) {
                            Tr.event(tc, "Caught exception re-driving recover", throwable);
                        }
                        Tr.error(tc, "WTRN0037_XA_RECOVER_ERROR", new Object[]{this._XARes, XAReturnCodeHelper.convertXACode(n), xAException});
                        throw new SystemException();
                    }
                }
                Tr.error(tc, "WTRN0037_XA_RECOVER_ERROR", new Object[]{this._XARes, XAReturnCodeHelper.convertXACode(n), xAException});
                throw new SystemException();
            }
            catch (Throwable throwable) {
                FFDCFilter.processException(throwable, this.getClass().getName() + ".recover", "149", this);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Resource {0} threw unexpected exception", new Object[]{this._XARes, throwable});
                }
                throw new XAResourceNotAvailableException(new Exception(throwable));
            }
        }
        if (xidArray == null) {
            xidArray = new Xid[]{};
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "recover");
        }
        return xidArray;
    }

    public void rollback(Xid xid) throws XAException {
        block14: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "rollback", new Object[]{this._XARes, xid});
            }
            try {
                this._XARes.rollback(xid);
            }
            catch (XAException xAException) {
                FFDCFilter.processException((Throwable)xAException, "com.ibm.ws.Transaction.JTA.XARminst.rollback", "295", this);
                int n = xAException.errorCode;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "XAException: error code " + XAReturnCodeHelper.convertXACode(n), xAException);
                }
                if (n == 6 || n == 7 || n == 5 || n == 8) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "rollback returned heuristic");
                    }
                    try {
                        this._XARes.forget(xid);
                    }
                    catch (XAException xAException2) {
                        FFDCFilter.processException((Throwable)xAException2, "com.ibm.ws.Transaction.JTA.XARminst.rollback", "676", this);
                        n = xAException2.errorCode;
                        if (n != -4) {
                            Tr.error(tc, "WTRN0054_XA_FORGET_ERROR", new Object[]{XAReturnCodeHelper.convertXACode(n), xAException2});
                            if (tc.isEntryEnabled()) {
                                Tr.exit(tc, "rollback", xAException2);
                            }
                            throw xAException2;
                        }
                        break block14;
                    }
                }
                if (n == -4 || n == -3 || n >= 100 && n <= 107) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "rollback complete");
                    }
                }
                Tr.warning(tc, "WTRN0031_XA_ROLLBACK_FAILED", new Object[]{xid, xAException});
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "rollback", xAException);
                }
                throw xAException;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "rollback");
        }
    }

    public void closeConnection() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "closeConnection");
        }
        try {
            this._XAResourceFactory.destroyXAResource(this._XARes);
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.Transaction.JTA.XARminst.closeConnection", "250", this);
            Tr.audit(tc, "WTRN0038_ERR_DESTROYING_XARESOURCE", throwable);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "closeConnection");
        }
    }
}

