/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.Transaction.JTA;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.Transaction.JTA.TxPrimaryKey;
import com.ibm.ws.Transaction.JTA.Util;
import com.ibm.ws.Transaction.JTS.Configuration;
import com.ibm.ws.Transaction.TxProperties;
import com.ibm.ws390.tx.NativeTransactionContext;
import java.util.Arrays;
import javax.transaction.xa.Xid;

public final class XidImpl
implements Xid {
    private final int _formatId;
    private final byte[] _gtrid;
    private final byte[] _bqual;
    private byte[] _otid;
    private TxPrimaryKey _primaryKey;
    private static final byte[] _currentStoken = (byte[])(TxProperties.NATIVE_CONTEXTS_USED ? NativeTransactionContext.getCurrentStoken() : null);
    public static final int ZOS_FID_CB390 = -1010695802;
    private static final int ZOS_FID_CBLT = -1010641949;
    private static final int ZOS_FID_WASZ = -423501079;
    public static final int WAS_FID_WASC = 1463898947;
    private static final int WAS_FID_WASD = 1463898948;
    private static final int WAS_FID_WASZ = 1463898970;
    public static final int WAS_FORMAT_ID = TxProperties.NATIVE_CONTEXTS_USED ? -1010695802 : 1463898948;
    private static final TraceComponent tc = Tr.register(XidImpl.class, "Transaction", "com.ibm.ws.Transaction.resources.TransactionMsgs");
    private static final int BQUAL_PKEY_OFFSET = 0;
    private static final int BQUAL_PKEY_LENGTH = 16;
    private static final int BQUAL_UUID_OFFSET = 16;
    private static final int BQUAL_UUID_LENGTH = 20;
    private static final int GTRID_JTA_GTRID_LENGTH = 36;
    private static final int BQUAL_BRANCH_INDEX_OFFSET = 39;
    private static final int BQUAL_JTA_GTRID_LENGTH = 40;
    private static final int BQUAL_STOKEN_OFFSET = 40;
    private static final int BQUAL_STOKEN_LENGTH = 8;
    private static final int BQUAL_RECOVERY_ID_OFFSET_UNUSED = 48;
    private static final int BQUAL_RECOVERY_ID_LENGTH_UNUSED = 4;
    private static final int BQUAL_RM_SEQ_OFFSET = 52;
    private static final int BQUAL_RM_SEQ_LENGTH = 2;
    public static final int BQUAL_JTA_BQUAL_LENGTH = 54;

    public XidImpl(int n, byte[] byArray, byte[] byArray2) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            if (byArray2 != null) {
                Tr.entry(tc, "XidImpl", new Object[]{new Integer(n), com.ibm.ejs.util.Util.toHexString(byArray), com.ibm.ejs.util.Util.toHexString(byArray2)});
            } else {
                Tr.entry(tc, "XidImpl", new Object[]{new Integer(n), com.ibm.ejs.util.Util.toHexString(byArray), "null"});
            }
        }
        this._formatId = n;
        this._gtrid = Util.duplicateByteArray(byArray);
        this._bqual = Util.duplicateByteArray(byArray2);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "XidImpl", this);
        }
    }

    public XidImpl(byte[] byArray, int n) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "XidImpl", new Object[]{com.ibm.ejs.util.Util.toHexString(byArray), new Integer(n)});
        }
        this._formatId = Util.getIntFromBytes(byArray, n, 4);
        int n2 = Util.getIntFromBytes(byArray, n + 4, 4);
        this._gtrid = Util.duplicateByteArray(byArray, n + 12, n2);
        int n3 = Util.getIntFromBytes(byArray, n + 8, 4);
        this._bqual = new byte[n3];
        System.arraycopy(byArray, n + 12 + n2, this._bqual, 0, n3);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "XidImpl", this);
        }
    }

    public XidImpl(byte[] byArray) {
        this(byArray, 0);
    }

    public XidImpl(Xid xid) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "XidImpl", xid);
        }
        this._formatId = xid.getFormatId();
        this._gtrid = Util.duplicateByteArray(xid.getGlobalTransactionId());
        this._bqual = Util.duplicateByteArray(xid.getBranchQualifier());
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "XidImpl", this);
        }
    }

    public XidImpl(Xid xid, int n) {
        if (TraceComponent.isAnyTracingEnabled()) {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "XidImpl", new Object[]{xid, new Integer(n)});
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Creating XID for a resource branch");
            }
        }
        this._formatId = xid.getFormatId();
        this._gtrid = Util.duplicateByteArray(xid.getGlobalTransactionId());
        this._bqual = new byte[54];
        byte[] byArray = xid.getBranchQualifier();
        System.arraycopy(byArray, 0, this._bqual, 0, byArray.length);
        this.setSequenceNumber(n);
        this.setStoken(_currentStoken);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "XidImpl", this);
        }
    }

    public XidImpl(byte[] byArray, int n, byte[] byArray2) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "XidImpl", new Object[]{com.ibm.ejs.util.Util.toHexString(byArray), new Integer(n), com.ibm.ejs.util.Util.toHexString(byArray2)});
        }
        this._formatId = Util.getIntFromBytes(byArray, 0, 4);
        int n2 = Util.getIntFromBytes(byArray, 4, 4);
        this._gtrid = Util.duplicateByteArray(byArray, 12, n2);
        int n3 = Util.getIntFromBytes(byArray, 8, 4);
        this._bqual = new byte[54];
        System.arraycopy(byArray, 12 + n2, this._bqual, 0, n3);
        this.setSequenceNumber(n);
        if (byArray2 == null) {
            this.setStoken(_currentStoken);
        } else {
            this.setStoken(byArray2);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "XidImpl", this);
        }
    }

    public XidImpl(TxPrimaryKey txPrimaryKey) {
        this(WAS_FORMAT_ID, txPrimaryKey);
    }

    XidImpl(int n, TxPrimaryKey txPrimaryKey) {
        if (TraceComponent.isAnyTracingEnabled()) {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "XidImpl", new Object[]{Integer.toHexString(n), txPrimaryKey});
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Creating XID for a global transaction");
            }
        }
        this._formatId = n;
        this._bqual = new byte[40];
        System.arraycopy(txPrimaryKey.toBytes(), 0, this._bqual, 0, 16);
        System.arraycopy(Configuration.getApplId(), 0, this._bqual, 16, 20);
        this._bqual[39] = 1;
        this._gtrid = new byte[36];
        System.arraycopy(this._bqual, 0, this._gtrid, 0, 36);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "XidImpl", this);
        }
    }

    XidImpl(Xid xid, TxPrimaryKey txPrimaryKey) {
        this(xid.getGlobalTransactionId(), txPrimaryKey, 1);
    }

    public XidImpl(byte[] byArray, TxPrimaryKey txPrimaryKey, int n) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "XidImpl", new Object[]{com.ibm.ejs.util.Util.toHexString(byArray), txPrimaryKey, new Integer(n)});
        }
        this._formatId = WAS_FORMAT_ID;
        this._bqual = new byte[40];
        System.arraycopy(txPrimaryKey.toBytes(), 0, this._bqual, 0, 16);
        System.arraycopy(Configuration.getApplId(), 0, this._bqual, 16, 20);
        this._bqual[39] = (byte)n;
        this._gtrid = Util.duplicateByteArray(byArray);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "XidImpl", this);
        }
    }

    public final boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof XidImpl)) {
            return false;
        }
        XidImpl xidImpl = (XidImpl)object;
        if (this._formatId != xidImpl._formatId) {
            return false;
        }
        return Arrays.equals(this._bqual, xidImpl._bqual) && Arrays.equals(this._gtrid, xidImpl._gtrid);
    }

    public String toString() {
        return new String("{XidImpl: formatId(" + Integer.toHexString(this._formatId) + "), gtrid_length(" + (this._gtrid == null ? 0 : this._gtrid.length) + "), bqual_length(" + (this._bqual == null ? 0 : this._bqual.length) + "), data(" + (this._gtrid == null ? "" : com.ibm.ejs.util.Util.toHexString(this._gtrid)) + (this._bqual == null ? "" : com.ibm.ejs.util.Util.toHexString(this._bqual)) + ")}");
    }

    public final int getFormatId() {
        return this._formatId;
    }

    public final byte[] getGlobalTransactionId() {
        return this._gtrid;
    }

    public final byte[] getBranchQualifier() {
        return this._bqual;
    }

    public byte[] toBytes() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "toBytes");
        }
        int n = this._gtrid == null ? 0 : this._gtrid.length;
        int n2 = this._bqual == null ? 0 : this._bqual.length;
        int n3 = 12 + n + n2;
        byte[] byArray = new byte[n3];
        Util.setBytesFromInt(byArray, 0, 4, this._formatId);
        Util.setBytesFromInt(byArray, 4, 4, n);
        Util.setBytesFromInt(byArray, 8, 4, n2);
        if (n > 0) {
            System.arraycopy(this._gtrid, 0, byArray, 12, n);
        }
        if (n2 > 0) {
            System.arraycopy(this._bqual, 0, byArray, 12 + n, n2);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "toBytes", com.ibm.ejs.util.Util.toHexString(byArray));
        }
        return byArray;
    }

    public byte[] getOtidBytes() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getOtidBytes");
        }
        if (this._otid == null) {
            int n = this._gtrid.length + this._bqual.length;
            this._otid = new byte[n];
            System.arraycopy(this._gtrid, 0, this._otid, 0, this._gtrid.length);
            System.arraycopy(this._bqual, 0, this._otid, this._gtrid.length, this._bqual.length);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getOtidBytes", this._otid);
        }
        return Util.duplicateByteArray(this._otid);
    }

    public byte[] getCruuid() {
        return Util.duplicateByteArray(this._bqual, 16, 20);
    }

    public byte[] getStoken() {
        return Util.duplicateByteArray(this._bqual, 40, 8);
    }

    void setStoken(byte[] byArray) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "setStoken", byArray);
        }
        if (byArray != null) {
            System.arraycopy(byArray, 0, this._bqual, 40, 8);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "setStoken");
        }
    }

    public int getSequenceNumber() {
        return Util.getIntFromBytes(this._bqual, 52, 2);
    }

    private void setSequenceNumber(int n) {
        Util.setBytesFromInt(this._bqual, 52, 2, n);
    }

    public TxPrimaryKey getPrimaryKey() {
        if (this._primaryKey == null) {
            this._primaryKey = new TxPrimaryKey(this._bqual, 0);
        }
        return this._primaryKey;
    }

    public int getEpoch() {
        return this.getPrimaryKey().getEpochNumber();
    }

    public int getPrimaryKeySequenceNumber() {
        return this.getPrimaryKey().getSequenceNumber();
    }

    public final int hashCode() {
        if (this._bqual != null) {
            return this.getPrimaryKeySequenceNumber();
        }
        return 0;
    }

    public static boolean isOurFormatId(int n) {
        boolean bl;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "isOurFormatId", new Integer(n));
        }
        switch (n) {
            case -1010695802: 
            case -1010641949: 
            case 1463898948: {
                bl = true;
                break;
            }
            default: {
                bl = false;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "isOurFormatId", bl);
        }
        return bl;
    }

    public final int getBqualBranchIndex() {
        return 0xFF & this._bqual[39];
    }
}

