/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.Transaction.JTS;

import com.ibm.CORBA.iiop.IOR;
import com.ibm.CORBA.iiop.ORB;
import com.ibm.CORBA.iiop.Profile;
import com.ibm.ejs.oa.UserKey;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.util.Util;
import com.ibm.ws.Transaction.JTA.JTAResource;
import com.ibm.ws.Transaction.JTA.ResourceWrapper;
import com.ibm.ws.Transaction.JTA.TranManagerSet;
import com.ibm.ws.Transaction.JTS.Configuration;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.recoverylog.spi.RecoverableUnitSection;
import com.ibm.ws.runtime.component.TxServiceImpl;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import javax.transaction.Transaction;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.COMM_FAILURE;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.INV_OBJREF;
import org.omg.CORBA.NO_IMPLEMENT;
import org.omg.CORBA.NO_MEMORY;
import org.omg.CORBA.NO_RESOURCES;
import org.omg.CORBA.NO_RESPONSE;
import org.omg.CORBA.OBJECT_NOT_EXIST;
import org.omg.CORBA.Object;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.TRANSACTION_REQUIRED;
import org.omg.CORBA.TRANSACTION_ROLLEDBACK;
import org.omg.CORBA.TRANSIENT;
import org.omg.CosTransactions.HeuristicCommit;
import org.omg.CosTransactions.HeuristicHazard;
import org.omg.CosTransactions.HeuristicMixed;
import org.omg.CosTransactions.HeuristicRollback;
import org.omg.CosTransactions.NotPrepared;
import org.omg.CosTransactions.Resource;
import org.omg.CosTransactions.ResourceHelper;
import org.omg.CosTransactions.Vote;

public final class CORBAResourceWrapper
extends ResourceWrapper
implements JTAResource {
    private Resource _resource;
    private Object _object;
    private static final TraceComponent tc = Tr.register(CORBAResourceWrapper.class, "Transaction", "com.ibm.ws.Transaction.resources.TransactionMsgs");

    public CORBAResourceWrapper(Resource resource) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "CORBAResourceWrapper", resource);
        }
        this._resource = resource;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "CORBAResourceWrapper", this);
        }
    }

    public CORBAResourceWrapper(byte[] byArray) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "CORBAResourceWrapper", Util.toHexString(byArray));
        }
        this._object = Configuration.bytes_to_object(byArray);
        if (this._object == null) {
            INV_OBJREF iNV_OBJREF = new INV_OBJREF();
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "CORBAResourceWrapper", iNV_OBJREF);
            }
            throw iNV_OBJREF;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "CORBAResourceWrapper", this);
        }
    }

    public Resource getCORBAResource() {
        return this._resource;
    }

    public void commit() throws XAException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "commit");
        }
        Transaction transaction = null;
        try {
            if (this._resource == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Attempting to narrow the remote resource reference", this._object);
                }
                if (this._object != null) {
                    this._resource = ResourceHelper.narrow(this._object);
                }
                if (this._resource == null) {
                    throw new BAD_PARAM();
                }
            }
            transaction = TranManagerSet.instance().suspend();
            PrivilegedExceptionAction privilegedExceptionAction = new PrivilegedExceptionAction(){

                public java.lang.Object run() throws NotPrepared, HeuristicRollback, HeuristicMixed, HeuristicHazard {
                    CORBAResourceWrapper.this._resource.commit();
                    return null;
                }
            };
            TxServiceImpl.runAsSystem(privilegedExceptionAction);
        }
        catch (PrivilegedActionException privilegedActionException) {
            Throwable throwable = privilegedActionException.getCause();
            if (throwable instanceof NotPrepared) {
                FFDCFilter.processException((Throwable)privilegedActionException, "com.ibm.ws.Transaction.JTS.CORBAResourceWrapper.commit", "86", this);
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "NotPrepared exception when committing CORBA resource", throwable);
                }
                throw new XAException(-6);
            }
            if (throwable instanceof HeuristicHazard) {
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "HeuristicHazard exception when committing CORBA resource", throwable);
                }
                throw new XAException(8);
            }
            if (throwable instanceof HeuristicMixed) {
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "HeuristicMixed exception when committing CORBA resource", throwable);
                }
                throw new XAException(5);
            }
            if (throwable instanceof HeuristicRollback) {
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "HeuristicRollback exception when committing CORBA resource", throwable);
                }
                throw new XAException(6);
            }
            if (throwable instanceof SystemException) {
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "CORBA SystemException when commiting CORBA resource", throwable);
                }
                throw CORBAResourceWrapper.processCORBASystemException((SystemException)throwable);
            }
            XAException xAException = new XAException(-3);
            xAException.initCause(privilegedActionException);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "commit", xAException);
            }
            throw xAException;
        }
        finally {
            block28: {
                try {
                    if (transaction != null) {
                        TranManagerSet.instance().resume(transaction);
                    }
                }
                catch (Throwable throwable) {
                    FFDCFilter.processException(throwable, "com.ibm.ws.Transaction.JTS.CORBAResourceWrapper.commit", "217", this);
                    if (!tc.isDebugEnabled()) break block28;
                    Tr.debug(tc, "Error resuming transaction", throwable);
                }
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "commit");
            }
        }
    }

    public void commit_one_phase() throws XAException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "commit_one_phase");
        }
        Transaction transaction = null;
        try {
            transaction = TranManagerSet.instance().suspend();
            PrivilegedExceptionAction privilegedExceptionAction = new PrivilegedExceptionAction(){

                public java.lang.Object run() throws HeuristicHazard {
                    CORBAResourceWrapper.this._resource.commit_one_phase();
                    return null;
                }
            };
            TxServiceImpl.runAsSystem(privilegedExceptionAction);
        }
        catch (PrivilegedActionException privilegedActionException) {
            Throwable throwable = privilegedActionException.getCause();
            if (throwable instanceof HeuristicHazard) {
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "HeuristicHazard exception upon flowing commit_one_phase to CORBA resource", privilegedActionException.getCause());
                }
                throw new XAException(8);
            }
            if (throwable instanceof SystemException) {
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "CORBA SystemException when commiting CORBA resource", throwable);
                }
                throw CORBAResourceWrapper.processCORBASystemException((SystemException)throwable);
            }
            FFDCFilter.processException((Throwable)privilegedActionException, "com.ibm.ws.Transaction.JTS.CORBAResourceWrapper.commit_one_phase", "300", this);
            XAException xAException = new XAException(-3);
            xAException.initCause(privilegedActionException);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "commit_one_phase", xAException);
            }
            throw xAException;
        }
        finally {
            block18: {
                try {
                    if (transaction != null) {
                        TranManagerSet.instance().resume(transaction);
                    }
                }
                catch (Throwable throwable) {
                    FFDCFilter.processException(throwable, "com.ibm.ws.Transaction.JTS.CORBAResourceWrapper.commit_one_phase", "252", this);
                    if (!tc.isDebugEnabled()) break block18;
                    Tr.debug(tc, "Error resuming transaction", throwable);
                }
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "commit_one_phase");
            }
        }
    }

    public void forget() throws XAException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "forget");
        }
        Transaction transaction = null;
        try {
            if (this._resource == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Attempting to narrow the remote resource reference", this._object);
                }
                if (this._object != null) {
                    this._resource = ResourceHelper.narrow(this._object);
                }
                if (this._resource == null) {
                    throw new BAD_PARAM();
                }
            }
            transaction = TranManagerSet.instance().suspend();
            PrivilegedExceptionAction privilegedExceptionAction = new PrivilegedExceptionAction(){

                public java.lang.Object run() {
                    CORBAResourceWrapper.this._resource.forget();
                    return null;
                }
            };
            TxServiceImpl.runAsSystem(privilegedExceptionAction);
        }
        catch (PrivilegedActionException privilegedActionException) {
            FFDCFilter.processException((Throwable)privilegedActionException, "com.ibm.ws.Transaction.JTS.CORBAResourceWrapper.forget", "335", this);
            Throwable throwable = privilegedActionException.getCause();
            if (throwable instanceof SystemException) {
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "CORBA SystemException when forgeting CORBA resource", throwable);
                }
                throw CORBAResourceWrapper.processCORBASystemException((SystemException)throwable);
            }
            XAException xAException = new XAException(-3);
            xAException.initCause(privilegedActionException);
            throw xAException;
        }
        finally {
            block19: {
                try {
                    if (transaction != null) {
                        TranManagerSet.instance().resume(transaction);
                    }
                }
                catch (Throwable throwable) {
                    FFDCFilter.processException(throwable, "com.ibm.ws.Transaction.JTS.CORBAResourceWrapper.forget", "288", this);
                    if (!tc.isDebugEnabled()) break block19;
                    Tr.debug(tc, "Error resuming transaction", throwable);
                }
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "forget");
            }
        }
    }

    public int prepare() throws XAException {
        Vote vote = null;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "prepare");
        }
        Transaction transaction = null;
        try {
            transaction = TranManagerSet.instance().suspend();
            PrivilegedExceptionAction privilegedExceptionAction = new PrivilegedExceptionAction(){

                public java.lang.Object run() throws HeuristicMixed, HeuristicHazard {
                    return CORBAResourceWrapper.this._resource.prepare();
                }
            };
            vote = (Vote)TxServiceImpl.runAsSystem(privilegedExceptionAction);
        }
        catch (PrivilegedActionException privilegedActionException) {
            Throwable throwable = privilegedActionException.getCause();
            if (throwable instanceof HeuristicMixed) {
                XAException xAException = new XAException(5);
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "prepare", xAException);
                }
                throw xAException;
            }
            if (throwable instanceof HeuristicHazard) {
                XAException xAException = new XAException(8);
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "prepare", xAException);
                }
                throw xAException;
            }
            if (throwable instanceof SystemException) {
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "CORBA SystemException when preparing CORBA resource", throwable);
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "prepare");
                }
                throw CORBAResourceWrapper.processCORBASystemException((SystemException)throwable);
            }
            FFDCFilter.processException((Throwable)privilegedActionException, "com.ibm.ws.Transaction.JTS.CORBAResourceWrapper.prepare", "426", this);
            XAException xAException = new XAException(-3);
            xAException.initCause(privilegedActionException);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "prepare", xAException);
            }
            throw xAException;
        }
        finally {
            block25: {
                try {
                    if (transaction != null) {
                        TranManagerSet.instance().resume(transaction);
                    }
                }
                catch (Throwable throwable) {
                    FFDCFilter.processException(throwable, "com.ibm.ws.Transaction.JTS.CORBAResourceWrapper.prepare", "334", this);
                    if (!tc.isDebugEnabled()) break block25;
                    Tr.debug(tc, "Error resuming transaction", throwable);
                }
            }
        }
        int n = vote.value();
        if (n == 0) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "prepare voted commit");
            }
            return 0;
        }
        if (n == 2) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "prepare voted readonly");
            }
            return 3;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "prepare voted rollback");
        }
        throw new XAException(100);
    }

    public void rollback() throws XAException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "rollback");
        }
        Transaction transaction = null;
        try {
            if (this._resource == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Attempting to narrow the remote resource reference", this._object);
                }
                if (this._object != null) {
                    this._resource = ResourceHelper.narrow(this._object);
                }
                if (this._resource == null) {
                    throw new BAD_PARAM();
                }
            }
            transaction = TranManagerSet.instance().suspend();
            PrivilegedExceptionAction privilegedExceptionAction = new PrivilegedExceptionAction(){

                public java.lang.Object run() throws HeuristicCommit, HeuristicMixed, HeuristicHazard {
                    CORBAResourceWrapper.this._resource.rollback();
                    return null;
                }
            };
            TxServiceImpl.runAsSystem(privilegedExceptionAction);
        }
        catch (PrivilegedActionException privilegedActionException) {
            Throwable throwable = privilegedActionException.getCause();
            if (throwable instanceof HeuristicCommit) {
                throw new XAException(7);
            }
            if (throwable instanceof HeuristicMixed) {
                throw new XAException(5);
            }
            if (throwable instanceof HeuristicHazard) {
                throw new XAException(8);
            }
            if (throwable instanceof SystemException) {
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "CORBA SystemException when rolling back  CORBA resource", throwable);
                }
                throw CORBAResourceWrapper.processCORBASystemException((SystemException)throwable);
            }
            FFDCFilter.processException((Throwable)privilegedActionException, "com.ibm.ws.Transaction.JTS.CORBAResourceWrapper.rollback", "517", this);
            XAException xAException = new XAException(-3);
            xAException.initCause(privilegedActionException);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "rollback", xAException);
            }
            throw xAException;
        }
        finally {
            block23: {
                try {
                    if (transaction != null) {
                        TranManagerSet.instance().resume(transaction);
                    }
                }
                catch (Throwable throwable) {
                    FFDCFilter.processException(throwable, "com.ibm.ws.Transaction.JTS.CORBAResourceWrapper.rollback", "405", this);
                    if (!tc.isDebugEnabled()) break block23;
                    Tr.debug(tc, "Error resuming transaction", throwable);
                }
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "rollback");
            }
        }
    }

    public static XAException processCORBASystemException(SystemException systemException) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "processCORBASystemException", (java.lang.Object)systemException);
        }
        XAException xAException = null;
        if (systemException instanceof INTERNAL) {
            FFDCFilter.processException(systemException, "com.ibm.ws.Transaction.JTS.CORBAResourceWrapper.processCORBAException", "324");
            xAException = new XAException(-5);
        } else if (systemException instanceof TRANSIENT) {
            xAException = new XAException(-7);
        } else if (systemException instanceof COMM_FAILURE) {
            xAException = new XAException(-7);
        } else if (systemException instanceof NO_RESPONSE) {
            xAException = new XAException(-7);
        } else if (systemException instanceof NO_MEMORY) {
            FFDCFilter.processException(systemException, "com.ibm.ws.Transaction.JTS.CORBAResourceWrapper.processCORBAException", "355");
            xAException = new XAException(-7);
        } else if (systemException instanceof NO_RESOURCES) {
            FFDCFilter.processException(systemException, "com.ibm.ws.Transaction.JTS.CORBAResourceWrapper.processCORBAException", "363");
            xAException = new XAException(-7);
        } else if (systemException instanceof OBJECT_NOT_EXIST) {
            xAException = systemException.minor == 1229126674 || systemException.minor == 1229126676 || systemException.minor == 1229126658 || systemException.minor == 1229126657 ? new XAException(-7) : new XAException(-4);
        } else if (systemException instanceof INV_OBJREF) {
            xAException = new XAException(-4);
        } else if (systemException instanceof TRANSACTION_ROLLEDBACK) {
            xAException = new XAException(100);
        } else if (systemException instanceof TRANSACTION_REQUIRED) {
            FFDCFilter.processException(systemException, "com.ibm.ws.Transaction.JTS.CORBAResourceWrapper.processCORBAException", "387");
            xAException = new XAException(-3);
        } else if (systemException instanceof NO_IMPLEMENT && systemException.minor == 1229066304) {
            xAException = new XAException(-7);
        } else if (systemException instanceof NO_IMPLEMENT && systemException.minor == 1229066306) {
            xAException = new XAException(-7);
        } else {
            FFDCFilter.processException(systemException, "com.ibm.ws.Transaction.JTS.CORBAResourceWrapper.processCORBAException", "394");
            xAException = new XAException(-3);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "processCORBASystemException", xAException);
        }
        return xAException;
    }

    public void log(RecoverableUnitSection recoverableUnitSection) throws javax.transaction.SystemException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "log", new java.lang.Object[]{this, recoverableUnitSection});
        }
        try {
            recoverableUnitSection.addData(Configuration.object_to_bytes(this._resource));
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.Transaction.JTS.CORBAResourceWrapper.log", "451", this);
            if (tc.isEventEnabled()) {
                Tr.event(tc, "Exception raised adding data to the transaction log", exception);
            }
            throw new javax.transaction.SystemException(exception.toString());
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "log");
            }
        }
    }

    public void start() {
    }

    public void end(int n) {
    }

    public Xid[] recover(int n) {
        return null;
    }

    public Xid getXID() {
        return null;
    }

    public int getState() {
        return -1;
    }

    public XAResource XAResource() {
        return null;
    }

    public void destroy() {
    }

    public void setState(int n) {
    }

    public String describe() {
        String string = new String(Configuration.object_to_bytes(this._resource));
        IOR iOR = ORB.createIOR((ORB)((ORB)Configuration.getORB()), (String)string);
        Profile profile = iOR.getProfile(0);
        StringBuffer stringBuffer = new StringBuffer(profile.getHost());
        stringBuffer.append(":").append(profile.getPort());
        try {
            UserKey userKey = (UserKey)profile.getObjectKeyObject().getUserKeyObject();
            stringBuffer.append(":").append(userKey.getName());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return "CORBA resource: " + stringBuffer.toString();
    }
}

