/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.Transaction.JTS;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.util.ByteArray;
import com.ibm.ws.Transaction.JTA.FailureScopeController;
import com.ibm.ws.Transaction.JTA.JTASynchronization;
import com.ibm.ws.Transaction.JTA.TranManagerSet;
import com.ibm.ws.Transaction.JTA.TransactionImpl;
import com.ibm.ws.Transaction.JTA.Util;
import com.ibm.ws.Transaction.JTA.XidImpl;
import com.ibm.ws.Transaction.JTS.CORBAResourceWrapper;
import com.ibm.ws.Transaction.JTS.Configuration;
import com.ibm.ws.Transaction.JTS.ControlImpl;
import com.ibm.ws.Transaction.JTS.CoordinatorResource;
import com.ibm.ws.Transaction.JTS.CoordinatorResourceImpl;
import com.ibm.ws.Transaction.JTS.GlobalTID;
import com.ibm.ws.Transaction.JTS.RecoveryCoordinatorImpl;
import com.ibm.ws.Transaction.JTS.ResourceCallback;
import com.ibm.ws.Transaction.JTS.TaskIdPropagationData;
import com.ibm.ws.Transaction.JTS.TaskIdPropagationDataHelper;
import com.ibm.ws.Transaction.JTS.TransactionWrapper;
import com.ibm.ws.Transaction.JTS.TxInterceptorHelper;
import com.ibm.ws.Transaction.JTS.TxStatusHelper;
import com.ibm.ws.Transaction.JTS.WSCoordinatorImpl;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.runtime.component.TxServiceImpl;
import com.ibm.ws.wscoor.ProtocolSecurityHelper;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Hashtable;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import org.omg.CORBA.Any;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.NO_PERMISSION;
import org.omg.CORBA.OBJECT_NOT_EXIST;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CORBA.TRANSACTION_ROLLEDBACK;
import org.omg.CORBA.portable.ObjectImpl;
import org.omg.CosTransactions.Control;
import org.omg.CosTransactions.Coordinator;
import org.omg.CosTransactions.Inactive;
import org.omg.CosTransactions.NotSubtransaction;
import org.omg.CosTransactions.PropagationContext;
import org.omg.CosTransactions.RecoveryCoordinator;
import org.omg.CosTransactions.Resource;
import org.omg.CosTransactions.Status;
import org.omg.CosTransactions.SubtransactionAwareResource;
import org.omg.CosTransactions.SubtransactionsUnavailable;
import org.omg.CosTransactions.Synchronization;
import org.omg.CosTransactions.TransIdentity;
import org.omg.CosTransactions._CoordinatorImplBase;
import org.omg.CosTransactions.otid_t;

public final class CoordinatorImpl
extends _CoordinatorImplBase
implements ResourceCallback {
    private static TraceComponent tc = Tr.register(CoordinatorImpl.class, "Transaction", "com.ibm.ws.Transaction.resources.TransactionMsgs");
    private TransactionImpl _transaction;
    private static Hashtable _coordinatorTable;
    private PropagationContext _propagationContext;
    private Coordinator _superiorCoord;
    private ControlImpl _control;
    private RecoveryCoordinator _recoveryCoordinator;
    private ByteArray _gtrid;
    private ArrayList _corbaResources;
    private ORB _orb;

    public CoordinatorImpl(TransactionImpl transactionImpl) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "CoordinatorImpl", transactionImpl);
        }
        this.init(transactionImpl, transactionImpl.getXid().getGlobalTransactionId());
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "CoordinatorImpl");
        }
    }

    public CoordinatorImpl(TransactionImpl transactionImpl, byte[] byArray) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "CoordinatorImpl", new java.lang.Object[]{transactionImpl, byArray});
        }
        this.init(transactionImpl, byArray);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "CoordinatorImpl");
        }
    }

    public CoordinatorImpl(TransactionImpl transactionImpl, PropagationContext propagationContext) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "CoordinatorImpl", new java.lang.Object[]{transactionImpl, propagationContext});
        }
        GlobalTID globalTID = new GlobalTID(propagationContext.current.otid);
        this.init(transactionImpl, globalTID.getGlobalTransactionId());
        this._superiorCoord = propagationContext.current.coord;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "CoordinatorImpl");
        }
    }

    private void init(TransactionImpl transactionImpl, byte[] byArray) {
        this._transaction = transactionImpl;
        this._gtrid = new ByteArray(byArray);
        CoordinatorImpl.getCoordinatorTable().put(this._gtrid, this);
        this._transaction.addDestroyCallback(this);
        this._orb = Configuration.getORB();
        this._orb.connect((Object)this);
    }

    public static CoordinatorImpl findCoordinator(byte[] byArray) {
        CoordinatorImpl coordinatorImpl;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "findCoordinator", byArray);
        }
        if ((coordinatorImpl = (CoordinatorImpl)CoordinatorImpl.getCoordinatorTable().get(new ByteArray(byArray))) == null) {
            java.lang.Object object;
            TransactionWrapper transactionWrapper = null;
            FailureScopeController failureScopeController = Configuration.getFailureScopeController();
            if (failureScopeController != null && (object = (WSCoordinatorImpl)failureScopeController.getWSCoordinator()) != null) {
                transactionWrapper = ((WSCoordinatorImpl)object).lookupTransactionWrapper(byArray);
            }
            if (transactionWrapper != null) {
                object = transactionWrapper.getTransaction();
                coordinatorImpl = new CoordinatorImpl((TransactionImpl)object, byArray);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "findCoordinator", coordinatorImpl);
        }
        return coordinatorImpl;
    }

    public static CoordinatorImpl importTransaction(PropagationContext propagationContext) {
        TranManagerSet tranManagerSet;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "importTransaction", propagationContext);
        }
        if (!(tranManagerSet = TranManagerSet.instance()).isReplayComplete() || tranManagerSet.isQuiesced()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "throwing NO_PERMISSION as not active");
            }
            throw new NO_PERMISSION("Transaction service is unavailable", 0, CompletionStatus.COMPLETED_NO);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Coordinator in context", propagationContext.current.coord);
        }
        if (((ObjectImpl)propagationContext.current.coord)._is_local()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "importTransaction", "TRANSACTION_ROLLEDBACK");
            }
            throw new TRANSACTION_ROLLEDBACK();
        }
        GlobalTID globalTID = new GlobalTID(propagationContext.current.otid);
        XidImpl xidImpl = new XidImpl(XidImpl.WAS_FORMAT_ID, globalTID.getGlobalTransactionId(), null);
        TransactionImpl transactionImpl = new TransactionImpl(propagationContext.timeout, xidImpl);
        CoordinatorImpl coordinatorImpl = new CoordinatorImpl(transactionImpl, propagationContext);
        try {
            final CoordinatorResource coordinatorResource = new CoordinatorResourceImpl(Configuration.getFailureScopeController(), transactionImpl).object();
            final PropagationContext propagationContext2 = propagationContext;
            PrivilegedExceptionAction privilegedExceptionAction = new PrivilegedExceptionAction(){

                public java.lang.Object run() throws Inactive {
                    return propagationContext2.current.coord.register_resource(coordinatorResource);
                }
            };
            RecoveryCoordinator recoveryCoordinator = (RecoveryCoordinator)TxServiceImpl.runAsSystem(privilegedExceptionAction);
            transactionImpl.setRecoveryCoordinator(recoveryCoordinator);
            transactionImpl.setCoordinatorResource(coordinatorResource);
        }
        catch (Throwable throwable) {
            block15: {
                FFDCFilter.processException(throwable, "com.ibm.ws.Transaction.JTS.CoordinatorImpl.importTransaction", "170");
                if (throwable instanceof PrivilegedActionException && throwable.getCause() instanceof Inactive || throwable instanceof OBJECT_NOT_EXIST) {
                    if (tc.isEventEnabled()) {
                        Tr.event(tc, "Exception caught registering coordinator with superior", throwable);
                    }
                } else {
                    Tr.error(tc, "WTRN0010_EXC_AT_COORD_REG", throwable);
                }
                try {
                    transactionImpl.rollback();
                }
                catch (Exception exception) {
                    FFDCFilter.processException(exception, "com.ibm.ws.Transaction.JTS.CoordinatorImpl.importTransaction", "180");
                    if (!tc.isEventEnabled()) break block15;
                    Tr.event(tc, "Exception rolling back imported tx", exception);
                }
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "importTransaction", "TRANSACTION_ROLLEDBACK");
            }
            throw new TRANSACTION_ROLLEDBACK();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "importTransaction", coordinatorImpl);
        }
        return coordinatorImpl;
    }

    public static CoordinatorImpl createCoordinator(int n) {
        TranManagerSet tranManagerSet;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createCoordinator", new Integer(n));
        }
        if (!(tranManagerSet = TranManagerSet.instance()).isReplayComplete() || tranManagerSet.isQuiesced()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "throwing NO_PERMISSION as not active");
            }
            throw new NO_PERMISSION("Transaction service is unavailable", 0, CompletionStatus.COMPLETED_NO);
        }
        CoordinatorImpl coordinatorImpl = null;
        try {
            TransactionImpl transactionImpl = new TransactionImpl(n);
            coordinatorImpl = new CoordinatorImpl(transactionImpl);
        }
        catch (SystemException systemException) {
            throw new TRANSACTION_ROLLEDBACK(systemException.toString());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createCoordinator", coordinatorImpl);
        }
        return coordinatorImpl;
    }

    public TransactionImpl getJTATransaction() {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getJTATransaction", this._transaction);
        }
        return this._transaction;
    }

    public void destroy() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "destroy");
        }
        java.lang.Object v = CoordinatorImpl.getCoordinatorTable().remove(this._gtrid);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Coordinator removed from table ", v);
        }
        this._orb.disconnect((Object)this);
        if (this._control != null) {
            this._control.destroy();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "destroy");
        }
    }

    private static Hashtable getCoordinatorTable() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCoordinatorTable");
        }
        if (_coordinatorTable == null) {
            if (tc.isEventEnabled()) {
                Tr.event(tc, "Null coordinator table. Initializing.");
            }
            _coordinatorTable = new Hashtable();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCoordinatorTable", _coordinatorTable);
        }
        return _coordinatorTable;
    }

    public Status get_status() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "get_status");
        }
        ProtocolSecurityHelper.checkAuthorization();
        Status status = TxStatusHelper.getCORBAStatus(this._transaction.getStatus());
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "get_status", TxStatusHelper.getCORBAStatusAsString(status));
        }
        return status;
    }

    public Status get_parent_status() {
        return this.get_status();
    }

    public Status get_top_level_status() {
        return this.get_status();
    }

    public boolean is_same_transaction(Coordinator coordinator) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "is_same_transaction", new java.lang.Object[]{this, coordinator});
        }
        ProtocolSecurityHelper.checkAuthorization();
        boolean bl = false;
        TransactionImpl transactionImpl = null;
        if (coordinator instanceof CoordinatorImpl) {
            transactionImpl = ((CoordinatorImpl)coordinator).getJTATransaction();
        }
        if (transactionImpl != null) {
            bl = this._transaction.equals(transactionImpl);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "is_same_transaction", new Boolean(bl));
        }
        return bl;
    }

    public boolean is_related_transaction(Coordinator coordinator) {
        return this.is_same_transaction(coordinator);
    }

    public boolean is_ancestor_transaction(Coordinator coordinator) {
        return this.is_same_transaction(coordinator);
    }

    public boolean is_descendant_transaction(Coordinator coordinator) {
        return this.is_same_transaction(coordinator);
    }

    public boolean is_top_level_transaction() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "is_top_level_transaction", this);
        }
        ProtocolSecurityHelper.checkAuthorization();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "is_top_level_transaction", Boolean.TRUE);
        }
        return true;
    }

    public int hash_transaction() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "hash_transaction", this);
        }
        ProtocolSecurityHelper.checkAuthorization();
        int n = this._transaction.hashCode();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "hash_transaction", new Integer(n));
        }
        return n;
    }

    public int hash_top_level_tran() {
        return this.hash_transaction();
    }

    public synchronized RecoveryCoordinator register_resource(Resource resource) throws Inactive {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "register_resource", resource);
        }
        ProtocolSecurityHelper.checkAuthorization();
        if (this._corbaResources == null) {
            this._corbaResources = new ArrayList();
        } else {
            for (int i = 0; i < this._corbaResources.size(); ++i) {
                block9: {
                    if (!resource._is_equivalent((Object)this._corbaResources.get(i))) continue;
                    try {
                        this._transaction.setRollbackOnly();
                    }
                    catch (IllegalStateException illegalStateException) {
                        FFDCFilter.processException((Throwable)illegalStateException, "com.ibm.ws.Transaction.JTS.CoordinatorImpl.register_resource", "483", this);
                        if (!tc.isEventEnabled()) break block9;
                        Tr.event(tc, "IllegalStateException setting tx rollback only", illegalStateException);
                    }
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "register_resource", "TRANSACTION_ROLLEDBACK");
                }
                throw new TRANSACTION_ROLLEDBACK();
            }
        }
        this._corbaResources.add(resource);
        this._transaction.enlistResource(new CORBAResourceWrapper(resource));
        if (this._recoveryCoordinator == null) {
            this._recoveryCoordinator = new RecoveryCoordinatorImpl(Configuration.getFailureScopeController(), this._transaction).object();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "register_resource", this._recoveryCoordinator);
        }
        return this._recoveryCoordinator;
    }

    public void register_synchronization(Synchronization synchronization) throws Inactive {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "register_synchronization", synchronization);
        }
        ProtocolSecurityHelper.checkAuthorization();
        try {
            this._transaction.registerSynchronization(new JTASynchronization(synchronization));
        }
        catch (RollbackException rollbackException) {
            FFDCFilter.processException((Throwable)rollbackException, "com.ibm.ws.Transaction.JTS.CoordinatorImpl.register_synchronization", "571", this);
            throw new TRANSACTION_ROLLEDBACK();
        }
        catch (IllegalStateException illegalStateException) {
            FFDCFilter.processException((Throwable)illegalStateException, "com.ibm.ws.Transaction.JTS.CoordinatorImpl.register_synchronization", "578", this);
            if (tc.isEventEnabled()) {
                Tr.event(tc, "IllegalStateException registering sync. Throwing Inactive");
            }
            throw new Inactive();
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "register_synchronization");
            }
        }
    }

    public void register_subtran_aware(SubtransactionAwareResource subtransactionAwareResource) throws NotSubtransaction {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "register_subtran_aware", new java.lang.Object[]{subtransactionAwareResource, this});
        }
        ProtocolSecurityHelper.checkAuthorization();
        NotSubtransaction notSubtransaction = new NotSubtransaction();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "register_subtran_aware", (java.lang.Object)notSubtransaction);
        }
        throw notSubtransaction;
    }

    public void rollback_only() throws Inactive {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "rollback_only");
        }
        ProtocolSecurityHelper.checkAuthorization();
        try {
            this._transaction.setRollbackOnly();
        }
        catch (IllegalStateException illegalStateException) {
            FFDCFilter.processException((Throwable)illegalStateException, "com.ibm.ws.Transaction.JTS.CoordinatorImpl.rollback_only", "604", this);
            if (tc.isEventEnabled()) {
                Tr.event(tc, "IllegalStateException setting tx rollback only. Throwing Inactive");
            }
            throw new Inactive();
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "rollback_only");
            }
        }
    }

    public String get_transaction_name() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "get_transaction_name", this);
        }
        ProtocolSecurityHelper.checkAuthorization();
        String string = this._transaction.getTranName();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "get_transaction_name", string);
        }
        return string;
    }

    public Control create_subtransaction() throws SubtransactionsUnavailable {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "create_subtransaction", this);
        }
        ProtocolSecurityHelper.checkAuthorization();
        SubtransactionsUnavailable subtransactionsUnavailable = new SubtransactionsUnavailable();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "create_subtransaction", (java.lang.Object)subtransactionsUnavailable);
        }
        throw subtransactionsUnavailable;
    }

    public PropagationContext get_txcontext() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "get_txcontext", this);
        }
        ProtocolSecurityHelper.checkAuthorization();
        PropagationContext propagationContext = this.internal_get_txcontext();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "get_txcontext", propagationContext);
        }
        return propagationContext;
    }

    PropagationContext internal_get_txcontext() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "internal_get_txcontext", this);
        }
        if (this._propagationContext == null) {
            Any any;
            int n;
            block14: {
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "Creating propagation context");
                }
                long l = this._transaction.getExpirationTime();
                n = 0;
                if (l != 0L && (n = (int)((l - System.currentTimeMillis() + 999L) / 1000L) + 10) <= 0) {
                    block13: {
                        if (tc.isEventEnabled()) {
                            Tr.event(tc, "Timeout for subordinate <= 0. Marking rollback only");
                        }
                        try {
                            this._transaction.setRollbackOnly();
                        }
                        catch (IllegalStateException illegalStateException) {
                            FFDCFilter.processException((Throwable)illegalStateException, "com.ibm.ws.Transaction.JTS.CoordinatorImpl.get_txcontext", "686", this);
                            if (!tc.isEventEnabled()) break block13;
                            Tr.event(tc, "IllegalStateException setting tx rollback only");
                        }
                    }
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "get_txcontext", "TRANSACTION_ROLLEDBACK");
                    }
                    throw new TRANSACTION_ROLLEDBACK();
                }
                any = this._orb.create_any();
                String string = this._transaction.getTaskId();
                if (string != null) {
                    try {
                        TaskIdPropagationData taskIdPropagationData = new TaskIdPropagationData(string);
                        TaskIdPropagationDataHelper.insert(any, taskIdPropagationData);
                    }
                    catch (Exception exception) {
                        FFDCFilter.processException((Throwable)exception, "com.ibm.ws.Transaction.JTS.CoordinatorImpl.internal_get_txcontext", "806", this);
                        if (!tc.isEventEnabled()) break block14;
                        Tr.event(tc, "Exception caught marshalling task id " + string, exception);
                    }
                }
            }
            this._propagationContext = new PropagationContext(n, new TransIdentity(this, null, TxInterceptorHelper.createOtidFromTransaction(this._transaction)), new TransIdentity[0], any);
            if (tc.isEventEnabled()) {
                Tr.event(tc, "PC context.timeout", new Integer(n));
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "internal_get_txcontext", this._propagationContext);
        }
        return this._propagationContext;
    }

    public String toString() {
        return Util.identity(this);
    }

    public Coordinator getParentCoordinator() {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getParentCoordinator", this._superiorCoord);
        }
        return this._superiorCoord;
    }

    public static TransactionImpl lookupTransaction(otid_t otid_t2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "lookupTransaction", otid_t2);
        }
        int n = otid_t2.tid.length - otid_t2.bqual_length;
        byte[] byArray = new byte[n];
        System.arraycopy(otid_t2.tid, 0, byArray, 0, n);
        CoordinatorImpl coordinatorImpl = (CoordinatorImpl)CoordinatorImpl.getCoordinatorTable().get(new ByteArray(byArray));
        TransactionImpl transactionImpl = null;
        if (coordinatorImpl != null) {
            transactionImpl = coordinatorImpl.getJTATransaction();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "lookupTransaction", transactionImpl);
        }
        return transactionImpl;
    }

    public static CoordinatorImpl lookupCoordinator(TransactionImpl transactionImpl) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "lookupCoordinator", transactionImpl);
        }
        byte[] byArray = transactionImpl.getXid().getGlobalTransactionId();
        CoordinatorImpl coordinatorImpl = (CoordinatorImpl)CoordinatorImpl.getCoordinatorTable().get(new ByteArray(byArray));
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "lookupCoordinator", coordinatorImpl);
        }
        return coordinatorImpl;
    }

    ControlImpl getControl() {
        return this._control;
    }

    void setControl(ControlImpl controlImpl) {
        this._control = controlImpl;
    }
}

