/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.Transaction.JTS;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.util.Util;
import com.ibm.ws.Transaction.JTA.TranManagerSet;
import com.ibm.ws.Transaction.JTA.TransactionImpl;
import com.ibm.ws.Transaction.JTS.ControlImpl;
import com.ibm.ws.Transaction.JTS.CoordinatorImpl;
import com.ibm.ws.Transaction.JTS.TerminatorImpl;
import com.ibm.ws.Transaction.JTS.TxStatusHelper;
import com.ibm.ws.Transaction.WebSphereTransactionManager;
import com.ibm.ws.Transaction.client.NonRecoverableTranManagerSet;
import com.ibm.ws.Transaction.client.NonRecoverableTransactionImpl;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.runtime.component.EnvironmentType;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.NO_IMPLEMENT;
import org.omg.CORBA.NO_PERMISSION;
import org.omg.CORBA.TRANSACTION_ROLLEDBACK;
import org.omg.CosTransactions.Control;
import org.omg.CosTransactions.Current;
import org.omg.CosTransactions.HeuristicHazard;
import org.omg.CosTransactions.HeuristicMixed;
import org.omg.CosTransactions.InvalidControl;
import org.omg.CosTransactions.NoTransaction;
import org.omg.CosTransactions.Status;
import org.omg.CosTransactions.SubtransactionsUnavailable;
import org.omg.CosTransactions._CurrentImplBase;

public final class CurrentImpl
extends _CurrentImplBase {
    private static final Current _instance = new CurrentImpl();
    private static WebSphereTransactionManager _tranManager = null;
    private static int _environmentType;
    private static final TraceComponent tc;

    public static Current instance() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "instance");
        }
        if (_tranManager == null) {
            _environmentType = EnvironmentType.getEnvironmentType();
            if (_environmentType == 0) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Server environment. Delegating to TranManagerSet");
                }
                _tranManager = TranManagerSet.instance();
            } else if (_environmentType == 1) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Client environment. Delegating to NonRecoverableTranManagerSet");
                }
                _tranManager = NonRecoverableTranManagerSet.instance();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "instance", _instance);
        }
        return _instance;
    }

    public void begin() throws SubtransactionsUnavailable {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "begin");
        }
        try {
            _tranManager.begin();
        }
        catch (NotSupportedException notSupportedException) {
            FFDCFilter.processException((Throwable)notSupportedException, "com.ibm.ws.Transaction.JTS.CurrentImpl.begin", "93", this);
            throw new SubtransactionsUnavailable();
        }
        catch (SystemException systemException) {
            FFDCFilter.processException((Throwable)systemException, "com.ibm.ws.Transaction.JTS.CurrentImpl.begin", "98", this);
            throw new INTERNAL();
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "begin");
            }
        }
    }

    public void commit(boolean bl) throws HeuristicMixed, HeuristicHazard {
        TransactionImpl transactionImpl;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "commit", new Boolean(bl));
        }
        if (_environmentType == 0 && (transactionImpl = ((TranManagerSet)_tranManager).getTransactionImpl()) != null && transactionImpl.isSubordinate()) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "The transaction may only be committed by its originator");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "commit");
            }
            throw new NO_PERMISSION();
        }
        try {
            _tranManager.commit();
        }
        catch (HeuristicMixedException heuristicMixedException) {
            throw new HeuristicMixed();
        }
        catch (HeuristicRollbackException heuristicRollbackException) {
            throw new HeuristicHazard();
        }
        catch (RollbackException rollbackException) {
            throw new TRANSACTION_ROLLEDBACK();
        }
        catch (SystemException systemException) {
            FFDCFilter.processException((Throwable)systemException, "com.ibm.ws.Transaction.JTS.CurrentImpl.commit", "132", this);
            throw new INTERNAL();
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "commit");
            }
        }
    }

    public Control get_control() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "get_control");
        }
        if (_environmentType == 1) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Control is not available in a client environment");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "get_control");
            }
            throw new NO_IMPLEMENT();
        }
        TransactionImpl transactionImpl = ((TranManagerSet)_tranManager).getTransactionImpl();
        ControlImpl controlImpl = null;
        if (transactionImpl != null) {
            CoordinatorImpl coordinatorImpl = CoordinatorImpl.lookupCoordinator(transactionImpl);
            if (coordinatorImpl == null) {
                coordinatorImpl = new CoordinatorImpl(transactionImpl);
            }
            if ((controlImpl = coordinatorImpl.getControl()) == null) {
                TerminatorImpl terminatorImpl = null;
                if (!transactionImpl.isSubordinate()) {
                    terminatorImpl = new TerminatorImpl(transactionImpl);
                }
                ControlImpl controlImpl2 = new ControlImpl(coordinatorImpl, terminatorImpl);
                coordinatorImpl.setControl(controlImpl2);
                controlImpl = controlImpl2;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "get_control", controlImpl);
        }
        return controlImpl;
    }

    public Status get_status() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "get_status");
        }
        Status status = Status.StatusUnknown;
        try {
            status = TxStatusHelper.getCORBAStatus(_tranManager.getStatus());
        }
        catch (SystemException systemException) {
            FFDCFilter.processException((Throwable)systemException, "com.ibm.ws.Transaction.JTS.CurrentImpl.get_status", "161", this);
            throw new INTERNAL();
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "get_status", TxStatusHelper.getCORBAStatusAsString(status));
            }
        }
        return status;
    }

    public String get_transaction_name() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "get_transaction_name");
        }
        String string = null;
        try {
            Transaction transaction = _tranManager.getTransaction();
            if (transaction != null) {
                string = _environmentType == 1 ? Util.toHexString(((NonRecoverableTransactionImpl)transaction).getTID()) : Util.toHexString(((TransactionImpl)transaction).getTID());
            }
        }
        catch (SystemException systemException) {
            FFDCFilter.processException((Throwable)systemException, "com.ibm.ws.Transaction.JTS.CurrentImpl.get_transaction_name", "183", this);
            throw new INTERNAL();
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "get_tranasction_name", string);
            }
        }
        return string;
    }

    public void resume(Control control) throws InvalidControl {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "resume", control);
            Tr.exit(tc, "resume");
        }
        throw new NO_IMPLEMENT();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback_only() throws NoTransaction {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "rollback_only");
        }
        try {
            _tranManager.setRollbackOnly();
        }
        catch (IllegalStateException illegalStateException) {
            FFDCFilter.processException((Throwable)illegalStateException, "com.ibm.ws.Transaction.JTS.CurrentImpl.rollback_only", "201", this);
            throw new NoTransaction();
        }
        catch (SystemException systemException) {
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "rollback_only");
            }
        }
    }

    public void rollback() {
        TransactionImpl transactionImpl;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "rollback");
        }
        if (_environmentType == 0 && (transactionImpl = ((TranManagerSet)_tranManager).getTransactionImpl()) != null && transactionImpl.isSubordinate()) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "The transaction may only be rolledback by its originator");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "commit");
            }
            throw new NO_PERMISSION();
        }
        try {
            _tranManager.rollback();
        }
        catch (SystemException systemException) {
            FFDCFilter.processException((Throwable)systemException, "com.ibm.ws.Transaction.JTS.CurrentImpl.rollback", "231", this);
            throw new INTERNAL();
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "rollback");
            }
        }
    }

    public void set_timeout(int n) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "set_timeout", new Integer(n));
        }
        try {
            _tranManager.setTransactionTimeout(n);
        }
        catch (SystemException systemException) {
            FFDCFilter.processException((Throwable)systemException, "com.ibm.ws.Transaction.JTS.CurrentImpl.set_timeout", "250", this);
            throw new INTERNAL();
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "set_timeout");
            }
        }
    }

    public Control suspend() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "suspend");
            Tr.exit(tc, "suspend");
        }
        throw new NO_IMPLEMENT();
    }

    static {
        tc = Tr.register(CurrentImpl.class, "Transaction", "com.ibm.ws.Transaction.resources.TransactionMsgs");
    }
}

