/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.Transaction.JTS;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.Transaction.JTA.LocalTIDTable;
import com.ibm.ws.Transaction.JTA.RecoveryManager;
import com.ibm.ws.Transaction.JTA.TranManagerSet;
import com.ibm.ws.Transaction.JTA.TransactionImpl;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.runtime.workloadcontroller.WorkloadRegulator;
import javax.transaction.Transaction;

public final class TransactionWorkloadRegulator
extends WorkloadRegulator {
    private static final TraceComponent tc = Tr.register(TransactionWorkloadRegulator.class, "Transaction", "com.ibm.ws.Transaction.resources.TransactionMsgs");
    private long _lastWarningTime;

    public TransactionWorkloadRegulator() {
        this._type = 8;
        this._sName = this.getTypeName();
    }

    public boolean quiesce() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "quiesce");
        }
        boolean bl = true;
        long l = System.currentTimeMillis();
        boolean bl2 = false;
        if (l - this._lastWarningTime > 30000L) {
            this._lastWarningTime = l;
            bl2 = true;
        }
        TransactionImpl[] transactionImplArray = LocalTIDTable.getAllTransactions();
        for (int i = 0; i < transactionImplArray.length; ++i) {
            if (!transactionImplArray[i].isSubordinate()) continue;
            bl = false;
            if (!bl2) continue;
            Tr.warning(tc, "WTRN0092_QUIESCE_UNFINISHED", new Long(transactionImplArray[i].getLocalTID()));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "quiesce", new Boolean(bl));
        }
        return bl;
    }

    public boolean quiesceComplete() {
        block4: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "quiesceComplete");
            }
            TranManagerSet.instance().quiesce();
            Thread thread = new Thread(){

                public void run() {
                    TransactionImpl[] transactionImplArray = LocalTIDTable.getAllTransactions();
                    if (tc.isEventEnabled()) {
                        Tr.event(tc, "Found " + transactionImplArray.length + " active transactions.");
                    }
                    for (int i = 0; i < transactionImplArray.length; ++i) {
                        TransactionImpl transactionImpl = transactionImplArray[i];
                        if (transactionImpl.isRAImport()) continue;
                        int n = transactionImpl.getStatus();
                        if (n != 4 && n != 3 && n != 8 && n != 6) {
                            TransactionWorkloadRegulator.this.rollbackTransaction(transactionImpl);
                            int n2 = transactionImpl.getStatus();
                            if (n2 == 4 || n2 == 6) {
                                Tr.warning(tc, "WTRN0034_DURING_SERVER_QUIESCE_TX_ROLLBACK_SUCCEEDED", new Long(transactionImpl.getLocalTID()));
                                continue;
                            }
                            if (n2 == 1) {
                                Tr.warning(tc, "WTRN0036_DURING_SERVER_QUIESCE_TX_MARKED_ROLLBACK_ONLY", new Long(transactionImpl.getLocalTID()));
                                continue;
                            }
                            Tr.warning(tc, "WTRN0035_DURING_SERVER_QUIESCE_TX_ROLLBACK_FAILED", new Long(transactionImpl.getLocalTID()));
                            continue;
                        }
                        if (!tc.isEventEnabled()) continue;
                        Tr.event(tc, "Tx already committing or rolled back. Skipping.");
                    }
                }
            };
            thread.setDaemon(true);
            thread.start();
            try {
                thread.join(30000L);
            }
            catch (InterruptedException interruptedException) {
                if (!tc.isEventEnabled()) break block4;
                Tr.event(tc, "Exception waiting for worker thread to die");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "quiesceComplete");
        }
        return true;
    }

    public boolean started() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "started", this);
        }
        RecoveryManager.setAppsAreLoaded();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "started", Boolean.TRUE);
        }
        return true;
    }

    public boolean starting() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "starting");
            Tr.exit(tc, "starting");
        }
        return true;
    }

    private synchronized void rollbackTransaction(Transaction transaction) {
        block4: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "rollbackTransaction", transaction);
            }
            try {
                ((TransactionImpl)transaction).timeoutTransaction(false);
            }
            catch (Throwable throwable) {
                FFDCFilter.processException(throwable, "com.ibm.ws.Transaction.JTS.TransactionWorkloadRegulator.rollbackTransaction", "181", this);
                if (!tc.isDebugEnabled()) break block4;
                Tr.debug(tc, "Unexpected exception caught during transaction ROLLBACK!", throwable);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "rollbackTransaction");
        }
    }
}

